/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.RWStrategy;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.IPreparedSparqlUpdate;
import com.bigdata.rwstore.RWStore;
import java.util.Collections;
import junit.framework.Test;

public class TestRWStoreTxBehaviors<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    public TestRWStoreTxBehaviors() {
    }

    public TestRWStoreTxBehaviors(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(TestRWStoreTxBehaviors.class, "test.*", Collections.singleton(BufferMode.DiskRW), TestMode.triples);
    }

    public void test_SPARQL_UPDATE_Tx_Properly_Closed() throws Exception {
        RWStore rwstore = null;
        if (this.getIndexManager() instanceof AbstractJournal && ((AbstractJournal)this.getIndexManager()).getBufferStrategy() instanceof RWStrategy) {
            rwstore = ((RWStrategy)((AbstractJournal)this.getIndexManager()).getBufferStrategy()).getStore();
        } else {
            TestRWStoreTxBehaviors.fail((String)"RWStore is not in use");
        }
        int activeTxBefore = rwstore.getActiveTxCount();
        if (log.isInfoEnabled()) {
            log.info((Object)("activeTxBefore=" + activeTxBefore));
        }
        IPreparedSparqlUpdate preparedUpdate = this.m_repo.prepareUpdate("PREFIX dc: <http://purl.org/dc/elements/1.1/>\nINSERT DATA\n{\n  <http://example/book1> dc:title \"A new book\" ; \n                          dc:creator \"A.N.Other\" .\n}\n");
        preparedUpdate.evaluate();
        int activeTxAfter = rwstore.getActiveTxCount();
        if (log.isInfoEnabled()) {
            log.info((Object)("activeTxAfter=" + activeTxAfter));
        }
        TestRWStoreTxBehaviors.assertEquals((int)activeTxBefore, (int)activeTxAfter);
    }
}

