/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.HttpException;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import junit.framework.Test;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResult;

public class TestRebuildTextIndex<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    public TestRebuildTextIndex() {
    }

    public TestRebuildTextIndex(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(TestRebuildTextIndex.class, "test_rebuildTextIndex", Collections.singleton(BufferMode.DiskRW), new TestMode[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rebuildTextIndex() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        Properties properties = new Properties();
        properties.put(AbstractTripleStore.Options.TEXT_INDEX, "false");
        this.m_mgr.createRepository(namespace, properties);
        RemoteRepository repo = this.m_mgr.getRepositoryForNamespace(namespace);
        ValueFactoryImpl vf = ValueFactoryImpl.getInstance();
        URI s = vf.createURI("s:s1");
        Literal o = vf.createLiteral("literal");
        Statement[] a = new Statement[]{vf.createStatement((Resource)s, RDFS.LABEL, (Value)o)};
        RemoteRepository.AddOp addOp = new RemoteRepository.AddOp(Arrays.asList(a));
        repo.add(addOp);
        String sparql = "select ?s where { ?s ?p ?o . ?o <http://www.bigdata.com/rdf/search#search> \"" + o.stringValue() + "\" .}";
        try {
            repo.prepareTupleQuery(sparql).evaluate().close();
        }
        catch (HttpException ex) {
            TestRebuildTextIndex.assertEquals((int)500, (int)ex.getStatusCode());
        }
        boolean forceBuildTextIndex = false;
        try {
            this.m_mgr.rebuildTextIndex(namespace, forceBuildTextIndex);
            TestRebuildTextIndex.fail((String)"Expecting: 500");
        }
        catch (HttpException ex) {
            TestRebuildTextIndex.assertEquals((int)500, (int)ex.getStatusCode());
        }
        forceBuildTextIndex = true;
        this.m_mgr.rebuildTextIndex(namespace, forceBuildTextIndex);
        String expected = s.stringValue();
        String actual = null;
        try (TupleQueryResult result = repo.prepareTupleQuery(sparql).evaluate();){
            actual = ((BindingSet)result.next()).getBinding("s").getValue().stringValue();
        }
        TestRebuildTextIndex.assertEquals((String)expected, (String)actual);
    }
}

