/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.sail.webapp.AbstractProtocolTest;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import java.io.IOException;
import junit.framework.Test;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class TestRelease123Protocol
extends AbstractProtocolTest {
    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(TestRelease123Protocol.class, "test.*", TestMode.quads, TestMode.sids, TestMode.triples);
    }

    public TestRelease123Protocol(String name) {
        super(name);
    }

    public void testSelectGetXML() throws IOException {
        TestRelease123Protocol.assertTrue((boolean)this.serviceRequest("query", "SELECT (1 as ?one){}").contains("</sparql>"));
        TestRelease123Protocol.assertEquals((String)"application/sparql-results+xml", (String)this.getResponseContentType());
    }

    public void testSelectGetJSON() throws IOException {
        this.setAccept("application/sparql-results+json");
        TestRelease123Protocol.assertTrue((boolean)this.serviceRequest("query", "SELECT (1 as ?one){}").contains("results"));
        TestRelease123Protocol.assertEquals((String)"application/sparql-results+json", (String)this.getResponseContentType());
    }

    public void testAskGetXML() throws IOException {
        TestRelease123Protocol.assertTrue((boolean)this.serviceRequest("query", "ASK WHERE {}").contains("</sparql>"));
        TestRelease123Protocol.assertEquals((String)"application/sparql-results+xml", (String)this.getResponseContentType());
    }

    public void testEchoBackHeader() throws IOException {
        this.resetDefaultOptions();
        this.setMethodisPost("application/sparql-update", this.update);
        String response = this.serviceRequest(new String[0]);
        TestRelease123Protocol.assertFalse((boolean)response.contains("INSERT"));
        BasicHeader echoBack = new BasicHeader("X-ECHO-BACK-QUERY", "true");
        Header[] headers = new Header[]{echoBack};
        this.setHeaders(headers);
        this.setMethodisPost("application/sparql-update", this.update);
        response = this.serviceRequest(new String[0]);
        TestRelease123Protocol.assertTrue((boolean)response.contains("INSERT"));
    }

    public void testRepeatedHeaders() throws IOException {
        this.resetDefaultOptions();
        this.setAccept("application/trig, text/turtle");
        String result1 = this.serviceRequest("query", "CONSTRUCT { <a:b> <c:d> <e:f> } WHERE {}");
        this.resetDefaultOptions();
        Header[] headers = new Header[]{new BasicHeader("Accept", "application/trig"), new BasicHeader("Accept", "text/turtle")};
        this.setHeaders(headers);
        String result2 = this.serviceRequest("query", "CONSTRUCT { <a:b> <c:d> <e:f> } WHERE {}");
        TestRelease123Protocol.assertEquals((String)result1, (String)result2);
    }

    public void testSelectPostEncodeXML() throws IOException {
        this.setMethodisPostUrlEncodedData();
        this.testSelectGetXML();
    }

    public void testSelectPostEncodeJSON() throws IOException {
        this.setMethodisPostUrlEncodedData();
        this.testSelectGetJSON();
    }

    public void testAskPostEncodeXML() throws IOException {
        this.setMethodisPostUrlEncodedData();
        this.testAskGetXML();
    }

    public void testUpdateGet() throws IOException {
        this.checkUpdate(false);
        this.setAllow400s();
        this.serviceRequest("update", this.update);
        this.checkUpdate(false);
    }

    public void testUpdatePostEncode() throws IOException {
        this.checkUpdate(false);
        this.setMethodisPostUrlEncodedData();
        this.serviceRequest("update", this.update);
        this.checkUpdate(true);
    }
}

