/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.BigdataStatics;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.CreateKBTask;
import com.bigdata.rdf.sail.DestroyKBTask;
import com.bigdata.rdf.sail.webapp.NanoSparqlServer;
import com.bigdata.rdf.sail.webapp.client.HttpClientConfigurator;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.task.AbstractApiTask;
import com.bigdata.rdf.task.IApiTask;
import com.bigdata.util.config.NicUtil;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import junit.framework.TestCase2;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.Server;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.TupleQueryResult;

public class TestServiceWhiteList
extends TestCase2 {
    private static final String SOME_SERVICE_ENDPOINT = "http://someService.com/test";
    private Server m_fixture;
    protected String namespace;
    protected Journal m_indexManager;
    private String m_rootURL;
    private String m_serviceURL;
    private RemoteRepositoryManager m_repo;
    private HttpClient m_client;
    private final Map<String, String> initParams = new LinkedHashMap<String, String>();

    public void testServiceWhiteList() throws Exception {
        TupleQueryResult res = this.m_repo.getRepositoryForNamespace(this.namespace).prepareTupleQuery("SELECT ?b { ?b <http://purl.org/dc/elements/1.1/title> ?title . SERVICE <http://someService.com/test> { } }").evaluate();
        int resCount = 0;
        while (res.hasNext()) {
            res.next();
            ++resCount;
        }
        TestServiceWhiteList.assertEquals((int)0, (int)resCount);
        boolean exceptionThrown = false;
        try {
            res = this.m_repo.getRepositoryForNamespace(this.namespace).prepareTupleQuery("SELECT ?b { ?b <http://purl.org/dc/elements/1.1/title> ?title . SERVICE <http://someService.com/test1> { } }").evaluate();
        }
        catch (Exception e) {
            exceptionThrown = e.toString().contains("Service URI http://someService.com/test1 is not allowed");
        }
        TestServiceWhiteList.assertTrue((boolean)exceptionThrown);
    }

    protected Properties getTripleStoreProperties() {
        Properties tripleStoreProperties = new Properties();
        tripleStoreProperties.setProperty(BigdataSail.Options.TRIPLES_MODE, "true");
        tripleStoreProperties.setProperty(Journal.Options.BUFFER_MODE, BufferMode.MemStore.name());
        return tripleStoreProperties;
    }

    public void setUp() throws Exception {
        log.warn((Object)("Setting up test:" + this.getName()));
        Properties journalProperties = new Properties();
        journalProperties.setProperty(Journal.Options.BUFFER_MODE, BufferMode.MemStore.name());
        this.namespace = "testWhiteList" + UUID.randomUUID();
        this.m_indexManager = new Journal(journalProperties);
        AbstractApiTask.submitApiTask((IIndexManager)this.m_indexManager, (IApiTask)new CreateKBTask(this.namespace, journalProperties)).get();
        this.initParams.put("serviceWhitelist", SOME_SERVICE_ENDPOINT);
        this.initParams.put("namespace", this.namespace);
        this.initParams.put("create", "true");
        this.m_fixture = NanoSparqlServer.newInstance((int)0, (IIndexManager)this.m_indexManager, this.initParams);
        this.m_fixture.start();
        int port = NanoSparqlServer.getLocalPort((Server)this.m_fixture);
        String hostAddr = NicUtil.getIpAddress((String)"default.nic", (String)"default", (boolean)true);
        if (hostAddr == null) {
            TestServiceWhiteList.fail((String)"Could not identify network address for this host.");
        }
        this.m_rootURL = new URL("http", hostAddr, port, "").toExternalForm();
        this.m_serviceURL = new URL("http", hostAddr, port, BigdataStatics.getContextPath()).toExternalForm();
        if (log.isInfoEnabled()) {
            log.info((Object)("Setup done: \nname=" + this.getName() + "\nnamespace=" + this.namespace + "\nrootURL=" + this.m_rootURL + "\nserviceURL=" + this.m_serviceURL));
        }
        this.m_client = HttpClientConfigurator.getInstance().newInstance();
        this.m_repo = new RemoteRepositoryManager(this.m_serviceURL, this.m_client, (Executor)this.m_indexManager.getExecutorService());
    }

    public void tearDown() throws Exception {
        log.warn((Object)("tearing down test: " + this.getName()));
        ServiceRegistry.getInstance().remove((URI)new URIImpl(SOME_SERVICE_ENDPOINT));
        ServiceRegistry.getInstance().setWhitelistEnabled(false);
        if (this.m_fixture != null) {
            this.m_fixture.stop();
            this.m_fixture = null;
        }
        if (this.m_indexManager != null && this.namespace != null) {
            AbstractApiTask.submitApiTask((IIndexManager)this.m_indexManager, (IApiTask)new DestroyKBTask(this.namespace)).get();
            this.m_indexManager = null;
        }
        this.namespace = null;
        this.m_rootURL = null;
        this.m_serviceURL = null;
        this.m_repo.close();
        this.m_client.stop();
        log.info((Object)"tear down done");
        super.tearDown();
    }
}

