/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.IPreparedTupleQuery;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import junit.framework.Test;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.DC;
import org.openrdf.model.vocabulary.FOAF;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;

public class TestSparqlUpdate<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    private static final String EX_NS = "http://example.org/";
    private ValueFactory f = new ValueFactoryImpl();
    private URI bob;
    private URI alice;
    private URI graph1;
    private URI graph2;

    public TestSparqlUpdate() {
    }

    public TestSparqlUpdate(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(TestSparqlUpdate.class, "test.*", new LinkedHashSet<BufferMode>(Arrays.asList(BufferMode.Transient, BufferMode.DiskWORM, BufferMode.MemStore, BufferMode.DiskRW)), TestMode.quads);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.doLoadFile();
        this.bob = this.f.createURI(EX_NS, "bob");
        this.alice = this.f.createURI(EX_NS, "alice");
        this.graph1 = this.f.createURI(EX_NS, "graph1");
        this.graph2 = this.f.createURI(EX_NS, "graph2");
    }

    private void doLoadFile() throws Exception {
        this.loadFile("src/test/java/com/bigdata/rdf/sail/webapp/dataset-update.trig", RDFFormat.TRIG);
    }

    @Override
    public void tearDown() throws Exception {
        this.graph2 = null;
        this.graph1 = null;
        this.alice = null;
        this.bob = null;
        this.f = null;
        super.tearDown();
    }

    protected void loadFile(String file, RDFFormat format) throws Exception {
        RemoteRepository.AddOp add = new RemoteRepository.AddOp(new File(file), format);
        this.m_repo.add(add);
    }

    protected String getNamespaceDeclarations() {
        StringBuilder declarations = new StringBuilder();
        declarations.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \n");
        declarations.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \n");
        declarations.append("PREFIX dc: <http://purl.org/dc/elements/1.1/> \n");
        declarations.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n");
        declarations.append("PREFIX ex: <http://example.org/> \n");
        declarations.append("PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \n");
        declarations.append("\n");
        return declarations.toString();
    }

    protected boolean hasStatement(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            return this.m_repo.hasStatement(subj, pred, obj, includeInferred, contexts);
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void testInsertWhere() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }");
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    public void testInsertEmptyWhere() throws Exception {
        log.debug((Object)"executing test testInsertEmptyWhere");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT { <" + this.bob + "> rdfs:label \"Bob\" . } WHERE { }");
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
    }

    public void testInsertNonMatchingWhere() throws Exception {
        log.debug((Object)"executing test testInsertNonMatchingWhere");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT { ?x rdfs:label ?y . } WHERE { ?x rdfs:comment ?y }");
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
    }

    public void testInsertWhereWithOptional() throws Exception {
        log.debug((Object)"executing testInsertWhereWithOptional");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append(" INSERT { ?s ex:age ?incAge } ");
        update.append(" WHERE { ?s foaf:name ?name . ");
        update.append(" OPTIONAL {?s ex:age ?age . BIND ((?age + 1) as ?incAge)  } ");
        update.append(" } ");
        URI age = this.f.createURI(EX_NS, "age");
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.alice, age, null, true, new Resource[0]));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, age, null, true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, age, (Value)this.f.createLiteral("43", XMLSchema.INTEGER), true, new Resource[0]));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.alice, age, null, true, new Resource[0]));
    }

    public void testDeleteInsertWhere() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE { ?x foaf:name ?y } INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }");
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    public void testDeleteInsertWhereLoopingBehavior() throws Exception {
        log.debug((Object)"executing test testDeleteInsertWhereLoopingBehavior");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append(" DELETE { ?x ex:age ?y } INSERT {?x ex:age ?z }");
        update.append(" WHERE { ");
        update.append("   ?x ex:age ?y .");
        update.append("   BIND((?y + 1) as ?z) ");
        update.append("   FILTER( ?y < 46 ) ");
        update.append(" } ");
        URI age = this.f.createURI(EX_NS, "age");
        Literal originalAgeValue = this.f.createLiteral("42", XMLSchema.INTEGER);
        Literal correctAgeValue = this.f.createLiteral("43", XMLSchema.INTEGER);
        Literal inCorrectAgeValue = this.f.createLiteral("46", XMLSchema.INTEGER);
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, age, (Value)originalAgeValue, true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.bob, age, (Value)originalAgeValue, true, new Resource[0]));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, age, (Value)correctAgeValue, true, new Resource[0]));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.bob, age, (Value)inCorrectAgeValue, true, new Resource[0]));
    }

    public void testInsertTransformedWhere() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT {?x rdfs:label [] . } WHERE {?y ex:containsPerson ?x.  }");
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.alice, RDFS.LABEL, null, true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.alice, RDFS.LABEL, null, true, new Resource[0]));
    }

    public void testInsertWhereGraph() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT {GRAPH ?g {?x rdfs:label ?y . }} WHERE {GRAPH ?g {?x foaf:name ?y }}");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String message = "labels should have been inserted in corresponding named graphs only.";
        TestSparqlUpdate.assertTrue((String)message, (boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertFalse((String)message, (boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertTrue((String)message, (boolean)this.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertFalse((String)message, (boolean)this.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph1}));
    }

    public void testInsertWhereUsing() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT {?x rdfs:label ?y . } USING ex:graph1 WHERE {?x foaf:name ?y }");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String message = "label should have been inserted in default graph, for ex:bob only";
        TestSparqlUpdate.assertTrue((String)message, (boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        TestSparqlUpdate.assertFalse((String)message, (boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertFalse((String)message, (boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertFalse((String)message, (boolean)this.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        TestSparqlUpdate.assertFalse((String)message, (boolean)this.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertFalse((String)message, (boolean)this.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph1}));
    }

    public void testInsertWhereWith() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("WITH ex:graph1 INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String message = "label should have been inserted in graph1 only, for ex:bob only";
        TestSparqlUpdate.assertTrue((String)message, (boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertFalse((String)message, (boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertFalse((String)message, (boolean)this.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertFalse((String)message, (boolean)this.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph1}));
    }

    public void testDeleteWhereShortcut() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE WHERE {?x foaf:name ?y }");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String msg = "foaf:name properties should have been deleted";
        TestSparqlUpdate.assertFalse((String)msg, (boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        TestSparqlUpdate.assertFalse((String)msg, (boolean)this.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        msg = "foaf:knows properties should not have been deleted";
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)this.bob, FOAF.KNOWS, null, true, new Resource[0]));
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)this.alice, FOAF.KNOWS, null, true, new Resource[0]));
    }

    public void testDeleteWhereShortcut2() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE WHERE { GRAPH ?g {?x foaf:name ?y } }");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String msg = "foaf:name properties should have been deleted";
        TestSparqlUpdate.assertFalse((String)msg, (boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        TestSparqlUpdate.assertFalse((String)msg, (boolean)this.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        msg = "foaf:knows properties should not have been deleted";
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)this.bob, FOAF.KNOWS, null, true, new Resource[0]));
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)this.alice, FOAF.KNOWS, null, true, new Resource[0]));
    }

    public void testDeleteWhere() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE {?x foaf:name ?y } WHERE {?x foaf:name ?y }");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String msg = "foaf:name properties should have been deleted";
        TestSparqlUpdate.assertFalse((String)msg, (boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        TestSparqlUpdate.assertFalse((String)msg, (boolean)this.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    public void testInsertData() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT DATA { ex:book1 dc:title \"book 1\" ; dc:creator \"Ringo\" . } ");
        URI book1 = this.f.createURI(EX_NS, "book1");
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String msg = "two new statements about ex:book1 should have been inserted";
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]));
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]));
    }

    public void testInsertDataMultiplePatterns() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT DATA { ex:book1 dc:title \"book 1\". ex:book1 dc:creator \"Ringo\" . ex:book2 dc:creator \"George\". } ");
        URI book1 = this.f.createURI(EX_NS, "book1");
        URI book2 = this.f.createURI(EX_NS, "book2");
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)book2, DC.CREATOR, (Value)this.f.createLiteral("George"), true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String msg = "newly inserted statement missing";
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]));
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]));
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)book2, DC.CREATOR, (Value)this.f.createLiteral("George"), true, new Resource[0]));
    }

    public void testInsertDataInGraph() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT DATA { GRAPH ex:graph1 { ex:book1 dc:title \"book 1\" ; dc:creator \"Ringo\" . } } ");
        URI book1 = this.f.createURI(EX_NS, "book1");
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[]{this.graph1}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String msg = "two new statements about ex:book1 should have been inserted in graph1";
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[]{this.graph1}));
    }

    public void testInsertDataInGraph2() throws Exception {
        log.debug((Object)"executing testInsertDataInGraph2");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT DATA { GRAPH ex:graph1 { ex:Human rdfs:subClassOf ex:Mammal. ex:Mammal rdfs:subClassOf ex:Animal. ex:george a ex:Human. ex:ringo a ex:Human. } } ");
        URI human = this.f.createURI(EX_NS, "Human");
        URI mammal = this.f.createURI(EX_NS, "Mammal");
        URI george = this.f.createURI(EX_NS, "george");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)human, RDFS.SUBCLASSOF, (Value)mammal, true, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)mammal, RDFS.SUBCLASSOF, null, true, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)george, RDF.TYPE, (Value)human, true, new Resource[]{this.graph1}));
    }

    public void testDeleteData() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE DATA { ex:alice foaf:knows ex:bob. } ");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String msg = "statement should have been deleted.";
        TestSparqlUpdate.assertFalse((String)msg, (boolean)this.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[0]));
    }

    public void testDeleteDataMultiplePatterns() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE DATA { ex:alice foaf:knows ex:bob. ex:alice foaf:mbox \"alice@example.org\" .} ");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[0]));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.alice, FOAF.MBOX, (Value)this.f.createLiteral("alice@example.org"), true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String msg = "statement should have been deleted.";
        TestSparqlUpdate.assertFalse((String)msg, (boolean)this.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[0]));
        TestSparqlUpdate.assertFalse((String)msg, (boolean)this.hasStatement((Resource)this.alice, FOAF.MBOX, (Value)this.f.createLiteral("alice@example.org"), true, new Resource[0]));
    }

    public void testDeleteDataFromGraph() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE DATA { GRAPH ex:graph1 {ex:alice foaf:knows ex:bob. } } ");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph1}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String msg = "statement should have been deleted from graph1";
        TestSparqlUpdate.assertFalse((String)msg, (boolean)this.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph1}));
    }

    public void testDeleteDataFromWrongGraph() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE DATA { GRAPH ex:graph2 {ex:alice foaf:knows ex:bob. } } ");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph2}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String msg = "statement should have not have been deleted from graph1";
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph1}));
    }

    public void testCreateNewGraph() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        URI newGraph = this.f.createURI(EX_NS, "new-graph");
        update.append("CREATE GRAPH <" + newGraph + "> ");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement(null, null, null, false, new Resource[]{newGraph}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[0]));
    }

    public void testCreateExistingGraph() throws Exception {
        block2: {
            StringBuilder update = new StringBuilder();
            update.append(this.getNamespaceDeclarations());
            update.append("CREATE GRAPH <" + this.graph1 + "> ");
            try {
                this.m_repo.prepareUpdate(update.toString()).evaluate();
                TestSparqlUpdate.fail((String)"creation of existing graph should have resulted in error.");
            }
            catch (Exception e) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)("Expected exception: " + e), (Throwable)e);
            }
        }
    }

    public void testCopyToDefault() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("COPY GRAPH <" + this.graph1.stringValue() + "> TO DEFAULT");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    public void testCopyToExistingNamed() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("COPY GRAPH ex:graph1 TO ex:graph2");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.alice, FOAF.NAME, null, false, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    public void testCopyToNewNamed() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("COPY GRAPH ex:graph1 TO ex:graph3");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    public void testCopyFromDefault() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("COPY DEFAULT TO ex:graph3");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
    }

    public void testCopyFromDefaultToDefault() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("COPY DEFAULT TO DEFAULT");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
    }

    public void testAddToDefault() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("ADD GRAPH <" + this.graph1.stringValue() + "> TO DEFAULT");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    public void testAddToExistingNamed() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("ADD GRAPH ex:graph1 TO ex:graph2");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.alice, FOAF.NAME, null, false, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    public void testAddToNewNamed() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("ADD GRAPH ex:graph1 TO ex:graph3");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    public void testAddFromDefault() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("ADD DEFAULT TO ex:graph3");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
    }

    public void testAddFromDefaultToDefault() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("ADD DEFAULT TO DEFAULT");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
    }

    public void testMoveToDefault() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("MOVE GRAPH <" + this.graph1.stringValue() + "> TO DEFAULT");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
    }

    public void testMoveToNewNamed() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("MOVE GRAPH ex:graph1 TO ex:graph3");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
    }

    public void testMoveFromDefault() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("MOVE DEFAULT TO ex:graph3");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
    }

    public void testMoveFromDefaultToDefault() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("MOVE DEFAULT TO DEFAULT");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
    }

    public void testClearAll() throws Exception {
        String update = "CLEAR ALL";
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement(null, null, null, false, new Resource[0]));
    }

    public void testClearGraph() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("CLEAR GRAPH <" + this.graph1.stringValue() + "> ");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[0]));
    }

    public void testClearNamed() throws Exception {
        String update = "CLEAR NAMED";
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[0]));
    }

    public void testClearDefault() throws Exception {
        String update = "CLEAR DEFAULT";
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[]{null}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement(null, null, null, false, new Resource[]{null}));
    }

    public void testDropAll() throws Exception {
        String update = "DROP ALL";
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement(null, null, null, false, new Resource[0]));
    }

    public void testDropGraph() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DROP GRAPH <" + this.graph1.stringValue() + "> ");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[0]));
    }

    public void testDropNamed() throws Exception {
        String update = "DROP NAMED";
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[0]));
    }

    public void testDropDefault() throws Exception {
        String update = "DROP DEFAULT";
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[]{null}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement(null, null, null, false, new Resource[]{null}));
    }

    public void testUpdateSequenceInsertDelete2() throws Exception {
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT { GRAPH ex:graph2 { ?s ?p ?o } } WHERE { GRAPH ex:graph1 { ?s ?p ?o . FILTER (?s = ex:bob) } }; ");
        update.append("WITH ex:graph1 DELETE { ?s ?p ?o } WHERE {?s ?p ?o . FILTER (?s = ex:bob) } ");
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph1}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph2}));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String msg = "statements about bob should have been removed from graph1";
        TestSparqlUpdate.assertFalse((String)msg, (boolean)this.hasStatement((Resource)this.bob, null, null, true, new Resource[]{this.graph1}));
        msg = "statements about bob should have been added to graph2";
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)this.bob, FOAF.MBOX, null, true, new Resource[]{this.graph2}));
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)this.bob, FOAF.KNOWS, (Value)this.alice, true, new Resource[]{this.graph2}));
    }

    public void testUpdateSequenceInsertDeleteExample9() throws Exception {
        this.m_repo.prepareUpdate("DROP ALL").evaluate();
        this.m_repo.prepareUpdate("LOAD <file:src/test/java/com/bigdata/rdf/sail/webapp/dataset-update-example9.trig>").evaluate();
        URI book1 = this.f.createURI("http://example/book1");
        URI bookStore = this.f.createURI("http://example/bookStore");
        URI bookStore2 = this.f.createURI("http://example/bookStore2");
        StringBuilder update = new StringBuilder();
        update.append("prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> ");
        update.append("prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>  ");
        update.append("prefix xsd: <http://www.w3.org/2001/XMLSchema#>  ");
        update.append("prefix dc: <http://purl.org/dc/elements/1.1/>  ");
        update.append("prefix dcmitype: <http://purl.org/dc/dcmitype/>  ");
        update.append("INSERT  { GRAPH <http://example/bookStore2> { ?book ?p ?v } } ");
        update.append(" WHERE ");
        update.append(" { GRAPH  <http://example/bookStore> ");
        update.append("   { ?book dc:date ?date . ");
        update.append("       FILTER ( ?date < \"2000-01-01T00:00:00-02:00\"^^xsd:dateTime ) ");
        update.append("       ?book ?p ?v ");
        update.append("      } ");
        update.append(" } ;");
        update.append("WITH <http://example/bookStore> ");
        update.append(" DELETE { ?book ?p ?v } ");
        update.append(" WHERE ");
        update.append(" { ?book dc:date ?date ; ");
        update.append("         a dcmitype:PhysicalObject .");
        update.append("    FILTER ( ?date < \"2000-01-01T00:00:00-02:00\"^^xsd:dateTime ) ");
        update.append("   ?book ?p ?v");
        update.append(" } ");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        String msg = "statements about book1 should have been removed from bookStore";
        TestSparqlUpdate.assertFalse((String)msg, (boolean)this.hasStatement((Resource)book1, null, null, true, new Resource[]{bookStore}));
        msg = "statements about book1 should have been added to bookStore2";
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)book1, RDF.TYPE, null, true, new Resource[]{bookStore2}));
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)book1, DC.DATE, null, true, new Resource[]{bookStore2}));
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement((Resource)book1, DC.TITLE, null, true, new Resource[]{bookStore2}));
    }

    public void testTicket567() throws Exception {
        this.m_repo.prepareUpdate("DROP ALL").evaluate();
        StringBuilder update = new StringBuilder();
        update.append("DROP ALL;\n");
        update.append("INSERT DATA {\n");
        update.append(" GRAPH <http://example.org/one> {\n");
        update.append("   <http://example.org/a> <http://example.org/b> <http://example.org/c> .\n");
        update.append("   <http://example.org/d> <http://example.org/e> <http://example.org/f> .\n");
        update.append("}};\n");
        update.append("ADD SILENT GRAPH <http://example.org/one> TO GRAPH <http://example.org/two> ;\n");
        update.append("DROP SILENT GRAPH <http://example.org/one>  ;\n");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        URI one = this.f.createURI("http://example.org/one");
        URI two = this.f.createURI("http://example.org/two");
        String msg = "Nothing in graph <one>";
        TestSparqlUpdate.assertFalse((String)msg, (boolean)this.hasStatement(null, null, null, true, new Resource[]{one}));
        msg = "statements are in graph <two>";
        TestSparqlUpdate.assertTrue((String)msg, (boolean)this.hasStatement(null, null, null, true, new Resource[]{two}));
    }

    public void testUnicodeCleanAndRegex() throws Exception {
        String updateStr = "PREFIX ns: <http://example.org/ns#>\nINSERT DATA { GRAPH ns:graph { ns:auml ns:label \"\u00c4\", \"\u00e4\" } }\n";
        this.m_repo.prepareUpdate("PREFIX ns: <http://example.org/ns#>\nINSERT DATA { GRAPH ns:graph { ns:auml ns:label \"\u00c4\", \"\u00e4\" } }\n").evaluate();
        String queryStr = "PREFIX ns: <http://example.org/ns#>\nSELECT * { GRAPH ns:graph { ?s ?p ?o FILTER(regex(?o, \"\u00e4\", \"i\")) } }";
        IPreparedTupleQuery query = this.m_repo.prepareTupleQuery("PREFIX ns: <http://example.org/ns#>\nSELECT * { GRAPH ns:graph { ?s ?p ?o FILTER(regex(?o, \"\u00e4\", \"i\")) } }");
        TestSparqlUpdate.assertEquals((long)2L, (long)TestSparqlUpdate.countResults(query.evaluate()));
    }

    public void testLoad() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("com/bigdata/rdf/rio/small.rdf");
        String update = "LOAD <" + url.toExternalForm() + ">";
        String ns = "http://bigdata.com/test/data#";
        this.m_repo.prepareUpdate(update).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.f.createURI("http://bigdata.com/test/data#", "mike"), RDFS.LABEL, (Value)this.f.createLiteral("Michael Personick"), true, new Resource[0]));
    }

    public void testLoadSilent() throws Exception {
        String update = "LOAD SILENT <file:src/test/com/bigdata/rdf/rio/NOT-FOUND.rdf>";
        String ns = "http://bigdata.com/test/data#";
        this.m_repo.prepareUpdate("LOAD SILENT <file:src/test/com/bigdata/rdf/rio/NOT-FOUND.rdf>").evaluate();
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.f.createURI("http://bigdata.com/test/data#", "mike"), RDFS.LABEL, (Value)this.f.createLiteral("Michael Personick"), true, new Resource[0]));
    }

    public void testLoadIntoGraph() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("com/bigdata/rdf/rio/small.rdf");
        URI g1 = this.f.createURI("http://www.bigdata.com/g1");
        URI g2 = this.f.createURI("http://www.bigdata.com/g2");
        String update = "LOAD <" + url.toExternalForm() + "> " + "INTO GRAPH <" + g1.stringValue() + ">";
        String ns = "http://bigdata.com/test/data#";
        this.m_repo.prepareUpdate(update).evaluate();
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.f.createURI("http://bigdata.com/test/data#", "mike"), RDFS.LABEL, (Value)this.f.createLiteral("Michael Personick"), true, new Resource[]{g2}));
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.f.createURI("http://bigdata.com/test/data#", "mike"), RDFS.LABEL, (Value)this.f.createLiteral("Michael Personick"), true, new Resource[]{g1}));
    }

    public void testLoadGZip() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("com/bigdata/rdf/rio/small.rdf.gz");
        String update = "LOAD <" + url.toExternalForm() + ">";
        String ns = "http://bigdata.com/test/data#";
        this.m_repo.prepareUpdate(update).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.f.createURI("http://bigdata.com/test/data#", "mike"), RDFS.LABEL, (Value)this.f.createLiteral("Michael Personick"), true, new Resource[0]));
    }

    public void testReallyLongQueryString() throws Exception {
        Literal l = this.getReallyLongLiteral(1000);
        log.debug((Object)"executing test testInsertEmptyWhere");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT { <" + this.bob + "> rdfs:label " + l + " . } WHERE { }");
        TestSparqlUpdate.assertFalse((boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)l, true, new Resource[0]));
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertTrue((boolean)this.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)l, true, new Resource[0]));
    }

    private Literal getReallyLongLiteral(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append('a');
        }
        return new LiteralImpl(sb.toString());
    }

    public void testStressInsertWhereGraph() throws Exception {
        int LIMIT = 10;
        int i = 0;
        StressTestOpEnum lastOp = null;
        try {
            for (i = 0; i < 10; ++i) {
                lastOp = StressTestOpEnum.Update;
                this.testInsertWhereGraph();
                lastOp = StressTestOpEnum.DropAll;
                this.testDropAll();
                lastOp = StressTestOpEnum.LoadFile;
                this.doLoadFile();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Iteration " + (i + 1) + " of " + 10 + ", lastOp=" + (Object)((Object)lastOp), t);
        }
    }

    public void testTicket1738() throws Exception {
        URI s1 = this.f.createURI("http://s1");
        URI p1 = this.f.createURI("http://p1");
        URI p2 = this.f.createURI("http://p2");
        URI p3 = this.f.createURI("http://p3");
        URI o1 = this.f.createURI("http://o1");
        URI o2 = this.f.createURI("http://o2");
        StringBuilder bootstrap = new StringBuilder();
        bootstrap.append(this.getNamespaceDeclarations());
        bootstrap.append("INSERT { <http://s1> <http://p1> <http://o1> . <http://s1> <http://p2> <http://o2> } WHERE { }");
        this.m_repo.prepareUpdate("DROP ALL").evaluate();
        this.m_repo.prepareUpdate(bootstrap.toString()).evaluate();
        TestSparqlUpdate.assertTrue((String)"Repo setup problem: missing statement", (boolean)this.hasStatement((Resource)s1, p1, (Value)o1, true, new Resource[0]));
        TestSparqlUpdate.assertTrue((String)"Repo setup problem: missing statement", (boolean)this.hasStatement((Resource)s1, p2, (Value)o2, true, new Resource[0]));
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE { ?s <http://p1> ?o1 } INSERT { ?s <http://p3> ?o2 } WHERE {   ?s <http://p1> ?o1 .  ?s <http://p2> | <http://p3> ?o2 }");
        this.m_repo.prepareUpdate(update.toString()).evaluate();
        TestSparqlUpdate.assertFalse((String)"Problem in UPDATE: unexpected statement", (boolean)this.hasStatement((Resource)s1, p1, (Value)o1, true, new Resource[0]));
        TestSparqlUpdate.assertTrue((String)"Problem in UPDATE: missing statement (test case main cause)", (boolean)this.hasStatement((Resource)s1, p3, (Value)o2, true, new Resource[0]));
        TestSparqlUpdate.assertTrue((String)"Problem in UPDATE: missing statement", (boolean)this.hasStatement((Resource)s1, p2, (Value)o2, true, new Resource[0]));
    }

    private static enum StressTestOpEnum {
        Update,
        DropAll,
        LoadFile;

    }
}

