/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.IPreparedTupleQuery;
import java.util.Arrays;
import java.util.LinkedHashSet;
import junit.framework.Test;

public class TestSparqlUpdateSuppressTruthMaintenance<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    public TestSparqlUpdateSuppressTruthMaintenance() {
    }

    public TestSparqlUpdateSuppressTruthMaintenance(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(TestSparqlUpdateSuppressTruthMaintenance.class, "test.*", new LinkedHashSet<BufferMode>(Arrays.asList(BufferMode.MemStore)), TestMode.triplesPlusTruthMaintenance);
    }

    public void testSuppressTruthMaintenance() throws Exception {
        String updateStr = "DISABLE ENTAILMENTS; INSERT DATA { <urn:1> <urn:property1> \"someValue\"^^<http://www.w3.org/2001/XMLSchema#string> .<urn:property1> <http://www.w3.org/2000/01/rdf-schema#subPropertyOf> <http://www.w3.org/2000/01/rdf-schema#label> . }";
        this.m_repo.prepareUpdate(updateStr).evaluate();
        String queryStr = "SELECT * {<urn:property1> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?o} ";
        IPreparedTupleQuery query = this.m_repo.prepareTupleQuery(queryStr);
        TestSparqlUpdateSuppressTruthMaintenance.assertEquals((long)0L, (long)TestSparqlUpdateSuppressTruthMaintenance.countResults(query.evaluate()));
        updateStr = "CREATE ENTAILMENTS; ENABLE ENTAILMENTS";
        this.m_repo.prepareUpdate(updateStr).evaluate();
        TestSparqlUpdateSuppressTruthMaintenance.assertEquals((long)1L, (long)TestSparqlUpdateSuppressTruthMaintenance.countResults(query.evaluate()));
        updateStr = "DISABLE ENTAILMENTS; DELETE DATA { <urn:1> <urn:property1> \"someValue\"^^<http://www.w3.org/2001/XMLSchema#string> .<urn:property1> <http://www.w3.org/2000/01/rdf-schema#subPropertyOf> <http://www.w3.org/2000/01/rdf-schema#label> . }";
        this.m_repo.prepareUpdate(updateStr).evaluate();
        TestSparqlUpdateSuppressTruthMaintenance.assertEquals((long)1L, (long)TestSparqlUpdateSuppressTruthMaintenance.countResults(query.evaluate()));
        updateStr = "DROP ENTAILMENTS; ENABLE ENTAILMENTS";
        this.m_repo.prepareUpdate(updateStr).evaluate();
        TestSparqlUpdateSuppressTruthMaintenance.assertEquals((long)0L, (long)TestSparqlUpdateSuppressTruthMaintenance.countResults(query.evaluate()));
    }
}

