/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import junit.framework.Test;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class Test_REST_DELETE_BY_ACCESS_PATH<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    public Test_REST_DELETE_BY_ACCESS_PATH() {
    }

    public Test_REST_DELETE_BY_ACCESS_PATH(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(Test_REST_DELETE_BY_ACCESS_PATH.class, "test.*", TestMode.quads);
    }

    public void test_DELETE_accessPath_delete_all() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath(null, null, null, new URI[0]);
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)7L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_s() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath((URI)new URIImpl("http://www.bigdata.com/Mike"), null, null, new URI[0]);
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)3L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_p() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath(null, (URI)new URIImpl("http://www.w3.org/2000/01/rdf-schema#label"), null, new URI[0]);
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)2L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_o_URI() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath(null, null, (Value)new URIImpl("http://xmlns.com/foaf/0.1/Person"), new URI[0]);
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)3L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_o_Literal() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath(null, null, (Value)new URIImpl("http://www.bigdata.com/Bryan"), new URI[0]);
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)1L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_p_o_URI() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath(null, RDF.TYPE, (Value)new URIImpl("http://xmlns.com/foaf/0.1/Person"), new URI[0]);
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)3L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_p_o_Literal() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath(null, RDFS.LABEL, (Value)new LiteralImpl("Bryan"), new URI[0]);
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)1L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_NothingMatched() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.ttl");
        long mutationResult = this.doDeleteWithAccessPath(null, null, (Value)new URIImpl("http://xmlns.com/foaf/0.1/XXX"), new URI[0]);
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)0L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_c() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.trig");
        URIImpl base = new URIImpl("http://www.bigdata.com/");
        URIImpl c1 = new URIImpl("http://www.bigdata.com/c1");
        URIImpl c2 = new URIImpl("http://www.bigdata.com/c2");
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)3L, (long)this.m_repo.rangeCount(null, null, null, new Resource[]{base}));
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)2L, (long)this.m_repo.rangeCount(null, null, null, new Resource[]{c1}));
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)2L, (long)this.m_repo.rangeCount(null, null, null, new Resource[]{c2}));
        long mutationResult = this.doDeleteWithAccessPath(null, null, null, new URI[]{base});
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)3L, (long)mutationResult);
        long rangeCount_base = this.m_repo.rangeCount(null, null, null, new Resource[]{base});
        long rangeCount_c1 = this.m_repo.rangeCount(null, null, null, new Resource[]{c1});
        long rangeCount_c2 = this.m_repo.rangeCount(null, null, null, new Resource[]{c2});
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)0L, (long)rangeCount_base);
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)2L, (long)rangeCount_c1);
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)2L, (long)rangeCount_c2);
    }

    public void test_DELETE_accessPath_delete_c1() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.trig");
        long mutationResult = this.doDeleteWithAccessPath(null, null, null, new URI[]{new URIImpl("http://www.bigdata.com/c1")});
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)2L, (long)mutationResult);
    }

    public void test_DELETE_accessPath_delete_multiple_contexts() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.trig");
        URIImpl base = new URIImpl("http://www.bigdata.com/");
        URIImpl c1 = new URIImpl("http://www.bigdata.com/c1");
        URIImpl c2 = new URIImpl("http://www.bigdata.com/c2");
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)3L, (long)this.m_repo.rangeCount(null, null, null, new Resource[]{base}));
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)2L, (long)this.m_repo.rangeCount(null, null, null, new Resource[]{c1}));
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)2L, (long)this.m_repo.rangeCount(null, null, null, new Resource[]{c2}));
        long mutationResult = this.doDeleteWithAccessPath(null, null, null, new URI[]{c1, c2});
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)4L, (long)mutationResult);
        long rangeCount_base = this.m_repo.rangeCount(null, null, null, new Resource[]{base});
        long rangeCount_c1 = this.m_repo.rangeCount(null, null, null, new Resource[]{c1});
        long rangeCount_c2 = this.m_repo.rangeCount(null, null, null, new Resource[]{c2});
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)3L, (long)rangeCount_base);
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)0L, (long)rangeCount_c1);
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)0L, (long)rangeCount_c2);
    }

    public void test_DELETE_accessPath_delete_c_nothingMatched() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_delete_by_access_path.trig");
        long mutationResult = this.doDeleteWithAccessPath(null, null, null, new URI[]{new URIImpl("http://xmlns.com/foaf/0.1/XXX")});
        Test_REST_DELETE_BY_ACCESS_PATH.assertEquals((long)0L, (long)mutationResult);
    }
}

