/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Test;
import junit.framework.TestCase;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.rio.RDFFormat;

public class Test_REST_DESCRIBE<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    public Test_REST_DESCRIBE() {
    }

    public Test_REST_DESCRIBE(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(Test_REST_DESCRIBE.class, "test.*", TestMode.quads);
    }

    public void test_GET_DESCRIBE_RDFXML() throws Exception {
        this.doDescribeTest("GET", RDFFormat.RDFXML);
    }

    public void test_GET_DESCRIBE_NTRIPLES() throws Exception {
        this.doDescribeTest("GET", RDFFormat.NTRIPLES);
    }

    public void test_GET_DESCRIBE_N3() throws Exception {
        this.doDescribeTest("GET", RDFFormat.N3);
    }

    public void test_GET_DESCRIBE_TURTLE() throws Exception {
        this.doDescribeTest("GET", RDFFormat.TURTLE);
    }

    public void test_GET_DESCRIBE_TRIG() throws Exception {
        this.doDescribeTest("GET", RDFFormat.TRIG);
    }

    public void test_GET_DESCRIBE_TRIX() throws Exception {
        this.doDescribeTest("GET", RDFFormat.TRIX);
    }

    public void test_POST_DESCRIBE_RDFXML() throws Exception {
        this.doDescribeTest("POST", RDFFormat.RDFXML);
    }

    public void test_POST_DESCRIBE_NTRIPLES() throws Exception {
        this.doDescribeTest("POST", RDFFormat.NTRIPLES);
    }

    public void test_POST_DESCRIBE_N3() throws Exception {
        this.doDescribeTest("POST", RDFFormat.N3);
    }

    public void test_POST_DESCRIBE_TURTLE() throws Exception {
        this.doDescribeTest("POST", RDFFormat.TURTLE);
    }

    public void test_POST_DESCRIBE_TRIG() throws Exception {
        this.doDescribeTest("POST", RDFFormat.TRIG);
    }

    public void test_POST_DESCRIBE_TRIX() throws Exception {
        this.doDescribeTest("POST", RDFFormat.TRIX);
    }

    public void test976_describeStress() throws Exception {
        this.doStressDescribeTest("GET", RDFFormat.RDFXML, 100, 50, 500);
    }

    protected void doStressDescribeTest(String method, RDFFormat format, int tasks, int threads, int statements) throws Exception {
        URIImpl person = new URIImpl("http://www.bigdata.com/rdf#Person");
        URIImpl likes = new URIImpl("http://www.bigdata.com/rdf#likes");
        URIImpl rdf = new URIImpl("http://www.bigdata.com/rdf#RDF");
        URIImpl rdfs = new URIImpl("http://www.bigdata.com/rdf#RDFS");
        GraphImpl g = new GraphImpl();
        for (int n = 0; n < statements; ++n) {
            URIImpl miken = new URIImpl("http://www.bigdata.com/rdf#Mike#" + n);
            URIImpl bryann = new URIImpl("http://www.bigdata.com/rdf#Bryan#" + n);
            LiteralImpl nameMiken = new LiteralImpl("Mike#" + n);
            LiteralImpl nameBryann = new LiteralImpl("Bryan#" + n);
            g.add((Resource)miken, RDF.TYPE, (Value)person, new Resource[0]);
            g.add((Resource)miken, (URI)likes, (Value)rdf, new Resource[0]);
            g.add((Resource)miken, RDFS.LABEL, (Value)nameMiken, new Resource[0]);
            g.add((Resource)bryann, RDF.TYPE, (Value)person, new Resource[0]);
            g.add((Resource)bryann, (URI)likes, (Value)rdfs, new Resource[0]);
            g.add((Resource)bryann, RDFS.LABEL, (Value)nameBryann, new Resource[0]);
        }
        this.m_repo.add(new RemoteRepository.AddOp((Iterable)g));
        String queryStr = "prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> DESCRIBE ?x WHERE {   ?x rdf:type bd:Person .   ?x bd:likes bd:RDF }";
        final AtomicInteger errorCount = new AtomicInteger();
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    Graph actual = AbstractTestNanoSparqlClient.asGraph(Test_REST_DESCRIBE.this.m_repo.prepareGraphQuery("prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> DESCRIBE ?x WHERE {   ?x rdf:type bd:Person .   ?x bd:likes bd:RDF }"));
                    TestCase.assertTrue((!actual.isEmpty() ? 1 : 0) != 0);
                    return null;
                }
                catch (Exception e) {
                    log.warn((Object)"Call failure", (Throwable)e);
                    errorCount.incrementAndGet();
                    throw e;
                }
            }
        };
        int threadCount = Thread.activeCount();
        ExecutorService exec = Executors.newFixedThreadPool(threads);
        for (int r = 0; r < tasks; ++r) {
            exec.submit(task);
        }
        exec.shutdown();
        exec.awaitTermination(2000L, TimeUnit.SECONDS);
        exec.shutdownNow();
        int loops = 20;
        while (Thread.activeCount() > threadCount && --loops > 0) {
            Thread.sleep(500L);
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Extra threads: " + (Thread.activeCount() - threadCount)));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Return with extra threads: " + (Thread.activeCount() - threadCount)));
        }
        Test_REST_DESCRIBE.assertTrue((errorCount.get() == 0 ? 1 : 0) != 0);
    }
}

