/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import java.util.Collection;
import java.util.Properties;
import junit.framework.Test;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class Test_REST_ESTCARD<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    public Test_REST_ESTCARD() {
    }

    public Test_REST_ESTCARD(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(Test_REST_ESTCARD.class, "test.*", TestMode.quads);
    }

    public void test_ESTCARD() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
        long rangeCount = this.m_repo.size();
        Test_REST_ESTCARD.assertEquals((long)7L, (long)rangeCount);
    }

    public void test_ESTCARD_s() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
        long rangeCount = this.m_repo.rangeCount((Resource)new URIImpl("http://www.bigdata.com/Mike"), null, null, new Resource[0]);
        Test_REST_ESTCARD.assertEquals((long)3L, (long)rangeCount);
    }

    public void test_ESTCARD_p() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
        long rangeCount = this.m_repo.rangeCount(null, RDF.TYPE, null, new Resource[0]);
        Test_REST_ESTCARD.assertEquals((long)3L, (long)rangeCount);
    }

    public void test_ESTCARD_p2() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
        long rangeCount = this.m_repo.rangeCount(null, RDFS.LABEL, null, new Resource[0]);
        Test_REST_ESTCARD.assertEquals((long)2L, (long)rangeCount);
    }

    public void test_ESTCARD_o() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
        long rangeCount = this.m_repo.rangeCount(null, null, (Value)new LiteralImpl("Mike"), new Resource[0]);
        Test_REST_ESTCARD.assertEquals((long)1L, (long)rangeCount);
    }

    public void test_ESTCARD_so() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
        long rangeCount = this.m_repo.rangeCount((Resource)new URIImpl("http://www.bigdata.com/Mike"), RDF.TYPE, null, new Resource[0]);
        Test_REST_ESTCARD.assertEquals((long)1L, (long)rangeCount);
    }

    public void test_ESTCARD_quads_01() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.trig");
        long rangeCount = this.m_repo.rangeCount(null, null, null, new Resource[0]);
        Test_REST_ESTCARD.assertEquals((long)7L, (long)rangeCount);
    }

    public void test_ESTCARD_quads_02() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.trig");
        long rangeCount = this.m_repo.rangeCount(null, null, null, new Resource[]{new URIImpl("http://www.bigdata.com/")});
        Test_REST_ESTCARD.assertEquals((long)3L, (long)rangeCount);
    }

    public void test_ESTCARD_quads_03() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.trig");
        long rangeCount = this.m_repo.rangeCount(null, null, null, new Resource[]{new URIImpl("http://www.bigdata.com/c1")});
        Test_REST_ESTCARD.assertEquals((long)2L, (long)rangeCount);
    }

    public void test_ESTCARD_quads_04() throws Exception {
        if (TestMode.quads != this.getTestMode()) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.trig");
        long rangeCount = this.m_repo.rangeCount((Resource)new URIImpl("http://www.bigdata.com/Mike"), null, null, new Resource[]{new URIImpl("http://www.bigdata.com/c1")});
        Test_REST_ESTCARD.assertEquals((long)1L, (long)rangeCount);
    }

    public void test_CONTEXTS() throws Exception {
        if (this.getTestMode() != TestMode.quads) {
            return;
        }
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.trig");
        Collection contexts = this.m_repo.getContexts();
        Test_REST_ESTCARD.assertEquals((int)3, (int)contexts.size());
    }

    public static class ReadWriteTx<S extends IIndexManager>
    extends Test_REST_ESTCARD<S> {
        public static Test suite() {
            return ProxySuiteHelper.suiteWhenStandalone(ReadWriteTx.class, "test.*", TestMode.quads);
        }

        @Override
        public Properties getProperties() {
            Properties p = new Properties(super.getProperties());
            p.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "true");
            return p;
        }

        public void test_ESTCARD_readWriteTx() throws Exception {
            this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
            long exactRangeCount1 = this.m_repo.rangeCount(true, null, null, null, new Resource[0]);
            long fastRangeCount1 = this.m_repo.rangeCount(false, null, null, null, new Resource[0]);
            ReadWriteTx.assertEquals((long)7L, (long)exactRangeCount1);
            ReadWriteTx.assertEquals((long)7L, (long)fastRangeCount1);
            long mutationCount = this.m_repo.remove(new RemoteRepository.RemoveOp(null, RDFS.LABEL, null, new Resource[0]));
            ReadWriteTx.assertEquals((long)2L, (long)mutationCount);
            long exactRangeCount2 = this.m_repo.rangeCount(true, null, null, null, new Resource[0]);
            long fastRangeCount2 = this.m_repo.rangeCount(false, null, null, null, new Resource[0]);
            ReadWriteTx.assertEquals((long)5L, (long)exactRangeCount2);
            ReadWriteTx.assertEquals((long)7L, (long)fastRangeCount2);
        }
    }
}

