/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import java.util.Properties;
import junit.framework.Test;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.FOAF;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class Test_REST_HASSTMT<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    public Test_REST_HASSTMT() {
    }

    public Test_REST_HASSTMT(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(Test_REST_HASSTMT.class, "test.*", TestMode.quads);
    }

    public void test_HASSTMT_s() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
        Test_REST_HASSTMT.assertTrue((boolean)this.m_repo.hasStatement((Resource)new URIImpl("http://www.bigdata.com/Mike"), null, null, false, new Resource[0]));
        Test_REST_HASSTMT.assertFalse((boolean)this.m_repo.hasStatement((Resource)new URIImpl("http://www.bigdata.com/Fred"), null, null, false, new Resource[0]));
    }

    public void test_HASSTMT_p() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
        Test_REST_HASSTMT.assertTrue((boolean)this.m_repo.hasStatement(null, RDF.TYPE, null, false, new Resource[0]));
        Test_REST_HASSTMT.assertFalse((boolean)this.m_repo.hasStatement(null, RDF.BAG, null, false, new Resource[0]));
    }

    public void test_HASSTMT_o() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
        Test_REST_HASSTMT.assertTrue((boolean)this.m_repo.hasStatement(null, null, (Value)new LiteralImpl("Mike"), false, new Resource[0]));
        Test_REST_HASSTMT.assertFalse((boolean)this.m_repo.hasStatement(null, null, (Value)new LiteralImpl("Fred"), false, new Resource[0]));
    }

    public void test_HASSTMT_so() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
        Test_REST_HASSTMT.assertTrue((boolean)this.m_repo.hasStatement((Resource)new URIImpl("http://www.bigdata.com/Mike"), RDF.TYPE, null, false, new Resource[0]));
        Test_REST_HASSTMT.assertFalse((boolean)this.m_repo.hasStatement((Resource)new URIImpl("http://www.bigdata.com/Fred"), RDF.TYPE, null, false, new Resource[0]));
        Test_REST_HASSTMT.assertFalse((boolean)this.m_repo.hasStatement((Resource)new URIImpl("http://www.bigdata.com/Mike"), RDF.BAG, null, false, new Resource[0]));
    }

    public void test_HASSTMT_po() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
        Test_REST_HASSTMT.assertTrue((boolean)this.m_repo.hasStatement(null, RDFS.LABEL, (Value)new LiteralImpl("Mike"), false, new Resource[0]));
        Test_REST_HASSTMT.assertFalse((boolean)this.m_repo.hasStatement(null, RDFS.LABEL, (Value)new LiteralImpl("Fred"), false, new Resource[0]));
        Test_REST_HASSTMT.assertFalse((boolean)this.m_repo.hasStatement(null, RDF.BAG, (Value)new LiteralImpl("Mike"), false, new Resource[0]));
    }

    public void test_HASSTMT_sp() throws Exception {
        this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
        Test_REST_HASSTMT.assertTrue((boolean)this.m_repo.hasStatement((Resource)new URIImpl("http://www.bigdata.com/Mike"), RDFS.LABEL, null, false, new Resource[0]));
        Test_REST_HASSTMT.assertFalse((boolean)this.m_repo.hasStatement((Resource)new URIImpl("http://www.bigdata.com/Mike"), RDF.BAG, null, false, new Resource[0]));
    }

    public static class TruthMaintenance<S extends IIndexManager>
    extends Test_REST_HASSTMT<S> {
        public static Test suite() {
            return ProxySuiteHelper.suiteWhenStandalone(TruthMaintenance.class, "test.*", TestMode.triples);
        }

        @Override
        public Properties getProperties() {
            Properties p = TestMode.triplesPlusTruthMaintenance.getProperties(super.getProperties());
            return p;
        }

        public void test_HASSTMT_includeInferred() throws Exception {
            this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
            TruthMaintenance.assertFalse((boolean)this.m_repo.hasStatement((Resource)OWL.EQUIVALENTCLASS, RDFS.SUBPROPERTYOF, (Value)RDFS.SUBCLASSOF, false, new Resource[0]));
            TruthMaintenance.assertTrue((boolean)this.m_repo.hasStatement((Resource)OWL.EQUIVALENTCLASS, RDFS.SUBPROPERTYOF, (Value)RDFS.SUBCLASSOF, true, new Resource[0]));
            long mutationCount = 0L;
            mutationCount += this.m_repo.remove(new RemoteRepository.RemoveOp(null, RDF.TYPE, null, new Resource[0]));
            mutationCount += this.m_repo.remove(new RemoteRepository.RemoveOp(null, RDFS.LABEL, null, new Resource[0]));
            TruthMaintenance.assertTrue(((mutationCount += this.m_repo.remove(new RemoteRepository.RemoveOp(null, FOAF.KNOWS, null, new Resource[0]))) > 7L ? 1 : 0) != 0);
            TruthMaintenance.assertFalse((boolean)this.m_repo.hasStatement((Resource)OWL.EQUIVALENTCLASS, RDFS.SUBPROPERTYOF, (Value)RDFS.SUBCLASSOF, false, new Resource[0]));
            TruthMaintenance.assertTrue((boolean)this.m_repo.hasStatement((Resource)OWL.EQUIVALENTCLASS, RDFS.SUBPROPERTYOF, (Value)RDFS.SUBCLASSOF, true, new Resource[0]));
        }
    }

    public static class ReadWriteTx<S extends IIndexManager>
    extends Test_REST_HASSTMT<S> {
        public static Test suite() {
            return ProxySuiteHelper.suiteWhenStandalone(ReadWriteTx.class, "test.*", TestMode.triples);
        }

        @Override
        public Properties getProperties() {
            Properties p = new Properties(super.getProperties());
            p.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "true");
            return p;
        }

        public void test_HASSTMT_readWriteTx() throws Exception {
            this.doInsertbyURL("POST", "src/test/java/com/bigdata/rdf/sail/webapp/test_estcard.ttl");
            ReadWriteTx.assertTrue((boolean)this.m_repo.hasStatement(null, RDFS.LABEL, null, false, new Resource[0]));
            long mutationCount = this.m_repo.remove(new RemoteRepository.RemoveOp(null, RDFS.LABEL, null, new Resource[0]));
            ReadWriteTx.assertEquals((long)2L, (long)mutationCount);
            ReadWriteTx.assertFalse((boolean)this.m_repo.hasStatement(null, RDFS.LABEL, null, false, new Resource[0]));
        }
    }
}

