/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.BigdataStatics;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.webapp.AbstractTestNanoSparqlClient;
import com.bigdata.rdf.sail.webapp.NanoSparqlServer;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import com.bigdata.rdf.sail.webapp.client.ConnectOptions;
import com.bigdata.rdf.sail.webapp.client.HttpException;
import com.bigdata.rdf.sail.webapp.client.JettyResponseListener;
import com.bigdata.util.config.NicUtil;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.server.Server;

public class Test_REST_Structure<S extends IIndexManager>
extends AbstractTestNanoSparqlClient<S> {
    private static final String JUNIT_TEST_MARKER_INDEX_HTML = "junit test marker: index.html";

    public Test_REST_Structure() {
    }

    public Test_REST_Structure(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(Test_REST_Structure.class, "test.*", TestMode.quads);
    }

    public void test_startup() throws Exception {
        Test_REST_Structure.assertTrue((String)"open", (boolean)this.m_fixture.isRunning());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleFixtures() throws Exception {
        Test_REST_Structure.assertTrue((String)"open", (boolean)this.m_fixture.isRunning());
        String lnamespace = this.getName() + UUID.randomUUID();
        Server altfixture = this.newFixture(lnamespace);
        try {
            int altport = NanoSparqlServer.getLocalPort((Server)altfixture);
            String hostAddr = NicUtil.getIpAddress((String)"default.nic", (String)"default", (boolean)true);
            if (hostAddr == null) {
                Test_REST_Structure.fail((String)"Could not identify network address for this host.");
            }
            String altrootURL = new URL("http", hostAddr, altport, "").toExternalForm();
            String altserviceURL = new URL("http", hostAddr, altport, BigdataStatics.getContextPath()).toExternalForm();
            String resp1 = this.doGET(this.m_serviceURL + "/status");
            String resp2 = this.doGET(altserviceURL + "/status");
            Test_REST_Structure.assertFalse((boolean)resp1.equals(resp2));
        }
        finally {
            altfixture.stop();
        }
    }

    public void test_webapp_structure_rootURL() throws Exception {
        String content = this.doGET(this.m_rootURL);
        Test_REST_Structure.assertTrue((boolean)content.contains(JUNIT_TEST_MARKER_INDEX_HTML));
    }

    public void test_webapp_structure_contextPath() throws Exception {
        String content = this.doGET(this.m_serviceURL);
        Test_REST_Structure.assertTrue((boolean)content.contains(JUNIT_TEST_MARKER_INDEX_HTML));
    }

    public void test_webapp_structure_contextPath_indexHtml() throws Exception {
        try {
            this.doGET(this.m_serviceURL + "/index.html");
        }
        catch (HttpException ex) {
            Test_REST_Structure.assertEquals((int)404, (int)ex.getStatusCode());
        }
    }

    public void test_webapp_structure_favicon() throws Exception {
        this.doGET(this.m_serviceURL + "/html/favicon.ico");
    }

    public void test_webapp_structure_status() throws Exception {
        this.doGET(this.m_serviceURL + "/status");
    }

    public void test_webapp_structure_counters() throws Exception {
        this.doGET(this.m_serviceURL + "/counters");
    }

    public void test_webapp_structure_contextPath_html_indexHtml() throws Exception {
        this.doGET(this.m_serviceURL + "/html/index.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doGET(String url) throws Exception {
        JettyResponseListener response = null;
        ConnectOptions opts = new ConnectOptions(url);
        opts.method = "GET";
        response = this.doConnect(opts);
        try {
            Test_REST_Structure.checkResponseCode(url, response);
            String string = response.getResponseBody();
            return string;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    private static JettyResponseListener checkResponseCode(String url, JettyResponseListener response) throws IOException {
        int rc = response.getStatus();
        if (rc < 200 || rc >= 300) {
            throw new HttpException(rc, "StatusCode=" + rc + ", StatusLine=" + response.getReason() + ", headers=" + response.getHeaders().toString() + ", ResponseBody=" + response.getResponseBody());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"*** Response ***");
            log.debug((Object)("Status Line: " + response.getReason()));
        }
        return response;
    }

    private JettyResponseListener doConnect(ConnectOptions opts) throws Exception {
        boolean isLongRequestURL;
        StringBuilder urlString = new StringBuilder(opts.serviceURL);
        ConnectOptions.addQueryParams((StringBuilder)urlString, (Map)opts.requestParams);
        boolean bl = isLongRequestURL = urlString.length() > 1024;
        if (isLongRequestURL && opts.method.equals("POST") && opts.entity == null) {
            urlString.setLength(0);
            urlString.append(opts.serviceURL);
            opts.entity = ConnectOptions.getFormEntity((Map)opts.requestParams);
        } else if (isLongRequestURL && opts.method.equals("GET") && opts.entity == null) {
            opts.method = "POST";
            urlString.setLength(0);
            urlString.append(opts.serviceURL);
            opts.entity = ConnectOptions.getFormEntity((Map)opts.requestParams);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"*** Request ***");
            log.debug((Object)opts.serviceURL);
            log.debug((Object)opts.method);
            log.debug((Object)("query=" + opts.getRequestParam("query")));
            log.debug((Object)urlString.toString());
        }
        Request request = null;
        try {
            request = this.m_repo.getRemoteRepositoryManager().newRequest(urlString.toString(), opts.method);
            if (opts.requestHeaders != null) {
                for (Map.Entry e : opts.requestHeaders.entrySet()) {
                    request.getHeaders().add((String)e.getKey(), (String)e.getValue());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)((String)e.getKey() + ": " + (String)e.getValue()));
                }
            }
            if (opts.entity != null) {
                ((HttpEntityEnclosingRequestBase)request).setEntity(opts.entity);
            }
            JettyResponseListener response = new JettyResponseListener(request, TimeUnit.SECONDS.toMillis(300L));
            request.send((Response.CompleteListener)response);
            return response;
        }
        catch (Throwable t) {
            try {
                if (request != null) {
                    request.abort(t);
                }
            }
            catch (Throwable t2) {
                // empty catch block
            }
            throw new RuntimeException(opts.serviceURL + " : " + t, t);
        }
    }
}

