/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepositoryConnection;
import com.bigdata.rdf.sail.webapp.AbstractProtocolTest;
import com.bigdata.rdf.sail.webapp.ProxySuiteHelper;
import com.bigdata.rdf.sail.webapp.TestMode;
import java.util.ArrayList;
import junit.framework.Test;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryException;

public class Test_Ticket_1893
extends AbstractProtocolTest {
    private static final String QUERY = "prefix bds: <http://www.bigdata.com/rdf/search#>\nselect ?s \nwhere {\n  ?o bds:search \"Test*\" .\n  ?s ?p ?o .\n}";

    public Test_Ticket_1893(String name) {
        super(name);
    }

    public static Test suite() {
        return ProxySuiteHelper.suiteWhenStandalone(Test_Ticket_1893.class, "test.*", TestMode.quads);
    }

    public void test_simple() throws Exception {
        this.setMethodisPostUrlEncodedData();
        BigdataSailRemoteRepositoryConnection conn = this.m_repo.getBigdataSailRemoteRepository().getConnection();
        conn.prepareUpdate(QueryLanguage.SPARQL, "INSERT { <http://s1> <http://p> \"Test123\" } WHERE { }").execute();
        this.checkResults(conn, 1);
        conn.prepareUpdate(QueryLanguage.SPARQL, "INSERT { <http://s2> <http://p> \"Test234\"^^xsd:string } WHERE { }").execute();
        this.checkResults(conn, 2);
        conn.prepareUpdate(QueryLanguage.SPARQL, "INSERT { <http://s3> <http://p> \"Test345\" } WHERE { }").execute();
        this.checkResults(conn, 3);
        this.m_repo.getRemoteRepositoryManager().rebuildTextIndex(this.namespace, true);
        this.checkResults(conn, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkResults(BigdataSailRemoteRepositoryConnection conn, int count) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        ArrayList<Value> subjects = new ArrayList<Value>();
        try (TupleQueryResult result = conn.prepareTupleQuery(QueryLanguage.SPARQL, QUERY).evaluate();){
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                subjects.add(bs.getBinding("s").getValue());
            }
        }
        if (log.isInfoEnabled()) {
            log.info(subjects);
        }
        Test_Ticket_1893.assertEquals((int)count, (int)subjects.size());
    }
}

