/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.health;

import com.bigdata.BigdataStatics;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.sail.CreateKBTask;
import com.bigdata.rdf.sail.DestroyKBTask;
import com.bigdata.rdf.sail.webapp.DatasetNotFoundException;
import com.bigdata.rdf.sail.webapp.NanoSparqlServer;
import com.bigdata.rdf.sail.webapp.client.ConnectOptions;
import com.bigdata.rdf.sail.webapp.client.HttpClientConfigurator;
import com.bigdata.rdf.sail.webapp.client.HttpException;
import com.bigdata.rdf.sail.webapp.client.JettyResponseListener;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import com.bigdata.rdf.task.AbstractApiTask;
import com.bigdata.rdf.task.IApiTask;
import com.bigdata.util.DaemonThreadFactory;
import com.bigdata.util.InnerCause;
import com.bigdata.util.config.NicUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase2;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.ResultPrinter;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.Server;

public class TestNSSHealthCheck
extends TestCase2 {
    private static final String JUNIT_TEST_MARKER_INDEX_HTML = "junit test marker: index.html";
    private ExecutorService executorService;
    protected HttpClient m_client;
    protected RemoteRepositoryManager m_repo;
    protected String m_serviceURL;
    protected String m_rootURL;
    protected Server m_fixture;
    protected String m_namespace;
    private Journal m_indexManager;

    public TestNSSHealthCheck(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_namespace = this.getName() + UUID.randomUUID();
        this.m_fixture = this.newFixture();
        int port = NanoSparqlServer.getLocalPort((Server)this.m_fixture);
        String hostAddr = NicUtil.getIpAddress((String)"default.nic", (String)"default", (boolean)true);
        if (hostAddr == null) {
            TestNSSHealthCheck.fail((String)"Could not identify network address for this host.");
        }
        this.m_rootURL = new URL("http", hostAddr, port, "").toExternalForm();
        this.m_serviceURL = new URL("http", hostAddr, port, BigdataStatics.getContextPath()).toExternalForm();
        this.executorService = Executors.newCachedThreadPool(DaemonThreadFactory.defaultThreadFactory());
        this.m_client = HttpClientConfigurator.getInstance().newInstance();
        this.m_repo = new RemoteRepositoryManager(this.m_serviceURL, this.m_client, (Executor)this.executorService);
    }

    protected void tearDown() throws Exception {
        this.m_rootURL = null;
        this.m_serviceURL = null;
        if (this.m_fixture != null) {
            this.m_fixture.stop();
            this.m_fixture = null;
        }
        if (this.m_indexManager != null && this.m_namespace != null) {
            this.dropTripleStore((IIndexManager)this.m_indexManager, this.m_namespace);
        }
        if (this.m_repo != null) {
            this.m_repo.close();
            this.m_repo = null;
        }
        if (this.m_client != null) {
            this.m_client.stop();
            this.m_client = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        super.tearDown();
    }

    private void dropTripleStore(IIndexManager indexManager, String namespace) {
        if (log.isInfoEnabled()) {
            log.info((Object)("KB namespace=" + namespace));
        }
        try {
            AbstractApiTask.submitApiTask((IIndexManager)indexManager, (IApiTask)new DestroyKBTask(namespace)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (InnerCause.isInnerCause((Throwable)e, DatasetNotFoundException.class)) {
                return;
            }
            throw new RuntimeException(e);
        }
    }

    protected Server newFixture() throws Exception {
        Properties properties = this.getProperties();
        this.m_indexManager = new Journal(properties);
        AbstractApiTask.submitApiTask((IIndexManager)this.m_indexManager, (IApiTask)new CreateKBTask(this.m_namespace, properties)).get();
        LinkedHashMap<String, String> initParams = new LinkedHashMap<String, String>();
        initParams.put("namespace", this.m_namespace);
        initParams.put("create", "false");
        Server fixture = NanoSparqlServer.newInstance((int)0, (IIndexManager)this.m_indexManager, initParams);
        fixture.start();
        return fixture;
    }

    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(Journal.Options.BUFFER_MODE, BufferMode.DiskRW.toString());
        props.setProperty(Journal.Options.CREATE_TEMP_FILE, "true");
        return props;
    }

    static HealthCheckTestSuite createTestSuite(String name, String requestURI) {
        HealthCheckTestSuite suite = new HealthCheckTestSuite(name, requestURI);
        suite.addTestSuite(TestNSSHealthCheck.class);
        return suite;
    }

    public void test_webapp_structure_rootURL() throws Exception {
        String content = this.doGET(this.m_rootURL);
        TestNSSHealthCheck.assertTrue((boolean)content.contains(JUNIT_TEST_MARKER_INDEX_HTML));
    }

    public void test_webapp_structure_contextPath() throws Exception {
        String content = this.doGET(this.m_serviceURL);
        TestNSSHealthCheck.assertTrue((boolean)content.contains(JUNIT_TEST_MARKER_INDEX_HTML));
    }

    public void test_webapp_structure_contextPath_indexHtml() throws Exception {
        try {
            this.doGET(this.m_serviceURL + "/index.html");
        }
        catch (HttpException ex) {
            TestNSSHealthCheck.assertEquals((int)404, (int)ex.getStatusCode());
        }
    }

    public void test_webapp_structure_favicon() throws Exception {
        this.doGET(this.m_serviceURL + "/html/favicon.ico");
    }

    public void test_webapp_structure_status() throws Exception {
        this.doGET(this.m_serviceURL + "/status");
    }

    public void test_webapp_structure_counters() throws Exception {
        this.doGET(this.m_serviceURL + "/counters");
    }

    public void test_webapp_structure_contextPath_html_indexHtml() throws Exception {
        this.doGET(this.m_serviceURL + "/html/index.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doGET(String url) throws Exception {
        JettyResponseListener response = null;
        try {
            ConnectOptions opts = new ConnectOptions(url);
            opts.method = "GET";
            response = this.m_repo.doConnect(opts);
            RemoteRepository.checkResponseCode((JettyResponseListener)response);
            String string = response.getResponseBody();
            return string;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws MalformedURLException {
        if (args.length < 1) {
            System.err.println("usage: Request-URI");
            System.exit(1);
        }
        String requestURI = args[0];
        TestResult result = new TestResult();
        result.addListener((TestListener)new ResultPrinter(System.out));
        result.addListener(new TestListener(){

            public void startTest(Test arg0) {
                log.info((Object)arg0);
            }

            public void endTest(Test arg0) {
                log.info((Object)arg0);
            }

            public void addFailure(Test arg0, AssertionFailedError arg1) {
                log.error((Object)arg0, (Throwable)arg1);
            }

            public void addError(Test arg0, Throwable arg1) {
                log.error((Object)arg0, arg1);
            }
        });
        HealthCheckTestSuite test = TestNSSHealthCheck.createTestSuite(null, requestURI);
        System.out.println("Running health check: Request-URI=" + requestURI);
        test.run(result);
        String msg = "nerrors=" + result.errorCount() + ", nfailures=" + result.failureCount() + ", nrun=" + result.runCount() + " : Request-URI=" + requestURI;
        System.out.println(msg);
        if (result.errorCount() > 0 || result.failureCount() > 0) {
            System.exit(1);
        }
        System.exit(0);
    }

    static class HealthCheckTestSuite
    extends TestSuite {
        private final String requestURI;

        private HealthCheckTestSuite(String name, String requestURI) {
            super(name);
            this.requestURI = requestURI;
        }
    }
}

