/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.lbs;

import com.bigdata.BigdataStatics;
import com.bigdata.rdf.sail.webapp.lbs.AbstractHostLBSPolicy;
import com.bigdata.rdf.sail.webapp.lbs.HostScore;
import com.bigdata.rdf.sail.webapp.lbs.ServiceScore;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase2;

public class TestAbstractHostLBSPolicy
extends TestCase2 {
    private AtomicInteger nextPort;

    protected void setUp() throws Exception {
        this.nextPort = new AtomicInteger(9999);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.nextPort = null;
    }

    public TestAbstractHostLBSPolicy() {
    }

    public TestAbstractHostLBSPolicy(String name) {
        super(name);
    }

    public void test_lbs_host_policy() {
        HostScore hostScore1;
        block5: {
            HostScore[] hostScores;
            block4: {
                String H1 = "H1";
                hostScore1 = new HostScore("H1", 1.0);
                TestAbstractHostLBSPolicy.assertEquals((double)1.0, (double)hostScore1.getAvailability());
                hostScores = new HostScore[]{hostScore1};
                HostScore actualHost = AbstractHostLBSPolicy.getHost((double)0.0, (HostScore[])hostScores);
                this.assertSameRef(hostScore1, actualHost);
                actualHost = AbstractHostLBSPolicy.getHost((double)0.1, (HostScore[])hostScores);
                this.assertSameRef(hostScore1, actualHost);
                actualHost = AbstractHostLBSPolicy.getHost((double)0.5, (HostScore[])hostScores);
                this.assertSameRef(hostScore1, actualHost);
                actualHost = AbstractHostLBSPolicy.getHost((double)0.9, (HostScore[])hostScores);
                this.assertSameRef(hostScore1, actualHost);
                try {
                    AbstractHostLBSPolicy.getHost((double)1.0, (HostScore[])hostScores);
                }
                catch (IllegalArgumentException ex) {
                    if (!log.isInfoEnabled()) break block4;
                    log.info((Object)ex);
                }
            }
            try {
                AbstractHostLBSPolicy.getHost((double)-1.0E-5, (HostScore[])hostScores);
            }
            catch (IllegalArgumentException ex) {
                if (!log.isInfoEnabled()) break block5;
                log.info((Object)ex);
            }
        }
        UUID A = UUID.randomUUID();
        UUID B = UUID.randomUUID();
        UUID C = UUID.randomUUID();
        ServiceScore serviceA = new ServiceScore(A, "H1", this.toRequestURI("H1"));
        ServiceScore serviceB = new ServiceScore(B, "H1", this.toRequestURI("H1"));
        ServiceScore serviceC = new ServiceScore(C, "H1", this.toRequestURI("H1"));
        Random rand = new Random(1L);
        ServiceScore[] serviceScores = new ServiceScore[]{serviceA};
        ServiceScore actualService = AbstractHostLBSPolicy.getService((Random)rand, (HostScore)hostScore1, (ServiceScore[])serviceScores);
        TestAbstractHostLBSPolicy.assertTrue((actualService == serviceA ? 1 : 0) != 0);
        rand = new Random(1L);
        serviceScores = new ServiceScore[]{serviceA, serviceB, serviceC};
        actualService = AbstractHostLBSPolicy.getService((Random)rand, (HostScore)hostScore1, (ServiceScore[])serviceScores);
        TestAbstractHostLBSPolicy.assertTrue((actualService == serviceA ? 1 : 0) != 0);
    }

    public void test_HA3() {
    }

    private <T> void assertSameRef(T expected, T actual) {
        if (expected != actual) {
            TestAbstractHostLBSPolicy.fail((String)("Different reference: expected=" + expected + ", actual=" + actual));
        }
    }

    private String toRequestURI(String hostname) {
        return "http://" + hostname + ":" + this.nextPort.getAndIncrement() + BigdataStatics.getContextPath();
    }
}

