/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import info.aduna.iteration.Iteration;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.QueryResults;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerBase;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComplexSPARQLQueryTest
extends TestCase {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Repository rep;
    protected RepositoryConnection conn;
    protected ValueFactory f;
    protected static final String EX_NS = "http://example.org/";
    private URI bob;
    private URI alice;
    private URI mary;

    @Before
    public void setUp() throws Exception {
        this.logger.debug("setting up test");
        this.rep = this.newRepository();
        this.rep.initialize();
        this.f = this.rep.getValueFactory();
        this.conn = this.rep.getConnection();
        this.conn.clear(new Resource[0]);
        this.bob = this.f.createURI(EX_NS, "bob");
        this.alice = this.f.createURI(EX_NS, "alice");
        this.mary = this.f.createURI(EX_NS, "mary");
        this.logger.debug("test setup complete.");
    }

    @After
    public void tearDown() throws Exception {
        this.logger.debug("tearing down...");
        this.conn.close();
        this.conn = null;
        this.rep.shutDown();
        this.rep = null;
        this.logger.debug("tearDown complete.");
    }

    @Test
    public void testNullContext1() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(" SELECT * ");
        query.append(" FROM DEFAULT ");
        query.append(" WHERE { ?s ?p ?o } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertNotNull((Object)bs);
                Resource s = (Resource)bs.getValue("s");
                ComplexSPARQLQueryTest.assertNotNull((Object)s);
                ComplexSPARQLQueryTest.assertFalse((boolean)this.bob.equals((Object)s));
                ComplexSPARQLQueryTest.assertFalse((boolean)this.alice.equals((Object)s));
            }
            result.close();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNullContext2() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append(" SELECT * ");
        query.append(" FROM sesame:nil ");
        query.append(" WHERE { ?s ?p ?o } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertNotNull((Object)bs);
                Resource s = (Resource)bs.getValue("s");
                ComplexSPARQLQueryTest.assertNotNull((Object)s);
                ComplexSPARQLQueryTest.assertFalse((boolean)this.bob.equals((Object)s));
                ComplexSPARQLQueryTest.assertFalse((boolean)this.alice.equals((Object)s));
            }
            result.close();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDescribeA() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE ex:a");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory f = this.conn.getValueFactory();
        URI a = f.createURI("http://example.org/a");
        URI p = f.createURI("http://example.org/p");
        Model result = QueryResults.asModel((GraphQueryResult)gq.evaluate());
        Set objects = result.filter((Resource)a, p, null, new Resource[0]).objects();
        ComplexSPARQLQueryTest.assertNotNull((Object)objects);
        for (Value object : objects) {
            if (!(object instanceof BNode)) continue;
            ComplexSPARQLQueryTest.assertTrue((boolean)result.contains((Resource)object, null, null, new Resource[0]));
            ComplexSPARQLQueryTest.assertEquals((int)2, (int)result.filter((Resource)object, null, null, new Resource[0]).size());
        }
    }

    @Test
    public void testDescribeAWhere() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE ?x WHERE {?x rdfs:label \"a\". } ");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory f = this.conn.getValueFactory();
        URI a = f.createURI("http://example.org/a");
        URI p = f.createURI("http://example.org/p");
        Model result = QueryResults.asModel((GraphQueryResult)gq.evaluate());
        Set objects = result.filter((Resource)a, p, null, new Resource[0]).objects();
        ComplexSPARQLQueryTest.assertNotNull((Object)objects);
        for (Value object : objects) {
            if (!(object instanceof BNode)) continue;
            ComplexSPARQLQueryTest.assertTrue((boolean)result.contains((Resource)object, null, null, new Resource[0]));
            ComplexSPARQLQueryTest.assertEquals((int)2, (int)result.filter((Resource)object, null, null, new Resource[0]).size());
        }
    }

    @Test
    public void testDescribeWhere() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE ?x WHERE {?x rdfs:label ?y . } ");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory vf = this.conn.getValueFactory();
        URI a = vf.createURI("http://example.org/a");
        URI b = vf.createURI("http://example.org/b");
        URI c = vf.createURI("http://example.org/c");
        URI e = vf.createURI("http://example.org/e");
        URI f = vf.createURI("http://example.org/f");
        URI p = vf.createURI("http://example.org/p");
        Model result = QueryResults.asModel((GraphQueryResult)gq.evaluate());
        ComplexSPARQLQueryTest.assertTrue((boolean)result.contains((Resource)a, p, null, new Resource[0]));
        ComplexSPARQLQueryTest.assertTrue((boolean)result.contains((Resource)b, RDFS.LABEL, null, new Resource[0]));
        ComplexSPARQLQueryTest.assertTrue((boolean)result.contains((Resource)c, RDFS.LABEL, null, new Resource[0]));
        ComplexSPARQLQueryTest.assertTrue((boolean)result.contains(null, p, (Value)b, new Resource[0]));
        ComplexSPARQLQueryTest.assertTrue((boolean)result.contains((Resource)e, RDFS.LABEL, null, new Resource[0]));
        ComplexSPARQLQueryTest.assertTrue((boolean)result.contains(null, p, (Value)e, new Resource[0]));
        ComplexSPARQLQueryTest.assertFalse((boolean)result.contains((Resource)f, null, null, new Resource[0]));
        Set objects = result.filter((Resource)a, p, null, new Resource[0]).objects();
        ComplexSPARQLQueryTest.assertNotNull((Object)objects);
        for (Value object : objects) {
            if (!(object instanceof BNode)) continue;
            ComplexSPARQLQueryTest.assertTrue((boolean)result.contains((Resource)object, null, null, new Resource[0]));
            ComplexSPARQLQueryTest.assertEquals((int)2, (int)result.filter((Resource)object, null, null, new Resource[0]).size());
        }
    }

    @Test
    public void testDescribeB() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE ex:b");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory f = this.conn.getValueFactory();
        URI b = f.createURI("http://example.org/b");
        URI p = f.createURI("http://example.org/p");
        Model result = QueryResults.asModel((GraphQueryResult)gq.evaluate());
        Set subjects = result.filter(null, p, (Value)b, new Resource[0]).subjects();
        ComplexSPARQLQueryTest.assertNotNull((Object)subjects);
        for (Value subject : subjects) {
            if (!(subject instanceof BNode)) continue;
            ComplexSPARQLQueryTest.assertTrue((boolean)result.contains(null, null, subject, new Resource[0]));
        }
    }

    @Test
    public void testDescribeD() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE ex:d");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory f = this.conn.getValueFactory();
        URI d = f.createURI("http://example.org/d");
        URI p = f.createURI("http://example.org/p");
        URI e = f.createURI("http://example.org/e");
        Model result = QueryResults.asModel((GraphQueryResult)gq.evaluate());
        ComplexSPARQLQueryTest.assertNotNull((Object)result);
        ComplexSPARQLQueryTest.assertTrue((boolean)result.contains(null, p, (Value)e, new Resource[0]));
        ComplexSPARQLQueryTest.assertFalse((boolean)result.contains((Resource)e, null, null, new Resource[0]));
        Set objects = result.filter((Resource)d, p, null, new Resource[0]).objects();
        ComplexSPARQLQueryTest.assertNotNull((Object)objects);
        for (Value object : objects) {
            if (!(object instanceof BNode)) continue;
            Set childObjects = result.filter((Resource)((BNode)object), null, null, new Resource[0]).objects();
            ComplexSPARQLQueryTest.assertNotNull((Object)childObjects);
            for (Value childObject : childObjects) {
                if (!(childObject instanceof BNode)) continue;
                ComplexSPARQLQueryTest.assertTrue((boolean)result.contains((Resource)((BNode)childObject), null, null, new Resource[0]));
            }
        }
    }

    @Test
    public void testDescribeF() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE ex:f");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory vf = this.conn.getValueFactory();
        URI f = vf.createURI("http://example.org/f");
        URI p = vf.createURI("http://example.org/p");
        Model result = QueryResults.asModel((GraphQueryResult)gq.evaluate());
        ComplexSPARQLQueryTest.assertNotNull((Object)result);
        ComplexSPARQLQueryTest.assertEquals((int)4, (int)result.size());
        Set objects = result.filter((Resource)f, p, null, new Resource[0]).objects();
        ComplexSPARQLQueryTest.assertNotNull((Object)objects);
        for (Value object : objects) {
            if (!(object instanceof BNode)) continue;
            Set childObjects = result.filter((Resource)((BNode)object), null, null, new Resource[0]).objects();
            ComplexSPARQLQueryTest.assertNotNull((Object)childObjects);
            for (Value childObject : childObjects) {
                if (!(childObject instanceof BNode)) continue;
                ComplexSPARQLQueryTest.assertTrue((boolean)result.contains((Resource)((BNode)childObject), null, null, new Resource[0]));
            }
        }
    }

    @Test
    public void testGroupConcatDistinct() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT (GROUP_CONCAT(DISTINCT ?l) AS ?concat)");
        query.append("WHERE { ex:groupconcat-test ?p ?l . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertNotNull((Object)bs);
                Value concat = bs.getValue("concat");
                ComplexSPARQLQueryTest.assertTrue((boolean)(concat instanceof Literal));
                String lexValue = ((Literal)concat).getLabel();
                int occ = this.countCharOccurrences(lexValue, 'a');
                ComplexSPARQLQueryTest.assertEquals((int)1, (int)occ);
                occ = this.countCharOccurrences(lexValue, 'b');
                ComplexSPARQLQueryTest.assertEquals((int)1, (int)occ);
                occ = this.countCharOccurrences(lexValue, 'c');
                ComplexSPARQLQueryTest.assertEquals((int)1, (int)occ);
                occ = this.countCharOccurrences(lexValue, 'd');
                ComplexSPARQLQueryTest.assertEquals((int)1, (int)occ);
            }
            result.close();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSameTermRepeatInOptional() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append(" SELECT ?l ?opt1 ?opt2 ");
        query.append(" FROM ex:optional-sameterm-graph ");
        query.append(" WHERE { ");
        query.append("          ?s ex:p ex:A ; ");
        query.append("          { ");
        query.append("              { ");
        query.append("                 ?s ?p ?l .");
        query.append("                 FILTER(?p = rdfs:label) ");
        query.append("              } ");
        query.append("              OPTIONAL { ");
        query.append("                 ?s ?p ?opt1 . ");
        query.append("                 FILTER (?p = ex:prop1) ");
        query.append("              } ");
        query.append("              OPTIONAL { ");
        query.append("                 ?s ?p ?opt2 . ");
        query.append("                 FILTER (?p = ex:prop2) ");
        query.append("              } ");
        query.append("          }");
        query.append(" } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                ComplexSPARQLQueryTest.assertNotNull((Object)bs);
                System.out.println(bs);
                Value l = bs.getValue("l");
                ComplexSPARQLQueryTest.assertTrue((boolean)(l instanceof Literal));
                ComplexSPARQLQueryTest.assertEquals((String)"label", (String)((Literal)l).getLabel());
                Value opt1 = bs.getValue("opt1");
                ComplexSPARQLQueryTest.assertNull((Object)opt1);
                Value opt2 = bs.getValue("opt2");
                ComplexSPARQLQueryTest.assertNull((Object)opt2);
            }
            result.close();
            ComplexSPARQLQueryTest.assertEquals((int)1, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1121VarNamesInOptionals() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1121.trig", new Resource[0]);
        StringBuilder query1 = new StringBuilder();
        query1.append(this.getNamespaceDeclarations());
        query1.append(" SELECT DISTINCT *\n");
        query1.append(" WHERE { GRAPH ?g { \n");
        query1.append("          OPTIONAL { ?var35 ex:p ?b . } \n ");
        query1.append("          OPTIONAL { ?b ex:q ?c . } \n ");
        query1.append("       } \n");
        query1.append(" } \n");
        StringBuilder query2 = new StringBuilder();
        query2.append(this.getNamespaceDeclarations());
        query2.append(" SELECT DISTINCT *\n");
        query2.append(" WHERE { GRAPH ?g { \n");
        query2.append("          OPTIONAL { ?var35 ex:p ?b . } \n ");
        query2.append("          OPTIONAL { ?b ex:q ?var2 . } \n ");
        query2.append("       } \n");
        query2.append(" } \n");
        TupleQuery tq1 = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query1.toString());
        TupleQuery tq2 = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query2.toString());
        try {
            TupleQueryResult result1 = tq1.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result1);
            TupleQueryResult result2 = tq2.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result2);
            List qr1 = QueryResults.asList((Iteration)result1);
            List qr2 = QueryResults.asList((Iteration)result2);
            ComplexSPARQLQueryTest.assertEquals((int)qr1.size(), (int)qr2.size());
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1081SameTermWithValues() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1081.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append("PREFIX ex: <http://example.org/>\n");
        query.append(" SELECT * \n");
        query.append(" WHERE { \n ");
        query.append("          ?s ex:p ?a . \n");
        query.append("          FILTER sameTerm(?a, ?e) \n ");
        query.append("          VALUES ?e { ex:b } \n ");
        query.append(" } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                ComplexSPARQLQueryTest.assertNotNull((Object)bs);
                Value s = bs.getValue("s");
                Value a = bs.getValue("a");
                ComplexSPARQLQueryTest.assertNotNull((Object)s);
                ComplexSPARQLQueryTest.assertNotNull((Object)a);
                ComplexSPARQLQueryTest.assertEquals((Object)this.f.createURI("http://example.org/a"), (Object)s);
                ComplexSPARQLQueryTest.assertEquals((Object)this.f.createURI("http://example.org/b"), (Object)a);
            }
            result.close();
            ComplexSPARQLQueryTest.assertEquals((int)1, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1898LeftJoinSemantics1() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1898.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append("  PREFIX : <http://example.org/> ");
        query.append("  SELECT * WHERE { ");
        query.append("    ?s :p1 ?v1 . ");
        query.append("    OPTIONAL {?s :p2 ?v2 } .");
        query.append("     ?s :p3 ?v2 . ");
        query.append("  } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                result.next();
                ++count;
            }
            ComplexSPARQLQueryTest.assertEquals((int)0, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSES1073InverseSymmetricPattern() throws Exception {
        URI a = this.f.createURI("http://example.org/a");
        URI b1 = this.f.createURI("http://example.org/b1");
        URI b2 = this.f.createURI("http://example.org/b2");
        URI c1 = this.f.createURI("http://example.org/c1");
        URI c2 = this.f.createURI("http://example.org/c2");
        URI a2b = this.f.createURI("http://example.org/a2b");
        URI b2c = this.f.createURI("http://example.org/b2c");
        this.conn.add((Resource)a, a2b, (Value)b1, new Resource[0]);
        this.conn.add((Resource)a, a2b, (Value)b2, new Resource[0]);
        this.conn.add((Resource)b1, b2c, (Value)c1, new Resource[0]);
        this.conn.add((Resource)b2, b2c, (Value)c2, new Resource[0]);
        String query = "select * ";
        query = query + "where{ ";
        query = query + "?c1 ^<http://example.org/b2c>/^<http://example.org/a2b>/<http://example.org/a2b>/<http://example.org/b2c> ?c2 . ";
        query = query + " } ";
        try (TupleQueryResult qRes = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            ComplexSPARQLQueryTest.assertTrue((boolean)qRes.hasNext());
            int count = 0;
            while (qRes.hasNext()) {
                BindingSet r = (BindingSet)qRes.next();
                System.out.println(r);
                ++count;
            }
            ComplexSPARQLQueryTest.assertEquals((int)4, (int)count);
        }
    }

    @Test
    public void testSES1970CountDistinctWildcard() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1970.trig", new Resource[0]);
        String query = "SELECT (COUNT(DISTINCT *) AS ?c) {?s ?p ?o }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            ComplexSPARQLQueryTest.assertTrue((boolean)result.hasNext());
            BindingSet s = (BindingSet)result.next();
            Literal count = (Literal)s.getValue("c");
            ComplexSPARQLQueryTest.assertNotNull((Object)count);
            ComplexSPARQLQueryTest.assertEquals((int)3, (int)count.intValue());
            result.close();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1898LeftJoinSemantics2() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1898.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append("  PREFIX : <http://example.org/> ");
        query.append("  SELECT * WHERE { ");
        query.append("    ?s :p1 ?v1 . ");
        query.append("    ?s :p3 ?v2 . ");
        query.append("    OPTIONAL {?s :p2 ?v2 } .");
        query.append("  } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                result.next();
                ++count;
            }
            ComplexSPARQLQueryTest.assertEquals((int)1, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIdenticalVariablesInStatementPattern() throws Exception {
        this.conn.add((Resource)this.alice, this.f.createURI("http://purl.org/dc/elements/1.1/publisher"), (Value)this.bob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT ?publisher ");
        queryBuilder.append("{ ?publisher <http://purl.org/dc/elements/1.1/publisher> ?publisher }");
        this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString()).evaluate((TupleQueryResultHandler)new TupleQueryResultHandlerBase(){

            public void handleSolution(BindingSet bindingSet) {
                TestCase.fail((String)"nobody is self published");
            }
        });
    }

    @Test
    public void testInComparison1() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1913.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(" PREFIX : <http://example.org/>\n");
        query.append(" SELECT ?y WHERE { :a :p ?y. FILTER(?y in (:c, :d, 1/0 , 1)) } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        TupleQueryResult result = tq.evaluate();
        ComplexSPARQLQueryTest.assertNotNull((Object)result);
        ComplexSPARQLQueryTest.assertTrue((boolean)result.hasNext());
        BindingSet bs = (BindingSet)result.next();
        Value y = bs.getValue("y");
        ComplexSPARQLQueryTest.assertNotNull((Object)y);
        ComplexSPARQLQueryTest.assertTrue((boolean)(y instanceof Literal));
        ComplexSPARQLQueryTest.assertEquals((Object)this.f.createLiteral("1", XMLSchema.INTEGER), (Object)y);
    }

    @Test
    public void testInComparison2() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1913.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(" PREFIX : <http://example.org/>\n");
        query.append(" SELECT ?y WHERE { :a :p ?y. FILTER(?y in (:c, :d, 1/0)) } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        TupleQueryResult result = tq.evaluate();
        ComplexSPARQLQueryTest.assertNotNull((Object)result);
        ComplexSPARQLQueryTest.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testInComparison3() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1913.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(" PREFIX : <http://example.org/>\n");
        query.append(" SELECT ?y WHERE { :a :p ?y. FILTER(?y in (:c, :d, 1, 1/0)) } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        TupleQueryResult result = tq.evaluate();
        ComplexSPARQLQueryTest.assertNotNull((Object)result);
        ComplexSPARQLQueryTest.assertTrue((boolean)result.hasNext());
        BindingSet bs = (BindingSet)result.next();
        Value y = bs.getValue("y");
        ComplexSPARQLQueryTest.assertNotNull((Object)y);
        ComplexSPARQLQueryTest.assertTrue((boolean)(y instanceof Literal));
        ComplexSPARQLQueryTest.assertEquals((Object)this.f.createLiteral("1", XMLSchema.INTEGER), (Object)y);
    }

    @Test
    public void testValuesInOptional() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1692.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(" PREFIX : <http://example.org/>\n");
        query.append(" SELECT DISTINCT ?a ?name ?isX WHERE { ?b :p1 ?a . ?a :name ?name. OPTIONAL { ?a a :X . VALUES(?isX) { (:X) } } } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        TupleQueryResult result = tq.evaluate();
        ComplexSPARQLQueryTest.assertNotNull((Object)result);
        ComplexSPARQLQueryTest.assertTrue((boolean)result.hasNext());
        int count = 0;
        while (result.hasNext()) {
            ++count;
            BindingSet bs = (BindingSet)result.next();
            System.out.println(bs);
            URI a = (URI)bs.getValue("a");
            ComplexSPARQLQueryTest.assertNotNull((Object)a);
            Value isX = bs.getValue("isX");
            Literal name = (Literal)bs.getValue("name");
            ComplexSPARQLQueryTest.assertNotNull((Object)name);
            if (a.stringValue().endsWith("a1")) {
                ComplexSPARQLQueryTest.assertNotNull((Object)isX);
                continue;
            }
            if (!a.stringValue().endsWith("a2")) continue;
            ComplexSPARQLQueryTest.assertNull((Object)isX);
        }
        ComplexSPARQLQueryTest.assertEquals((int)2, (int)count);
    }

    @Test
    public void testSameTermRepeatInUnion() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append("PREFIX foaf:<http://xmlns.com/foaf/0.1/>\n");
        query.append("SELECT * {\n");
        query.append("    {\n");
        query.append("        ?sameTerm foaf:mbox ?mbox\n");
        query.append("        FILTER sameTerm(?sameTerm,$william)\n");
        query.append("    } UNION {\n");
        query.append("        ?x foaf:knows ?sameTerm\n");
        query.append("        FILTER sameTerm(?sameTerm,$william)\n");
        query.append("    }\n");
        query.append("}");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        tq.setBinding("william", (Value)this.conn.getValueFactory().createURI("http://example.org/william"));
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                ComplexSPARQLQueryTest.assertNotNull((Object)bs);
                System.out.println(bs);
                Value mbox = bs.getValue("mbox");
                Value x = bs.getValue("x");
                ComplexSPARQLQueryTest.assertTrue((mbox instanceof Literal || x instanceof URI ? 1 : 0) != 0);
            }
            result.close();
            ComplexSPARQLQueryTest.assertEquals((int)3, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSameTermRepeatInUnionAndOptional() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT * {\n");
        query.append("    {\n");
        query.append("        ex:a ?p ?prop1\n");
        query.append("        FILTER (?p = ex:prop1)\n");
        query.append("    } UNION {\n");
        query.append("          ?s ex:p ex:A ; ");
        query.append("          { ");
        query.append("              { ");
        query.append("                 ?s ?p ?l .");
        query.append("                 FILTER(?p = rdfs:label) ");
        query.append("              } ");
        query.append("              OPTIONAL { ");
        query.append("                 ?s ?p ?opt1 . ");
        query.append("                 FILTER (?p = ex:prop1) ");
        query.append("              } ");
        query.append("              OPTIONAL { ");
        query.append("                 ?s ?p ?opt2 . ");
        query.append("                 FILTER (?p = ex:prop2) ");
        query.append("              } ");
        query.append("          }");
        query.append("    }\n");
        query.append("}");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                ComplexSPARQLQueryTest.assertNotNull((Object)bs);
                System.out.println(bs);
                Value prop1 = bs.getValue("prop1");
                Value l = bs.getValue("l");
                ComplexSPARQLQueryTest.assertTrue((prop1 instanceof Literal || l instanceof Literal ? 1 : 0) != 0);
                if (!(l instanceof Literal)) continue;
                Value opt1 = bs.getValue("opt1");
                ComplexSPARQLQueryTest.assertNull((Object)opt1);
                Value opt2 = bs.getValue("opt2");
                ComplexSPARQLQueryTest.assertNull((Object)opt2);
            }
            result.close();
            ComplexSPARQLQueryTest.assertEquals((int)2, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPropertyPathInTree() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append(" SELECT ?node ?name ");
        query.append(" FROM ex:tree-graph ");
        query.append(" WHERE { ?node ex:hasParent+ ex:b . ?node ex:name ?name . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertNotNull((Object)bs);
                System.out.println(bs);
            }
            result.close();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testFilterRegexBoolean() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append(" SELECT *");
        query.append(" WHERE { ");
        query.append("       ?x foaf:name ?name ; ");
        query.append("          foaf:mbox ?mbox . ");
        query.append("       FILTER(EXISTS { ");
        query.append("            FILTER(REGEX(?name, \"Bo\") && REGEX(?mbox, \"bob\")) ");
        query.append("            } )");
        query.append(" } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            ComplexSPARQLQueryTest.assertTrue((boolean)result.hasNext());
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                System.out.println(bs);
            }
            ComplexSPARQLQueryTest.assertEquals((int)1, (int)count);
            result.close();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGroupConcatNonDistinct() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT (GROUP_CONCAT(?l) AS ?concat)");
        query.append("WHERE { ex:groupconcat-test ?p ?l . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertNotNull((Object)bs);
                Value concat = bs.getValue("concat");
                ComplexSPARQLQueryTest.assertTrue((boolean)(concat instanceof Literal));
                String lexValue = ((Literal)concat).getLabel();
                int occ = this.countCharOccurrences(lexValue, 'a');
                ComplexSPARQLQueryTest.assertEquals((int)1, (int)occ);
                occ = this.countCharOccurrences(lexValue, 'b');
                ComplexSPARQLQueryTest.assertEquals((int)2, (int)occ);
                occ = this.countCharOccurrences(lexValue, 'c');
                ComplexSPARQLQueryTest.assertEquals((int)2, (int)occ);
                occ = this.countCharOccurrences(lexValue, 'd');
                ComplexSPARQLQueryTest.assertEquals((int)1, (int)occ);
            }
            result.close();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding1() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child a owl:Class . ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            BindingSet bs;
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)7, (int)count);
            tq.setBinding("parent", (Value)OWL.THING);
            result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)4, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding2() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            BindingSet bs;
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)7, (int)count);
            tq.setBinding("parent", (Value)OWL.THING);
            result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)4, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding3() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            BindingSet bs;
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)7, (int)count);
            tq.setBinding("child", (Value)this.f.createURI(EX_NS, "C"));
            result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)2, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding4() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{this.alice});
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            BindingSet bs;
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)7, (int)count);
            tq.setBinding("child", (Value)this.f.createURI(EX_NS, "C"));
            result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)2, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding5() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{this.alice, this.bob});
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            BindingSet bs;
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            System.out.println("--- testArbitraryLengthPathWithBinding5 ---");
            int count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                System.out.println(bs);
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)7, (int)count);
            tq.setBinding("child", (Value)this.f.createURI(EX_NS, "C"));
            result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)2, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding6() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{this.alice, this.bob, this.mary});
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            BindingSet bs;
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            System.out.println("--- testArbitraryLengthPathWithBinding6 ---");
            int count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                System.out.println(bs);
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)7, (int)count);
            tq.setBinding("child", (Value)this.f.createURI(EX_NS, "C"));
            result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)2, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding7() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{this.alice, this.bob, this.mary});
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        DatasetImpl dt = new DatasetImpl();
        dt.addDefaultGraph(this.alice);
        tq.setDataset((Dataset)dt);
        try {
            BindingSet bs;
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            System.out.println("--- testArbitraryLengthPathWithBinding7 ---");
            int count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                System.out.println(bs);
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)7, (int)count);
            tq.setBinding("child", (Value)this.f.createURI(EX_NS, "C"));
            result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)2, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding8() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{this.alice, this.bob, this.mary});
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        DatasetImpl dt = new DatasetImpl();
        dt.addDefaultGraph(this.alice);
        dt.addDefaultGraph(this.bob);
        tq.setDataset((Dataset)dt);
        try {
            BindingSet bs;
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            System.out.println("--- testArbitraryLengthPathWithBinding8 ---");
            int count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                System.out.println(bs);
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)7, (int)count);
            tq.setBinding("child", (Value)this.f.createURI(EX_NS, "C"));
            result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            count = 0;
            while (result.hasNext()) {
                ++count;
                bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)2, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithFilter1() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child a owl:Class . ?child rdfs:subClassOf+ ?parent . FILTER (?parent = owl:Thing) }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)4, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithFilter2() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . FILTER (?parent = owl:Thing) }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)4, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithFilter3() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . FILTER (?child = <http://example.org/C>) }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("child"));
                ComplexSPARQLQueryTest.assertTrue((boolean)bs.hasBinding("parent"));
            }
            ComplexSPARQLQueryTest.assertEquals((int)2, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1991UUIDEvaluation() throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", new Resource[0]);
        String query = "SELECT ?uid WHERE {?s ?p ?o . BIND(UUID() as ?uid) } LIMIT 2";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            URI uuid1 = (URI)((BindingSet)result.next()).getValue("uid");
            URI uuid2 = (URI)((BindingSet)result.next()).getValue("uid");
            ComplexSPARQLQueryTest.assertNotNull((Object)uuid1);
            ComplexSPARQLQueryTest.assertNotNull((Object)uuid2);
            ComplexSPARQLQueryTest.assertFalse((boolean)uuid1.equals((Object)uuid2));
            result.close();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1991STRUUIDEvaluation() throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", new Resource[0]);
        String query = "SELECT ?uid WHERE {?s ?p ?o . BIND(STRUUID() as ?uid) } LIMIT 2";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            Literal uid1 = (Literal)((BindingSet)result.next()).getValue("uid");
            Literal uid2 = (Literal)((BindingSet)result.next()).getValue("uid");
            ComplexSPARQLQueryTest.assertNotNull((Object)uid1);
            ComplexSPARQLQueryTest.assertFalse((boolean)uid1.equals((Object)uid2));
            result.close();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1991RANDEvaluation() throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", new Resource[0]);
        String query = "SELECT ?r WHERE {?s ?p ?o . BIND(RAND() as ?r) } LIMIT 3";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            Literal r1 = (Literal)((BindingSet)result.next()).getValue("r");
            Literal r2 = (Literal)((BindingSet)result.next()).getValue("r");
            Literal r3 = (Literal)((BindingSet)result.next()).getValue("r");
            ComplexSPARQLQueryTest.assertNotNull((Object)r1);
            ComplexSPARQLQueryTest.assertFalse((r1.equals((Object)r2) && r1.equals((Object)r3) ? 1 : 0) != 0);
            result.close();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1991NOWEvaluation() throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", new Resource[0]);
        String query = "SELECT ?d WHERE {?s ?p ?o . BIND(NOW() as ?d) } LIMIT 2";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            Literal d1 = (Literal)((BindingSet)result.next()).getValue("d");
            Literal d2 = (Literal)((BindingSet)result.next()).getValue("d");
            ComplexSPARQLQueryTest.assertNotNull((Object)d1);
            ComplexSPARQLQueryTest.assertEquals((Object)d1, (Object)d2);
            result.close();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES2024PropertyPathAnonVarSharing() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses2024.trig", new Resource[0]);
        String query = "PREFIX : <http://example.org/> SELECT * WHERE { ?x1 :p/:lit ?l1 . ?x1 :diff ?x2 . ?x2 :p/:lit ?l2 . }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try {
            TupleQueryResult result = tq.evaluate();
            ComplexSPARQLQueryTest.assertNotNull((Object)result);
            BindingSet bs = (BindingSet)result.next();
            Literal l1 = (Literal)bs.getValue("l1");
            Literal l2 = (Literal)bs.getValue("l2");
            ComplexSPARQLQueryTest.assertNotNull((Object)l1);
            ComplexSPARQLQueryTest.assertFalse((boolean)l1.equals((Object)l2));
            result.close();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            ComplexSPARQLQueryTest.fail((String)e.getMessage());
        }
    }

    private int countCharOccurrences(String string, char ch) {
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ch) continue;
            ++count;
        }
        return count;
    }

    protected String getNamespaceDeclarations() {
        StringBuilder declarations = new StringBuilder();
        declarations.append("PREFIX dc: <http://purl.org/dc/terms/> \n");
        declarations.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n");
        declarations.append("PREFIX sesame: <http://www.openrdf.org/schema/sesame#> \n");
        declarations.append("PREFIX ex: <http://example.org/> \n");
        declarations.append("\n");
        return declarations.toString();
    }

    protected abstract Repository newRepository() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadTestData(String dataFile, Resource ... contexts) throws RDFParseException, RepositoryException, IOException {
        this.logger.debug("loading dataset {}", (Object)dataFile);
        try (InputStream dataset = ComplexSPARQLQueryTest.class.getResourceAsStream(dataFile);){
            this.conn.add(dataset, "", RDFFormat.forFileName((String)dataFile), contexts);
        }
        this.logger.debug("dataset loaded.");
    }
}

