/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.DC;
import org.openrdf.model.vocabulary.FOAF;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SPARQLUpdateTest
extends TestCase {
    protected static final Logger logger = LoggerFactory.getLogger(SPARQLUpdateTest.class);
    private Repository rep;
    protected RepositoryConnection con;
    protected ValueFactory f;
    protected URI bob;
    protected URI alice;
    protected URI graph1;
    protected URI graph2;
    protected static final String EX_NS = "http://example.org/";

    @Before
    public void setUp() throws Exception {
        logger.debug("setting up test");
        this.rep = this.createRepository();
        this.con = this.rep.getConnection();
        this.f = this.rep.getValueFactory();
        this.loadDataset("/testdata-update/dataset-update.trig");
        this.bob = this.f.createURI(EX_NS, "bob");
        this.alice = this.f.createURI(EX_NS, "alice");
        this.graph1 = this.f.createURI(EX_NS, "graph1");
        this.graph2 = this.f.createURI(EX_NS, "graph2");
        logger.debug("setup complete.");
    }

    @After
    public void tearDown() throws Exception {
        logger.debug("tearing down...");
        this.con.close();
        this.con = null;
        this.rep.shutDown();
        this.rep = null;
        logger.debug("tearDown complete.");
    }

    @Test
    public void testInsertWhere() throws Exception {
        logger.debug("executing test InsertWhere");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testInsertWhereWithBinding() throws Exception {
        logger.debug("executing test testInsertWhereWithBinding");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.setBinding("x", (Value)this.bob);
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testInsertWhereWithBindings2() throws Exception {
        logger.debug("executing test testInsertWhereWithBindings2");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT {?x rdfs:label ?z . } WHERE {?x foaf:name ?y }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.setBinding("z", (Value)this.f.createLiteral("Bobbie"));
        operation.setBinding("x", (Value)this.bob);
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bobbie"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, null, true, new Resource[0]));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bobbie"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testInsertEmptyWhere() throws Exception {
        logger.debug("executing test testInsertEmptyWhere");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT { <" + this.bob + "> rdfs:label \"Bob\" . } WHERE { }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
    }

    @Test
    public void testInsertEmptyWhereWithBinding() throws Exception {
        logger.debug("executing test testInsertEmptyWhereWithBinding");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT {?x rdfs:label ?y . } WHERE { }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.setBinding("x", (Value)this.bob);
        operation.setBinding("y", (Value)this.f.createLiteral("Bob"));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
    }

    @Test
    public void testInsertNonMatchingWhere() throws Exception {
        logger.debug("executing test testInsertNonMatchingWhere");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT { ?x rdfs:label ?y . } WHERE { ?x rdfs:comment ?y }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
        operation.execute();
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
    }

    @Test
    public void testInsertNonMatchingWhereWithBindings() throws Exception {
        logger.debug("executing test testInsertNonMatchingWhereWithBindings");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT { ?x rdfs:label ?y . } WHERE { ?x rdfs:comment ?y }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.setBinding("x", (Value)this.bob);
        operation.setBinding("y", (Value)this.f.createLiteral("Bob"));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
        operation.execute();
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
    }

    @Test
    public void testInsertWhereWithBindings() throws Exception {
        logger.debug("executing test testInsertWhereWithBindings");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT { ?x rdfs:comment ?z . } WHERE { ?x foaf:name ?y }");
        Literal comment = this.f.createLiteral("Bob has a comment");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.setBinding("x", (Value)this.bob);
        operation.setBinding("z", (Value)comment);
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, RDFS.COMMENT, (Value)comment, true, new Resource[0]));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.COMMENT, (Value)comment, true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.COMMENT, (Value)comment, true, new Resource[0]));
    }

    @Test
    public void testInsertWhereWithOptional() throws Exception {
        logger.debug("executing testInsertWhereWithOptional");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append(" INSERT { ?s ex:age ?incAge } ");
        update.append(" WHERE { ?s foaf:name ?name . ");
        update.append(" OPTIONAL {?s ex:age ?age . BIND ((?age + 1) as ?incAge)  } ");
        update.append(" } ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        URI age = this.f.createURI(EX_NS, "age");
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, age, null, true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, age, null, true, new Resource[0]));
        operation.execute();
        RepositoryResult result = this.con.getStatements((Resource)this.bob, age, null, true, new Resource[0]);
        while (result.hasNext()) {
            System.out.println(((Statement)result.next()).toString());
        }
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, age, (Value)this.f.createLiteral("43", XMLSchema.INTEGER), true, new Resource[0]));
        result = this.con.getStatements((Resource)this.alice, age, null, true, new Resource[0]);
        while (result.hasNext()) {
            System.out.println(result.next());
        }
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, age, null, true, new Resource[0]));
    }

    @Test
    public void testInsertWhereWithBlankNode() throws Exception {
        logger.debug("executing testInsertWhereWithBlankNode");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append(" INSERT { ?s ex:complexAge [ rdf:value ?age; rdfs:label \"old\" ] . } ");
        update.append(" WHERE { ?s ex:age ?age . ");
        update.append(" } ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        URI age = this.f.createURI(EX_NS, "age");
        URI complexAge = this.f.createURI(EX_NS, "complexAge");
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, age, null, true, new Resource[0]));
        operation.execute();
        RepositoryResult sts = this.con.getStatements((Resource)this.bob, complexAge, null, true, new Resource[0]);
        SPARQLUpdateTest.assertTrue((boolean)sts.hasNext());
        Value v1 = ((Statement)sts.next()).getObject();
        sts.close();
        sts = this.con.getStatements(null, RDF.VALUE, null, true, new Resource[0]);
        SPARQLUpdateTest.assertTrue((boolean)sts.hasNext());
        Resource v2 = ((Statement)sts.next()).getSubject();
        SPARQLUpdateTest.assertEquals((Object)v1, (Object)v2);
        sts.close();
        String query = this.getNamespaceDeclarations() + " SELECT ?bn ?age ?l WHERE { ex:bob ex:complexAge ?bn. ?bn rdf:value ?age. ?bn rdfs:label ?l .} ";
        TupleQueryResult result = this.con.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();
        SPARQLUpdateTest.assertTrue((boolean)result.hasNext());
        BindingSet bs = (BindingSet)result.next();
        SPARQLUpdateTest.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testDeleteInsertWhere() throws Exception {
        logger.debug("executing test DeleteInsertWhere");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE { ?x foaf:name ?y } INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testDeleteWhereOptional() throws Exception {
        logger.debug("executing test testDeleteWhereOptional");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append(" DELETE { ?x foaf:name ?y; foaf:mbox ?mbox. } ");
        update.append(" WHERE {?x foaf:name ?y. ");
        update.append(" OPTIONAL { ?x foaf:mbox ?mbox. FILTER (str(?mbox) = \"bob@example.org\") } }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        Literal mboxBob = this.f.createLiteral("bob@example.org");
        Literal mboxAlice = this.f.createLiteral("alice@example.org");
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.MBOX, (Value)mboxBob, true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.MBOX, (Value)mboxAlice, true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, FOAF.MBOX, (Value)mboxBob, true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.MBOX, (Value)mboxAlice, true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testDeleteInsertWhereWithBindings() throws Exception {
        logger.debug("executing test testDeleteInsertWhereWithBindings");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE { ?x foaf:name ?y } INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.setBinding("x", (Value)this.bob);
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testDeleteInsertWhereWithBindings2() throws Exception {
        logger.debug("executing test testDeleteInsertWhereWithBindings2");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE { ?x foaf:name ?y } INSERT {?x rdfs:label ?z . } WHERE {?x foaf:name ?y }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.setBinding("z", (Value)this.f.createLiteral("person"));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("person"), true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("person"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testDeleteInsertWhereLoopingBehavior() throws Exception {
        logger.debug("executing test testDeleteInsertWhereLoopingBehavior");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append(" DELETE { ?x ex:age ?y } INSERT {?x ex:age ?z }");
        update.append(" WHERE { ");
        update.append("   ?x ex:age ?y .");
        update.append("   BIND((?y + 1) as ?z) ");
        update.append("   FILTER( ?y < 46 ) ");
        update.append(" } ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        URI age = this.f.createURI(EX_NS, "age");
        Literal originalAgeValue = this.f.createLiteral("42", XMLSchema.INTEGER);
        Literal correctAgeValue = this.f.createLiteral("43", XMLSchema.INTEGER);
        Literal inCorrectAgeValue = this.f.createLiteral("46", XMLSchema.INTEGER);
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, age, (Value)originalAgeValue, true, new Resource[0]));
        operation.execute();
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, age, (Value)originalAgeValue, true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, age, (Value)correctAgeValue, true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, age, (Value)inCorrectAgeValue, true, new Resource[0]));
    }

    @Test
    public void testConsecutiveUpdatesInSameTransaction() throws Exception {
        block2: {
            logger.debug("executing test testConsecutiveUpdatesInSameTransaction");
            StringBuilder update1 = new StringBuilder();
            update1.append(this.getNamespaceDeclarations());
            update1.append("DELETE { ?x foaf:name ?y } WHERE {?x foaf:name ?y }");
            try {
                this.con.begin();
                Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update1.toString());
                SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
                SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
                operation.execute();
                SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
                SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
                StringBuilder update2 = new StringBuilder();
                update2.append(this.getNamespaceDeclarations());
                update2.append("INSERT { ?x rdfs:label ?y } WHERE {?x foaf:name ?y }");
                operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update2.toString());
                operation.execute();
                this.con.commit();
                SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
                SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
            }
            catch (Exception e) {
                if (!this.con.isActive()) break block2;
                this.con.rollback();
            }
        }
    }

    @Test
    public void testInsertTransformedWhere() throws Exception {
        logger.debug("executing test InsertTransformedWhere");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT {?x rdfs:label [] . } WHERE {?y ex:containsPerson ?x.  }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, null, true, new Resource[0]));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, null, true, new Resource[0]));
    }

    @Test
    public void testInsertWhereGraph() throws Exception {
        logger.debug("executing testInsertWhereGraph");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT {GRAPH ?g {?x rdfs:label ?y . }} WHERE {GRAPH ?g {?x foaf:name ?y }}");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.execute();
        String message = "labels should have been inserted in corresponding named graphs only.";
        SPARQLUpdateTest.assertTrue((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertTrue((String)message, (boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph1}));
    }

    @Test
    public void testInsertWhereUsing() throws Exception {
        logger.debug("executing testInsertWhereUsing");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT {?x rdfs:label ?y . } USING ex:graph1 WHERE {?x foaf:name ?y }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.execute();
        String message = "label should have been inserted in default graph, for ex:bob only";
        SPARQLUpdateTest.assertTrue((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testInsertWhereWith() throws Exception {
        logger.debug("executing testInsertWhereWith");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("WITH ex:graph1 INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.execute();
        String message = "label should have been inserted in graph1 only, for ex:bob only";
        SPARQLUpdateTest.assertTrue((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph1}));
    }

    @Test
    public void testDeleteWhereShortcut() throws Exception {
        logger.debug("executing testDeleteWhereShortcut");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE WHERE {?x foaf:name ?y }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        String msg = "foaf:name properties should have been deleted";
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        msg = "foaf:knows properties should not have been deleted";
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.KNOWS, null, true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, null, true, new Resource[0]));
    }

    @Test
    public void testDeleteWhere() throws Exception {
        logger.debug("executing testDeleteWhere");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE {?x foaf:name ?y } WHERE {?x foaf:name ?y }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        String msg = "foaf:name properties should have been deleted";
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testDeleteTransformedWhere() throws Exception {
        logger.debug("executing testDeleteTransformedWhere");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE {?y foaf:name ?n } WHERE {?x ex:containsPerson ?y . ?y foaf:name ?n . }");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        String msg = "foaf:name properties should have been deleted";
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        msg = "ex:containsPerson properties should not have been deleted";
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.graph1, this.f.createURI(EX_NS, "containsPerson"), (Value)this.bob, true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.graph2, this.f.createURI(EX_NS, "containsPerson"), (Value)this.alice, true, new Resource[0]));
    }

    @Test
    public void testInsertData() throws Exception {
        logger.debug("executing testInsertData");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT DATA { ex:book1 dc:title \"book 1\" ; dc:creator \"Ringo\" . } ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        URI book1 = this.f.createURI(EX_NS, "book1");
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]));
        operation.execute();
        String msg = "two new statements about ex:book1 should have been inserted";
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]));
    }

    @Test
    public void testInsertData2() throws Exception {
        logger.debug("executing testInsertData2");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT DATA { ex:book1 dc:title \"the number four\"^^<http://www.w3.org/2001/XMLSchema#integer> . }; ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        URI book1 = this.f.createURI(EX_NS, "book1");
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("the number four", XMLSchema.INTEGER), true, new Resource[0]));
        operation.execute();
        String msg = "new statement about ex:book1 should have been inserted";
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("the number four", XMLSchema.INTEGER), true, new Resource[0]));
    }

    @Test
    public void testInsertDataBlankNode() throws Exception {
        Resource subject;
        logger.debug("executing testInsertDataBlankNode");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT DATA { _:foo dc:title \"book 1\" ; dc:creator \"Ringo\" . } ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]));
        operation.execute();
        RepositoryResult titleStatements = this.con.getStatements(null, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]);
        SPARQLUpdateTest.assertNotNull((Object)titleStatements);
        RepositoryResult creatorStatements = this.con.getStatements(null, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]);
        SPARQLUpdateTest.assertNotNull((Object)creatorStatements);
        BNode bookNode = null;
        if (titleStatements.hasNext()) {
            Statement ts = (Statement)titleStatements.next();
            SPARQLUpdateTest.assertFalse((boolean)titleStatements.hasNext());
            subject = ts.getSubject();
            SPARQLUpdateTest.assertTrue((boolean)(subject instanceof BNode));
            bookNode = (BNode)subject;
        }
        titleStatements.close();
        SPARQLUpdateTest.assertNotNull(bookNode);
        SPARQLUpdateTest.assertFalse((boolean)"_:foo".equals(bookNode.getID()));
        if (creatorStatements.hasNext()) {
            Statement cs = (Statement)creatorStatements.next();
            SPARQLUpdateTest.assertFalse((boolean)creatorStatements.hasNext());
            subject = cs.getSubject();
            SPARQLUpdateTest.assertTrue((boolean)(subject instanceof BNode));
            SPARQLUpdateTest.assertEquals((Object)bookNode, (Object)subject);
        } else {
            SPARQLUpdateTest.fail((String)"at least one creator statement expected");
        }
        creatorStatements.close();
    }

    @Test
    public void testInsertDataMultiplePatterns() throws Exception {
        logger.debug("executing testInsertData");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT DATA { ex:book1 dc:title \"book 1\". ex:book1 dc:creator \"Ringo\" . ex:book2 dc:creator \"George\". } ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        URI book1 = this.f.createURI(EX_NS, "book1");
        URI book2 = this.f.createURI(EX_NS, "book2");
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)book2, DC.CREATOR, (Value)this.f.createLiteral("George"), true, new Resource[0]));
        operation.execute();
        String msg = "newly inserted statement missing";
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book2, DC.CREATOR, (Value)this.f.createLiteral("George"), true, new Resource[0]));
    }

    @Test
    public void testInsertDataInGraph() throws Exception {
        logger.debug("executing testInsertDataInGraph");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT DATA { GRAPH ex:graph1 { ex:book1 dc:title \"book 1\" ; dc:creator \"Ringo\" . } } ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        URI book1 = this.f.createURI(EX_NS, "book1");
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[]{this.graph1}));
        operation.execute();
        String msg = "two new statements about ex:book1 should have been inserted in graph1";
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[]{this.graph1}));
    }

    @Test
    public void testInsertDataInGraph2() throws Exception {
        logger.debug("executing testInsertDataInGraph2");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT DATA { GRAPH ex:graph1 { ex:Human rdfs:subClassOf ex:Mammal. ex:Mammal rdfs:subClassOf ex:Animal. ex:george a ex:Human. ex:ringo a ex:Human. } } ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        URI human = this.f.createURI(EX_NS, "Human");
        URI mammal = this.f.createURI(EX_NS, "Mammal");
        URI george = this.f.createURI(EX_NS, "george");
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)human, RDFS.SUBCLASSOF, (Value)mammal, true, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)mammal, RDFS.SUBCLASSOF, null, true, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)george, RDF.TYPE, (Value)human, true, new Resource[]{this.graph1}));
    }

    @Test
    public void testDeleteData() throws Exception {
        logger.debug("executing testDeleteData");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE DATA { ex:alice foaf:knows ex:bob. } ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[0]));
        operation.execute();
        String msg = "statement should have been deleted.";
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[0]));
    }

    @Test
    public void testDeleteDataMultiplePatterns() throws Exception {
        logger.debug("executing testDeleteData");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE DATA { ex:alice foaf:knows ex:bob. ex:alice foaf:mbox \"alice@example.org\" .} ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.MBOX, (Value)this.f.createLiteral("alice@example.org"), true, new Resource[0]));
        operation.execute();
        String msg = "statement should have been deleted.";
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.MBOX, (Value)this.f.createLiteral("alice@example.org"), true, new Resource[0]));
    }

    @Test
    public void testDeleteDataFromGraph() throws Exception {
        logger.debug("executing testDeleteDataFromGraph");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE DATA { GRAPH ex:graph1 {ex:alice foaf:knows ex:bob. } } ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph1}));
        operation.execute();
        String msg = "statement should have been deleted from graph1";
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph1}));
    }

    @Test
    public void testDeleteDataFromWrongGraph() throws Exception {
        logger.debug("executing testDeleteDataFromWrongGraph");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE DATA { GRAPH ex:graph2 {ex:alice foaf:knows ex:bob. } } ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph2}));
        operation.execute();
        String msg = "statement should have not have been deleted from graph1";
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph1}));
    }

    @Test
    public void testCreateNewGraph() throws Exception {
        logger.debug("executing testCreateNewGraph");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        URI newGraph = this.f.createURI(EX_NS, "new-graph");
        update.append("CREATE GRAPH <" + newGraph + "> ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{newGraph}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[0]));
    }

    @Test
    public void testCreateExistingGraph() throws Exception {
        logger.debug("executing testCreateExistingGraph");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("CREATE GRAPH <" + this.graph1 + "> ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        try {
            operation.execute();
            SPARQLUpdateTest.fail((String)"creation of existing graph should have resulted in error.");
        }
        catch (UpdateExecutionException e) {
            this.con.rollback();
        }
    }

    @Test
    public void testCopyToDefault() throws Exception {
        logger.debug("executing testCopyToDefault");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("COPY GRAPH <" + this.graph1.stringValue() + "> TO DEFAULT");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testCopyToExistingNamed() throws Exception {
        logger.debug("executing testCopyToExistingNamed");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("COPY GRAPH ex:graph1 TO ex:graph2");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, null, false, new Resource[]{this.graph2}));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, null, false, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testCopyToNewNamed() throws Exception {
        logger.debug("executing testCopyToNewNamed");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("COPY GRAPH ex:graph1 TO ex:graph3");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testCopyFromDefault() throws Exception {
        logger.debug("executing testCopyFromDefault");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("COPY DEFAULT TO ex:graph3");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
    }

    @Test
    public void testCopyFromDefaultToDefault() throws Exception {
        logger.debug("executing testCopyFromDefaultToDefault");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("COPY DEFAULT TO DEFAULT");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
    }

    @Test
    public void testAddToDefault() throws Exception {
        logger.debug("executing testAddToDefault");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("ADD GRAPH <" + this.graph1.stringValue() + "> TO DEFAULT");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testAddToExistingNamed() throws Exception {
        logger.debug("executing testAddToExistingNamed");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("ADD GRAPH ex:graph1 TO ex:graph2");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, null, false, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testAddToNewNamed() throws Exception {
        logger.debug("executing testAddToNewNamed");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("ADD GRAPH ex:graph1 TO ex:graph3");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testAddFromDefault() throws Exception {
        logger.debug("executing testAddFromDefault");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("ADD DEFAULT TO ex:graph3");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        URI graph3 = this.f.createURI(EX_NS, "graph3");
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, false, new Resource[]{this.graph1}));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{graph3}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{graph3}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, false, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, false, new Resource[]{graph3}));
    }

    @Test
    public void testAddFromDefaultToDefault() throws Exception {
        logger.debug("executing testAddFromDefaultToDefault");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("ADD DEFAULT TO DEFAULT");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
    }

    @Test
    public void testMoveToDefault() throws Exception {
        logger.debug("executing testMoveToDefault");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("MOVE GRAPH <" + this.graph1.stringValue() + "> TO DEFAULT");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testMoveToNewNamed() throws Exception {
        logger.debug("executing testMoveToNewNamed");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("MOVE GRAPH ex:graph1 TO ex:graph3");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testMoveFromDefault() throws Exception {
        logger.debug("executing testMoveFromDefault");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("MOVE DEFAULT TO ex:graph3");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{this.f.createURI(EX_NS, "graph3")}));
    }

    @Test
    public void testMoveFromDefaultToDefault() throws Exception {
        logger.debug("executing testMoveFromDefaultToDefault");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("MOVE DEFAULT TO DEFAULT");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
    }

    @Test
    public void testClearAll() throws Exception {
        logger.debug("executing testClearAll");
        String update = "CLEAR ALL";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[0]));
    }

    @Test
    public void testClearDefault() throws Exception {
        logger.debug("executing testClearDefault");
        String update = "CLEAR DEFAULT";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{null}));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{null}));
    }

    @Test
    public void testClearGraph() throws Exception {
        logger.debug("executing testClearGraph");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("CLEAR GRAPH <" + this.graph1.stringValue() + "> ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.execute();
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[0]));
    }

    @Test
    public void testClearNamed() throws Exception {
        logger.debug("executing testClearNamed");
        String update = "CLEAR NAMED";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[0]));
    }

    @Test
    public void testDropAll() throws Exception {
        logger.debug("executing testDropAll");
        String update = "DROP ALL";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[0]));
    }

    @Test
    public void testDropDefault() throws Exception {
        logger.debug("executing testDropDefault");
        String update = "DROP DEFAULT";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{null}));
        operation.execute();
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{null}));
    }

    @Test
    public void testDropGraph() throws Exception {
        logger.debug("executing testDropGraph");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DROP GRAPH <" + this.graph1.stringValue() + "> ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.execute();
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[0]));
    }

    @Test
    public void testDropNamed() throws Exception {
        logger.debug("executing testDropNamed");
        String update = "DROP NAMED";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[0]));
    }

    @Test
    public void testUpdateSequenceDeleteInsert() throws Exception {
        logger.debug("executing testUpdateSequenceDeleteInsert");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE {?y foaf:name ?n } WHERE {?x ex:containsPerson ?y. ?y foaf:name ?n . }; ");
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT {?x foaf:name \"foo\" } WHERE {?y ex:containsPerson ?x} ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        String msg = "foaf:name properties should have been deleted";
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        msg = "foaf:name properties with value 'foo' should have been added";
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("foo"), true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("foo"), true, new Resource[0]));
    }

    @Test
    public void testUpdateSequenceInsertDelete() throws Exception {
        logger.debug("executing testUpdateSequenceInsertDelete");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT {?x foaf:name \"foo\" } WHERE {?y ex:containsPerson ?x}; ");
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE {?y foaf:name ?n } WHERE {?x ex:containsPerson ?y. ?y foaf:name ?n . } ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        String msg = "foaf:name properties should have been deleted";
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        msg = "foaf:name properties with value 'foo' should not have been added";
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("foo"), true, new Resource[0]));
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("foo"), true, new Resource[0]));
    }

    @Test
    public void testUpdateSequenceInsertDelete2() throws Exception {
        logger.debug("executing testUpdateSequenceInsertDelete2");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("INSERT { GRAPH ex:graph2 { ?s ?p ?o } } WHERE { GRAPH ex:graph1 { ?s ?p ?o . FILTER (?s = ex:bob) } }; ");
        update.append("WITH ex:graph1 DELETE { ?s ?p ?o } WHERE {?s ?p ?o . FILTER (?s = ex:bob) } ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph1}));
        SPARQLUpdateTest.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph2}));
        operation.execute();
        String msg = "statements about bob should have been removed from graph1";
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, null, null, true, new Resource[]{this.graph1}));
        msg = "statements about bob should have been added to graph2";
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.MBOX, null, true, new Resource[]{this.graph2}));
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.KNOWS, (Value)this.alice, true, new Resource[]{this.graph2}));
    }

    @Test
    public void testUpdateSequenceInsertDeleteExample9() throws Exception {
        logger.debug("executing testUpdateSequenceInsertDeleteExample9");
        this.con.clear(new Resource[0]);
        this.con.commit();
        this.loadDataset("/testdata-update/dataset-update-example9.trig");
        URI book1 = this.f.createURI("http://example/book1");
        URI book3 = this.f.createURI("http://example/book3");
        URI bookStore = this.f.createURI("http://example/bookStore");
        URI bookStore2 = this.f.createURI("http://example/bookStore2");
        StringBuilder update = new StringBuilder();
        update.append("prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> ");
        update.append("prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>  ");
        update.append("prefix xsd: <http://www.w3.org/2001/XMLSchema#>  ");
        update.append("prefix dc: <http://purl.org/dc/elements/1.1/>  ");
        update.append("prefix dcmitype: <http://purl.org/dc/dcmitype/>  ");
        update.append("INSERT  { GRAPH <http://example/bookStore2> { ?book ?p ?v } } ");
        update.append(" WHERE ");
        update.append(" { GRAPH  <http://example/bookStore> ");
        update.append("   { ?book dc:date ?date . ");
        update.append("       FILTER ( ?date < \"2000-01-01T00:00:00-02:00\"^^xsd:dateTime ) ");
        update.append("       ?book ?p ?v ");
        update.append("      } ");
        update.append(" } ;");
        update.append("WITH <http://example/bookStore> ");
        update.append(" DELETE { ?book ?p ?v } ");
        update.append(" WHERE ");
        update.append(" { ?book dc:date ?date ; ");
        update.append("         a dcmitype:PhysicalObject .");
        update.append("    FILTER ( ?date < \"2000-01-01T00:00:00-02:00\"^^xsd:dateTime ) ");
        update.append("   ?book ?p ?v");
        update.append(" } ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.execute();
        String msg = "statements about book1 should have been removed from bookStore";
        SPARQLUpdateTest.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)book1, null, null, true, new Resource[]{bookStore}));
        msg = "statements about book1 should have been added to bookStore2";
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, RDF.TYPE, null, true, new Resource[]{bookStore2}));
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.DATE, null, true, new Resource[]{bookStore2}));
        SPARQLUpdateTest.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.TITLE, null, true, new Resource[]{bookStore2}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDataset(String datasetFile) throws RDFParseException, RepositoryException, IOException {
        logger.debug("loading dataset...");
        try (InputStream dataset = SPARQLUpdateTest.class.getResourceAsStream(datasetFile);){
            this.con.add(dataset, "", RDFFormat.TRIG, new Resource[0]);
        }
        logger.debug("dataset loaded.");
    }

    protected String getNamespaceDeclarations() {
        StringBuilder declarations = new StringBuilder();
        declarations.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \n");
        declarations.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \n");
        declarations.append("PREFIX dc: <http://purl.org/dc/elements/1.1/> \n");
        declarations.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n");
        declarations.append("PREFIX ex: <http://example.org/> \n");
        declarations.append("PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \n");
        declarations.append("PREFIX bd: <http://www.bigdata.com/rdf#> \n");
        declarations.append("\n");
        return declarations.toString();
    }

    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        RepositoryConnection con = repository.getConnection();
        con.clear(new Resource[0]);
        con.clearNamespaces();
        con.close();
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;
}

