/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.query.parser.sparql.SPARQLUpdateTest;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQLUpdateTestv2
extends TestCase {
    protected static final Logger logger = LoggerFactory.getLogger(SPARQLUpdateTestv2.class);
    private Repository rep;
    protected RepositoryConnection con;
    protected ValueFactory f;
    protected URI bob;
    protected URI alice;
    protected URI graph1;
    protected URI graph2;
    protected static final String EX_NS = "http://example.org/";
    private IIndexManager backend = null;

    @Before
    public void setUp() throws Exception {
        logger.debug("setting up test");
        this.rep = this.createRepository();
        this.con = this.rep.getConnection();
        this.f = this.rep.getValueFactory();
        this.loadDataset("/testdata-update/dataset-update.trig");
        this.bob = this.f.createURI(EX_NS, "bob");
        this.alice = this.f.createURI(EX_NS, "alice");
        this.graph1 = this.f.createURI(EX_NS, "graph1");
        this.graph2 = this.f.createURI(EX_NS, "graph2");
        logger.debug("setup complete.");
    }

    @After
    public void tearDown() throws Exception {
        logger.debug("tearing down...");
        this.con.close();
        this.con = null;
        this.rep.shutDown();
        this.rep = null;
        if (this.backend != null) {
            this.tearDownBackend(this.backend);
        }
        this.backend = null;
        logger.debug("tearDown complete.");
    }

    protected void tearDownBackend(IIndexManager backend) {
        backend.destroy();
    }

    protected Repository createRepository() throws Exception {
        Repository repo = this.newRepository();
        repo.initialize();
        return repo;
    }

    protected Repository newRepository() throws RepositoryException {
        Properties props = this.getProperties();
        BigdataSail sail = new BigdataSail(props);
        this.backend = sail.getIndexManager();
        return new BigdataSailRepository(sail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDataset(String datasetFile) throws RDFParseException, RepositoryException, IOException {
        logger.debug("loading dataset...");
        try (InputStream dataset = SPARQLUpdateTest.class.getResourceAsStream(datasetFile);){
            this.con.add(dataset, "", RDFFormat.forFileName((String)datasetFile), new Resource[0]);
            this.con.commit();
        }
        logger.debug("dataset loaded.");
    }

    protected String getNamespaceDeclarations() {
        StringBuilder declarations = new StringBuilder();
        declarations.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \n");
        declarations.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \n");
        declarations.append("PREFIX dc: <http://purl.org/dc/elements/1.1/> \n");
        declarations.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n");
        declarations.append("PREFIX ex: <http://example.org/> \n");
        declarations.append("PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \n");
        declarations.append("PREFIX bd: <http://www.bigdata.com/rdf#> \n");
        declarations.append("\n");
        return declarations.toString();
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        props.setProperty(BigdataSail.Options.BUFFER_MODE, BufferMode.Transient.toString());
        props.setProperty(BigdataSail.Options.QUADS_MODE, "true");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.QUERY_TIME_EXPANDER, "false");
        props.setProperty(BigdataSail.Options.EXACT_SIZE, "true");
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "false");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "true");
        props.setProperty(BigdataSail.Options.NAMESPACE, "BigdataSPARQLUpdate-" + UUID.randomUUID());
        return props;
    }

    public void testTicket571Standalone() throws RepositoryException, MalformedQueryException, UpdateExecutionException, QueryEvaluationException {
        URI graphA = this.f.createURI("http://example.org/graphA");
        URI tempGraph = this.f.createURI("http://example.org/tmp");
        URI s = this.f.createURI("http://example/s>");
        URI p = this.f.createURI("http://example/p>");
        URI x = this.f.createURI("http://example/x>");
        URI foo = this.f.createURI("http://example/Foo>");
        URI rdfType = this.f.createURI(RDF.TYPE.stringValue());
        Literal two = this.f.createLiteral("2", XSD.INTEGER);
        this.con.prepareUpdate(QueryLanguage.SPARQL, "DROP ALL").execute();
        System.err.println("##### INITIAL DATA IN DATABASE");
        this.debugPrintSolutions("SELECT * WHERE { GRAPH ?g { ?s ?p ?o } }");
        this.con.prepareUpdate(QueryLanguage.SPARQL, "PREFIX graphA:  <http://example/graphA> \nINSERT DATA { \n GRAPH graphA: { \n   _:bnode <http://example/p> 2 . \n   _:bnode a <http://example/Foo> . \n   <http://example/s> <http://example/p> 2 . \n}}\n").execute();
        System.err.println("##### DATA IN DATABASE AFTER INSERT");
        this.debugPrintSolutions("SELECT * WHERE { GRAPH ?g { ?s ?p ?o } }");
        String query = "SELECT * WHERE { GRAPH <http://example/graphA> { ?s ?p ?v . } }";
        SPARQLUpdateTestv2.assertEquals((String)"graphA", (long)3L, (long)this.countSolutions("SELECT * WHERE { GRAPH <http://example/graphA> { ?s ?p ?v . } }"));
        this.con.prepareUpdate(QueryLanguage.SPARQL, "PREFIX graphA:  <http://example/graphA> \nPREFIX tempGraph:  <http://example/temp> \nDELETE { GRAPH graphA:    { ?s ?p ?v . } } \nINSERT { GRAPH tempGraph: { ?s ?p ?v . } } \nWHERE { GRAPH graphA: { \n    ?s a <http://example/Foo> . \n    ?s ?p ?v . } }\n").execute();
        System.err.println("##### DATA IN DATABASE AFTER DELETE + INSERT");
        this.debugPrintSolutions("SELECT * WHERE { GRAPH ?g { ?s ?p ?o } }");
        query = "SELECT * WHERE { GRAPH <http://example/graphA> { ?s ?p ?v . } }";
        SPARQLUpdateTestv2.assertEquals((String)"graphA", (long)1L, (long)this.countSolutions("SELECT * WHERE { GRAPH <http://example/graphA> { ?s ?p ?v . } }"));
        query = "SELECT * WHERE { GRAPH <http://example/temp> { ?s ?p ?v . } }";
        SPARQLUpdateTestv2.assertEquals((String)"tempGraph", (long)2L, (long)this.countSolutions("SELECT * WHERE { GRAPH <http://example/temp> { ?s ?p ?v . } }"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long countSolutions(String query) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        try (TupleQueryResult result = this.con.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            long n = 0L;
            while (result.hasNext()) {
                BindingSet bset = (BindingSet)result.next();
                ++n;
                if (!logger.isInfoEnabled()) continue;
                logger.info(bset.toString());
            }
            long l = n;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long debugPrintSolutions(String query) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        try (TupleQueryResult result = this.con.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            long n = 0L;
            while (result.hasNext()) {
                System.err.println("==> NEXT SOLUTION");
                BindingSet bset = (BindingSet)result.next();
                for (String bindingName : bset.getBindingNames()) {
                    Binding b = bset.getBinding(bindingName);
                    System.err.println(bindingName + " -> " + b);
                }
                ++n;
            }
            long l = n;
            return l;
        }
    }
}

