/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql.manifest;

import info.aduna.io.IOUtil;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.util.ModelUtil;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.Update;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.parser.sparql.manifest.ManifestTest;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SPARQLUpdateConformanceTest
extends TestCase {
    protected static final Logger logger = LoggerFactory.getLogger(SPARQLUpdateConformanceTest.class);
    protected final String testURI;
    protected final String requestFileURL;
    protected Repository dataRep;
    protected Repository expectedResultRepo;
    protected URI inputDefaultGraph;
    protected Map<String, URI> inputNamedGraphs;
    protected URI resultDefaultGraph;
    protected Map<String, URI> resultNamedGraphs;
    protected final Dataset dataset;

    public SPARQLUpdateConformanceTest(String testURI, String name, String requestFile, URI defaultGraphURI, Map<String, URI> inputNamedGraphs, URI resultDefaultGraphURI, Map<String, URI> resultNamedGraphs) {
        super(name);
        this.testURI = testURI;
        this.requestFileURL = requestFile;
        this.inputDefaultGraph = defaultGraphURI;
        this.inputNamedGraphs = inputNamedGraphs;
        this.resultDefaultGraph = resultDefaultGraphURI;
        this.resultNamedGraphs = resultNamedGraphs;
        if (this.inputNamedGraphs.size() > 0) {
            DatasetImpl ds = new DatasetImpl();
            ds.addDefaultGraph(null);
            ds.addDefaultRemoveGraph(null);
            ds.setDefaultInsertGraph(null);
            for (String ng : inputNamedGraphs.keySet()) {
                URIImpl namedGraph = new URIImpl(ng);
                ds.addNamedGraph((URI)namedGraph);
            }
            this.dataset = ds;
        } else {
            this.dataset = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        this.dataRep = this.createRepository();
        URL graphURL = null;
        try (RepositoryConnection conn = this.dataRep.getConnection();){
            conn.clear(new Resource[0]);
            if (this.inputDefaultGraph != null) {
                graphURL = new URL(this.inputDefaultGraph.stringValue());
                conn.add(graphURL, null, RDFFormat.forFileName((String)graphURL.toString()), new Resource[0]);
            }
            for (String ng : this.inputNamedGraphs.keySet()) {
                graphURL = new URL(this.inputNamedGraphs.get(ng).stringValue());
                conn.add(graphURL, null, RDFFormat.forFileName((String)graphURL.toString()), new Resource[]{this.dataRep.getValueFactory().createURI(ng)});
            }
        }
        this.expectedResultRepo = this.createRepository();
        conn = this.expectedResultRepo.getConnection();
        try {
            conn.clear(new Resource[0]);
            if (this.resultDefaultGraph != null) {
                graphURL = new URL(this.resultDefaultGraph.stringValue());
                conn.add(graphURL, null, RDFFormat.forFileName((String)graphURL.toString()), new Resource[0]);
            }
            for (String ng : this.resultNamedGraphs.keySet()) {
                graphURL = new URL(this.resultNamedGraphs.get(ng).stringValue());
                conn.add(graphURL, null, RDFFormat.forFileName((String)graphURL.toString()), new Resource[]{this.dataRep.getValueFactory().createURI(ng)});
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Repository createRepository() throws Exception {
        Repository repo = this.newRepository();
        repo.initialize();
        try (RepositoryConnection con = repo.getConnection();){
            con.clear(new Resource[0]);
            con.clearNamespaces();
        }
        return repo;
    }

    protected abstract Repository newRepository() throws Exception;

    protected void tearDown() throws Exception {
        if (this.dataRep != null) {
            this.dataRep.shutDown();
            this.dataRep = null;
        }
        if (this.expectedResultRepo != null) {
            this.expectedResultRepo.shutDown();
            this.expectedResultRepo = null;
        }
    }

    protected void runTest() throws Exception {
        RepositoryConnection con = this.dataRep.getConnection();
        RepositoryConnection erCon = this.expectedResultRepo.getConnection();
        try {
            String updateString = this.readUpdateString();
            con.begin();
            Update update = con.prepareUpdate(QueryLanguage.SPARQL, updateString, this.requestFileURL);
            if (this.dataset != null) {
                update.setDataset(this.dataset);
            }
            update.execute();
            con.commit();
            logger.info("checking default graph");
            this.compareGraphs(Iterations.asList((Iteration)con.getStatements(null, null, null, true, new Resource[]{null})), Iterations.asList((Iteration)erCon.getStatements(null, null, null, true, new Resource[]{null})));
            for (String namedGraph : this.inputNamedGraphs.keySet()) {
                logger.info("checking named graph {}", (Object)namedGraph);
                URI contextURI = con.getValueFactory().createURI(namedGraph.replaceAll("\"", ""));
                this.compareGraphs(Iterations.asList((Iteration)con.getStatements(null, null, null, true, new Resource[]{contextURI})), Iterations.asList((Iteration)erCon.getStatements(null, null, null, true, new Resource[]{contextURI})));
            }
        }
        catch (Exception e) {
            if (con.isActive()) {
                con.rollback();
            }
            throw e;
        }
        finally {
            con.close();
            erCon.close();
        }
    }

    protected void compareGraphs(Iterable<? extends Statement> actual, Iterable<? extends Statement> expected) throws Exception {
        if (!ModelUtil.equals(expected, actual)) {
            StringBuilder message = new StringBuilder(128);
            message.append("\n=========================================\n");
            message.append(this.getName());
            message.append("\n");
            message.append(this.testURI);
            message.append("\n=========================================\n");
            message.append("Expected results: \n");
            for (Statement statement : expected) {
                message.append(statement);
                message.append("\n");
            }
            message.append("=========================================\n");
            message.append("Bigdata results: \n");
            for (Statement statement : actual) {
                message.append(statement);
                message.append("\n");
            }
            message.append("=========================================\n");
            String queryStr = this.readUpdateString();
            message.append("Query:\n" + queryStr);
            message.append("\n=========================================\n");
            logger.error(message.toString());
            SPARQLUpdateConformanceTest.fail((String)message.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readUpdateString() throws IOException {
        try (InputStream stream = new URL(this.requestFileURL).openStream();){
            String string = IOUtil.readString((Reader)new InputStreamReader(stream, "UTF-8"));
            return string;
        }
    }

    public static TestSuite suite(String manifestFileURL, Factory factory) throws Exception {
        return SPARQLUpdateConformanceTest.suite(manifestFileURL, factory, true);
    }

    public static TestSuite suite(String manifestFileURL, Factory factory, boolean approvedOnly) throws Exception {
        logger.info("Building test suite for {}", (Object)manifestFileURL);
        TestSuite suite = new TestSuite(factory.getClass().getName());
        SailRepository manifestRep = new SailRepository((Sail)new MemoryStore());
        manifestRep.initialize();
        RepositoryConnection con = manifestRep.getConnection();
        ManifestTest.addTurtle((RepositoryConnection)con, (URL)new URL(manifestFileURL), (String)manifestFileURL, (Resource[])new Resource[0]);
        suite.setName(SPARQLUpdateConformanceTest.getManifestName((Repository)manifestRep, con, manifestFileURL));
        StringBuilder query = new StringBuilder(512);
        query.append(" SELECT DISTINCT testURI, testName, result, action, requestFile, defaultGraph, resultDefaultGraph ");
        query.append(" FROM {} rdf:first {testURI} rdf:type {mf:UpdateEvaluationTest}; ");
        if (approvedOnly) {
            query.append("                          dawgt:approval {dawgt:Approved}; ");
        }
        query.append("                             mf:name {testName}; ");
        query.append("                             mf:action {action} ut:request {requestFile}; ");
        query.append("                                                [ ut:data {defaultGraph} ],  ");
        query.append("                   {testURI} mf:result {result} [ut:data {resultDefaultGraph}] ");
        query.append(" USING NAMESPACE ");
        query.append("  mf = <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>, ");
        query.append("  dawgt = <http://www.w3.org/2001/sw/DataAccess/tests/test-dawg#>, ");
        query.append("  qt = <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>, ");
        query.append("  ut = <http://www.w3.org/2009/sparql/tests/test-update#>, ");
        query.append("  sd = <http://www.w3.org/ns/sparql-service-description#>, ");
        query.append("  ent = <http://www.w3.org/ns/entailment/> ");
        TupleQuery testCaseQuery = con.prepareTupleQuery(QueryLanguage.SERQL, query.toString());
        query.setLength(0);
        query.append(" SELECT DISTINCT namedGraphData, namedGraphLabel ");
        query.append(" FROM {graphDef} ut:graphData {} ut:graph {namedGraphData} ; ");
        query.append("                               rdfs:label {namedGraphLabel} ");
        query.append(" USING NAMESPACE ");
        query.append("  ut = <http://www.w3.org/2009/sparql/tests/test-update#> ");
        TupleQuery namedGraphsQuery = con.prepareTupleQuery(QueryLanguage.SERQL, query.toString());
        logger.debug("evaluating query..");
        TupleQueryResult testCases = testCaseQuery.evaluate();
        while (testCases.hasNext()) {
            SPARQLUpdateConformanceTest test;
            BindingSet bindingSet = (BindingSet)testCases.next();
            URI testURI = (URI)bindingSet.getValue("testURI");
            String testName = bindingSet.getValue("testName").toString();
            Value result = bindingSet.getValue("result");
            Value action = bindingSet.getValue("action");
            URI requestFile = (URI)bindingSet.getValue("requestFile");
            URI defaultGraphURI = (URI)bindingSet.getValue("defaultGraph");
            URI resultDefaultGraphURI = (URI)bindingSet.getValue("resultDefaultGraph");
            logger.debug("found test case : {}", (Object)testName);
            namedGraphsQuery.setBinding("graphDef", action);
            TupleQueryResult inputNamedGraphsResult = namedGraphsQuery.evaluate();
            HashMap<String, URI> inputNamedGraphs = new HashMap<String, URI>();
            if (inputNamedGraphsResult.hasNext()) {
                while (inputNamedGraphsResult.hasNext()) {
                    BindingSet graphBindings = (BindingSet)inputNamedGraphsResult.next();
                    URI namedGraphData = (URI)graphBindings.getValue("namedGraphData");
                    String namedGraphLabel = ((Literal)graphBindings.getValue("namedGraphLabel")).getLabel();
                    logger.debug(" adding named graph : {}", (Object)namedGraphLabel);
                    inputNamedGraphs.put(namedGraphLabel, namedGraphData);
                }
            }
            namedGraphsQuery.setBinding("graphDef", result);
            TupleQueryResult resultNamedGraphsResult = namedGraphsQuery.evaluate();
            HashMap<String, URI> resultNamedGraphs = new HashMap<String, URI>();
            if (resultNamedGraphsResult.hasNext()) {
                while (resultNamedGraphsResult.hasNext()) {
                    BindingSet graphBindings = (BindingSet)resultNamedGraphsResult.next();
                    URI namedGraphData = (URI)graphBindings.getValue("namedGraphData");
                    String namedGraphLabel = ((Literal)graphBindings.getValue("namedGraphLabel")).getLabel();
                    logger.debug(" adding named graph : {}", (Object)namedGraphLabel);
                    resultNamedGraphs.put(namedGraphLabel, namedGraphData);
                }
            }
            if ((test = factory.createSPARQLUpdateConformanceTest(testURI.toString(), testName, requestFile.toString(), defaultGraphURI, inputNamedGraphs, resultDefaultGraphURI, resultNamedGraphs)) == null) continue;
            suite.addTest((Test)test);
        }
        testCases.close();
        con.close();
        manifestRep.shutDown();
        logger.info("Created test suite with " + suite.countTestCases() + " test cases.");
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getManifestName(Repository manifestRep, RepositoryConnection con, String manifestFileURL) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        TupleQuery manifestNameQuery = con.prepareTupleQuery(QueryLanguage.SERQL, "SELECT ManifestName FROM {ManifestURL} rdfs:label {ManifestName}");
        manifestNameQuery.setBinding("ManifestURL", (Value)manifestRep.getValueFactory().createURI(manifestFileURL));
        try (TupleQueryResult manifestNames = manifestNameQuery.evaluate();){
            if (manifestNames.hasNext()) {
                String string = ((BindingSet)manifestNames.next()).getValue("ManifestName").stringValue();
                return string;
            }
        }
        int lastSlashIdx = manifestFileURL.lastIndexOf(47);
        int secLastSlashIdx = manifestFileURL.lastIndexOf(47, lastSlashIdx - 1);
        return manifestFileURL.substring(secLastSlashIdx + 1, lastSlashIdx);
    }

    public static interface Factory {
        public SPARQLUpdateConformanceTest createSPARQLUpdateConformanceTest(String var1, String var2, String var3, URI var4, Map<String, URI> var5, URI var6, Map<String, URI> var7);
    }
}

