/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository;

import com.bigdata.rdf.store.BD;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.util.Namespaces;
import org.openrdf.model.vocabulary.DC;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.Update;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.contextaware.ContextAwareConnection;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.RDFHandlerBase;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public abstract class RepositoryConnectionTest
extends TestCase {
    @Rule
    public Timeout to = new Timeout(60000);
    private static final String URN_TEST_OTHER = "urn:test:other";
    private static final String SPARQL_DEL_ALL = "DELETE { ?s ?p ?o } WHERE { ?s ?p ?o }";
    private static final String URN_TEST_O1 = "urn:test:o1";
    private static final String URN_TEST_S1 = "urn:test:s1";
    private static final String URN_TEST_P2 = "urn:test:p2";
    private static final String URN_TEST_P1 = "urn:test:p1";
    private static final String URN_PRED = "urn:pred";
    private static final String RDF_PREFIX = "rdf";
    private static final String RDFS_NS = "http://www.w3.org/2000/01/rdf-schema#";
    private static final String RDFS_PREFIX = "rdfs";
    private static final String EXAMPLE_NS = "http://example.org/";
    private static final String EXAMPLE = "example";
    private static final String ASK = "ASK ";
    private static final String PREFIX_FOAF = "PREFIX foaf: <";
    private static final String PERSON = "person";
    private static final String UNEXPECTED_TYPE = "unexpected query object type: ";
    private static final String UNSUPPORTED_OP = "unsupported operation: ";
    private static final String NEWLY_ADDED = "Repository should contain newly added statement";
    private static final String MBOX = "mbox";
    private static final String NAME = "name";
    protected static final String FOAF_NS = "http://xmlns.com/foaf/0.1/";
    public static final String TEST_DIR_PREFIX = "/testcases/";
    protected Repository testRepository;
    protected RepositoryConnection testCon;
    protected RepositoryConnection testCon2;
    protected ValueFactory vf;
    protected Resource bob;
    protected Resource alice;
    protected Resource alexander;
    protected URI name;
    protected URI mbox;
    protected final URI publisher = DC.PUBLISHER;
    protected URI unknownContext;
    protected URI context1;
    protected URI context2;
    protected Literal nameAlice;
    protected Literal nameBob;
    protected Literal mboxAlice;
    protected Literal mboxBob;

    public RepositoryConnectionTest(String name) {
        super(name);
    }

    @Before
    public void setUp() throws Exception {
        this.testRepository = this.createRepository();
        this.testRepository.initialize();
        this.testCon = this.testRepository.getConnection();
        this.testCon.clear(new Resource[0]);
        this.testCon.clearNamespaces();
        this.testCon2 = this.testRepository.getConnection();
        this.vf = this.testRepository.getValueFactory();
        this.bob = this.vf.createBNode();
        this.alice = this.vf.createBNode();
        this.alexander = this.vf.createBNode();
        this.name = this.vf.createURI("http://xmlns.com/foaf/0.1/name");
        this.mbox = this.vf.createURI("http://xmlns.com/foaf/0.1/mbox");
        this.nameAlice = this.vf.createLiteral("Alice");
        this.nameBob = this.vf.createLiteral("Bob");
        this.mboxAlice = this.vf.createLiteral("alice@example.org");
        this.mboxBob = this.vf.createLiteral("bob@example.org");
        this.unknownContext = new URIImpl("urn:unknownContext");
        this.context1 = this.vf.createURI("urn:x-local:graph1");
        this.context2 = this.vf.createURI("urn:x-local:graph2");
    }

    @After
    public void tearDown() throws Exception {
        this.testCon2.close();
        this.testCon.close();
        this.testRepository.shutDown();
    }

    protected abstract Repository createRepository() throws Exception;

    @Test
    public void testAddStatement() throws Exception {
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)NEWLY_ADDED, (boolean)this.testCon.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        Statement statement = this.vf.createStatement(this.alice, this.name, (Value)this.nameAlice);
        this.testCon.add(statement, new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)NEWLY_ADDED, (boolean)this.testCon.hasStatement(statement, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)NEWLY_ADDED, (boolean)this.testCon.hasStatement(this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        SailRepository tempRep = new SailRepository((Sail)new MemoryStore());
        tempRep.initialize();
        RepositoryConnection con = tempRep.getConnection();
        con.add((Iteration)this.testCon.getStatements(null, null, null, false, new Resource[0]), new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)"Temp Repository should contain newly added statement", (boolean)con.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        con.close();
        tempRep.shutDown();
    }

    @Test
    public void testAddLiteralWithNewline() throws Exception {
        Literal test = this.vf.createLiteral("this is a test\n");
        this.testCon.add(this.bob, RDFS.LABEL, (Value)test, new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)NEWLY_ADDED, (boolean)this.testCon.hasStatement(this.bob, RDFS.LABEL, (Value)test, false, new Resource[0]));
    }

    @Test
    public void testTransactionIsolation() throws Exception {
        this.testCon.begin();
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        Assert.assertThat((Object)this.testCon.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Assert.assertThat((Object)this.testCon2.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        this.testCon.commit();
        this.testCon2.close();
        this.testCon2 = this.testRepository.getConnection();
        Assert.assertThat((Object)this.testCon.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Assert.assertThat((Object)this.testCon2.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
    }

    @Test
    public void testReadOfAddedStatement1() throws Exception {
        URI context = this.vf.createURI("urn:context");
        URI subject = this.vf.createURI("urn:test");
        URI predicate = this.vf.createURI("urn:property");
        Literal one = this.vf.createLiteral(1);
        Literal two = this.vf.createLiteral(2);
        this.testCon.begin();
        this.testCon.add((Resource)subject, predicate, (Value)one, new Resource[]{context});
        this.testCon.commit();
        this.testCon.begin();
        RepositoryResult statements = this.testCon.getStatements(null, predicate, null, false, new Resource[]{context});
        RepositoryConnectionTest.assertTrue((String)"should find the add", (boolean)statements.hasNext());
        statements.next();
        this.testCon.add((Resource)subject, predicate, (Value)two, new Resource[]{context});
        statements.close();
        this.testCon.rollback();
    }

    @Test
    public void testReadOfAddedStatement2() throws Exception {
        URI duff = this.vf.createURI("urn:duff");
        URI context = this.vf.createURI("urn:context");
        URI subject = this.vf.createURI("urn:test");
        URI predicate = this.vf.createURI("urn:property");
        Literal one = this.vf.createLiteral(1);
        Literal two = this.vf.createLiteral(2);
        this.testCon.begin();
        this.testCon.add((Resource)subject, predicate, (Value)one, new Resource[]{context});
        this.testCon.commit();
        this.testCon.begin();
        this.testCon.add((Resource)duff, duff, (Value)duff, new Resource[]{duff});
        RepositoryResult statements = this.testCon.getStatements(null, predicate, null, false, new Resource[]{context});
        RepositoryConnectionTest.assertTrue((String)"should find the add", (boolean)statements.hasNext());
        statements.next();
        this.testCon.add((Resource)subject, predicate, (Value)two, new Resource[]{context});
        statements.close();
        this.testCon.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionIsolationForRead() throws Exception {
        this.testCon.begin();
        try {
            this.testCon.add((Resource)OWL.CLASS, RDFS.COMMENT, (Value)RDF.STATEMENT, new Resource[0]);
            RepositoryConnectionTest.assertTrue((String)"Should be able to see uncommitted statement on same connection", (boolean)this.testCon.hasStatement((Resource)OWL.CLASS, RDFS.COMMENT, (Value)RDF.STATEMENT, true, new Resource[0]));
            RepositoryConnectionTest.assertFalse((String)"Should not be able to see uncommitted statement on separate connection outside transaction", (boolean)this.testCon2.hasStatement((Resource)OWL.CLASS, RDFS.COMMENT, (Value)RDF.STATEMENT, true, new Resource[0]));
            this.testCon2.begin();
            try {
                RepositoryConnectionTest.assertFalse((String)"Should not be able to see uncommitted statement on separate connection inside transaction", (boolean)this.testCon2.hasStatement((Resource)OWL.CLASS, RDFS.COMMENT, (Value)RDF.STATEMENT, true, new Resource[0]));
            }
            finally {
                this.testCon2.rollback();
            }
        }
        finally {
            this.testCon.rollback();
        }
    }

    @Test
    public void testAddReader() throws Exception {
        InputStreamReader defaultGraph = new InputStreamReader(RepositoryConnectionTest.class.getResourceAsStream("/testcases/default-graph.ttl"), "UTF-8");
        this.testCon.add((Reader)defaultGraph, "", RDFFormat.TURTLE, new Resource[0]);
        ((Reader)defaultGraph).close();
        RepositoryConnectionTest.assertTrue((String)NEWLY_ADDED, (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)NEWLY_ADDED, (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        InputStream graph1Stream = RepositoryConnectionTest.class.getResourceAsStream("/testcases/graph1.ttl");
        InputStreamReader graph1 = new InputStreamReader(graph1Stream, "UTF-8");
        this.testCon.add((Reader)graph1, "", RDFFormat.TURTLE, new Resource[]{this.context1});
        ((Reader)graph1).close();
        InputStream graph2Stream = RepositoryConnectionTest.class.getResourceAsStream("/testcases/graph2.ttl");
        InputStreamReader graph2 = new InputStreamReader(graph2Stream, "UTF-8");
        this.testCon.add((Reader)graph2, "", RDFFormat.TURTLE, new Resource[]{this.context2});
        ((Reader)graph2).close();
        RepositoryConnectionTest.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        RepositoryConnectionTest.assertFalse((String)"alice should not be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context1}));
        RepositoryConnectionTest.assertTrue((String)"alice should be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context2}));
        RepositoryConnectionTest.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertFalse((String)"bob should not be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
        RepositoryConnectionTest.assertTrue((String)"bib should be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
    }

    @Test
    public void testAddInputStream() throws Exception {
        InputStream defaultGraph = RepositoryConnectionTest.class.getResourceAsStream("/testcases/default-graph.ttl");
        this.testCon.add(defaultGraph, "", RDFFormat.TURTLE, new Resource[0]);
        defaultGraph.close();
        RepositoryConnectionTest.assertTrue((String)NEWLY_ADDED, (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)NEWLY_ADDED, (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        InputStream graph1 = RepositoryConnectionTest.class.getResourceAsStream("/testcases/graph1.ttl");
        this.testCon.add(graph1, "", RDFFormat.TURTLE, new Resource[]{this.context1});
        graph1.close();
        InputStream graph2 = RepositoryConnectionTest.class.getResourceAsStream("/testcases/graph2.ttl");
        this.testCon.add(graph2, "", RDFFormat.TURTLE, new Resource[]{this.context2});
        graph2.close();
        RepositoryConnectionTest.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        RepositoryConnectionTest.assertFalse((String)"alice should not be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context1}));
        RepositoryConnectionTest.assertTrue((String)"alice should be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context2}));
        RepositoryConnectionTest.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertFalse((String)"bob should not be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
        RepositoryConnectionTest.assertTrue((String)"bib should be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddGzipInputStream() throws Exception {
        try (InputStream defaultGraph = RepositoryConnectionTest.class.getResourceAsStream("/testcases/default-graph.ttl.gz");){
            this.testCon.add(defaultGraph, "", RDFFormat.TURTLE, new Resource[0]);
        }
        RepositoryConnectionTest.assertTrue((String)NEWLY_ADDED, (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)NEWLY_ADDED, (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
    }

    @Test
    public void testAddZipFile() throws Exception {
        this.testCon.add(RepositoryConnectionTest.class.getResourceAsStream("/testcases/graphs.zip"), "", RDFFormat.TURTLE, new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)NEWLY_ADDED, (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)NEWLY_ADDED, (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
    }

    @Test
    public void testAddMalformedLiteralsDefaultConfig() throws Exception {
        try {
            this.testCon.add(RepositoryConnectionTest.class.getResourceAsStream("/testcases/malformed-literals.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            RepositoryConnectionTest.fail((String)"upload of malformed literals should fail with error in default configuration");
        }
        catch (RDFParseException rDFParseException) {
            // empty catch block
        }
    }

    @Test
    public void testAddMalformedLiteralsStrictConfig() throws Exception {
        Set empty = Collections.emptySet();
        this.testCon.getParserConfig().setNonFatalErrors(empty);
        try {
            this.testCon.add(RepositoryConnectionTest.class.getResourceAsStream("/testcases/malformed-literals.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            RepositoryConnectionTest.fail((String)"upload of malformed literals should fail with error in strict configuration");
        }
        catch (RDFParseException rDFParseException) {
            // empty catch block
        }
    }

    @Test
    public void testAutoCommit() throws Exception {
        this.testCon.begin();
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)"Uncommitted update should be visible to own connection", (boolean)this.testCon.hasStatement(this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        this.testCon.commit();
        RepositoryConnectionTest.assertTrue((String)"Repository should contain statement after commit", (boolean)this.testCon.hasStatement(this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
    }

    @Test
    public void testRollback() throws Exception {
        this.testCon.begin();
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)"Uncommitted updates should be visible to own connection", (boolean)this.testCon.hasStatement(this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        this.testCon.rollback();
        RepositoryConnectionTest.assertFalse((String)"Repository should not contain statement after rollback", (boolean)this.testCon.hasStatement(this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleTupleQuery() throws Exception {
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder(128);
        queryBuilder.append(" prefix foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" SELECT ?name ?mbox");
        queryBuilder.append(" where { ?s foaf:name ?name . ?s foaf:mbox ?mbox . }");
        try (TupleQueryResult result = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString()).evaluate();){
            Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)result.hasNext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
            while (result.hasNext()) {
                BindingSet solution = (BindingSet)result.next();
                Assert.assertThat((Object)solution.hasBinding(NAME), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
                Assert.assertThat((Object)solution.hasBinding(MBOX), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
                Value nameResult = solution.getValue(NAME);
                Value mboxResult = solution.getValue(MBOX);
                Assert.assertThat((Object)nameResult, (Matcher)AnyOf.anyOf((Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.nameAlice)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.nameBob))));
                Assert.assertThat((Object)mboxResult, (Matcher)AnyOf.anyOf((Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.mboxAlice)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.mboxBob))));
            }
        }
    }

    @Test
    public void testPrepareSPARQLQuery() throws Exception {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" SELECT ?person");
        queryBuilder.append(" WHERE { ?person foaf:name ?y . }");
        try {
            this.testCon.prepareQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        }
        catch (UnsupportedOperationException e) {
            RepositoryConnectionTest.fail((String)(UNSUPPORTED_OP + e.getMessage()));
        }
        catch (ClassCastException e) {
            RepositoryConnectionTest.fail((String)(UNEXPECTED_TYPE + e.getMessage()));
        }
        queryBuilder = new StringBuilder();
        queryBuilder.append(" BASE <http://base.uri>");
        queryBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" PREFIX ex: <http://example.org/>");
        queryBuilder.append(" PREFIX : <http://example.org/foo#>");
        queryBuilder.append(" SELECT ?person");
        queryBuilder.append(" WHERE { ?person foaf:name ?y . }");
        try {
            this.testCon.prepareQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        }
        catch (UnsupportedOperationException e) {
            RepositoryConnectionTest.fail((String)(UNSUPPORTED_OP + e.getMessage()));
        }
        catch (ClassCastException e) {
            RepositoryConnectionTest.fail((String)(UNEXPECTED_TYPE + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreparedTupleQuery() throws Exception {
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" prefix foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" select ?name ?mbox ");
        queryBuilder.append(" where { ?s foaf:name ?name . ?s foaf:mbox ?mbox . }");
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        query.setBinding(NAME, (Value)this.nameBob);
        try (TupleQueryResult result = query.evaluate();){
            Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)result.hasNext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
            while (result.hasNext()) {
                BindingSet solution = (BindingSet)result.next();
                Assert.assertThat((Object)solution.hasBinding(NAME), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
                Assert.assertThat((Object)solution.hasBinding(MBOX), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
                Value nameResult = solution.getValue(NAME);
                Value mboxResult = solution.getValue(MBOX);
                RepositoryConnectionTest.assertEquals((String)("unexpected value for name: " + nameResult), (Object)this.nameBob, (Object)nameResult);
                RepositoryConnectionTest.assertEquals((String)("unexpected value for mbox: " + mboxResult), (Object)this.mboxBob, (Object)mboxResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreparedTupleQuery2() throws Exception {
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" prefix foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" SELECT ?name ?mbox");
        queryBuilder.append(" where { ?VAR foaf:name ?name . ?VAR foaf:mbox ?mbox . }");
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        query.setBinding("VAR", (Value)this.bob);
        try (TupleQueryResult result = query.evaluate();){
            Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)result.hasNext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
            while (result.hasNext()) {
                BindingSet solution = (BindingSet)result.next();
                Assert.assertThat((Object)solution.hasBinding(NAME), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
                Assert.assertThat((Object)solution.hasBinding(MBOX), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
                Value nameResult = solution.getValue(NAME);
                Value mboxResult = solution.getValue(MBOX);
                RepositoryConnectionTest.assertEquals((String)("unexpected value for name: " + nameResult), (Object)this.nameBob, (Object)nameResult);
                RepositoryConnectionTest.assertEquals((String)("unexpected value for mbox: " + mboxResult), (Object)this.mboxBob, (Object)mboxResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleGraphQuery() throws Exception {
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder(128);
        queryBuilder.append(" prefix foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" construct ");
        queryBuilder.append(" where { ?s foaf:name ?name . ?s foaf:mbox ?mbox . }");
        try (GraphQueryResult result = this.testCon.prepareGraphQuery(QueryLanguage.SPARQL, queryBuilder.toString()).evaluate();){
            Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)result.hasNext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
            while (result.hasNext()) {
                Statement st = (Statement)result.next();
                if (this.name.equals((Object)st.getPredicate())) {
                    Assert.assertThat((Object)st.getObject(), (Matcher)AnyOf.anyOf((Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.nameAlice)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.nameBob))));
                    continue;
                }
                Assert.assertThat((Object)st.getPredicate(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.mbox)));
                Assert.assertThat((Object)st.getObject(), (Matcher)AnyOf.anyOf((Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.mboxAlice)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.mboxBob))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreparedGraphQuery() throws Exception {
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder(128);
        queryBuilder.append(" prefix foaf: <http://xmlns.com/foaf/0.1/>");
        queryBuilder.append(" construct ");
        queryBuilder.append(" where { ?s foaf:name ?name . ?s foaf:mbox ?mbox . }");
        GraphQuery query = this.testCon.prepareGraphQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        query.setBinding(NAME, (Value)this.nameBob);
        try (GraphQueryResult result = query.evaluate();){
            Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)result.hasNext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
            while (result.hasNext()) {
                Statement st = (Statement)result.next();
                URI predicate = st.getPredicate();
                Assert.assertThat((Object)predicate, (Matcher)AnyOf.anyOf((Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.name)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.mbox))));
                Value object = st.getObject();
                if (this.name.equals((Object)predicate)) {
                    RepositoryConnectionTest.assertEquals((String)("unexpected value for name: " + object), (Object)this.nameBob, (Object)object);
                    continue;
                }
                Assert.assertThat((Object)predicate, (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.mbox)));
                RepositoryConnectionTest.assertEquals((String)("unexpected value for mbox: " + object), (Object)this.mboxBob, (Object)object);
            }
        }
    }

    @Test
    public void testSimpleBooleanQuery() throws Exception {
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder(64);
        queryBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
        queryBuilder.append(ASK);
        queryBuilder.append("{ ?p foaf:name ?name }");
        boolean exists = this.testCon.prepareBooleanQuery(QueryLanguage.SPARQL, queryBuilder.toString()).evaluate();
        Assert.assertThat((Object)exists, (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
    }

    @Test
    public void testPreparedBooleanQuery() throws Exception {
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
        queryBuilder.append(ASK);
        queryBuilder.append("{ ?p foaf:name ?name }");
        BooleanQuery query = this.testCon.prepareBooleanQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        query.setBinding(NAME, (Value)this.nameBob);
        Assert.assertThat((Object)query.evaluate(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
    }

    @Test
    public void testDataset() throws Exception {
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
        queryBuilder.append(ASK);
        queryBuilder.append("{ ?p foaf:name ?name }");
        BooleanQuery query = this.testCon.prepareBooleanQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        query.setBinding(NAME, (Value)this.nameBob);
        Assert.assertThat((Object)query.evaluate(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        DatasetImpl dataset = new DatasetImpl();
        dataset.addDefaultGraph(this.context1);
        query.setDataset((Dataset)dataset);
        Assert.assertThat((Object)query.evaluate(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        dataset.addDefaultGraph(this.context2);
        query.setDataset((Dataset)dataset);
        Assert.assertThat((Object)query.evaluate(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        dataset.removeDefaultGraph(this.context1);
        query.setDataset((Dataset)dataset);
        Assert.assertThat((Object)query.evaluate(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        queryBuilder.setLength(0);
        queryBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
        queryBuilder.append(ASK);
        queryBuilder.append("{ GRAPH ?g { ?p foaf:name ?name } }");
        query = this.testCon.prepareBooleanQuery(QueryLanguage.SPARQL, queryBuilder.toString());
        query.setBinding(NAME, (Value)this.nameBob);
        query.setDataset((Dataset)dataset);
        Assert.assertThat((Object)query.evaluate(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        dataset.addDefaultGraph(this.context1);
        dataset.addNamedGraph(this.context2);
        query.setDataset((Dataset)dataset);
        Assert.assertThat((Object)query.evaluate(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        dataset.addNamedGraph(this.context1);
        query.setDataset((Dataset)dataset);
        Assert.assertThat((Object)query.evaluate(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetStatements() throws Exception {
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)"Repository should contain statement", (boolean)this.testCon.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        try (RepositoryResult result = this.testCon.getStatements(null, this.name, null, false, new Resource[0]);){
            RepositoryConnectionTest.assertNotNull((String)"Iterator should not be null", (Object)result);
            RepositoryConnectionTest.assertTrue((String)"Iterator should not be empty", (boolean)result.hasNext());
            while (result.hasNext()) {
                Statement st = (Statement)result.next();
                RepositoryConnectionTest.assertNull((String)"Statement should not be in a context ", (Object)st.getContext());
                RepositoryConnectionTest.assertTrue((String)"Statement predicate should be equal to name ", (boolean)st.getPredicate().equals((Object)this.name));
            }
        }
        List list = (List)Iterations.addAll((Iteration)this.testCon.getStatements(null, this.name, null, false, new Resource[0]), new ArrayList());
        RepositoryConnectionTest.assertNotNull((String)"List should not be null", (Object)list);
        RepositoryConnectionTest.assertFalse((String)"List should not be empty", (boolean)list.isEmpty());
    }

    @Test
    public void testGetStatementsMalformedTypedLiteral() throws Exception {
        Literal invalidIntegerLiteral = this.vf.createLiteral("the number four", XMLSchema.INTEGER);
        try {
            URI pred = this.vf.createURI(URN_PRED);
            this.testCon.add(this.bob, pred, (Value)invalidIntegerLiteral, new Resource[0]);
            RepositoryResult statements = this.testCon.getStatements(this.bob, pred, null, true, new Resource[0]);
            RepositoryConnectionTest.assertNotNull((Object)statements);
            RepositoryConnectionTest.assertTrue((boolean)statements.hasNext());
            Statement st = (Statement)statements.next();
            RepositoryConnectionTest.assertTrue((boolean)(st.getObject() instanceof Literal));
            RepositoryConnectionTest.assertTrue((boolean)st.getObject().equals(invalidIntegerLiteral));
        }
        catch (RepositoryException e) {
            RepositoryConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetStatementsMalformedLanguageLiteral() throws Exception {
        Literal invalidLanguageLiteral = this.vf.createLiteral("the number four", "en_us");
        try {
            URI pred = this.vf.createURI(URN_PRED);
            this.testCon.add(this.bob, pred, (Value)invalidLanguageLiteral, new Resource[0]);
            RepositoryResult statements = this.testCon.getStatements(this.bob, pred, null, true, new Resource[0]);
            RepositoryConnectionTest.assertNotNull((Object)statements);
            RepositoryConnectionTest.assertTrue((boolean)statements.hasNext());
            Statement st = (Statement)statements.next();
            RepositoryConnectionTest.assertTrue((boolean)(st.getObject() instanceof Literal));
            RepositoryConnectionTest.assertTrue((boolean)st.getObject().equals(invalidLanguageLiteral));
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            RepositoryConnectionTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetStatementsInSingleContext() throws Exception {
        Statement st;
        this.testCon.begin();
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.commit();
        RepositoryConnectionTest.assertTrue((String)"Repository should contain statement", (boolean)this.testCon.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)"Repository should contain statement in context1", (boolean)this.testCon.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
        RepositoryConnectionTest.assertFalse((String)"Repository should not contain statement in context2", (boolean)this.testCon.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
        try (RepositoryResult result = this.testCon.getStatements(this.bob, this.name, null, false, new Resource[0]);){
            while (result.hasNext()) {
                st = (Statement)result.next();
                Assert.assertThat((Object)st.getSubject(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.bob)));
                Assert.assertThat((Object)st.getPredicate(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.name)));
                Assert.assertThat((Object)st.getObject(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.nameBob)));
                Assert.assertThat((Object)st.getContext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.context1)));
            }
        }
        result = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1});
        try {
            while (result.hasNext()) {
                st = (Statement)result.next();
                Assert.assertThat((Object)st.getContext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.context1)));
            }
        }
        finally {
            result.close();
        }
        result = this.testCon.getStatements(null, null, null, false, new Resource[]{this.unknownContext});
        try {
            Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)result.hasNext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        }
        finally {
            result.close();
        }
        List list = (List)Iterations.addAll((Iteration)this.testCon.getStatements(null, this.name, null, false, new Resource[]{this.context1}), new ArrayList());
        RepositoryConnectionTest.assertNotNull((String)"List should not be null", (Object)list);
        RepositoryConnectionTest.assertFalse((String)"List should not be empty", (boolean)list.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetStatementsInMultipleContexts() throws Exception {
        Statement st;
        int count;
        this.testCon.clear(new Resource[0]);
        this.testCon.begin();
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add(this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.commit();
        try (RepositoryResult iter = this.testCon.getStatements(null, null, null, false, new Resource[]{null, this.context2});){
            count = 0;
            while (iter.hasNext()) {
                ++count;
                st = (Statement)iter.next();
                Assert.assertThat((Object)st.getContext(), (Matcher)AnyOf.anyOf((Matcher)Is.is((Matcher)IsNull.nullValue(Resource.class)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.context2))));
            }
            RepositoryConnectionTest.assertEquals((String)"there should be three statements", (int)3, (int)count);
        }
        iter = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2});
        try {
            count = 0;
            while (iter.hasNext()) {
                ++count;
                st = (Statement)iter.next();
                Assert.assertThat((Object)st.getContext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.context2)));
            }
            RepositoryConnectionTest.assertEquals((String)"there should be two statements", (int)2, (int)count);
        }
        finally {
            iter.close();
        }
        iter = this.testCon.getStatements(null, null, null, false, new Resource[]{this.unknownContext, this.context2});
        try {
            count = 0;
            while (iter.hasNext()) {
                ++count;
                st = (Statement)iter.next();
                Assert.assertThat((Object)st.getContext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.context2)));
            }
            RepositoryConnectionTest.assertEquals((String)"there should be two statements", (int)2, (int)count);
        }
        finally {
            iter.close();
        }
        this.testCon.begin();
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        this.testCon.commit();
        iter = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1});
        try {
            Assert.assertThat((Object)iter, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)iter.hasNext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        }
        finally {
            iter.close();
        }
        iter = this.testCon.getStatements(null, null, null, false, new Resource[]{null, this.context2});
        try {
            count = 0;
            while (iter.hasNext()) {
                ++count;
                st = (Statement)iter.next();
                Assert.assertThat((Object)st.getContext(), (Matcher)AnyOf.anyOf((Matcher)Is.is((Matcher)IsNull.nullValue(Resource.class)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.context2))));
            }
            RepositoryConnectionTest.assertEquals((String)"there should be four statements", (int)4, (int)count);
        }
        finally {
            iter.close();
        }
        iter = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2});
        try {
            count = 0;
            while (iter.hasNext()) {
                ++count;
                st = (Statement)iter.next();
                Assert.assertThat((Object)st.getContext(), (Matcher)AnyOf.anyOf((Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.context1)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.context2))));
            }
            RepositoryConnectionTest.assertEquals((String)"there should be four statements", (int)4, (int)count);
        }
        finally {
            iter.close();
        }
    }

    @Test
    public void testDuplicateFilter() throws Exception {
        this.testCon.begin();
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context2});
        this.testCon.commit();
        RepositoryResult result = this.testCon.getStatements(this.bob, this.name, null, true, new Resource[0]);
        result.enableDuplicateFilter();
        int count = 0;
        while (result.hasNext()) {
            result.next();
            ++count;
        }
        Assert.assertThat((Object)count, (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)1)));
    }

    @Test
    public void testRemoveStatements() throws Exception {
        this.testCon.begin();
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        this.testCon.commit();
        Assert.assertThat((Object)this.testCon.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Assert.assertThat((Object)this.testCon.hasStatement(this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        this.testCon.remove(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        Assert.assertThat((Object)this.testCon.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        Assert.assertThat((Object)this.testCon.hasStatement(this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        this.testCon.remove(this.alice, null, null, new Resource[0]);
        Assert.assertThat((Object)this.testCon.hasStatement(this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        Assert.assertThat((Object)this.testCon.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
    }

    @Test
    public void testRemoveStatementCollection() throws Exception {
        this.testCon.begin();
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.commit();
        Assert.assertThat((Object)this.testCon.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Assert.assertThat((Object)this.testCon.hasStatement(this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Collection c = Iterations.addAll((Iteration)this.testCon.getStatements(null, null, null, false, new Resource[0]), new ArrayList());
        this.testCon.remove((Iterable)c, new Resource[0]);
        Assert.assertThat((Object)this.testCon.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        Assert.assertThat((Object)this.testCon.hasStatement(this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveStatementIteration() throws Exception {
        this.testCon.begin();
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.commit();
        Assert.assertThat((Object)this.testCon.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Assert.assertThat((Object)this.testCon.hasStatement(this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        try (RepositoryResult iter = this.testCon.getStatements(null, null, null, false, new Resource[0]);){
            this.testCon.remove((Iteration)iter, new Resource[0]);
        }
        Assert.assertThat((Object)this.testCon.hasStatement(this.bob, this.name, (Value)this.nameBob, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        Assert.assertThat((Object)this.testCon.hasStatement(this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
    }

    @Test
    public void testGetNamespace() throws Exception {
        this.setupNamespaces();
        Assert.assertThat((Object)this.testCon.getNamespace(EXAMPLE), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)EXAMPLE_NS)));
        Assert.assertThat((Object)this.testCon.getNamespace(RDFS_PREFIX), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)RDFS_NS)));
        Assert.assertThat((Object)this.testCon.getNamespace(RDF_PREFIX), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#")));
        Assert.assertThat((Object)this.testCon.getNamespace("undefined"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void testGetNamespaces() throws Exception {
        this.setupNamespaces();
        Map map = Namespaces.asMap((Set)Iterations.asSet((Iteration)this.testCon.getNamespaces()));
        Assert.assertThat((Object)map.size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)3)));
        Assert.assertThat(map.keySet(), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{EXAMPLE, RDFS_PREFIX, RDF_PREFIX}));
        Assert.assertThat(map.get(EXAMPLE), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)EXAMPLE_NS)));
        Assert.assertThat(map.get(RDFS_PREFIX), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)RDFS_NS)));
        Assert.assertThat(map.get(RDF_PREFIX), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#")));
    }

    private void setupNamespaces() throws IOException, RDFParseException, RepositoryException {
        this.testCon.setNamespace(EXAMPLE, EXAMPLE_NS);
        this.testCon.setNamespace(RDF_PREFIX, "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.testCon.setNamespace(RDFS_PREFIX, RDFS_NS);
        this.testCon.add((Resource)this.vf.createURI(EXAMPLE_NS, "Main"), this.vf.createURI(RDFS_NS, "label"), (Value)this.vf.createLiteral("Main Node"), new Resource[0]);
    }

    @Test
    public void testClear() throws Exception {
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        Assert.assertThat((Object)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        this.testCon.clear(new Resource[0]);
        Assert.assertThat((Object)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
    }

    @Test
    public void testRecoverFromParseError() throws RepositoryException, IOException {
        String invalidData = "bad";
        String validData = "@prefix foo: <http://example.org/foo#>.\nfoo:a foo:b foo:c.";
        try {
            this.testCon.add((Reader)new StringReader(invalidData), "", RDFFormat.TURTLE, new Resource[0]);
            RepositoryConnectionTest.fail((String)"Invalid data should result in an exception");
        }
        catch (RDFParseException e) {
            // empty catch block
        }
        try {
            this.testCon.add((Reader)new StringReader(validData), "", RDFFormat.TURTLE, new Resource[0]);
        }
        catch (RDFParseException e) {
            RepositoryConnectionTest.fail((String)"Valid data should not result in an exception");
        }
        RepositoryConnectionTest.assertEquals((String)"Repository contains incorrect number of statements", (long)1L, (long)this.testCon.size(new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatementSerialization() throws Exception {
        Statement st;
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        try (RepositoryResult statements = this.testCon.getStatements(null, null, null, true, new Resource[0]);){
            st = (Statement)statements.next();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(st);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        Statement deserialized = (Statement)in.readObject();
        in.close();
        Assert.assertThat((Object)deserialized, (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)st)));
        Assert.assertThat((Object)this.testCon.hasStatement(st, true, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Assert.assertThat((Object)this.testCon.hasStatement(deserialized, true, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBNodeSerialization() throws Exception {
        Statement st;
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        try (RepositoryResult statements = this.testCon.getStatements(null, null, null, false, new Resource[0]);){
            st = (Statement)statements.next();
        }
        BNode bnode = (BNode)st.getSubject();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(bnode);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        BNode deserializedBNode = (BNode)in.readObject();
        in.close();
        Assert.assertThat((Object)deserializedBNode, (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)bnode)));
        Assert.assertThat((Object)this.testCon.hasStatement((Resource)bnode, this.name, (Value)this.nameBob, true, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Assert.assertThat((Object)this.testCon.hasStatement((Resource)deserializedBNode, this.name, (Value)this.nameBob, true, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testURISerialization() throws Exception {
        Statement st;
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        try (RepositoryResult statements = this.testCon.getStatements(null, null, null, false, new Resource[0]);){
            st = (Statement)statements.next();
        }
        URI uri = st.getPredicate();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(uri);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        URI deserializedURI = (URI)in.readObject();
        in.close();
        Assert.assertThat((Object)deserializedURI, (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)uri)));
        Assert.assertThat((Object)this.testCon.hasStatement(this.bob, uri, (Value)this.nameBob, true, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Assert.assertThat((Object)this.testCon.hasStatement(this.bob, deserializedURI, (Value)this.nameBob, true, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLiteralSerialization() throws Exception {
        Statement st;
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        try (RepositoryResult statements = this.testCon.getStatements(null, null, null, false, new Resource[0]);){
            st = (Statement)statements.next();
        }
        Literal literal = (Literal)st.getObject();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(literal);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        Literal deserialized = (Literal)in.readObject();
        in.close();
        Assert.assertThat((Object)deserialized, (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)literal)));
        Assert.assertThat((Object)this.testCon.hasStatement(this.bob, this.name, (Value)literal, true, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Assert.assertThat((Object)this.testCon.hasStatement(this.bob, this.name, (Value)deserialized, true, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGraphSerialization() throws Exception {
        LinkedHashModel graph;
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.add(this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        try (RepositoryResult statements = this.testCon.getStatements(null, null, null, true, new Resource[0]);){
            graph = new LinkedHashModel((Collection)Iterations.asList((Iteration)statements));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(graph);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        Graph deserializedGraph = (Graph)in.readObject();
        in.close();
        Assert.assertThat((Object)deserializedGraph.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        for (Statement st : deserializedGraph) {
            Assert.assertThat((Object)graph, (Matcher)CoreMatchers.hasItem((Object)st));
            Assert.assertThat((Object)this.testCon.hasStatement(st, true, new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        }
    }

    @Test
    public void testEmptyRollback() throws Exception {
        Assert.assertThat((Object)this.testCon.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Assert.assertThat((Object)this.testCon2.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        this.testCon.begin();
        this.testCon.add((Resource)this.vf.createBNode(), this.vf.createURI(URN_PRED), (Value)this.vf.createBNode(), new Resource[0]);
        Assert.assertThat((Object)this.testCon.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        Assert.assertThat((Object)this.testCon2.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        this.testCon.rollback();
        Assert.assertThat((Object)this.testCon.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Assert.assertThat((Object)this.testCon2.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
    }

    @Test
    public void testEmptyCommit() throws Exception {
        Assert.assertThat((Object)this.testCon.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Assert.assertThat((Object)this.testCon2.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        this.testCon.begin();
        this.testCon.add((Resource)this.vf.createBNode(), this.vf.createURI(URN_PRED), (Value)this.vf.createBNode(), new Resource[0]);
        Assert.assertThat((Object)this.testCon.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        Assert.assertThat((Object)this.testCon2.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        this.testCon.commit();
        this.testCon2.close();
        this.testCon2 = this.testRepository.getConnection();
        Assert.assertThat((Object)this.testCon.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        Assert.assertThat((Object)this.testCon2.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
    }

    @Test
    public void testOpen() throws Exception {
        Assert.assertThat((Object)this.testCon.isOpen(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Assert.assertThat((Object)this.testCon2.isOpen(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        this.testCon.close();
        Assert.assertThat((Object)this.testCon.isOpen(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)false)));
        Assert.assertThat((Object)this.testCon2.isOpen(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
    }

    @Test
    public void testSizeRollback() throws Exception {
        Assert.assertThat((Object)this.testCon.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0L)));
        Assert.assertThat((Object)this.testCon2.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0L)));
        this.testCon.begin();
        this.testCon.add((Resource)this.vf.createBNode(), this.vf.createURI(URN_PRED), (Value)this.vf.createBNode(), new Resource[0]);
        Assert.assertThat((Object)this.testCon.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)1L)));
        Assert.assertThat((Object)this.testCon2.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0L)));
        this.testCon.add((Resource)this.vf.createBNode(), this.vf.createURI(URN_PRED), (Value)this.vf.createBNode(), new Resource[0]);
        Assert.assertThat((Object)this.testCon.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)2L)));
        Assert.assertThat((Object)this.testCon2.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0L)));
        this.testCon.rollback();
        Assert.assertThat((Object)this.testCon.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0L)));
        Assert.assertThat((Object)this.testCon2.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0L)));
    }

    @Test
    public void testSizeCommit() throws Exception {
        Assert.assertThat((Object)this.testCon.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0L)));
        Assert.assertThat((Object)this.testCon2.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0L)));
        this.testCon.begin();
        this.testCon.add((Resource)this.vf.createBNode(), this.vf.createURI(URN_PRED), (Value)this.vf.createBNode(), new Resource[0]);
        Assert.assertThat((Object)this.testCon.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)1L)));
        Assert.assertThat((Object)this.testCon2.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0L)));
        this.testCon.add((Resource)this.vf.createBNode(), this.vf.createURI(URN_PRED), (Value)this.vf.createBNode(), new Resource[0]);
        Assert.assertThat((Object)this.testCon.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)2L)));
        Assert.assertThat((Object)this.testCon2.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0L)));
        this.testCon.commit();
        this.testCon2.close();
        this.testCon2 = this.testRepository.getConnection();
        Assert.assertThat((Object)this.testCon.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)2L)));
        Assert.assertThat((Object)this.testCon2.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)2L)));
    }

    @Test
    public void testAddRemove() throws Exception {
        URI FOAF_PERSON = this.vf.createURI("http://xmlns.com/foaf/0.1/Person");
        final Statement stmt = this.vf.createStatement(this.bob, this.name, (Value)this.nameBob);
        this.testCon.add(this.bob, RDF.TYPE, (Value)FOAF_PERSON, new Resource[0]);
        this.testCon.begin();
        this.testCon.add(stmt, new Resource[0]);
        this.testCon.remove(stmt, new Resource[0]);
        this.testCon.commit();
        this.testCon.exportStatements(null, null, null, false, (RDFHandler)new RDFHandlerBase(){

            public void handleStatement(Statement st) throws RDFHandlerException {
                Assert.assertThat((Object)st, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)stmt))));
            }
        }, new Resource[0]);
    }

    @Test
    public void testInferredStatementCount() throws Exception {
        Assert.assertThat((Object)this.testCon.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        int inferred = this.getTotalStatementCount(this.testCon);
        URI root = this.vf.createURI("urn:root");
        this.testCon.add((Resource)root, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
        this.testCon.remove((Resource)root, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
        Assert.assertThat((Object)this.testCon.isEmpty(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        Assert.assertThat((Object)this.getTotalStatementCount(this.testCon), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)inferred)));
    }

    @Test
    public void testGetContextIDs() throws Exception {
        Assert.assertThat((Object)Iterations.asList((Iteration)this.testCon.getContextIDs()).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0)));
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        Assert.assertThat((Object)Iterations.asList((Iteration)this.testCon.getContextIDs()), (Matcher)Is.is((Matcher)IsEqual.equalTo(Arrays.asList(this.context1))));
        this.testCon.remove(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        Assert.assertThat((Object)Iterations.asList((Iteration)this.testCon.getContextIDs()).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0)));
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context2});
        Assert.assertThat((Object)Iterations.asList((Iteration)this.testCon.getContextIDs()), (Matcher)Is.is((Matcher)IsEqual.equalTo(Arrays.asList(this.context2))));
    }

    @Test
    public void testXmlCalendarZ() throws Exception {
        String NS = "http://example.org/rdf/";
        int OFFSET = TimeZone.getDefault().getOffset(new GregorianCalendar(107, 10, 6).getTimeInMillis()) / 1000 / 60;
        String SELECT_BY_DATE = "SELECT ?s ?d WHERE { ?s <http://www.w3.org/1999/02/22-rdf-syntax-ns#value> ?d . FILTER (?d <= ?date) }";
        DatatypeFactory data = DatatypeFactory.newInstance();
        for (int i = 1; i < 5; ++i) {
            URI uri = this.vf.createURI(NS, "date" + i);
            XMLGregorianCalendar xcal = data.newXMLGregorianCalendar();
            xcal.setYear(2000);
            xcal.setMonth(11);
            xcal.setDay(i * 2);
            this.testCon.add((Resource)uri, RDF.VALUE, (Value)this.vf.createLiteral(xcal), new Resource[0]);
            URI uriz = this.vf.createURI(NS, "dateZ" + i);
            xcal = data.newXMLGregorianCalendar();
            xcal.setYear(2007);
            xcal.setMonth(11);
            xcal.setDay(i * 2);
            xcal.setTimezone(OFFSET);
            this.testCon.add((Resource)uriz, RDF.VALUE, (Value)this.vf.createLiteral(xcal), new Resource[0]);
        }
        XMLGregorianCalendar xcal = data.newXMLGregorianCalendar();
        xcal.setYear(2007);
        xcal.setMonth(11);
        xcal.setDay(6);
        xcal.setTimezone(OFFSET);
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, SELECT_BY_DATE);
        query.setBinding("date", (Value)this.vf.createLiteral(xcal));
        TupleQueryResult result = query.evaluate();
        ArrayList<Object> list = new ArrayList<Object>();
        while (result.hasNext()) {
            list.add(result.next());
        }
        Assert.assertThat((Object)list.size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)7)));
    }

    @Test
    public void testOptionalFilter() throws Exception {
        String optional = "{ ?s :p1 ?v1 OPTIONAL {?s :p2 ?v2 FILTER(?v1<3) } }";
        URI s = this.vf.createURI("urn:test:s");
        URI p1 = this.vf.createURI(URN_TEST_P1);
        URI p2 = this.vf.createURI(URN_TEST_P2);
        Literal v1 = this.vf.createLiteral(1);
        Literal v2 = this.vf.createLiteral(2);
        Literal v3 = this.vf.createLiteral(3);
        this.testCon.add((Resource)s, p1, (Value)v1, new Resource[0]);
        this.testCon.add((Resource)s, p2, (Value)v2, new Resource[0]);
        this.testCon.add((Resource)s, p1, (Value)v3, new Resource[0]);
        String qry = "PREFIX :<urn:test:> SELECT ?s ?v1 ?v2 WHERE " + optional;
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, qry);
        TupleQueryResult result = query.evaluate();
        HashSet<List<Value>> set = new HashSet<List<Value>>();
        while (result.hasNext()) {
            BindingSet bindings = (BindingSet)result.next();
            set.add(Arrays.asList(bindings.getValue("v1"), bindings.getValue("v2")));
        }
        result.close();
        Assert.assertThat(set, (Matcher)CoreMatchers.hasItem(Arrays.asList(v1, v2)));
        Assert.assertThat(set, (Matcher)CoreMatchers.hasItem(Arrays.asList(v3, null)));
    }

    @Test
    public void testOrPredicate() throws Exception {
        String union = "{ :s ?p :o FILTER (?p = :p1 || ?p = :p2) }";
        URI s = this.vf.createURI("urn:test:s");
        URI p1 = this.vf.createURI(URN_TEST_P1);
        URI p2 = this.vf.createURI(URN_TEST_P2);
        URI o = this.vf.createURI("urn:test:o");
        this.testCon.add((Resource)s, p1, (Value)o, new Resource[0]);
        this.testCon.add((Resource)s, p2, (Value)o, new Resource[0]);
        String qry = "PREFIX :<urn:test:> SELECT ?p WHERE " + union;
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, qry);
        TupleQueryResult result = query.evaluate();
        ArrayList<Value> list = new ArrayList<Value>();
        while (result.hasNext()) {
            BindingSet bindings = (BindingSet)result.next();
            list.add(bindings.getValue("p"));
        }
        result.close();
        Assert.assertThat(list, (Matcher)CoreMatchers.hasItem((Object)p1));
        Assert.assertThat(list, (Matcher)CoreMatchers.hasItem((Object)p2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSES713() throws Exception {
        String queryString = "SELECT * { ?sub ?pred ?obj . FILTER ( 'not a number' + 1 = ?obj )}";
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        try (TupleQueryResult tqr = query.evaluate();){
            RepositoryConnectionTest.assertFalse((String)"Query should not return any results", (boolean)tqr.hasNext());
        }
    }

    @Test
    public void testOrderByQueriesAreInterruptable() throws Exception {
        this.testCon.begin();
        for (int index = 0; index < 512; ++index) {
            this.testCon.add((Resource)RDFS.CLASS, RDFS.COMMENT, (Value)this.testCon.getValueFactory().createBNode(), new Resource[0]);
        }
        this.testCon.commit();
        TupleQuery query = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT * WHERE { ?s ?p ?o . ?s1 ?p1 ?o1 . ?s2 ?p2 ?o2 . ?s3 ?p3 ?o3 } ORDER BY ?s1 ?p1 ?o1 LIMIT 1000");
        query.setMaxQueryTime(2);
        TupleQueryResult result = query.evaluate();
        long startTime = System.currentTimeMillis();
        try {
            result.hasNext();
            RepositoryConnectionTest.fail((String)"Query should have been interrupted");
        }
        catch (QueryInterruptedException e) {
            long duration = System.currentTimeMillis() - startTime;
            RepositoryConnectionTest.assertTrue((String)("Query not interrupted quickly enough, should have been ~2s, but was " + duration / 1000L + "s"), (duration < 5000L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQueryDefaultGraph() throws Exception {
        URI graph = this.vf.createURI("urn:test:default");
        this.testCon.add((Resource)this.vf.createURI(URN_TEST_S1), this.vf.createURI(URN_TEST_P1), (Value)this.vf.createURI(URN_TEST_O1), new Resource[0]);
        Assert.assertThat((Object)this.size(graph), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0)));
        this.testCon.add((Resource)this.vf.createURI("urn:test:s2"), this.vf.createURI(URN_TEST_P2), (Value)this.vf.createURI("urn:test:o2"), new Resource[]{graph});
        Assert.assertThat((Object)this.size(graph), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryBaseURI() throws Exception {
        this.testCon.add((Resource)this.vf.createURI(URN_TEST_S1), this.vf.createURI(URN_TEST_P1), (Value)this.vf.createURI(URN_TEST_O1), new Resource[0]);
        try (TupleQueryResult rs = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT * { <> ?p ?o }", URN_TEST_S1).evaluate();){
            Assert.assertThat((Object)rs.hasNext(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
        }
    }

    @Test
    public void testUpdateBaseURI() throws Exception {
        this.testCon.prepareUpdate(QueryLanguage.SPARQL, "INSERT DATA { <> a <> }", URN_TEST_S1).execute();
        Assert.assertThat((Object)this.testCon.size(new Resource[0]), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)1L)));
    }

    @Test
    public void testDeleteDefaultGraph() throws Exception {
        URI g1 = this.vf.createURI("urn:test:g1");
        URI g2 = this.vf.createURI("urn:test:g2");
        this.testCon.add((Resource)this.vf.createURI(URN_TEST_S1), this.vf.createURI(URN_TEST_P1), (Value)this.vf.createURI(URN_TEST_O1), new Resource[]{g1});
        this.testCon.add((Resource)this.vf.createURI("urn:test:s2"), this.vf.createURI(URN_TEST_P2), (Value)this.vf.createURI("urn:test:o2"), new Resource[]{g2});
        Update up = this.testCon.prepareUpdate(QueryLanguage.SPARQL, SPARQL_DEL_ALL);
        DatasetImpl ds = new DatasetImpl();
        ds.addDefaultGraph(g1);
        ds.addDefaultRemoveGraph(g1);
        up.setDataset((Dataset)ds);
        up.execute();
        Assert.assertThat((Object)this.size(g1), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0)));
        Assert.assertThat((Object)this.size(g2), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)1)));
    }

    @Test
    public void testDefaultContext() throws Exception {
        ContextAwareConnection con = new ContextAwareConnection(this.testCon);
        URI defaultGraph = this.vf.createURI("urn:test:default");
        con.setReadContexts(new URI[]{defaultGraph});
        con.setInsertContext(defaultGraph);
        con.setRemoveContexts(new URI[]{defaultGraph});
        con.add((Resource)this.vf.createURI(URN_TEST_S1), this.vf.createURI(URN_TEST_P1), (Value)this.vf.createURI(URN_TEST_O1), new Resource[0]);
        con.prepareUpdate("INSERT DATA { graph <urn:test:default> { <urn:test:s2> <urn:test:p2> \"l2\" }}").execute();
        Assert.assertThat((Object)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)2)));
        Assert.assertThat((Object)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[]{defaultGraph})).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)2)));
        Assert.assertThat((Object)this.size(defaultGraph), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)2)));
        con.add((Resource)this.vf.createURI("urn:test:s3"), this.vf.createURI("urn:test:p3"), (Value)this.vf.createURI("urn:test:o3"), new Resource[]{null});
        con.add((Resource)this.vf.createURI("urn:test:s4"), this.vf.createURI("urn:test:p4"), (Value)this.vf.createURI("urn:test:o4"), new Resource[]{this.vf.createURI(URN_TEST_OTHER)});
        Assert.assertThat((Object)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)3)));
        Assert.assertThat((Object)Iterations.asList((Iteration)this.testCon.getStatements(null, null, null, true, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)4)));
        Assert.assertThat((Object)this.size(defaultGraph), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)3)));
        Assert.assertThat((Object)this.size(this.vf.createURI(URN_TEST_OTHER)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)1)));
        con.prepareUpdate(SPARQL_DEL_ALL).execute();
        Assert.assertThat((Object)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0)));
        Assert.assertThat((Object)Iterations.asList((Iteration)this.testCon.getStatements(null, null, null, true, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)1)));
        Assert.assertThat((Object)this.size(defaultGraph), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0)));
        Assert.assertThat((Object)this.size(this.vf.createURI(URN_TEST_OTHER)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)1)));
    }

    @Test
    public void testDefaultInsertContext() throws Exception {
        ContextAwareConnection con = new ContextAwareConnection(this.testCon);
        URI defaultGraph = this.vf.createURI("urn:test:default");
        con.setInsertContext(defaultGraph);
        con.add((Resource)this.vf.createURI(URN_TEST_S1), this.vf.createURI(URN_TEST_P1), (Value)this.vf.createURI(URN_TEST_O1), new Resource[0]);
        con.prepareUpdate("INSERT DATA { graph <urn:test:default> { <urn:test:s2> <urn:test:p2> \"l2\" }}").execute();
        Assert.assertThat((Object)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)2)));
        Assert.assertThat((Object)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[]{defaultGraph})).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)2)));
        Assert.assertThat((Object)this.size(defaultGraph), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)2)));
        con.add((Resource)this.vf.createURI("urn:test:s3"), this.vf.createURI("urn:test:p3"), (Value)this.vf.createURI("urn:test:o3"), new Resource[]{null});
        con.add((Resource)this.vf.createURI("urn:test:s4"), this.vf.createURI("urn:test:p4"), (Value)this.vf.createURI("urn:test:o4"), new Resource[]{this.vf.createURI(URN_TEST_OTHER)});
        Assert.assertThat((Object)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)4)));
        Assert.assertThat((Object)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[]{defaultGraph})).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)3)));
        Assert.assertThat((Object)Iterations.asList((Iteration)this.testCon.getStatements(null, null, null, true, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)4)));
        Assert.assertThat((Object)this.size(defaultGraph), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)3)));
        Assert.assertThat((Object)this.size(this.vf.createURI(URN_TEST_OTHER)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)1)));
        con.clear(new Resource[0]);
        Assert.assertThat((Object)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0)));
        Assert.assertThat((Object)Iterations.asList((Iteration)this.testCon.getStatements(null, null, null, true, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0)));
        Assert.assertThat((Object)this.size(defaultGraph), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0)));
        Assert.assertThat((Object)this.size(this.vf.createURI(URN_TEST_OTHER)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0)));
    }

    @Test
    public void testExclusiveNullContext() throws Exception {
        ContextAwareConnection con = new ContextAwareConnection(this.testCon);
        URI defaultGraph = BD.NULL_GRAPH;
        con.setReadContexts(new URI[]{defaultGraph});
        con.setInsertContext(defaultGraph);
        con.setRemoveContexts(new URI[]{defaultGraph});
        con.add((Resource)this.vf.createURI(URN_TEST_S1), this.vf.createURI(URN_TEST_P1), (Value)this.vf.createURI(URN_TEST_O1), new Resource[0]);
        con.prepareUpdate("INSERT DATA { <urn:test:s2> <urn:test:p2> \"l2\" }").execute();
        Assert.assertThat((Object)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)2)));
        Assert.assertThat((Object)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[]{defaultGraph})).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)2)));
        Assert.assertThat((Object)this.size(defaultGraph), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)2)));
        con.add((Resource)this.vf.createURI("urn:test:s3"), this.vf.createURI("urn:test:p3"), (Value)this.vf.createURI("urn:test:o3"), new Resource[]{null});
        con.add((Resource)this.vf.createURI("urn:test:s4"), this.vf.createURI("urn:test:p4"), (Value)this.vf.createURI("urn:test:o4"), new Resource[]{this.vf.createURI(URN_TEST_OTHER)});
        Assert.assertThat((Object)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)3)));
        Assert.assertThat((Object)Iterations.asList((Iteration)this.testCon.getStatements(null, null, null, true, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)4)));
        Assert.assertThat((Object)this.size(defaultGraph), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)3)));
        Assert.assertThat((Object)this.size(this.vf.createURI(URN_TEST_OTHER)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)1)));
        con.prepareUpdate(SPARQL_DEL_ALL).execute();
        Assert.assertThat((Object)Iterations.asList((Iteration)con.getStatements(null, null, null, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0)));
        Assert.assertThat((Object)Iterations.asList((Iteration)this.testCon.getStatements(null, null, null, true, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)1)));
        Assert.assertThat((Object)this.size(defaultGraph), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)0)));
        Assert.assertThat((Object)this.size(this.vf.createURI(URN_TEST_OTHER)), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int size(URI defaultGraph) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        TupleQuery qry = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT * { ?s ?p ?o }");
        DatasetImpl dataset = new DatasetImpl();
        dataset.addDefaultGraph(defaultGraph);
        qry.setDataset((Dataset)dataset);
        try (TupleQueryResult result = qry.evaluate();){
            int count = 0;
            while (result.hasNext()) {
                result.next();
                ++count;
            }
            int n = count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTotalStatementCount(RepositoryConnection connection) throws RepositoryException {
        try (RepositoryResult iter = connection.getStatements(null, null, null, true, new Resource[0]);){
            int size = 0;
            while (iter.hasNext()) {
                iter.next();
                ++size;
            }
            int n = size;
            return n;
        }
    }
}

