/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.NumericLiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public abstract class RDFStoreTest
extends TestCase {
    @Rule
    public Timeout to = new Timeout(60000);
    private static final String EXAMPLE_NS = "http://example.org/";
    private static final String PAINTER = "Painter";
    private static final String PAINTS = "paints";
    private static final String PAINTING = "Painting";
    private static final String PICASSO = "picasso";
    private static final String REMBRANDT = "rembrandt";
    private static final String GUERNICA = "guernica";
    private static final String NIGHTWATCH = "nightwatch";
    private static final String CONTEXT_1 = "context1";
    private static final String CONTEXT_2 = "context2";
    protected URI painter;
    protected URI paints;
    protected URI painting;
    protected URI picasso;
    protected URI rembrandt;
    protected URI guernica;
    protected URI nightwatch;
    protected URI context1;
    protected URI context2;
    protected Sail sail;
    protected SailConnection con;
    protected ValueFactory vf;

    protected abstract Sail createSail() throws SailException;

    @Before
    public void setUp() throws Exception {
        this.sail = this.createSail();
        this.con = this.sail.getConnection();
        this.vf = this.sail.getValueFactory();
        this.painter = this.vf.createURI(EXAMPLE_NS, PAINTER);
        this.paints = this.vf.createURI(EXAMPLE_NS, PAINTS);
        this.painting = this.vf.createURI(EXAMPLE_NS, PAINTING);
        this.picasso = this.vf.createURI(EXAMPLE_NS, PICASSO);
        this.guernica = this.vf.createURI(EXAMPLE_NS, GUERNICA);
        this.rembrandt = this.vf.createURI(EXAMPLE_NS, REMBRANDT);
        this.nightwatch = this.vf.createURI(EXAMPLE_NS, NIGHTWATCH);
        this.context1 = this.vf.createURI(EXAMPLE_NS, CONTEXT_1);
        this.context2 = this.vf.createURI(EXAMPLE_NS, CONTEXT_2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        try {
            if (this.con.isOpen()) {
                this.con.rollback();
                this.con.close();
            }
        }
        finally {
            this.sail.shutDown();
            this.sail = null;
        }
    }

    @Test
    public void testEmptyRepository() throws Exception {
        RDFStoreTest.assertEquals((String)"Empty repository should not return any statements", (int)0, (int)this.countAllElements());
        RDFStoreTest.assertEquals((String)"Named context should be empty", (int)0, (int)this.countContext1Elements());
        RDFStoreTest.assertEquals((String)"Empty repository should not return any context identifiers", (int)0, (int)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        RDFStoreTest.assertEquals((String)"Empty repository should not return any query results", (int)0, (int)this.countQueryResults("select * from {S} P {O}"));
    }

    @Test
    public void testValueRoundTrip1() throws Exception {
        URIImpl subj = new URIImpl("http://example.org/picasso");
        URIImpl pred = new URIImpl("http://example.org/paints");
        URIImpl obj = new URIImpl("http://example.org/guernica");
        this.testValueRoundTrip((Resource)subj, (URI)pred, (Value)obj);
    }

    @Test
    public void testValueRoundTrip2() throws Exception {
        BNode subj = this.vf.createBNode();
        URIImpl pred = new URIImpl("http://example.org/paints");
        URIImpl obj = new URIImpl("http://example.org/guernica");
        this.testValueRoundTrip((Resource)subj, (URI)pred, (Value)obj);
    }

    @Test
    public void testValueRoundTrip3() throws Exception {
        URIImpl subj = new URIImpl("http://example.org/picasso");
        URIImpl pred = new URIImpl("http://example.org/paints");
        LiteralImpl obj = new LiteralImpl(GUERNICA);
        this.testValueRoundTrip((Resource)subj, (URI)pred, (Value)obj);
    }

    @Test
    public void testValueRoundTrip4() throws Exception {
        URIImpl subj = new URIImpl("http://example.org/picasso");
        URIImpl pred = new URIImpl("http://example.org/paints");
        LiteralImpl obj = new LiteralImpl(GUERNICA, "es");
        this.testValueRoundTrip((Resource)subj, (URI)pred, (Value)obj);
    }

    @Test
    public void testValueRoundTrip5() throws Exception {
        URIImpl subj = new URIImpl("http://example.org/picasso");
        URIImpl pred = new URIImpl("http://example.org/paints");
        NumericLiteralImpl obj = new NumericLiteralImpl(3);
        this.testValueRoundTrip((Resource)subj, (URI)pred, (Value)obj);
    }

    @Test
    public void testDecimalRoundTrip() throws Exception {
        URIImpl subj = new URIImpl("http://example.org/picasso");
        URIImpl pred = new URIImpl("http://example.org/paints");
        NumericLiteralImpl obj = new NumericLiteralImpl((Number)3, XMLSchema.DECIMAL);
        this.testValueRoundTrip((Resource)subj, (URI)pred, (Value)obj);
    }

    @Test
    public void testTimeZoneRoundTrip() throws Exception {
        URIImpl subj = new URIImpl("http://example.org/picasso");
        URIImpl pred = new URIImpl("http://example.org/paints");
        LiteralImpl obj = new LiteralImpl("2006-08-23+00:00", XMLSchema.DATE);
        this.testValueRoundTrip((Resource)subj, (URI)pred, (Value)obj);
        this.con.begin();
        this.con.removeStatements(null, null, null, new Resource[0]);
        this.con.commit();
        obj = new LiteralImpl("2006-08-23", XMLSchema.DATE);
        this.testValueRoundTrip((Resource)subj, (URI)pred, (Value)obj);
    }

    @Test
    public void testLongURIRoundTrip() throws Exception {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 512; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        URIImpl subj = new URIImpl("http://example.org/picasso");
        URIImpl pred = new URIImpl("http://example.org/paints");
        URIImpl obj = new URIImpl("http://example.org/guernica" + sb.toString());
        this.testValueRoundTrip((Resource)subj, (URI)pred, (Value)obj);
    }

    @Test
    public void testLongLiteralRoundTrip() throws Exception {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 512; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        URIImpl subj = new URIImpl("http://example.org/picasso");
        URIImpl pred = new URIImpl("http://example.org/paints");
        LiteralImpl obj = new LiteralImpl(GUERNICA + sb.toString());
        this.testValueRoundTrip((Resource)subj, (URI)pred, (Value)obj);
    }

    @Test
    public void testReallyLongLiteralRoundTrip() throws Exception {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 1024000; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        URIImpl subj = new URIImpl("http://example.org/picasso");
        URIImpl pred = new URIImpl("http://example.org/paints");
        LiteralImpl obj = new LiteralImpl(GUERNICA + sb.toString());
        this.testValueRoundTrip((Resource)subj, (URI)pred, (Value)obj);
    }

    @Test
    public void testLongLangRoundTrip() throws Exception {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 512; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        URIImpl subj = new URIImpl("http://example.org/picasso");
        URIImpl pred = new URIImpl("http://example.org/paints");
        LiteralImpl obj = new LiteralImpl(GUERNICA + sb.toString(), "es");
        this.testValueRoundTrip((Resource)subj, (URI)pred, (Value)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testValueRoundTrip(Resource subj, URI pred, Value obj) throws Exception {
        this.con.begin();
        this.con.addStatement(subj, pred, obj, new Resource[0]);
        this.con.commit();
        try (CloseableIteration stIter = this.con.getStatements(null, null, null, false, new Resource[0]);){
            RDFStoreTest.assertTrue((boolean)stIter.hasNext());
            Statement st = (Statement)stIter.next();
            RDFStoreTest.assertEquals((Object)subj, (Object)st.getSubject());
            RDFStoreTest.assertEquals((Object)pred, (Object)st.getPredicate());
            RDFStoreTest.assertEquals((Object)obj, (Object)st.getObject());
            RDFStoreTest.assertTrue((!stIter.hasNext() ? 1 : 0) != 0);
        }
        ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SERQL, (String)("SELECT S, P, O FROM {S} P {O} WHERE P = <" + pred.stringValue() + ">"), null);
        try (CloseableIteration iter = this.con.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false);){
            RDFStoreTest.assertTrue((boolean)iter.hasNext());
            BindingSet bindings = (BindingSet)iter.next();
            RDFStoreTest.assertEquals((Object)subj, (Object)bindings.getValue("S"));
            RDFStoreTest.assertEquals((Object)pred, (Object)bindings.getValue("P"));
            RDFStoreTest.assertEquals((Object)obj, (Object)bindings.getValue("O"));
            RDFStoreTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCreateURI1() throws Exception {
        URI picasso1 = this.vf.createURI(EXAMPLE_NS, PICASSO);
        URI picasso2 = this.vf.createURI("http://example.org/picasso");
        this.con.begin();
        this.con.addStatement((Resource)picasso1, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.addStatement((Resource)picasso2, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.commit();
        RDFStoreTest.assertEquals((String)"createURI(Sring) and createURI(String, String) should create equal URIs", (long)1L, (long)this.con.size(new Resource[0]));
    }

    @Test
    public void testCreateURI2() throws Exception {
        URI picasso1 = this.vf.createURI("http://example.org/picasso");
        URI picasso2 = this.vf.createURI(EXAMPLE_NS, PICASSO);
        this.con.begin();
        this.con.addStatement((Resource)picasso1, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.addStatement((Resource)picasso2, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.commit();
        RDFStoreTest.assertEquals((String)"createURI(Sring) and createURI(String, String) should create equal URIs", (long)1L, (long)this.con.size(new Resource[0]));
    }

    @Test
    public void testInvalidDateTime() throws Exception {
        Literal date1 = this.vf.createLiteral("2004-12-20", XMLSchema.DATETIME);
        Literal date2 = this.vf.createLiteral("2004-12-20", XMLSchema.DATETIME);
        RDFStoreTest.assertEquals((Object)date1, (Object)date2);
    }

    @Test
    public void testSize() throws Exception {
        RDFStoreTest.assertEquals((String)"Size of empty repository should be 0", (long)0L, (long)this.con.size(new Resource[0]));
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        RDFStoreTest.assertEquals((String)"Size of repository should be 5", (long)5L, (long)this.con.size(new Resource[0]));
        RDFStoreTest.assertEquals((String)"Size of named context should be 3", (long)3L, (long)this.con.size(new Resource[]{this.context1}));
        URIImpl unknownContext = new URIImpl("http://example.org/unknown");
        RDFStoreTest.assertEquals((String)"Size of unknown context should be 0", (long)0L, (long)this.con.size(new Resource[]{unknownContext}));
        URIImpl uriImplContext1 = new URIImpl(this.context1.toString());
        RDFStoreTest.assertEquals((String)"Size of named context (defined as URIImpl) should be 3", (long)3L, (long)this.con.size(new Resource[]{uriImplContext1}));
    }

    @Test
    public void testAddData() throws Exception {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        RDFStoreTest.assertEquals((String)"Repository should contain 5 statements in total", (int)5, (int)this.countAllElements());
        RDFStoreTest.assertEquals((String)"Named context should contain 3 statements", (int)3, (int)this.countContext1Elements());
        RDFStoreTest.assertEquals((String)"Repository should have 1 context identifier", (int)1, (int)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        RDFStoreTest.assertEquals((String)"Repository should contain 5 statements in total", (int)5, (int)this.countQueryResults("select * from {S} P {O}"));
        RDFStoreTest.assertEquals((String)"Statement (Painter, type, Class) should be in the repository", (int)1, (int)this.countQueryResults("select 1 from {ex:Painter} rdf:type {rdfs:Class}"));
        RDFStoreTest.assertEquals((String)"Statement (picasso, type, Painter) should be in the repository", (int)1, (int)this.countQueryResults("select 1 from {ex:picasso} rdf:type {ex:Painter}"));
        RDFStoreTest.assertEquals((String)"Statement (Painter, paints, Painting) should not be in the repository", (int)0, (int)this.countQueryResults("select 1 from {ex:Painter} ex:paints {ex:Painting}"));
        RDFStoreTest.assertEquals((String)"Statement (picasso, creates, guernica) should not be in the repository", (int)0, (int)this.countQueryResults("select 1 from {ex:picasso} ex:creates {ex:guernica}"));
        RDFStoreTest.assertEquals((String)"Repository should contain 2 statements matching (picasso, _, _)", (int)2, (int)this.countQueryResults("select * from {ex:picasso} P {O}"));
        RDFStoreTest.assertEquals((String)"Repository should contain 1 statement matching (picasso, paints, _)", (int)1, (int)this.countQueryResults("select * from {ex:picasso} ex:paints {O}"));
        RDFStoreTest.assertEquals((String)"Repository should contain 4 statements matching (_, type, _)", (int)4, (int)this.countQueryResults("select * from {S} rdf:type {O}"));
        RDFStoreTest.assertEquals((String)"Repository should contain 2 statements matching (_, _, Class)", (int)2, (int)this.countQueryResults("select * from {S} P {rdfs:Class}"));
        RDFStoreTest.assertEquals((String)"Repository should contain 0 statements matching (_, _, type)", (int)0, (int)this.countQueryResults("select * from {S} P {rdf:type}"));
    }

    @Test
    public void testAddWhileQuerying() throws Exception {
        BindingSet bindings;
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[0]);
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.commit();
        ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SERQL, (String)"SELECT C FROM {} rdf:type {C}", null);
        CloseableIteration iter = this.con.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false);
        this.con.begin();
        while (iter.hasNext()) {
            bindings = (BindingSet)iter.next();
            Value c = bindings.getValue("C");
            if (!(c instanceof Resource)) continue;
            this.con.addStatement((Resource)c, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        }
        this.con.commit();
        RDFStoreTest.assertEquals((int)3, (int)this.countElements((Iteration<?, ?>)this.con.getStatements(null, RDF.TYPE, (Value)RDFS.CLASS, false, new Resource[0])));
        tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SERQL, (String)"SELECT P FROM {} P {}", null);
        iter = this.con.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false);
        while (iter.hasNext()) {
            bindings = (BindingSet)iter.next();
            Value p = bindings.getValue("P");
            if (!(p instanceof URI)) continue;
            this.con.begin();
            this.con.addStatement((Resource)((URI)p), RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
            this.con.commit();
        }
        RDFStoreTest.assertEquals((int)2, (int)this.countElements((Iteration<?, ?>)this.con.getStatements(null, RDF.TYPE, (Value)RDF.PROPERTY, false, new Resource[0])));
    }

    @Test
    public void testRemoveAndClear() throws Exception {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        this.con.begin();
        this.con.removeStatements((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.commit();
        RDFStoreTest.assertEquals((String)"Repository should contain 4 statements in total", (int)4, (int)this.countAllElements());
        RDFStoreTest.assertEquals((String)"Named context should contain 3 statements", (int)3, (int)this.countContext1Elements());
        RDFStoreTest.assertEquals((String)"Statement (Painting, type, Class) should no longer be in the repository", (int)0, (int)this.countQueryResults("select 1 from {ex:Painting} rdf:type {rdfs:Class}"));
        this.con.begin();
        this.con.removeStatements(null, null, null, new Resource[]{this.context1});
        this.con.commit();
        RDFStoreTest.assertEquals((String)"Repository should contain 1 statement in total", (int)1, (int)this.countAllElements());
        RDFStoreTest.assertEquals((String)"Named context should be empty", (int)0, (int)this.countContext1Elements());
        this.con.begin();
        this.con.clear(new Resource[0]);
        this.con.commit();
        RDFStoreTest.assertEquals((String)"Repository should no longer contain any statements", (int)0, (int)this.countAllElements());
    }

    @Test
    public void testClose() {
        try {
            this.con.close();
            this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            RDFStoreTest.fail((String)"Operation on connection after close should result in IllegalStateException");
        }
        catch (IllegalStateException e) {
        }
        catch (SailException e) {
            RDFStoreTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testContexts() throws Exception {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.rembrandt, RDF.TYPE, (Value)this.painter, new Resource[]{this.context2});
        this.con.addStatement((Resource)this.nightwatch, RDF.TYPE, (Value)this.painting, new Resource[]{this.context2});
        this.con.addStatement((Resource)this.rembrandt, this.paints, (Value)this.nightwatch, new Resource[]{this.context2});
        this.con.commit();
        RDFStoreTest.assertEquals((String)"context1 should contain 3 statements", (int)3, (int)this.countContext1Elements());
        RDFStoreTest.assertEquals((String)"context2 should contain 3 statements", (int)3, (int)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{this.context2})));
        RDFStoreTest.assertEquals((String)"Repository should contain 8 statements", (int)8, (int)this.countAllElements());
        RDFStoreTest.assertEquals((String)"statements without context should equal 2", (int)2, (int)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{null})));
        RDFStoreTest.assertEquals((String)"Statements without context and statements in context 1 together should total 5", (int)5, (int)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{null, this.context1})));
        RDFStoreTest.assertEquals((String)"Statements without context and statements in context 2 together should total 5", (int)5, (int)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{null, this.context2})));
        RDFStoreTest.assertEquals((String)"Statements in context 1 and in context 2 together should total 6", (int)6, (int)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2})));
        this.con.begin();
        this.con.removeStatements((Resource)this.picasso, null, null, new Resource[]{this.context1});
        this.con.commit();
        RDFStoreTest.assertEquals((String)"context1 should contain 1 statements", (int)1, (int)this.countContext1Elements());
        RDFStoreTest.assertEquals((String)"Repository should contain 6 statements", (int)6, (int)this.countAllElements());
        RDFStoreTest.assertEquals((String)"Statements without context and statements in context 1 together should total 3", (int)3, (int)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{null, this.context1})));
        RDFStoreTest.assertEquals((String)"Statements without context and statements in context 2 together should total 5", (int)5, (int)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{this.context2, null})));
        RDFStoreTest.assertEquals((String)"Statements in context 1 and in context 2 together should total 4", (int)4, (int)this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2})));
    }

    @Test
    public void testQueryBindings() throws Exception {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SERQL, (String)"select X from {X} rdf:type {Y} rdf:type {rdfs:Class}", null);
        TupleExpr tupleExpr = tupleQuery.getTupleExpr();
        MapBindingSet bindings = new MapBindingSet(2);
        CloseableIteration iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        int resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet, QueryEvaluationException>)iter, 1);
        RDFStoreTest.assertEquals((String)"Wrong number of query results", (int)2, (int)resultCount);
        bindings.addBinding("Y", (Value)this.painter);
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet, QueryEvaluationException>)iter, 1);
        RDFStoreTest.assertEquals((String)"Wrong number of query results", (int)1, (int)resultCount);
        bindings.addBinding("Z", (Value)this.painting);
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet, QueryEvaluationException>)iter, 1);
        RDFStoreTest.assertEquals((String)"Wrong number of query results", (int)1, (int)resultCount);
        bindings.removeBinding("Y");
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet, QueryEvaluationException>)iter, 1);
        RDFStoreTest.assertEquals((String)"Wrong number of query results", (int)2, (int)resultCount);
        tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SERQL, (String)"select X from {X} rdf:type {Y} rdf:type {rdfs:Class} where Y = Z", null);
        tupleExpr = tupleQuery.getTupleExpr();
        bindings.clear();
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet, QueryEvaluationException>)iter, 1);
        RDFStoreTest.assertEquals((String)"Wrong number of query results", (int)0, (int)resultCount);
        bindings.addBinding("Z", (Value)this.painter);
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet, QueryEvaluationException>)iter, 1);
        RDFStoreTest.assertEquals((String)"Wrong number of query results", (int)1, (int)resultCount);
    }

    private void __testMultiThreadedAccess() {
        Runnable runnable = new Runnable(){
            SailConnection sharedCon;
            {
                this.sharedCon = RDFStoreTest.this.con;
            }

            @Override
            public void run() {
                TestCase.assertTrue((this.sharedCon != null ? 1 : 0) != 0);
                try {
                    while (this.sharedCon.isActive()) {
                        Thread.sleep(10L);
                    }
                    this.sharedCon.begin();
                    this.sharedCon.addStatement((Resource)RDFStoreTest.this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
                    this.sharedCon.commit();
                    Thread.sleep(500L);
                    CloseableIteration result = this.sharedCon.getStatements(null, null, null, true, new Resource[0]);
                    TestCase.assertTrue((boolean)result.hasNext());
                    int numberOfStatements = 0;
                    while (result.hasNext()) {
                        ++numberOfStatements;
                        Statement st = (Statement)result.next();
                        TestCase.assertTrue((st.getSubject().equals(RDFStoreTest.this.painter) || st.getSubject().equals(RDFStoreTest.this.picasso) ? 1 : 0) != 0);
                        TestCase.assertTrue((boolean)st.getPredicate().equals((Object)RDF.TYPE));
                        TestCase.assertTrue((st.getObject().equals(RDFS.CLASS) || st.getObject().equals(RDFStoreTest.this.painter) ? 1 : 0) != 0);
                    }
                    TestCase.assertTrue((String)"we should have retrieved statements from both threads", (numberOfStatements == 2 ? 1 : 0) != 0);
                }
                catch (SailException e) {
                    e.printStackTrace();
                    TestCase.fail((String)e.getMessage());
                }
                catch (InterruptedException e) {
                    TestCase.fail((String)e.getMessage());
                }
                try {
                    Thread.sleep(1000L);
                    this.sharedCon.getStatements(null, null, null, true, new Resource[0]);
                    TestCase.fail((String)"should have caused an IllegalStateException");
                }
                catch (InterruptedException e) {
                    TestCase.fail((String)e.getMessage());
                }
                catch (SailException e) {
                    e.printStackTrace();
                    TestCase.fail((String)e.getMessage());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        };
        Thread newThread = new Thread(runnable, "B (parallel)");
        newThread.start();
        try {
            while (this.con.isActive()) {
                Thread.sleep(10L);
            }
            this.con.begin();
            this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[0]);
            this.con.commit();
            Thread.sleep(1000L);
            this.con.close();
        }
        catch (SailException e) {
            e.printStackTrace();
            RDFStoreTest.fail((String)e.getMessage());
        }
        catch (InterruptedException e) {
            RDFStoreTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStatementEquals() throws Exception {
        Statement st = this.vf.createStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter);
        RDFStoreTest.assertEquals((Object)st, (Object)this.vf.createStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, (Resource)this.context1));
        RDFStoreTest.assertEquals((Object)st, (Object)this.vf.createStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, (Resource)this.context2));
    }

    @Test
    public void testStatementSerialization() throws Exception {
        Statement st = this.vf.createStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(st);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        Statement deserializedStatement = (Statement)in.readObject();
        in.close();
        RDFStoreTest.assertTrue((boolean)st.equals((Object)deserializedStatement));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetNamespaces() throws Exception {
        this.con.begin();
        this.con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.con.commit();
        try (CloseableIteration namespaces = this.con.getNamespaces();){
            RDFStoreTest.assertTrue((boolean)namespaces.hasNext());
            Namespace rdf = (Namespace)namespaces.next();
            RDFStoreTest.assertEquals((String)"rdf", (String)rdf.getPrefix());
            RDFStoreTest.assertEquals((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (String)rdf.getName());
            RDFStoreTest.assertTrue((!namespaces.hasNext() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetNamespace() throws Exception {
        this.con.begin();
        this.con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.con.commit();
        RDFStoreTest.assertEquals((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (String)this.con.getNamespace("rdf"));
    }

    @Test
    public void testClearNamespaces() throws Exception {
        this.con.begin();
        this.con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.con.setNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.con.clearNamespaces();
        this.con.commit();
        RDFStoreTest.assertTrue((!this.con.getNamespaces().hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveNamespaces() throws Exception {
        this.con.begin();
        this.con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.con.removeNamespace("rdf");
        this.con.commit();
        RDFStoreTest.assertNull((Object)this.con.getNamespace("rdf"));
    }

    @Test
    public void testNullNamespaceDisallowed() throws Exception {
        try {
            this.con.setNamespace("foo", null);
            RDFStoreTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testNullPrefixDisallowed() throws Exception {
        try {
            this.con.setNamespace(null, "foo");
            RDFStoreTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.con.getNamespace(null);
            RDFStoreTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.con.removeNamespace(null);
            RDFStoreTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetContextIDs() throws Exception {
        RDFStoreTest.assertEquals((int)0, (int)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        this.con.begin();
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        RDFStoreTest.assertEquals((int)1, (int)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        RDFStoreTest.assertEquals((Object)this.context1, this.first((Iteration)this.con.getContextIDs()));
        this.con.removeStatements((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        RDFStoreTest.assertEquals((int)0, (int)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        this.con.commit();
        RDFStoreTest.assertEquals((int)0, (int)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        this.con.begin();
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context2});
        RDFStoreTest.assertEquals((int)1, (int)this.countElements((Iteration<?, ?>)this.con.getContextIDs()));
        RDFStoreTest.assertEquals((Object)this.context2, this.first((Iteration)this.con.getContextIDs()));
        this.con.commit();
    }

    @Test
    public void testOldURI() throws Exception {
        RDFStoreTest.assertEquals((int)0, (int)this.countAllElements());
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        RDFStoreTest.assertEquals((int)5, (int)this.countAllElements());
        this.con.commit();
        this.con.begin();
        this.con.clear(new Resource[0]);
        this.con.commit();
        this.con.begin();
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        RDFStoreTest.assertEquals((int)1, (int)this.countAllElements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDualConnections() throws Exception {
        try (SailConnection con2 = this.sail.getConnection();){
            RDFStoreTest.assertEquals((int)0, (int)this.countAllElements());
            this.con.begin();
            this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
            this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
            this.con.commit();
            RDFStoreTest.assertEquals((int)4, (int)this.countAllElements());
            con2.begin();
            con2.addStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            String query = "SELECT S, P, O FROM {S} P {O}";
            ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SERQL, (String)query, null);
            RDFStoreTest.assertEquals((int)5, (int)this.countElements((Iteration<?, ?>)con2.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false)));
            Runnable clearer = new Runnable(){

                @Override
                public void run() {
                    try {
                        RDFStoreTest.this.con.begin();
                        RDFStoreTest.this.con.clear(new Resource[0]);
                        RDFStoreTest.this.con.commit();
                    }
                    catch (SailException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            Thread thread = new Thread(clearer);
            thread.start();
            Thread.yield();
            Thread.yield();
            con2.commit();
            thread.join();
        }
    }

    @Test
    public void testBNodeReuse() throws Exception {
        this.con.begin();
        this.con.addStatement((Resource)RDF.VALUE, RDF.VALUE, (Value)RDF.VALUE, new Resource[0]);
        RDFStoreTest.assertEquals((long)1L, (long)this.con.size(new Resource[0]));
        BNode b1 = this.vf.createBNode();
        this.con.addStatement((Resource)b1, RDF.VALUE, (Value)b1, new Resource[0]);
        this.con.removeStatements((Resource)b1, RDF.VALUE, (Value)b1, new Resource[0]);
        RDFStoreTest.assertEquals((long)1L, (long)this.con.size(new Resource[0]));
        BNode b2 = this.vf.createBNode();
        this.con.addStatement((Resource)b2, RDF.VALUE, (Value)b2, new Resource[0]);
        this.con.addStatement((Resource)b1, RDF.VALUE, (Value)b1, new Resource[0]);
        RDFStoreTest.assertEquals((long)3L, (long)this.con.size(new Resource[0]));
        this.con.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T first(Iteration<T, ?> iter) throws Exception {
        try {
            if (iter.hasNext()) {
                Object object = iter.next();
                return (T)object;
            }
        }
        finally {
            Iterations.closeCloseable(iter);
        }
        return null;
    }

    protected int countContext1Elements() throws Exception, SailException {
        return this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[]{this.context1}));
    }

    protected int countAllElements() throws Exception, SailException {
        return this.countElements((Iteration<?, ?>)this.con.getStatements(null, null, null, false, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countElements(Iteration<?, ?> iter) throws Exception {
        int count = 0;
        try {
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
        }
        finally {
            Iterations.closeCloseable(iter);
        }
        return count;
    }

    protected int countQueryResults(String query) throws Exception {
        ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SERQL, (String)(query + " using namespace ex = <" + EXAMPLE_NS + ">"), null);
        return this.countElements((Iteration<?, ?>)this.con.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false));
    }

    protected int verifyQueryResult(CloseableIteration<? extends BindingSet, QueryEvaluationException> resultIter, int expectedBindingCount) throws QueryEvaluationException {
        int resultCount = 0;
        while (resultIter.hasNext()) {
            BindingSet resultBindings = (BindingSet)resultIter.next();
            ++resultCount;
            RDFStoreTest.assertEquals((String)"Wrong number of binding names for binding set", (int)expectedBindingCount, (int)resultBindings.getBindingNames().size());
            int bindingCount = 0;
            Iterator bindingIter = resultBindings.iterator();
            while (bindingIter.hasNext()) {
                bindingIter.next();
                ++bindingCount;
            }
            RDFStoreTest.assertEquals((String)"Wrong number of bindings in binding set", (int)expectedBindingCount, (int)bindingCount);
        }
        return resultCount;
    }
}

