/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer;

import cern.colt.PersistentObject;
import cern.colt.buffer.IntBuffer2DConsumer;
import cern.colt.list.IntArrayList;

public class IntBuffer2D
extends PersistentObject
implements IntBuffer2DConsumer {
    protected IntBuffer2DConsumer target;
    protected int[] xElements;
    protected int[] yElements;
    protected IntArrayList xList;
    protected IntArrayList yList;
    protected int capacity;
    protected int size;

    public IntBuffer2D(IntBuffer2DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new int[capacity];
        this.yElements = new int[capacity];
        this.xList = new IntArrayList(this.xElements);
        this.yList = new IntArrayList(this.yElements);
        this.size = 0;
    }

    public void add(int x, int y) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size++] = y;
    }

    @Override
    public void addAllOf(IntArrayList x, IntArrayList y) {
        int listSize = x.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(x, y);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

