/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.CharProcedure;
import cern.colt.list.AbstractCharList;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.Date;

public class CharArrayList
extends AbstractCharList {
    protected char[] elements;

    public CharArrayList() {
        this(10);
    }

    public CharArrayList(char[] elements) {
        this.elements(elements);
    }

    public CharArrayList(int initialCapacity) {
        this(new char[initialCapacity]);
        this.setSizeRaw(0);
    }

    @Override
    public void add(char element) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = element;
    }

    @Override
    public void beforeInsert(int index, char element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = element;
        ++this.size;
    }

    @Override
    public int binarySearchFromTo(char key, int from, int to) {
        return Sorting.binarySearchFromTo(this.elements, key, from, to);
    }

    @Override
    public Object clone() {
        CharArrayList clone = new CharArrayList((char[])this.elements.clone());
        clone.setSizeRaw(this.size);
        return clone;
    }

    public CharArrayList copy() {
        return (CharArrayList)this.clone();
    }

    protected void countSortFromTo(int from, int to, char min, char max) {
        if (this.size == 0) {
            return;
        }
        CharArrayList.checkRangeFromTo(from, to, this.size);
        int width = max - min + 1;
        int[] counts = new int[width];
        char[] theElements = this.elements;
        int i = from;
        while (i <= to) {
            int n = theElements[i++] - min;
            counts[n] = counts[n] + 1;
        }
        int fromIndex = from;
        char val = min;
        int i2 = 0;
        while (i2 < width) {
            int c = counts[i2];
            if (c > 0) {
                if (c == 1) {
                    theElements[fromIndex++] = val;
                } else {
                    int toIndex = fromIndex + c - 1;
                    this.fillFromToWith(fromIndex, toIndex, val);
                    fromIndex = toIndex + 1;
                }
            }
            ++i2;
            val = (char)(val + '\u0001');
        }
    }

    @Override
    public char[] elements() {
        return this.elements;
    }

    @Override
    public AbstractCharList elements(char[] elements) {
        this.elements = elements;
        this.size = elements.length;
        return this;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements = Arrays.ensureCapacity(this.elements, minCapacity);
    }

    @Override
    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof CharArrayList)) {
            return super.equals(otherObj);
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        CharArrayList other = (CharArrayList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        char[] theElements = this.elements();
        char[] otherElements = other.elements();
        int i = this.size();
        while (--i >= 0) {
            if (theElements[i] == otherElements[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEach(CharProcedure procedure) {
        char[] theElements = this.elements;
        int theSize = this.size;
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public char get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    @Override
    public char getQuick(int index) {
        return this.elements[index];
    }

    @Override
    public int indexOfFromTo(char element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        CharArrayList.checkRangeFromTo(from, to, this.size);
        char[] theElements = this.elements;
        for (int i = from; i <= to; ++i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfFromTo(char element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        CharArrayList.checkRangeFromTo(from, to, this.size);
        char[] theElements = this.elements;
        for (int i = to; i >= from; --i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public AbstractCharList partFromTo(int from, int to) {
        if (this.size == 0) {
            return new CharArrayList(0);
        }
        CharArrayList.checkRangeFromTo(from, to, this.size);
        char[] part = new char[to - from + 1];
        System.arraycopy(this.elements, from, part, 0, to - from + 1);
        return new CharArrayList(part);
    }

    @Override
    public boolean removeAll(AbstractCharList other) {
        double M;
        if (!(other instanceof CharArrayList)) {
            return super.removeAll(other);
        }
        if (other.size() == 0) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        char[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * Arithmetic.log2(N) < M * N) {
            CharArrayList sortedList = (CharArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    @Override
    public void replaceFromToWithFrom(int from, int to, AbstractCharList other, int otherFrom) {
        if (!(other instanceof CharArrayList)) {
            super.replaceFromToWithFrom(from, to, other, otherFrom);
            return;
        }
        int length = to - from + 1;
        if (length > 0) {
            CharArrayList.checkRangeFromTo(from, to, this.size());
            CharArrayList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            System.arraycopy(((CharArrayList)other).elements, otherFrom, this.elements, from, length);
        }
    }

    @Override
    public boolean retainAll(AbstractCharList other) {
        double M;
        if (!(other instanceof CharArrayList)) {
            return super.retainAll(other);
        }
        int limit = other.size() - 1;
        int j = 0;
        char[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * Arithmetic.log2(N) < M * N) {
            CharArrayList sortedList = (CharArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    @Override
    public void reverse() {
        int limit = this.size / 2;
        int j = this.size - 1;
        char[] theElements = this.elements;
        int i = 0;
        while (i < limit) {
            char tmp = theElements[i];
            theElements[i++] = theElements[j];
            theElements[j--] = tmp;
        }
    }

    @Override
    public void set(int index, char element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.elements[index] = element;
    }

    @Override
    public void setQuick(int index, char element) {
        this.elements[index] = element;
    }

    @Override
    public void shuffleFromTo(int from, int to) {
        if (this.size == 0) {
            return;
        }
        CharArrayList.checkRangeFromTo(from, to, this.size);
        Uniform gen = new Uniform(new DRand(new Date()));
        char[] theElements = this.elements;
        for (int i = from; i < to; ++i) {
            int random = gen.nextIntFromTo(i, to);
            char tmpElement = theElements[random];
            theElements[random] = theElements[i];
            theElements[i] = tmpElement;
        }
    }

    @Override
    public void sortFromTo(int from, int to) {
        int widthThreshold = 10000;
        if (this.size == 0) {
            return;
        }
        CharArrayList.checkRangeFromTo(from, to, this.size);
        char min = this.elements[from];
        char max = this.elements[from];
        char[] theElements = this.elements;
        int i = from + 1;
        while (i <= to) {
            char elem;
            if ((elem = theElements[i++]) > max) {
                max = elem;
                continue;
            }
            if (elem >= min) continue;
            min = elem;
        }
        double N = (double)to - (double)from + 1.0;
        double quickSortEstimate = N * Math.log(N) / 0.6931471805599453;
        double width = (double)max - (double)min + 1.0;
        double countSortEstimate = Math.max(width, N);
        if (width < 10000.0 && countSortEstimate < quickSortEstimate) {
            this.countSortFromTo(from, to, min, max);
        } else {
            this.quickSortFromTo(from, to);
        }
    }

    @Override
    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

