/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.function.Double9Function;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.function.DoubleProcedure;
import cern.colt.function.IntIntDoubleFunction;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix1DProcedure;
import cern.colt.matrix.doublealgo.Formatter;
import cern.colt.matrix.doublealgo.Sorting;
import cern.colt.matrix.impl.AbstractMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;

public abstract class DoubleMatrix2D
extends AbstractMatrix2D {
    protected DoubleMatrix2D() {
    }

    public double aggregate(DoubleDoubleFunction aggr, DoubleFunction f) {
        if (this.size() == 0) {
            return Double.NaN;
        }
        double a = f.apply(this.getQuick(this.rows - 1, this.columns - 1));
        int d = 1;
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns - d;
            while (--column >= 0) {
                a = aggr.apply(a, f.apply(this.getQuick(row, column)));
            }
            d = 0;
        }
        return a;
    }

    public double aggregate(DoubleMatrix2D other, DoubleDoubleFunction aggr, DoubleDoubleFunction f) {
        this.checkShape(other);
        if (this.size() == 0) {
            return Double.NaN;
        }
        double a = f.apply(this.getQuick(this.rows - 1, this.columns - 1), other.getQuick(this.rows - 1, this.columns - 1));
        int d = 1;
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns - d;
            while (--column >= 0) {
                a = aggr.apply(a, f.apply(this.getQuick(row, column), other.getQuick(row, column)));
            }
            d = 0;
        }
        return a;
    }

    public DoubleMatrix2D assign(double[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int row = this.rows;
        while (--row >= 0) {
            double[] currentRow = values[row];
            if (currentRow.length != this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
            }
            int column = this.columns;
            while (--column >= 0) {
                this.setQuick(row, column, currentRow[column]);
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(double value) {
        int r = this.rows;
        int c = this.columns;
        for (int row = 0; row < r; ++row) {
            for (int column = 0; column < c; ++column) {
                this.setQuick(row, column, value);
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleFunction function) {
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns;
            while (--column >= 0) {
                this.setQuick(row, column, function.apply(this.getQuick(row, column)));
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.haveSharedCells(other)) {
            other = other.copy();
        }
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns;
            while (--column >= 0) {
                this.setQuick(row, column, other.getQuick(row, column));
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D y, DoubleDoubleFunction function) {
        this.checkShape(y);
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns;
            while (--column >= 0) {
                this.setQuick(row, column, function.apply(this.getQuick(row, column), y.getQuick(row, column)));
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns;
            while (--column >= 0) {
                if (this.getQuick(row, column) == 0.0) continue;
                ++cardinality;
            }
        }
        return cardinality;
    }

    public DoubleMatrix2D copy() {
        return this.like().assign(this);
    }

    public boolean equals(double value) {
        return Property.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleMatrix2D)) {
            return false;
        }
        return Property.DEFAULT.equals(this, (DoubleMatrix2D)obj);
    }

    public DoubleMatrix2D forEachNonZero(IntIntDoubleFunction function) {
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns;
            while (--column >= 0) {
                double r;
                double value = this.getQuick(row, column);
                if (value == 0.0 || (r = function.apply(row, column, value)) == value) continue;
                this.setQuick(row, column, r);
            }
        }
        return this;
    }

    public double get(int row, int column) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        return this.getQuick(row, column);
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int r = this.rows;
        int c = this.columns;
        for (int row = 0; row < r; ++row) {
            for (int column = 0; column < c; ++column) {
                double value = this.getQuick(row, column);
                if (value == 0.0) continue;
                rowList.add(row);
                columnList.add(column);
                valueList.add(value);
            }
        }
    }

    public abstract double getQuick(int var1, int var2);

    protected boolean haveSharedCells(DoubleMatrix2D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix2D other) {
        return false;
    }

    public DoubleMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract DoubleMatrix2D like(int var1, int var2);

    public abstract DoubleMatrix1D like1D(int var1);

    protected abstract DoubleMatrix1D like1D(int var1, int var2, int var3);

    public void set(int row, int column, double value) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        this.setQuick(row, column, value);
    }

    public abstract void setQuick(int var1, int var2, double var3);

    public double[][] toArray() {
        double[][] values = new double[this.rows][this.columns];
        int row = this.rows;
        while (--row >= 0) {
            double[] currentRow = values[row];
            int column = this.columns;
            while (--column >= 0) {
                currentRow[column] = this.getQuick(row, column);
            }
        }
        return values;
    }

    public String toString() {
        return new Formatter().toString(this);
    }

    protected DoubleMatrix2D view() {
        return (DoubleMatrix2D)this.clone();
    }

    public DoubleMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = this.index(0, column);
        int viewStride = this.rowStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public DoubleMatrix2D viewColumnFlip() {
        return (DoubleMatrix2D)this.view().vColumnFlip();
    }

    public DoubleMatrix2D viewDice() {
        return (DoubleMatrix2D)this.view().vDice();
    }

    public DoubleMatrix2D viewPart(int row, int column, int height, int width) {
        return (DoubleMatrix2D)this.view().vPart(row, column, height, width);
    }

    public DoubleMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = this.index(row, 0);
        int viewStride = this.columnStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public DoubleMatrix2D viewRowFlip() {
        return (DoubleMatrix2D)this.view().vRowFlip();
    }

    public DoubleMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i2 = rowIndexes.length;
        while (--i2 >= 0) {
            rowOffsets[i2] = this._rowOffset(this._rowRank(rowIndexes[i2]));
        }
        i2 = columnIndexes.length;
        while (--i2 >= 0) {
            columnOffsets[i2] = this._columnOffset(this._columnRank(columnIndexes[i2]));
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    public DoubleMatrix2D viewSelection(DoubleMatrix1DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.rows; ++i) {
            if (!condition.apply(this.viewRow(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null);
    }

    protected abstract DoubleMatrix2D viewSelectionLike(int[] var1, int[] var2);

    public DoubleMatrix2D viewSorted(int column) {
        return Sorting.mergeSort.sort(this, column);
    }

    public DoubleMatrix2D viewStrides(int rowStride, int columnStride) {
        return (DoubleMatrix2D)this.view().vStrides(rowStride, columnStride);
    }

    private boolean xforEach(DoubleProcedure procedure) {
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns;
            while (--column >= 0) {
                if (procedure.apply(this.getQuick(row, column))) continue;
                return false;
            }
        }
        return true;
    }

    public void zAssign8Neighbors(DoubleMatrix2D B, Double9Function function) {
        if (function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(B);
        if (this.rows < 3 || this.columns < 3) {
            return;
        }
        int r = this.rows - 1;
        int c = this.columns - 1;
        for (int i = 1; i < r; ++i) {
            double a00 = this.getQuick(i - 1, 0);
            double a01 = this.getQuick(i - 1, 1);
            double a10 = this.getQuick(i, 0);
            double a11 = this.getQuick(i, 1);
            double a20 = this.getQuick(i + 1, 0);
            double a21 = this.getQuick(i + 1, 1);
            for (int j = 1; j < c; ++j) {
                double a02 = this.getQuick(i - 1, j + 1);
                double a12 = this.getQuick(i, j + 1);
                double a22 = this.getQuick(i + 1, j + 1);
                B.setQuick(i, j, function.apply(a00, a01, a02, a10, a11, a12, a20, a21, a22));
                a00 = a01;
                a10 = a11;
                a20 = a21;
                a01 = a02;
                a11 = a12;
                a21 = a22;
            }
        }
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z) {
        return this.zMult(y, z, 1.0, z == null ? 1 : 0, false);
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z, double alpha, double beta, boolean transposeA) {
        if (transposeA) {
            return this.viewDice().zMult(y, z, alpha, beta, false);
        }
        if (z == null) {
            z = new DenseDoubleMatrix1D(this.rows);
        }
        if (this.columns != y.size() || this.rows > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        int i = this.rows;
        while (--i >= 0) {
            double s = 0.0;
            int j = this.columns;
            while (--j >= 0) {
                s += this.getQuick(i, j) * y.getQuick(j);
            }
            z.setQuick(i, alpha * s + beta * z.getQuick(i));
        }
        return z;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C) {
        return this.zMult(B, C, 1.0, C == null ? 1 : 0, false, false);
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C, double alpha, double beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        int m = this.rows;
        int n = this.columns;
        int p = B.columns;
        if (C == null) {
            C = new DenseDoubleMatrix2D(m, p);
        }
        if (B.rows != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows != m || C.columns != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int j = p;
        while (--j >= 0) {
            int i = m;
            while (--i >= 0) {
                double s = 0.0;
                int k = n;
                while (--k >= 0) {
                    s += this.getQuick(i, k) * B.getQuick(k, j);
                }
                C.setQuick(i, j, alpha * s + beta * C.getQuick(i, j));
            }
        }
        return C;
    }

    public double zSum() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.aggregate(Functions.plus, Functions.identity);
    }
}

