/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.bench;

import cern.colt.matrix.bench.TimerProcedure;
import cern.colt.matrix.impl.DenseObjectMatrix2D;
import cern.colt.matrix.objectalgo.Formatter;

class BenchmarkKernel {
    protected BenchmarkKernel() {
    }

    public static float run(double minSeconds, TimerProcedure procedure) {
        long iter = 0L;
        long minMillis = (long)(minSeconds * 1000.0);
        long begin = System.currentTimeMillis();
        long limit = begin + minMillis;
        while (System.currentTimeMillis() < limit) {
            procedure.init();
            procedure.apply(null);
            ++iter;
        }
        long end = System.currentTimeMillis();
        if (minSeconds / (double)iter < 0.1) {
            begin = System.currentTimeMillis();
            long i = iter;
            while (--i >= 0L) {
                procedure.init();
                procedure.apply(null);
            }
            end = System.currentTimeMillis();
        }
        long begin2 = System.currentTimeMillis();
        int dummy = 1;
        long i = iter;
        while (--i >= 0L) {
            dummy = (int)((long)dummy * i);
            procedure.init();
        }
        long end2 = System.currentTimeMillis();
        long elapsed = end - begin - (end2 - begin2);
        return (float)elapsed / 1000.0f / (float)iter;
    }

    public static String systemInfo() {
        Object[] properties = new String[]{"java.vm.vendor", "java.vm.version", "java.vm.name", "os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vendor.url"};
        DenseObjectMatrix2D matrix = new DenseObjectMatrix2D(properties.length, 2);
        matrix.viewColumn(0).assign(properties);
        for (int i = 0; i < properties.length; ++i) {
            String value = System.getProperty((String)properties[i]);
            if (value == null) {
                value = "?";
            }
            matrix.set(i, 1, value);
        }
        Formatter formatter = new Formatter();
        formatter.setPrintShape(false);
        return formatter.toString(matrix);
    }
}

