/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.doublealgo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.Timer;
import cern.colt.function.DoubleComparator;
import cern.colt.function.IntComparator;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleFactory3D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.doublealgo.DoubleMatrix1DComparator;
import cern.colt.matrix.doublealgo.DoubleMatrix2DComparator;
import cern.colt.matrix.doublealgo.Formatter;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.jet.math.Functions;
import cern.jet.random.engine.DRand;

public class Sorting
extends PersistentObject {
    public static final Sorting quickSort = new Sorting();
    public static final Sorting mergeSort = new Sorting(){

        @Override
        protected void runSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
            cern.colt.Sorting.mergeSort(a, fromIndex, toIndex, c);
        }

        @Override
        protected void runSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
            GenericSorting.mergeSort(fromIndex, toIndex, c, swapper);
        }
    };

    protected Sorting() {
    }

    private static final int compareNaN(double a, double b) {
        if (a != a) {
            if (b != b) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    protected void runSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
        cern.colt.Sorting.quickSort(a, fromIndex, toIndex, c);
    }

    protected void runSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
        GenericSorting.quickSort(fromIndex, toIndex, c, swapper);
    }

    public DoubleMatrix1D sort(final DoubleMatrix1D vector) {
        int[] indexes = new int[vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                double av = vector.getQuick(a);
                double bv = vector.getQuick(b);
                if (av != av || bv != bv) {
                    return Sorting.compareNaN(av, bv);
                }
                return av < bv ? -1 : (av == bv ? 0 : 1);
            }
        };
        this.runSort(indexes, 0, indexes.length, comp);
        return vector.viewSelection(indexes);
    }

    public DoubleMatrix1D sort(final DoubleMatrix1D vector, final DoubleComparator c) {
        int[] indexes = new int[vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return c.compare(vector.getQuick(a), vector.getQuick(b));
            }
        };
        this.runSort(indexes, 0, indexes.length, comp);
        return vector.viewSelection(indexes);
    }

    public DoubleMatrix2D sort(DoubleMatrix2D matrix, final double[] aggregates) {
        int rows = matrix.rows();
        if (aggregates.length != rows) {
            throw new IndexOutOfBoundsException("aggregates.length != matrix.rows()");
        }
        final int[] indexes = new int[rows];
        int i = rows;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int x, int y) {
                double a = aggregates[x];
                double b = aggregates[y];
                if (a != a || b != b) {
                    return Sorting.compareNaN(a, b);
                }
                return a < b ? -1 : (a == b ? 0 : 1);
            }
        };
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int x, int y) {
                int t1 = indexes[x];
                indexes[x] = indexes[y];
                indexes[y] = t1;
                double t2 = aggregates[x];
                aggregates[x] = aggregates[y];
                aggregates[y] = t2;
            }
        };
        this.runSort(0, rows, comp, swapper);
        return matrix.viewSelection(indexes, null);
    }

    public DoubleMatrix2D sort(DoubleMatrix2D matrix, int column) {
        if (column < 0 || column >= matrix.columns()) {
            throw new IndexOutOfBoundsException("column=" + column + ", matrix=" + Formatter.shape(matrix));
        }
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        final DoubleMatrix1D col = matrix.viewColumn(column);
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                double av = col.getQuick(a);
                double bv = col.getQuick(b);
                if (av != av || bv != bv) {
                    return Sorting.compareNaN(av, bv);
                }
                return av < bv ? -1 : (av == bv ? 0 : 1);
            }
        };
        this.runSort(rowIndexes, 0, rowIndexes.length, comp);
        return matrix.viewSelection(rowIndexes, null);
    }

    public DoubleMatrix2D sort(DoubleMatrix2D matrix, final DoubleMatrix1DComparator c) {
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        final DoubleMatrix1D[] views = new DoubleMatrix1D[matrix.rows()];
        int i2 = views.length;
        while (--i2 >= 0) {
            views[i2] = matrix.viewRow(i2);
        }
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return c.compare(views[a], views[b]);
            }
        };
        this.runSort(rowIndexes, 0, rowIndexes.length, comp);
        return matrix.viewSelection(rowIndexes, null);
    }

    public DoubleMatrix3D sort(DoubleMatrix3D matrix, int row, int column) {
        if (row < 0 || row >= matrix.rows()) {
            throw new IndexOutOfBoundsException("row=" + row + ", matrix=" + Formatter.shape(matrix));
        }
        if (column < 0 || column >= matrix.columns()) {
            throw new IndexOutOfBoundsException("column=" + column + ", matrix=" + Formatter.shape(matrix));
        }
        int[] sliceIndexes = new int[matrix.slices()];
        int i = sliceIndexes.length;
        while (--i >= 0) {
            sliceIndexes[i] = i;
        }
        final DoubleMatrix1D sliceView = matrix.viewRow(row).viewColumn(column);
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                double av = sliceView.getQuick(a);
                double bv = sliceView.getQuick(b);
                if (av != av || bv != bv) {
                    return Sorting.compareNaN(av, bv);
                }
                return av < bv ? -1 : (av == bv ? 0 : 1);
            }
        };
        this.runSort(sliceIndexes, 0, sliceIndexes.length, comp);
        return matrix.viewSelection(sliceIndexes, null, null);
    }

    public DoubleMatrix3D sort(DoubleMatrix3D matrix, final DoubleMatrix2DComparator c) {
        int[] sliceIndexes = new int[matrix.slices()];
        int i = sliceIndexes.length;
        while (--i >= 0) {
            sliceIndexes[i] = i;
        }
        final DoubleMatrix2D[] views = new DoubleMatrix2D[matrix.slices()];
        int i2 = views.length;
        while (--i2 >= 0) {
            views[i2] = matrix.viewSlice(i2);
        }
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return c.compare(views[a], views[b]);
            }
        };
        this.runSort(sliceIndexes, 0, sliceIndexes.length, comp);
        return matrix.viewSelection(sliceIndexes, null, null);
    }

    public static void zdemo1() {
        Sorting sort = quickSort;
        DoubleMatrix2D matrix = DoubleFactory2D.dense.descending(4, 3);
        DoubleMatrix1DComparator comp = new DoubleMatrix1DComparator(){

            @Override
            public int compare(DoubleMatrix1D a, DoubleMatrix1D b) {
                double bs;
                double as = a.zSum();
                return as < (bs = b.zSum()) ? -1 : (as == bs ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + matrix);
        System.out.println("sorted  :" + sort.sort(matrix, comp));
    }

    public static void zdemo2() {
        Sorting sort = quickSort;
        DoubleMatrix3D matrix = DoubleFactory3D.dense.descending(4, 3, 2);
        DoubleMatrix2DComparator comp = new DoubleMatrix2DComparator(){

            @Override
            public int compare(DoubleMatrix2D a, DoubleMatrix2D b) {
                double bs;
                double as = a.zSum();
                return as < (bs = b.zSum()) ? -1 : (as == bs ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + matrix);
        System.out.println("sorted  :" + sort.sort(matrix, comp));
    }

    public static void zdemo3() {
        Sorting sort = quickSort;
        double[] values = new double[]{0.5, 1.5, 2.5, 3.5};
        DenseDoubleMatrix1D matrix = new DenseDoubleMatrix1D(values);
        DoubleComparator comp = new DoubleComparator(){

            @Override
            public int compare(double a, double b) {
                double bs;
                double as = Math.sin(a);
                return as < (bs = Math.sin(b)) ? -1 : (as == bs ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + matrix);
        DoubleMatrix1D sorted = sort.sort(matrix, comp);
        System.out.println("sorted  :" + sorted);
        sorted.assign(Functions.sin);
        System.out.println("sined  :" + sorted);
    }

    protected static void zdemo4() {
        double[] values1 = new double[]{0.0, 1.0, 2.0, 3.0};
        double[] values2 = new double[]{0.0, 2.0, 4.0, 6.0};
        DenseDoubleMatrix1D matrix1 = new DenseDoubleMatrix1D(values1);
        DenseDoubleMatrix1D matrix2 = new DenseDoubleMatrix1D(values2);
        System.out.println("m1:" + matrix1);
        System.out.println("m2:" + matrix2);
        ((DoubleMatrix1D)matrix1).assign(matrix2, Functions.pow);
        System.out.println("applied:" + matrix1);
    }

    public static void zdemo5(int rows, int columns, boolean print) {
        Sorting sort = quickSort;
        System.out.println("\n\n");
        System.out.print("now initializing... ");
        Timer timer = new Timer().start();
        Functions F = Functions.functions;
        DoubleMatrix2D A = DoubleFactory2D.dense.make(rows, columns);
        A.assign(new DRand());
        timer.stop().display();
        DoubleMatrix2D B = A.like();
        timer.reset().start();
        System.out.print("now copying... ");
        B.assign(A);
        timer.stop().display();
        timer.reset().start();
        System.out.print("now copying subrange... ");
        B.viewPart(0, 0, rows, columns).assign(A.viewPart(0, 0, rows, columns));
        timer.stop().display();
        timer.reset().start();
        System.out.print("now copying selected... ");
        B.viewSelection(null, null).assign(A.viewSelection(null, null));
        timer.stop().display();
        System.out.print("now sorting - quick version with precomputation... ");
        timer.reset().start();
        System.out.println("FIXME:  Should this test exist without hep.aida");
        timer.stop().display();
        if (print) {
            int r = Math.min(rows, 5);
            System.out.println("FIXME:  Should this test exist without hep.aida");
            String[] rowNames = new String[r];
            String[] columnNames = new String[columns];
            int i = columns;
            while (--i >= 0) {
                columnNames[i] = Integer.toString(i);
            }
            i = r;
            while (--i >= 0) {
                rowNames[i] = Integer.toString(i);
            }
            System.out.println("first part of sorted result = \n" + new Formatter("%G").toTitleString(A.viewPart(0, 0, r, columns), rowNames, columnNames, null, null, null));
        }
        System.out.print("now sorting - slow version... ");
        A = B;
        DoubleMatrix1DComparator fun = new DoubleMatrix1DComparator(){

            @Override
            public int compare(DoubleMatrix1D x, DoubleMatrix1D y) {
                System.out.println("FIXME:  Should this test exist without hep.aida");
                return 1;
            }
        };
        timer.reset().start();
        A = sort.sort(A, fun);
        timer.stop().display();
    }

    public static void zdemo6() {
        Sorting sort = quickSort;
        double[][] values = new double[][]{{3.0, 7.0, 0.0}, {2.0, 1.0, 0.0}, {2.0, 2.0, 0.0}, {1.0, 8.0, 0.0}, {2.0, 5.0, 0.0}, {7.0, 0.0, 0.0}, {2.0, 3.0, 0.0}, {1.0, 0.0, 0.0}, {4.0, 0.0, 0.0}, {2.0, 0.0, 0.0}};
        DoubleMatrix2D A = DoubleFactory2D.dense.make(values);
        System.out.println("\n\nunsorted:" + A);
        DoubleMatrix2D B = quickSort.sort(A, 1);
        DoubleMatrix2D C = quickSort.sort(B, 0);
        System.out.println("quick sorted  :" + C);
        B = mergeSort.sort(A, 1);
        C = mergeSort.sort(B, 0);
        System.out.println("merge sorted  :" + C);
    }

    public static void zdemo7(int rows, int columns, boolean print) {
        System.out.println("\n\n");
        System.out.println("now initializing... ");
        Functions F = Functions.functions;
        DoubleMatrix2D A = DoubleFactory2D.dense.make(rows, columns);
        A.assign(new DRand());
        DoubleMatrix2D B = A.copy();
        double[] v1 = A.viewColumn(0).toArray();
        double[] v2 = A.viewColumn(0).toArray();
        System.out.print("now quick sorting... ");
        Timer timer = new Timer().start();
        quickSort.sort(A, 0);
        timer.stop().display();
        System.out.print("now merge sorting... ");
        timer.reset().start();
        mergeSort.sort(A, 0);
        timer.stop().display();
        System.out.print("now quick sorting with simple aggregation... ");
        timer.reset().start();
        quickSort.sort(A, v1);
        timer.stop().display();
        System.out.print("now merge sorting with simple aggregation... ");
        timer.reset().start();
        mergeSort.sort(A, v2);
        timer.stop().display();
    }
}

