/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.WrapperDoubleMatrix1D;

class DelegateDoubleMatrix1D
extends WrapperDoubleMatrix1D {
    protected DoubleMatrix2D content;
    protected int row;

    public DelegateDoubleMatrix1D(DoubleMatrix2D newContent, int row) {
        super(null);
        if (row < 0 || row >= newContent.rows()) {
            throw new IllegalArgumentException();
        }
        this.setUp(newContent.columns());
        this.row = row;
        this.content = newContent;
    }

    @Override
    public double getQuick(int index) {
        return this.content.getQuick(this.row, index);
    }

    @Override
    public DoubleMatrix1D like(int size) {
        return this.content.like1D(size);
    }

    @Override
    public DoubleMatrix2D like2D(int rows, int columns) {
        return this.content.like(rows, columns);
    }

    @Override
    public void setQuick(int index, double value) {
        this.content.setQuick(this.row, index, value);
    }
}

