/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math;

import cern.colt.function.DoubleDoubleFunction;

public final class PlusMult
implements DoubleDoubleFunction {
    public double multiplicator;

    protected PlusMult(double multiplicator) {
        this.multiplicator = multiplicator;
    }

    @Override
    public final double apply(double a, double b) {
        return a + b * this.multiplicator;
    }

    public static PlusMult minusDiv(double constant) {
        return new PlusMult(-1.0 / constant);
    }

    public static PlusMult minusMult(double constant) {
        return new PlusMult(-constant);
    }

    public static PlusMult plusDiv(double constant) {
        return new PlusMult(1.0 / constant);
    }

    public static PlusMult plusMult(double constant) {
        return new PlusMult(constant);
    }
}

