/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractDiscreteDistribution;
import cern.jet.random.Stack;
import cern.jet.random.engine.RandomEngine;

public class EmpiricalWalker
extends AbstractDiscreteDistribution {
    protected int K;
    protected int[] A;
    protected double[] F;
    protected double[] cdf;

    public EmpiricalWalker(double[] pdf, int interpolationType, RandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(pdf, interpolationType);
        this.setState2(pdf);
    }

    public double cdf(int k) {
        if (k < 0) {
            return 0.0;
        }
        if (k >= this.cdf.length - 1) {
            return 1.0;
        }
        return this.cdf[k];
    }

    @Override
    public Object clone() {
        EmpiricalWalker copy = (EmpiricalWalker)super.clone();
        if (this.cdf != null) {
            copy.cdf = (double[])this.cdf.clone();
        }
        if (this.A != null) {
            copy.A = (int[])this.A.clone();
        }
        if (this.F != null) {
            copy.F = (double[])this.F.clone();
        }
        return copy;
    }

    @Override
    public int nextInt() {
        int c = 0;
        double u = this.randomGenerator.raw();
        c = (int)(u *= (double)this.K);
        u -= (double)c;
        double f = this.F[c];
        if (f == 1.0) {
            return c;
        }
        if (u < f) {
            return c;
        }
        return this.A[c];
    }

    public double pdf(int k) {
        if (k < 0 || k >= this.cdf.length - 1) {
            return 0.0;
        }
        return this.cdf[k - 1] - this.cdf[k];
    }

    public void setState(double[] pdf, int interpolationType) {
        int i;
        if (pdf == null || pdf.length == 0) {
            throw new IllegalArgumentException("Non-existing pdf");
        }
        int nBins = pdf.length;
        this.cdf = new double[nBins + 1];
        this.cdf[0] = 0.0;
        for (i = 0; i < nBins; ++i) {
            if (pdf[i] < 0.0) {
                throw new IllegalArgumentException("Negative probability");
            }
            this.cdf[i + 1] = this.cdf[i] + pdf[i];
        }
        if (this.cdf[nBins] <= 0.0) {
            throw new IllegalArgumentException("At leat one probability must be > 0.0");
        }
        i = 0;
        while (i < nBins + 1) {
            int n = i++;
            this.cdf[n] = this.cdf[n] / this.cdf[nBins];
        }
    }

    public void setState2(double[] pdf) {
        int b;
        int k;
        int size = pdf.length;
        double pTotal = 0.0;
        for (k = 0; k < size; ++k) {
            pTotal += pdf[k];
        }
        this.K = size;
        this.F = new double[size];
        this.A = new int[size];
        double[] E = new double[size];
        for (k = 0; k < size; ++k) {
            E[k] = pdf[k] / pTotal;
        }
        double mean = 1.0 / (double)size;
        int nSmalls = 0;
        int nBigs = 0;
        for (k = 0; k < size; ++k) {
            if (E[k] < mean) {
                ++nSmalls;
                continue;
            }
            ++nBigs;
        }
        Stack Bigs = new Stack(nBigs);
        Stack Smalls = new Stack(nSmalls);
        for (k = 0; k < size; ++k) {
            if (E[k] < mean) {
                Smalls.push(k);
                continue;
            }
            Bigs.push(k);
        }
        while (Smalls.size() > 0) {
            int s = Smalls.pop();
            if (Bigs.size() == 0) {
                this.A[s] = s;
                this.F[s] = 1.0;
                break;
            }
            this.A[s] = b = Bigs.pop();
            this.F[s] = (double)size * E[s];
            double d = mean - E[s];
            int n = s;
            E[n] = E[n] + d;
            int n2 = b;
            E[n2] = E[n2] - d;
            if (E[b] < mean) {
                Smalls.push(b);
                continue;
            }
            if (E[b] > mean) {
                Bigs.push(b);
                continue;
            }
            this.A[b] = b;
            this.F[b] = 1.0;
        }
        while (Bigs.size() > 0) {
            this.A[b] = b = Bigs.pop();
            this.F[b] = 1.0;
        }
    }

    public String toString() {
        Object interpolation = null;
        return this.getClass().getName() + "(" + (this.cdf != null ? this.cdf.length : 0) + ")";
    }
}

