/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.colt.list.DoubleArrayList;
import cern.jet.math.Arithmetic;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.quantile.DoubleQuantileFinder;
import cern.jet.stat.quantile.ExactDoubleQuantileFinder;
import cern.jet.stat.quantile.KnownDoubleQuantileEstimator;
import cern.jet.stat.quantile.UnknownDoubleQuantileEstimator;

public class QuantileFinderFactory {
    protected QuantileFinderFactory() {
    }

    public static long[] known_N_compute_B_and_K(long N, double epsilon, double delta, int quantiles, double[] returnSamplingRate) {
        returnSamplingRate[0] = 1.0;
        if (epsilon <= 0.0) {
            long[] result = new long[]{1L, N};
            return result;
        }
        if (epsilon >= 1.0 || delta >= 1.0) {
            long[] result = new long[]{2L, 1L};
            return result;
        }
        if (delta > 0.0) {
            return QuantileFinderFactory.known_N_compute_B_and_K_slow(N, epsilon, delta, quantiles, returnSamplingRate);
        }
        return QuantileFinderFactory.known_N_compute_B_and_K_quick(N, epsilon);
    }

    protected static long[] known_N_compute_B_and_K_quick(long N, double epsilon) {
        long k;
        long b;
        int maxBuffers = 50;
        int maxHeight = 50;
        double N_double = N;
        double c = N_double * epsilon * 2.0;
        int[] heightMaximums = new int[49];
        for (int b2 = 2; b2 <= 50; ++b2) {
            int h;
            for (h = 3; h <= 50 && (double)(h - 2) * Arithmetic.binomial(b2 + h - 2, (long)(h - 1)) - Arithmetic.binomial(b2 + h - 3, (long)(h - 3)) + Arithmetic.binomial(b2 + h - 3, (long)(h - 2)) - c > 0.0; ++h) {
            }
            while (h <= 50 && (double)(h - 2) * Arithmetic.binomial(b2 + h - 2, (long)(h - 1)) - Arithmetic.binomial(b2 + h - 3, (long)(h - 3)) + Arithmetic.binomial(b2 + h - 3, (long)(h - 2)) - c <= 0.0) {
                ++h;
            }
            int hMax = --h >= 50 && (double)(h - 2) * Arithmetic.binomial(b2 + h - 2, (long)(h - 1)) - Arithmetic.binomial(b2 + h - 3, (long)(h - 3)) + Arithmetic.binomial(b2 + h - 3, (long)(h - 2)) - c > 0.0 ? Integer.MIN_VALUE : h;
            heightMaximums[b2 - 2] = hMax;
        }
        long[] kMinimums = new long[49];
        for (int b3 = 2; b3 <= 50; ++b3) {
            double value;
            long tmpK;
            int h = heightMaximums[b3 - 2];
            long kMin = Long.MAX_VALUE;
            if (h > Integer.MIN_VALUE && (tmpK = (long)Math.ceil(N_double / (value = Arithmetic.binomial(b3 + h - 2, (long)(h - 1))))) <= Long.MAX_VALUE) {
                kMin = tmpK;
            }
            kMinimums[b3 - 2] = kMin;
        }
        long multMin = Long.MAX_VALUE;
        int minB = -1;
        for (int b4 = 2; b4 <= 50; ++b4) {
            long mult;
            if (kMinimums[b4 - 2] >= Long.MAX_VALUE || (mult = (long)b4 * kMinimums[b4 - 2]) >= multMin) continue;
            multMin = mult;
            minB = b4;
        }
        if (minB != -1) {
            b = minB;
            k = kMinimums[minB - 2];
        } else {
            b = 1L;
            k = N;
        }
        long[] result = new long[]{b, k};
        return result;
    }

    protected static long[] known_N_compute_B_and_K_slow(long N, double epsilon, double delta, int quantiles, double[] returnSamplingRate) {
        int maxBuffers = 50;
        int maxHeight = 50;
        double N_double = N;
        long ret_b = 1L;
        long ret_k = N;
        double sampling_rate = 1.0;
        long memory = N;
        double logarithm = Math.log(2.0 * (double)quantiles / delta);
        double c = 2.0 * epsilon * N_double;
        for (long b = 2L; b < 50L; ++b) {
            for (long h = 3L; h < 50L; ++h) {
                double binomial = Arithmetic.binomial(b + h - 2L, h - 1L);
                long tmp = (long)Math.ceil(N_double / binomial);
                if (b * tmp < memory && (double)(h - 2L) * binomial - Arithmetic.binomial(b + h - 3L, h - 3L) + Arithmetic.binomial(b + h - 3L, h - 2L) <= c) {
                    ret_k = tmp;
                    ret_b = b;
                    memory = ret_k * b;
                    sampling_rate = 1.0;
                }
                if (!(delta > 0.0)) continue;
                double t = (double)(h - 2L) * Arithmetic.binomial(b + h - 2L, h - 1L) - Arithmetic.binomial(b + h - 3L, h - 3L) + Arithmetic.binomial(b + h - 3L, h - 2L);
                double u = logarithm / epsilon;
                double v = Arithmetic.binomial(b + h - 2L, h - 1L);
                double w = logarithm / (2.0 * epsilon * epsilon);
                double x = 0.5 + 0.5 * Math.sqrt(1.0 + 4.0 * t / u);
                long k = (long)Math.ceil(w * x * x / v);
                if (b * k >= memory) continue;
                ret_k = k;
                ret_b = b;
                memory = b * k;
                sampling_rate = N_double * 2.0 * epsilon * epsilon / logarithm;
            }
        }
        long[] result = new long[]{ret_b, ret_k};
        returnSamplingRate[0] = sampling_rate;
        return result;
    }

    public static DoubleQuantileFinder newDoubleQuantileFinder(boolean known_N, long N, double epsilon, double delta, int quantiles, RandomEngine generator) {
        if (epsilon <= 0.0 || N < 1000L) {
            return new ExactDoubleQuantileFinder();
        }
        if (epsilon > 1.0) {
            epsilon = 1.0;
        }
        if (delta < 0.0) {
            delta = 0.0;
        }
        if (delta > 1.0) {
            delta = 1.0;
        }
        if (quantiles < 1) {
            quantiles = 1;
        }
        if ((long)quantiles > N) {
            N = quantiles;
        }
        if (known_N) {
            double[] samplingRate = new double[1];
            long[] resultKnown = QuantileFinderFactory.known_N_compute_B_and_K(N, epsilon, delta, quantiles, samplingRate);
            long b = resultKnown[0];
            long k = resultKnown[1];
            if (b == 1L) {
                return new ExactDoubleQuantileFinder();
            }
            return new KnownDoubleQuantileEstimator((int)b, (int)k, N, samplingRate[0], generator);
        }
        long[] resultUnknown = QuantileFinderFactory.unknown_N_compute_B_and_K(epsilon, delta, quantiles);
        long b1 = resultUnknown[0];
        long k1 = resultUnknown[1];
        long h1 = resultUnknown[2];
        double preComputeEpsilon = -1.0;
        if (resultUnknown[3] == 1L) {
            preComputeEpsilon = epsilon;
        }
        if (b1 == 1L) {
            return new ExactDoubleQuantileFinder();
        }
        return new UnknownDoubleQuantileEstimator((int)b1, (int)k1, (int)h1, preComputeEpsilon, generator);
    }

    public static DoubleArrayList newEquiDepthPhis(int quantiles) {
        DoubleArrayList phis = new DoubleArrayList(quantiles - 1);
        for (int i = 1; i <= quantiles - 1; ++i) {
            phis.add((double)i / (double)quantiles);
        }
        return phis;
    }

    public static long[] unknown_N_compute_B_and_K(double epsilon, double delta, int quantiles) {
        return QuantileFinderFactory.unknown_N_compute_B_and_K_raw(epsilon, delta, quantiles);
    }

    protected static long[] unknown_N_compute_B_and_K_raw(double epsilon, double delta, int quantiles) {
        if (epsilon <= 0.0) {
            long[] result = new long[]{1L, Long.MAX_VALUE, Long.MAX_VALUE, 0L};
            return result;
        }
        if (epsilon >= 1.0 || delta >= 1.0) {
            long[] result = new long[]{2L, 1L, 3L, 0L};
            return result;
        }
        if (delta <= 0.0) {
            long[] result = new long[]{1L, Long.MAX_VALUE, Long.MAX_VALUE, 0L};
            return result;
        }
        int max_b = 50;
        int max_h = 50;
        int max_H = 50;
        int max_Iterations = 2;
        long best_b = Long.MAX_VALUE;
        long best_k = Long.MAX_VALUE;
        long best_h = Long.MAX_VALUE;
        long best_memory = Long.MAX_VALUE;
        double pow = Math.pow(2.0, max_H);
        double logDelta = Math.log(2.0 / (delta / (double)quantiles)) / (2.0 * epsilon * epsilon);
        while (best_b == Long.MAX_VALUE && max_Iterations-- > 0) {
            for (int b = 2; b <= max_b; ++b) {
                for (int h = 2; h <= max_h; ++h) {
                    long memory;
                    double beta;
                    double cc;
                    double d;
                    double Ls;
                    double Ld = Arithmetic.binomial(b + h - 2, (long)(h - 1));
                    double c = logDelta / Math.min(Ld, 8.0 * (Ls = Arithmetic.binomial(b + h - 3, (long)(h - 1))) / 3.0);
                    double f = c * c + 4.0 * c * (d = ((double)(h + 3) + (cc = ((beta = Ld / Ls) - 2.0) * ((double)max_H - 2.0) / (beta + pow - 2.0))) / (2.0 * epsilon));
                    if (f < 0.0) continue;
                    double root = Math.sqrt(f);
                    double alpha_one = (c + 2.0 * d + root) / (2.0 * d);
                    double alpha_two = (c + 2.0 * d - root) / (2.0 * d);
                    boolean alpha_one_OK = false;
                    boolean alpha_two_OK = false;
                    if (0.0 < alpha_one && alpha_one < 1.0) {
                        alpha_one_OK = true;
                    }
                    if (0.0 < alpha_two && alpha_two < 1.0) {
                        alpha_two_OK = true;
                    }
                    if (!alpha_one_OK && !alpha_two_OK) continue;
                    double alpha = alpha_one;
                    if (alpha_one_OK && alpha_two_OK) {
                        alpha = Math.max(alpha_one, alpha_two);
                    } else if (alpha_two_OK) {
                        alpha = alpha_two;
                    }
                    long k = (long)Math.ceil(Math.max(d / alpha, (double)(h + 1) / (2.0 * epsilon)));
                    if (k <= 0L || (memory = (long)b * k) >= best_memory) continue;
                    best_k = k;
                    best_b = b;
                    best_h = h;
                    best_memory = memory;
                }
            }
            if (best_b != Long.MAX_VALUE) continue;
            System.out.println("Warning: Computing b and k looks like a lot of work!");
            max_b *= 2;
            max_h *= 2;
            max_H *= 2;
        }
        long[] result = new long[4];
        result[3] = 0L;
        if (best_b == Long.MAX_VALUE) {
            result[0] = 1L;
            result[1] = Long.MAX_VALUE;
            result[2] = Long.MAX_VALUE;
        } else {
            result[0] = best_b;
            result[1] = best_k;
            result[2] = best_h;
        }
        return result;
    }
}

