/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.http2.sampler;

import com.blazemeter.jmeter.http2.sampler.HTTP2SampleResult;
import com.blazemeter.jmeter.http2.sampler.HTTP2StreamHandler;
import com.blazemeter.jmeter.http2.sampler.RequestBody;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FuturePromise;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2Connection {
    private static Logger LOG = LoggerFactory.getLogger(HTTP2Connection.class);
    private String connectionId;
    private Session session = null;
    private HTTP2Client client;
    private SslContextFactory sslContextFactory;
    private Queue<HTTP2StreamHandler> streamHandlers = new ConcurrentLinkedQueue<HTTP2StreamHandler>();

    public void setSession(Session session) {
        this.session = session;
    }

    public HTTP2Connection(String connectionId, boolean isSSL) throws Exception {
        this.connectionId = connectionId;
        this.client = new HTTP2Client();
        this.sslContextFactory = null;
        if (isSSL) {
            this.sslContextFactory = new SslContextFactory(true);
        }
        this.client.addBean((Object)this.sslContextFactory);
        this.client.start();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void connect(String hostname, int port) throws InterruptedException, ExecutionException, TimeoutException {
        FuturePromise sessionFuture = new FuturePromise();
        this.client.connect(this.sslContextFactory, new InetSocketAddress(hostname, port), (Session.Listener)new Session.Listener.Adapter(), (Promise)sessionFuture);
        this.setSession((Session)sessionFuture.get(10L, TimeUnit.SECONDS));
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    private synchronized void sendMutExc(String method, HeadersFrame headersFrame, FuturePromise<Stream> streamPromise, HTTP2StreamHandler http2StreamHandler, RequestBody requestBody) throws Exception {
        this.session.newStream(headersFrame, streamPromise, (Stream.Listener)http2StreamHandler);
        if ("POST".equals(method)) {
            Stream actualStream = (Stream)streamPromise.get();
            int streamID = actualStream.getId();
            DataFrame data = new DataFrame(streamID, ByteBuffer.wrap(requestBody.getPayloadBytes()), true);
            actualStream.data(data, Callback.NOOP);
        }
    }

    public void send(String method, URL url, HeaderManager headerManager, CookieManager cookieManager, RequestBody requestBody, HTTP2SampleResult sampleResult, int timeout) throws Exception {
        HttpFields headers = this.buildHeaders(url, headerManager, cookieManager);
        if (requestBody != null) {
            headers.put("Content-Length", Long.toString(requestBody.getPayloadBytes().length));
            String contentTypeHeader = headers.get("Content-Type");
            if (contentTypeHeader == null || contentTypeHeader.isEmpty()) {
                headers.put("Content-Type", "application/x-www-form-urlencoded");
            }
            sampleResult.setQueryString(requestBody.getPayload());
        }
        MetaData.Request metaData = null;
        boolean endOfStream = true;
        switch (method) {
            case "GET": {
                metaData = new MetaData.Request("GET", new HttpURI(url.toString()), HttpVersion.HTTP_2, headers);
                break;
            }
            case "POST": {
                metaData = new MetaData.Request("POST", new HttpURI(url.toString()), HttpVersion.HTTP_2, headers);
                endOfStream = false;
                break;
            }
        }
        HeadersFrame headersFrame = new HeadersFrame(metaData, null, endOfStream);
        String headersString = headers.toString().replaceAll("\r\n", "\n");
        sampleResult.setRequestHeaders(headersString.substring(0, headersString.length() - 1));
        HTTP2StreamHandler http2StreamHandler = new HTTP2StreamHandler(this, headerManager, cookieManager, sampleResult);
        http2StreamHandler.setTimeout(timeout);
        sampleResult.setCookies(headers.get("Cookie"));
        this.addStreamHandler(http2StreamHandler);
        sampleResult.sampleStart();
        this.sendMutExc(method, headersFrame, (FuturePromise<Stream>)new FuturePromise(), http2StreamHandler, requestBody);
    }

    private HttpFields buildHeaders(URL url, HeaderManager headerManager, CookieManager cookieManager) {
        String cookieHeader;
        CollectionProperty headersProps;
        HttpFields headers = new HttpFields();
        if (headerManager != null && (headersProps = headerManager.getHeaders()) != null) {
            for (JMeterProperty prop : headersProps) {
                Header header = (Header)prop.getObjectValue();
                String n = header.getName();
                if (n.startsWith(":")) {
                    LOG.warn("The specified pseudo header {} is not allowed and will be ignored", (Object)n);
                    continue;
                }
                if ("Content-Length".equalsIgnoreCase(n)) continue;
                String v = header.getValue();
                v = v.replaceFirst(":\\d+$", "");
                headers.put(n, v);
            }
        }
        if (cookieManager != null && (cookieHeader = cookieManager.getCookieHeaderForURL(url)) != null) {
            headers.put("Cookie", cookieHeader);
        }
        return headers;
    }

    public void addStreamHandler(HTTP2StreamHandler http2StreamHandler) {
        this.streamHandlers.add(http2StreamHandler);
    }

    public void disconnect() throws Exception {
        this.client.stop();
    }

    public List<HTTP2SampleResult> awaitResponses() throws InterruptedException {
        ArrayList<HTTP2SampleResult> results = new ArrayList<HTTP2SampleResult>();
        while (!this.streamHandlers.isEmpty()) {
            HTTP2StreamHandler h = this.streamHandlers.poll();
            results.add(h.getHTTP2SampleResult());
            try {
                h.getCompletedFuture().get(h.getTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException | TimeoutException e) {
                HTTP2SampleResult sample = h.getHTTP2SampleResult();
                sample.setErrorResult("Error while await for response", e);
                sample.setResponseHeaders("");
            }
        }
        return results;
    }
}

