/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.http2.sampler;

import com.blazemeter.jmeter.http2.sampler.HTTP2Connection;
import com.blazemeter.jmeter.http2.sampler.HTTP2SampleResult;
import com.blazemeter.jmeter.http2.sampler.RequestBody;
import com.blazemeter.jmeter.http2.visualizers.ResultCollector;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.protocol.http.control.CacheManager;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.protocol.http.util.HTTPFileArgs;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.SamplePackage;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.eclipse.jetty.http.HttpFields;

public class HTTP2Request
extends AbstractSampler
implements ThreadListener,
LoopIterationListener {
    public static final String ENCODING = StandardCharsets.ISO_8859_1.name();
    private static final long serialVersionUID = 5859387434748163229L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String DEFAULT_RESPONSE_TIMEOUT = "20000";
    public static final String METHOD = "HTTP2Sampler.method";
    private static final String PROTOCOL_SCHEME = "HTTP2Sampler.scheme";
    public static final String PORT = "HTTPSampler.port";
    private static final String FILE_ARGS = "HTTPsampler.Files";
    public static final String DEFAULT_METHOD = "GET";
    private static final String HEADER_MANAGER = "HTTP2Request.header_manager";
    private static final String COOKIE_MANAGER = "HTTP2Request.cookie_manager";
    private static final String CACHE_MANAGER = "HTTP2Request.cache_manager";
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final String DEFAULT_PROTOCOL = "https";
    private static final int UNSPECIFIED_PORT = 0;
    public static final String UNSPECIFIED_PORT_AS_STRING = "0";
    private static final String NON_HTTP_RESPONSE_CODE = "Non HTTP response code";
    private static final String NON_HTTP_RESPONSE_MESSAGE = "Non HTTP response message";
    public static final String IP_SOURCE = "HTTP2Request.ipSource";
    public static final String IP_SOURCE_TYPE = "HTTP2Request.ipSourceType";
    public static final String EMBEDDED_URL_REGEX = "HTTPSampler.embedded_url_re";
    public static final String MD5 = "HTTPSampler.md5";
    public static final String EMBEDDED_RESOURCES = "HTTPSampler.embedded_resources";
    public static final int SOURCE_TYPE_DEFAULT = HTTPSamplerBase.SourceType.HOSTNAME.ordinal();
    public static final String ARGUMENTS = "HTTP2Request.Arguments";
    public static final String POST_BODY_RAW = "HTTP2Request.postBodyRaw";
    public static final boolean POST_BODY_RAW_DEFAULT = false;
    public static final String DOMAIN = "HTTP2Request.domain";
    public static final String RESPONSE_TIMEOUT = "HTTP2Request.response_timeout";
    public static final String FOLLOW_REDIRECTS = "HTTP2Request.follow_redirects";
    public static final String AUTO_REDIRECTS = "HTTP2Request.auto_redirects";
    public static final String SYNC_REQUEST = "HTTP2Request.sync_request";
    public static final String PROTOCOL = "HTTP2Request.protocol";
    public static final String REQUEST_ID = "HTTP2Request.request_id";
    public static final String CONTENT_ENCODING = "HTTP2Request.contentEncoding";
    public static final String PATH = "HTTP2Request.path";
    private static ThreadLocal<Map<String, HTTP2Connection>> connections = ThreadLocal.withInitial(HashMap::new);
    private HTTP2Connection http2Connection;

    public HTTP2Request() {
        this.setName("HTTP2 Request");
    }

    public void setName(String name) {
        if (name != null) {
            this.setProperty("TestElement.name", name);
        }
    }

    public String getName() {
        return this.getPropertyAsString("TestElement.name");
    }

    public SampleResult sample(Entry entry) {
        return this.sample();
    }

    public SampleResult sample() {
        JMeterContext threadContext = this.getThreadContext();
        int nbActiveThreadsInThreadGroup = threadContext.getThreadGroup().getNumberOfThreads();
        int nbTotalActiveThreads = JMeterContextService.getNumberOfThreads();
        HTTP2SampleResult sampleResult = new HTTP2SampleResult(threadContext);
        sampleResult.setSampleLabel(this.getName());
        sampleResult.setGroupThreads(nbActiveThreadsInThreadGroup);
        sampleResult.setAllThreads(nbTotalActiveThreads);
        sampleResult.setThreadName(this.getThreadName());
        sampleResult.setSync(this.isSyncRequest());
        try {
            URL url = this.getUrl();
            sampleResult.setURL(url);
            sampleResult.setHTTPMethod(this.getMethod());
            this.setConnection(url, sampleResult);
            this.sample(url, this.getMethod(), this.getConnection(), sampleResult);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.errorResult(e, sampleResult);
        }
        catch (Exception e) {
            this.errorResult(e, sampleResult);
        }
        if (!this.isSyncRequest().booleanValue()) {
            SamplePackage pack = (SamplePackage)threadContext.getVariables().getObject("JMeterThread.pack");
            for (SampleListener l : pack.getSampleListeners()) {
                if (!(l instanceof ResultCollector)) continue;
                SampleEvent event = new SampleEvent((SampleResult)sampleResult, this.getThreadName(), threadContext.getVariables(), false);
                ((ResultCollector)l).sampleOccurred(event);
            }
            return null;
        }
        return sampleResult;
    }

    private void errorResult(Throwable e, HTTP2SampleResult res) {
        res.setSampleLabel(res.getSampleLabel());
        res.setDataType("text");
        ByteArrayOutputStream text = new ByteArrayOutputStream(200);
        e.printStackTrace(new PrintStream(text));
        res.setResponseData(text.toByteArray());
        res.setResponseCode("Non HTTP response code: " + e.getClass().getName());
        res.setResponseMessage("Non HTTP response message: " + e.getMessage());
        res.setSuccessful(false);
        res.setPendingResponse(false);
    }

    protected void sample(URL url, String method, HTTP2Connection http2Connection, HTTP2SampleResult sampleResult) {
        sampleResult.setEmbebedResults(this.isEmbeddedResources());
        sampleResult.setEmbeddedUrlRE(this.getEmbeddedUrlRE());
        try {
            int timeout = Integer.parseInt(DEFAULT_RESPONSE_TIMEOUT);
            if (!this.getResponseTimeout().equals("")) {
                timeout = Integer.parseInt(this.getResponseTimeout());
            }
            RequestBody body = null;
            if ("POST".equals(method) || "PUT".equals(method)) {
                body = RequestBody.from(method, this.getContentEncoding(), this.getArguments(), this.getSendParameterValuesAsPostBody());
            }
            http2Connection.send(method, url, this.getHeaderManager(), this.getCookieManager(), body, sampleResult, timeout);
            CacheManager cacheManager = this.getCacheManager();
            if (cacheManager == null || DEFAULT_METHOD.equalsIgnoreCase(method)) {
                // empty if block
            }
            if (this.isSyncRequest().booleanValue()) {
                for (HTTP2Connection h : connections.get().values()) {
                    for (HTTP2SampleResult r : h.awaitResponses()) {
                        this.saveConnectionCookies(r.getHttpFieldsResponse(), r.getURL(), this.getCookieManager());
                    }
                }
            } else {
                sampleResult.setSuccessful(true);
            }
        }
        catch (Exception e) {
            this.errorResult(e, sampleResult);
        }
    }

    private boolean getSendParameterValuesAsPostBody() {
        if (this.getPostBodyRaw()) {
            return true;
        }
        boolean hasArguments = false;
        for (JMeterProperty jMeterProperty : this.getArguments()) {
            hasArguments = true;
            HTTPArgument arg = (HTTPArgument)jMeterProperty.getObjectValue();
            if (arg.getName() == null || arg.getName().length() <= 0) continue;
            return false;
        }
        return hasArguments;
    }

    private boolean getPostBodyRaw() {
        return this.getPropertyAsBoolean(POST_BODY_RAW, false);
    }

    private String getContentEncoding() {
        String prop = this.getPropertyAsString(CONTENT_ENCODING);
        return prop == null || prop.isEmpty() ? ENCODING : prop;
    }

    public HTTP2Connection getConnection() {
        return this.http2Connection;
    }

    public void addConnection(String id, HTTP2Connection connection) {
        connections.get().put(id, connection);
    }

    public void setConnection(URL url, HTTP2SampleResult sampleResult) throws Exception {
        String host = url.getHost().replaceAll("\\[", "").replaceAll("]", "");
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        String connectionId = this.buildConnectionId(host, port);
        long startConnectTime = sampleResult.currentTimeInMillis();
        Map<String, HTTP2Connection> threadConnections = connections.get();
        this.http2Connection = threadConnections.get(connectionId);
        if (this.http2Connection != null) {
            if (this.http2Connection.isClosed()) {
                this.http2Connection.connect(host, port);
            }
        } else {
            this.http2Connection = new HTTP2Connection(connectionId, true);
            this.http2Connection.connect(host, port);
            threadConnections.put(connectionId, this.http2Connection);
        }
        sampleResult.setConnectTime(sampleResult.currentTimeInMillis() - startConnectTime);
    }

    private String buildConnectionId(String host, int port) {
        return host + ": " + port;
    }

    public String getMethod() {
        return this.getPropertyAsString(METHOD);
    }

    public URL getUrl() throws MalformedURLException {
        StringBuilder pathAndQuery = new StringBuilder(100);
        String path = this.getContextPath();
        if (path.startsWith(HTTP_PREFIX) || path.startsWith(HTTPS_PREFIX)) {
            return new URL(path);
        }
        String domain = this.getDomain();
        String protocol = this.getProtocol();
        if (!path.startsWith("/")) {
            pathAndQuery.append("/");
        }
        pathAndQuery.append(path);
        if (this.isProtocolDefaultPort()) {
            return new URL(protocol, domain, pathAndQuery.toString());
        }
        return new URL(protocol, domain, this.getPort(), pathAndQuery.toString());
    }

    private boolean isProtocolDefaultPort() {
        int port = this.getPortIfSpecified();
        String protocol = this.getProtocol();
        boolean isDefaultHTTPPort = "http".equalsIgnoreCase(protocol) && port == 80;
        boolean isDefaultHTTPSPort = DEFAULT_PROTOCOL.equalsIgnoreCase(protocol) && port == 443;
        return port == 0 || isDefaultHTTPPort || isDefaultHTTPSPort;
    }

    private int getPortIfSpecified() {
        String port_s = this.getPropertyAsString(PORT, UNSPECIFIED_PORT_AS_STRING);
        try {
            return Integer.parseInt(port_s.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getPort() {
        int port = this.getPortIfSpecified();
        if (port == 0) {
            String protocol = this.getProtocol();
            if (DEFAULT_PROTOCOL.equalsIgnoreCase(protocol)) {
                return 443;
            }
            if (!"http".equalsIgnoreCase(protocol)) {
                log.warn("Unexpected protocol: " + protocol);
            }
            return 80;
        }
        return port;
    }

    public void setProtocol(String value) {
        this.setProperty(PROTOCOL_SCHEME, value);
    }

    public String getProtocol() {
        String protocol = this.getPropertyAsString(PROTOCOL_SCHEME);
        if (protocol == null || protocol.length() == 0) {
            return DEFAULT_PROTOCOL;
        }
        return protocol;
    }

    public boolean getSendFileAsPostBody() {
        HTTPFileArg[] files = this.getHTTPFiles();
        return files.length == 1 && files[0].getPath().length() > 0 && files[0].getParamName().length() == 0;
    }

    private String getDomain() {
        return this.getPropertyAsString(DOMAIN);
    }

    private String getResponseTimeout() {
        return this.getPropertyAsString(RESPONSE_TIMEOUT);
    }

    private String getContextPath() {
        return this.getPropertyAsString(PATH);
    }

    private Arguments getArguments() {
        return (Arguments)this.getProperty(ARGUMENTS).getObjectValue();
    }

    private HTTPFileArgs getHTTPFileArgs() {
        return (HTTPFileArgs)this.getProperty(FILE_ARGS).getObjectValue();
    }

    public HTTPFileArg[] getHTTPFiles() {
        HTTPFileArgs fileArgs = this.getHTTPFileArgs();
        return fileArgs == null ? new HTTPFileArg[]{} : fileArgs.asArray();
    }

    public Boolean isEmbeddedResources() {
        return this.getPropertyAsBoolean(EMBEDDED_RESOURCES);
    }

    private Boolean isSyncRequest() {
        return this.getPropertyAsBoolean(SYNC_REQUEST);
    }

    public HeaderManager getHeaderManager() {
        return (HeaderManager)this.getProperty(HEADER_MANAGER).getObjectValue();
    }

    public String getEmbeddedUrlRE() {
        return this.getPropertyAsString(EMBEDDED_URL_REGEX, "");
    }

    public void addTestElement(TestElement el) {
        if (el instanceof HeaderManager) {
            this.setHeaderManager((HeaderManager)el);
        } else if (el instanceof CookieManager) {
            this.setCookieManager((CookieManager)el);
        } else if (el instanceof CacheManager) {
            this.setCacheManager((CacheManager)el);
        } else {
            super.addTestElement(el);
        }
    }

    private void setHeaderManager(HeaderManager value) {
        HeaderManager mgr = this.getHeaderManager();
        if (mgr != null) {
            value = mgr.merge((TestElement)value);
            if (log.isDebugEnabled()) {
                log.debug("Existing HeaderManager '" + mgr.getName() + "' merged with '" + value.getName() + "'");
                for (int i = 0; i < value.getHeaders().size(); ++i) {
                    log.debug("    " + value.getHeader(i).getName() + "=" + value.getHeader(i).getValue());
                }
            }
        }
        this.setProperty((JMeterProperty)new TestElementProperty(HEADER_MANAGER, (TestElement)value));
    }

    private void setCookieManagerProperty(CookieManager value) {
        this.setProperty((JMeterProperty)new TestElementProperty(COOKIE_MANAGER, (TestElement)value));
    }

    private void setCookieManager(CookieManager value) {
        CookieManager mgr = this.getCookieManager();
        if (mgr != null) {
            log.warn("Existing CookieManager " + mgr.getName() + " superseded by " + value.getName());
        }
        this.setCookieManagerProperty(value);
    }

    public CookieManager getCookieManager() {
        return (CookieManager)this.getProperty(COOKIE_MANAGER).getObjectValue();
    }

    private void setCacheManager(CacheManager value) {
        CacheManager mgr = this.getCacheManager();
        if (mgr != null) {
            log.warn("Existing CacheManager " + mgr.getName() + " superseded by " + value.getName());
        }
        this.setCacheManagerProperty(value);
    }

    private void setCacheManagerProperty(CacheManager value) {
        this.setProperty((JMeterProperty)new TestElementProperty(CACHE_MANAGER, (TestElement)value));
    }

    public CacheManager getCacheManager() {
        return (CacheManager)this.getProperty(CACHE_MANAGER).getObjectValue();
    }

    public void threadStarted() {
    }

    public void threadFinished() {
        this.waitAllResponses();
        for (HTTP2Connection connection : connections.get().values()) {
            try {
                connection.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        connections.get().clear();
    }

    private void saveConnectionCookies(HttpFields hdrsResponse, URL url, CookieManager cookieManager) {
        if (cookieManager != null && hdrsResponse != null) {
            List hdrs = hdrsResponse.getValuesList("set-cookie");
            for (String hdr : hdrs) {
                cookieManager.addCookieFromHeader(hdr, url);
            }
        }
    }

    public void setEmbeddedResources(boolean embeddedResources) {
        this.setProperty(EMBEDDED_RESOURCES, embeddedResources, false);
    }

    public void setEmbeddedUrlRE(String regex) {
        this.setProperty((JMeterProperty)new StringProperty(EMBEDDED_URL_REGEX, regex));
    }

    public void iterationStart(LoopIterationEvent iterEvent) {
        this.waitAllResponses();
    }

    private void waitAllResponses() {
        connections.get().values().forEach(c -> {
            try {
                c.awaitResponses();
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for HTTP2 async responses", (Throwable)e);
            }
        });
    }
}

