/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.http2.sampler;

import com.blazemeter.jmeter.http2.sampler.HTTP2ResultConverter;
import com.google.common.annotations.VisibleForTesting;
import com.thoughtworks.xstream.XStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.AbstractScopedAssertion;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.SamplePackage;
import org.apache.jorphan.util.JMeterError;
import org.eclipse.jetty.http.HttpFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2SampleResult
extends HTTPSampleResult {
    private int embebedResultsDepth;
    private boolean embebedResults;
    private String embeddedUrlRE;
    private boolean secondaryRequest;
    private boolean pendingResponse;
    private transient HttpFields httpFieldsResponse;
    private transient ListenerNotifier listenerNotifier = new ListenerNotifier();
    private transient JMeterContext threadContext;
    private transient JMeterVariables threadVars;
    private transient List<SampleListener> sampleListeners;
    private transient List<Assertion> assertions;
    private transient List<PostProcessor> postProcessors;
    private transient boolean isSync;
    private static final Logger LOG = LoggerFactory.getLogger(HTTP2SampleResult.class);

    private static void registerHTTP2ResultConverter() {
        try {
            Method method = SaveService.class.getDeclaredMethod("registerConverter", String.class, XStream.class, Boolean.TYPE);
            method.setAccessible(true);
            Field target = SaveService.class.getDeclaredField("JTLSAVER");
            target.setAccessible(true);
            XStream JTLSAVER = (XStream)target.get(null);
            method.invoke(null, HTTP2ResultConverter.class.getCanonicalName(), JTLSAVER, true);
        }
        catch (ReflectiveOperationException e) {
            LOG.error("This version of JMeter is not supported", (Throwable)e);
        }
    }

    public HTTP2SampleResult() {
    }

    public HTTP2SampleResult(JMeterContext threadContext) {
        this.threadContext = threadContext;
        this.threadVars = threadContext.getVariables();
        SamplePackage pack = (SamplePackage)this.threadVars.getObject("JMeterThread.pack");
        this.assertions = pack.getAssertions();
        this.postProcessors = pack.getPostProcessors();
        this.sampleListeners = pack.getSampleListeners();
        this.setPendingResponse(true);
        this.setEmbebedResultsDepth(1);
    }

    public HTTP2SampleResult(HTTP2SampleResult res) {
        super((HTTPSampleResult)res);
    }

    protected void setErrorResult(String message, Throwable e) {
        this.setDataType("text");
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        this.setResponseData(sw.toString(), HTTPSampleResult.DEFAULT_HTTP_ENCODING);
        this.setResponseCode(e.getClass().getName());
        this.setResponseMessage(e.getMessage());
        this.setSuccessful(false);
        this.setPendingResponse(false);
        LOG.error(message, e);
    }

    public static HTTP2SampleResult createErrorResult(String message, Throwable e) {
        HTTP2SampleResult result = new HTTP2SampleResult();
        result.setErrorResult(message, e);
        return result;
    }

    public HTTP2SampleResult createSubResult() {
        HTTP2SampleResult result = new HTTP2SampleResult();
        result.embebedResultsDepth = this.embebedResultsDepth - 1;
        result.embebedResults = this.embebedResults;
        result.secondaryRequest = true;
        result.pendingResponse = true;
        result.threadContext = this.threadContext;
        result.threadVars = this.threadVars;
        result.sampleListeners = null;
        result.assertions = null;
        result.postProcessors = null;
        return result;
    }

    public boolean isEmbebedResults() {
        return this.embebedResults;
    }

    public String getEmbeddedUrlRE() {
        return this.embeddedUrlRE;
    }

    public void setEmbeddedUrlRE(String embeddedUrlRE) {
        this.embeddedUrlRE = embeddedUrlRE;
    }

    public void setEmbebedResults(boolean embebedResults) {
        this.embebedResults = embebedResults;
    }

    public int getEmbebedResultsDepth() {
        return this.embebedResultsDepth;
    }

    public void setEmbebedResultsDepth(int embebedResultsDepth) {
        this.embebedResultsDepth = embebedResultsDepth;
    }

    public HttpFields getHttpFieldsResponse() {
        return this.httpFieldsResponse;
    }

    public void setHttpFieldsResponse(HttpFields httpFieldsResponse) {
        this.httpFieldsResponse = httpFieldsResponse;
    }

    public void setPendingResponse(boolean pendingResp) {
        this.pendingResponse = pendingResp;
    }

    public boolean isPendingResponse() {
        return this.pendingResponse;
    }

    public boolean isSecondaryRequest() {
        return this.secondaryRequest;
    }

    public void setSecondaryRequest(boolean secondaryRequest) {
        this.secondaryRequest = secondaryRequest;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public void setSync(boolean sync) {
        this.isSync = sync;
    }

    public void completeAsyncSample() {
        HTTP2SampleResult parent = (HTTP2SampleResult)this.getParent();
        if (parent != null) {
            parent.completeAsyncSample();
        } else if (!this.isPendingResponse()) {
            boolean sonsArePendingResponse = false;
            for (SampleResult s : this.getSubResults()) {
                HTTP2SampleResult h = (HTTP2SampleResult)s;
                if (!h.isPendingResponse()) continue;
                sonsArePendingResponse = true;
                break;
            }
            if (!sonsArePendingResponse) {
                this.runPostProcessors(this.postProcessors);
                this.checkAssertions(this.assertions);
                SampleEvent event = new SampleEvent((SampleResult)this, this.getThreadName(), this.threadVars, false);
                this.listenerNotifier.notifyListeners(event, this.sampleListeners);
            }
        }
    }

    private void runPostProcessors(List<PostProcessor> postProcessors) {
        for (PostProcessor postProcessor : postProcessors) {
            if (this.threadContext.getVariables() != null) {
                TestBeanHelper.prepare((TestElement)((TestElement)postProcessor));
                postProcessor.process();
                continue;
            }
            LOG.warn("The Post Processor " + postProcessor.getClass() + "was not executed for the sampler" + this.getSampleLabel() + ". Use Synchronized Request to avoid this error");
        }
    }

    private void checkAssertions(List<Assertion> assertions) {
        for (Assertion assertion : assertions) {
            TestBeanHelper.prepare((TestElement)((TestElement)assertion));
            if (assertion instanceof AbstractScopedAssertion) {
                AbstractScopedAssertion scopedAssertion = (AbstractScopedAssertion)assertion;
                String scope = scopedAssertion.fetchScope();
                if (scopedAssertion.isScopeParent(scope) || scopedAssertion.isScopeAll(scope)) {
                    this.processAssertion((SampleResult)this, assertion);
                }
                if (scopedAssertion.isScopeVariable(scope)) {
                    if (((AbstractScopedAssertion)assertion).getThreadContext().getVariables() != null) {
                        this.processAssertion((SampleResult)this, assertion);
                    } else {
                        LOG.warn("The Variable Assertion was not executed for the sampler" + this.getSampleLabel() + ". Use Synchronized Request to avoid this error");
                    }
                }
                if (!scopedAssertion.isScopeChildren(scope) && !scopedAssertion.isScopeAll(scope)) continue;
                SampleResult[] children = this.getSubResults();
                boolean childError = false;
                for (SampleResult childSampleResult : children) {
                    this.processAssertion(childSampleResult, assertion);
                    if (childSampleResult.isSuccessful()) continue;
                    childError = true;
                }
                if (!childError || !this.isSuccessful()) continue;
                AssertionResult assertionResult = new AssertionResult(((AbstractTestElement)assertion).getName());
                assertionResult.setResultForFailure("One or more sub-samples failed");
                this.addAssertionResult(assertionResult);
                this.setSuccessful(false);
                continue;
            }
            this.processAssertion((SampleResult)this, assertion);
        }
        this.threadVars.put("JMeterThread.last_sample_ok", Boolean.toString(this.isSuccessful()));
    }

    private void processAssertion(SampleResult result, Assertion assertion) {
        AssertionResult assertionResult;
        try {
            assertionResult = assertion.getResult(result);
        }
        catch (AssertionError e) {
            LOG.debug("Error processing Assertion.", (Throwable)((Object)e));
            assertionResult = new AssertionResult("Assertion failed! See log file (debug level, only).");
            assertionResult.setFailure(true);
            assertionResult.setFailureMessage(((Throwable)((Object)e)).toString());
        }
        catch (JMeterError e) {
            LOG.error("Error processing Assertion.", (Throwable)e);
            assertionResult = new AssertionResult("Assertion failed! See log file.");
            assertionResult.setError(true);
            assertionResult.setFailureMessage(e.toString());
        }
        catch (Exception e) {
            LOG.error("Exception processing Assertion.", (Throwable)e);
            assertionResult = new AssertionResult("Assertion failed! See log file.");
            assertionResult.setError(true);
            assertionResult.setFailureMessage(e.toString());
        }
        result.setSuccessful(result.isSuccessful() && !assertionResult.isError() && !assertionResult.isFailure());
        result.addAssertionResult(assertionResult);
    }

    @VisibleForTesting
    public void setListenerNotifier(ListenerNotifier listenerNotifier) {
        this.listenerNotifier = listenerNotifier;
    }

    static {
        HTTP2SampleResult.registerHTTP2ResultConverter();
    }
}

