/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.http2.sampler;

import com.blazemeter.jmeter.http2.sampler.HTTP2Connection;
import com.blazemeter.jmeter.http2.sampler.HTTP2SampleResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.parser.BaseParser;
import org.apache.jmeter.protocol.http.parser.LinkExtractorParseException;
import org.apache.jmeter.protocol.http.parser.LinkExtractorParser;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2StreamHandler
extends Stream.Listener.Adapter {
    private static final String USER_AGENT = "User-Agent";
    private static final Map<String, String> PARSERS_FOR_CONTENT_TYPE = new HashMap<String, String>();
    private static final String RESPONSE_PARSERS = JMeterUtils.getProperty((String)"HTTPResponse.parsers");
    private static final Logger LOG = LoggerFactory.getLogger(HTTP2StreamHandler.class);
    private static final boolean IGNORE_FAILED_EMBEDDED_RESOURCES = JMeterUtils.getPropDefault((String)"httpsampler.ignore_failed_embedded_resources", (boolean)false);
    private final CompletableFuture<Void> completedFuture = new CompletableFuture();
    private HTTP2SampleResult result;
    private HTTP2Connection parent;
    private byte[] responseBytes;
    private HeaderManager headerManager;
    private CookieManager cookieManager;
    private boolean first = true;
    private int timeout = 0;

    private static void getParsers() {
        String[] parsers;
        for (String parser : parsers = JOrphanUtils.split((String)RESPONSE_PARSERS, (String)" ", (boolean)true)) {
            String classname = JMeterUtils.getProperty((String)(parser + ".className"));
            if (classname == null) {
                LOG.error("Cannot find .className property for " + parser + ", ensure you set property:'" + parser + ".className'");
                continue;
            }
            String typeList = JMeterUtils.getProperty((String)(parser + ".types"));
            if (typeList != null) {
                String[] types;
                for (String type : types = JOrphanUtils.split((String)typeList, (String)" ", (boolean)true)) {
                    LOG.info("Parser for " + type + " is " + classname);
                    PARSERS_FOR_CONTENT_TYPE.put(type, classname);
                }
                continue;
            }
            LOG.warn("Cannot find .types property for " + parser + ", as a consequence parser will not be used, to make it usable, define property:'" + parser + ".types'");
        }
    }

    public HTTP2StreamHandler(HTTP2Connection parent, HeaderManager headerManager, CookieManager cookieManager, HTTP2SampleResult sampleResult) {
        this.result = sampleResult;
        this.parent = parent;
        this.cookieManager = cookieManager;
        this.headerManager = headerManager;
    }

    public CompletableFuture<Void> getCompletedFuture() {
        return this.completedFuture;
    }

    public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
        MetaData.Request requestMetadata = (MetaData.Request)frame.getMetaData();
        URL url = null;
        try {
            url = requestMetadata.getURI().toURI().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOG.error("Failed when parsed Push URL", (Throwable)e);
        }
        HTTP2SampleResult sampleSubResult = this.result.createSubResult();
        sampleSubResult.setSampleLabel(url.toString());
        sampleSubResult.setURL(url);
        sampleSubResult.setHTTPMethod(requestMetadata.getMethod());
        for (HttpField h : requestMetadata.getFields()) {
            switch (h.getName()) {
                case "Content-Type": 
                case "content-type": {
                    sampleSubResult.setContentType(h.getValue());
                    sampleSubResult.setEncodingAndType(h.getValue());
                    break;
                }
                case "content-encoding": {
                    sampleSubResult.setDataEncoding(h.getValue());
                }
            }
        }
        String rawHeaders = requestMetadata.getFields().toString();
        String headers = rawHeaders.replaceAll("\r\n", "\n");
        sampleSubResult.setRequestHeaders(headers);
        sampleSubResult.sampleStart();
        sampleSubResult.setSync(this.result.isSync());
        this.result.addSubResult((SampleResult)sampleSubResult);
        HTTP2StreamHandler hTTP2StreamHandler = new HTTP2StreamHandler(this.parent, this.headerManager, this.cookieManager, sampleSubResult);
        this.parent.addStreamHandler(hTTP2StreamHandler);
        hTTP2StreamHandler.setTimeout(this.timeout);
        return hTTP2StreamHandler;
    }

    public void onHeaders(Stream stream, HeadersFrame frame) {
        MetaData.Response responseMetadata = (MetaData.Response)frame.getMetaData();
        this.result.setResponseCode(Integer.toString(responseMetadata.getStatus()));
        this.result.setResponseMessage(responseMetadata.getReason());
        for (HttpField h : frame.getMetaData().getFields()) {
            switch (h.getName()) {
                case "Content-Type": 
                case "content-type": {
                    this.result.setContentType(h.getValue());
                    this.result.setEncodingAndType(h.getValue());
                    break;
                }
                case "content-encoding": {
                    this.result.setDataEncoding(h.getValue());
                }
            }
        }
        String messageLine = responseMetadata.getHttpVersion() + " " + responseMetadata.getStatus() + " " + HttpStatus.getMessage((int)responseMetadata.getStatus());
        this.result.setResponseMessage(messageLine);
        String rawHeaders = frame.getMetaData().getFields().toString();
        String headers = rawHeaders.replaceAll("\r\n", "\n");
        String responseHeaders = messageLine + "\n" + headers.substring(0, headers.length() - 1);
        this.result.setResponseHeaders(responseHeaders);
        this.result.setHeadersSize(rawHeaders.length());
        this.result.setHttpFieldsResponse(frame.getMetaData().getFields());
    }

    public void onData(Stream stream, DataFrame frame, Callback callback) {
        callback.succeeded();
        byte[] bytes = new byte[frame.getData().remaining()];
        frame.getData().get(bytes);
        try {
            if (this.first) {
                this.result.latencyEnd();
                this.first = false;
            }
            this.setResponseBytes(bytes);
            if (frame.isEndStream()) {
                this.result.setSuccessful(this.isSuccessCode(Integer.parseInt(this.result.getResponseCode())));
                this.result.setResponseData(this.responseBytes);
                if (this.result.isRedirect()) {
                    // empty if block
                }
                if (this.result.isEmbebedResults() && this.result.getEmbebedResultsDepth() > 0 && this.result.getDataType().equals("text")) {
                    this.getPageResources(this.result);
                }
                if (this.result.isSecondaryRequest()) {
                    HTTP2SampleResult parent;
                    this.setParentSampleSuccess(parent, (parent = (HTTP2SampleResult)this.result.getParent()).isSuccessful() && (this.result == null || this.result.isSuccessful()));
                }
                this.completeStream();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onReset(Stream stream, ResetFrame frame) {
        this.result.setResponseCode(String.valueOf(frame.getError()));
        this.result.setResponseMessage(ErrorCode.from((int)frame.getError()).name());
        this.result.setSuccessful(frame.getError() == ErrorCode.NO_ERROR.code || frame.getError() == ErrorCode.CANCEL_STREAM_ERROR.code);
        this.completeStream();
    }

    private void setParentSampleSuccess(HTTP2SampleResult res, boolean initialValue) {
        if (!IGNORE_FAILED_EMBEDDED_RESOURCES) {
            res.setSuccessful(initialValue);
            if (!initialValue) {
                StringBuilder detailedMessage = new StringBuilder(80);
                detailedMessage.append("Embedded resource download error:");
                for (SampleResult subResult : res.getSubResults()) {
                    HTTP2SampleResult httpSampleResult = (HTTP2SampleResult)subResult;
                    if (httpSampleResult.isSuccessful()) continue;
                    detailedMessage.append(httpSampleResult.getURL()).append(" code:").append(httpSampleResult.getResponseCode()).append(" message:").append(httpSampleResult.getResponseMessage()).append(", ");
                }
                res.setResponseMessage(detailedMessage.toString());
            }
        }
    }

    private void setResponseBytes(byte[] bytes) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            if (this.responseBytes != null) {
                outputStream.write(this.responseBytes);
            }
            outputStream.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.responseBytes = outputStream.toByteArray();
    }

    private URL escapeIllegalURLCharacters(URL url) {
        if (url == null || url.getProtocol().equals("file")) {
            return url;
        }
        try {
            return ConversionUtils.sanitizeUrl((URL)url).toURL();
        }
        catch (Exception e1) {
            return url;
        }
    }

    private void getPageResources(HTTP2SampleResult res) throws Exception {
        Iterator urls = null;
        try {
            LinkExtractorParser parser;
            byte[] responseData = res.getResponseData();
            if (responseData.length > 0 && (parser = this.getParser(res)) != null) {
                String userAgent = this.getUserAgent(res);
                String encoding = res.getDataEncodingWithDefault();
                urls = parser.getEmbeddedResourceURLs(userAgent, responseData, res.getURL(), encoding);
            }
        }
        catch (LinkExtractorParseException e) {
            HTTP2SampleResult subRes = new HTTP2SampleResult(res);
            subRes.setErrorResult("Error while getting the embebed resources", e);
            this.setParentSampleSuccess(res, false);
        }
        if (urls != null && urls.hasNext()) {
            String re = res.getEmbeddedUrlRE();
            Perl5Matcher localMatcher = null;
            Pattern pattern = null;
            if (re.length() > 0) {
                try {
                    pattern = JMeterUtils.getPattern((String)re);
                    localMatcher = JMeterUtils.getMatcher();
                }
                catch (MalformedCachePatternException encoding) {
                    // empty catch block
                }
            }
            while (urls.hasNext()) {
                URL url = (URL)urls.next();
                try {
                    url = this.escapeIllegalURLCharacters(url);
                }
                catch (Exception e) {
                    res.addSubResult((SampleResult)HTTP2SampleResult.createErrorResult(url.toString() + " is not a correct URI", e));
                    this.setParentSampleSuccess(res, false);
                    continue;
                }
                if (pattern != null && localMatcher != null && !localMatcher.matches(url.toString(), pattern)) continue;
                try {
                    url = url.toURI().normalize().toURL();
                }
                catch (MalformedURLException | URISyntaxException e) {
                    res.addSubResult((SampleResult)HTTP2SampleResult.createErrorResult(url.toString() + " URI can not be normalized", e));
                    this.setParentSampleSuccess(res, false);
                    continue;
                }
                HTTP2SampleResult subResult = this.result.createSubResult();
                subResult.setSampleLabel(url.toString());
                subResult.setSync(res.isSync());
                res.addSubResult((SampleResult)subResult);
                this.parent.send("GET", url, this.headerManager, this.cookieManager, null, subResult, this.timeout);
            }
        }
    }

    private LinkExtractorParser getParser(HTTP2SampleResult res) throws LinkExtractorParseException {
        String parserClassName = PARSERS_FOR_CONTENT_TYPE.get(res.getMediaType());
        if (!StringUtils.isEmpty((CharSequence)parserClassName)) {
            return BaseParser.getParser((String)parserClassName);
        }
        return null;
    }

    private String getUserAgent(HTTP2SampleResult sampleResult) {
        String res = sampleResult.getRequestHeaders();
        int index = res.indexOf(USER_AGENT);
        if (index >= 0) {
            String userAgentPrefix = "User-Agent: ";
            String userAgentHdr = res.substring(index + "User-Agent: ".length(), res.indexOf(10, index + "User-Agent: ".length() + 1));
            return userAgentHdr.trim();
        }
        return null;
    }

    protected boolean isSuccessCode(int code) {
        return code >= 200 && code <= 399;
    }

    protected HTTP2SampleResult getHTTP2SampleResult() {
        return this.result;
    }

    protected int getTimeout() {
        return this.timeout;
    }

    protected void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private void completeStream() {
        this.result.sampleEnd();
        this.result.setPendingResponse(false);
        if (!this.result.isSync()) {
            this.result.completeAsyncSample();
        }
        this.completedFuture.complete(null);
    }

    static {
        HTTP2StreamHandler.getParsers();
    }
}

