/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.http2.sampler.gui;

import com.blazemeter.jmeter.http2.sampler.HTTP2Request;
import com.blazemeter.jmeter.http2.sampler.gui.BlazemeterLabsLogo;
import com.blazemeter.jmeter.http2.sampler.gui.HTTP2RequestPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

public class HTTP2RequestGui
extends AbstractSamplerGui {
    private JCheckBox retrieveEmbeddedResources;
    private HTTP2RequestPanel http2RequestPanel;
    private JCheckBox useMD5;
    private JLabeledTextField embeddedResourceUrlRegexFilter;
    private JTextField sourceIpAddr;
    private JComboBox<String> sourceIpType = new JComboBox<String>(HTTPSamplerBase.getSourceTypeList());

    public HTTP2RequestGui() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        JPanel logoPanel = new JPanel();
        logoPanel.add(new BlazemeterLabsLogo());
        this.http2RequestPanel = new HTTP2RequestPanel(true);
        VerticalPanel advancedPanel = new VerticalPanel();
        advancedPanel.add(this.createEmbeddedRsrcPanel());
        advancedPanel.add(this.createSourceAddrPanel());
        advancedPanel.add(this.createOptionalTasksPanel());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(JMeterUtils.getResString((String)"web_testing_basic"), this.http2RequestPanel);
        tabbedPane.add(JMeterUtils.getResString((String)"web_testing_advanced"), (Component)advancedPanel);
        this.add(this.makeTitlePanel(), "North");
        this.add(logoPanel, "South");
        this.add(tabbedPane, "Center");
    }

    private JPanel createEmbeddedRsrcPanel() {
        this.retrieveEmbeddedResources = new JCheckBox(JMeterUtils.getResString((String)"web_testing_retrieve_images"));
        HorizontalPanel embeddedRsrcPanel = new HorizontalPanel();
        embeddedRsrcPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_testing_retrieve_title")));
        embeddedRsrcPanel.add(this.retrieveEmbeddedResources);
        this.embeddedResourceUrlRegexFilter = new JLabeledTextField(JMeterUtils.getResString((String)"web_testing_embedded_url_pattern"), 20);
        embeddedRsrcPanel.add((Component)this.embeddedResourceUrlRegexFilter);
        return embeddedRsrcPanel;
    }

    private JPanel createSourceAddrPanel() {
        HorizontalPanel sourceAddrPanel = new HorizontalPanel();
        sourceAddrPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_testing_source_ip")));
        this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
        sourceAddrPanel.add(this.sourceIpType);
        this.sourceIpAddr = new JTextField();
        sourceAddrPanel.add(this.sourceIpAddr);
        return sourceAddrPanel;
    }

    private JPanel createOptionalTasksPanel() {
        VerticalPanel checkBoxPanel = new VerticalPanel();
        checkBoxPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"optional_tasks")));
        this.useMD5 = new JCheckBox(JMeterUtils.getResString((String)"response_save_as_md5"));
        checkBoxPanel.add(this.useMD5);
        return checkBoxPanel;
    }

    public String getStaticLabel() {
        return "HTTP2 Request";
    }

    public String getLabelResource() {
        return "HTTP2 Request";
    }

    public TestElement createTestElement() {
        HTTP2Request sampler = new HTTP2Request();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void configure(TestElement element) {
        super.configure(element);
        HTTP2Request http2sampler = (HTTP2Request)element;
        this.http2RequestPanel.configure(element);
        this.retrieveEmbeddedResources.setSelected(http2sampler.isEmbeddedResources());
        this.embeddedResourceUrlRegexFilter.setText(http2sampler.getEmbeddedUrlRE());
    }

    public void modifyTestElement(TestElement sampler) {
        sampler.clear();
        this.http2RequestPanel.modifyTestElement(sampler);
        HTTP2Request http2Sample = (HTTP2Request)sampler;
        http2Sample.setEmbeddedResources(this.retrieveEmbeddedResources.isSelected());
        http2Sample.setEmbeddedUrlRE(this.embeddedResourceUrlRegexFilter.getText());
        super.configureTestElement(sampler);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void clearGui() {
        super.clearGui();
        this.retrieveEmbeddedResources.setSelected(false);
        this.useMD5.setSelected(false);
        this.embeddedResourceUrlRegexFilter.setText("");
        this.sourceIpAddr.setText("");
        this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
        this.http2RequestPanel.clear();
    }
}

