/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.http2.sampler.gui;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.protocol.http.gui.HTTPArgumentsPanel;
import org.apache.jmeter.protocol.http.gui.HTTPFileArgsPanel;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;

public class HTTP2RequestPanel
extends JPanel {
    private static final int TAB_PARAMETERS = 0;
    private HTTPArgumentsPanel argsPanel;
    private int tabRawBodyIndex = 1;
    private int tabFileUploadIndex = 2;
    private HTTPFileArgsPanel filesPanel;
    private JPanel webRequestPanel = new JPanel();
    private JPanel webServerPanel = new JPanel();
    private JPanel timeoutPanel = new JPanel();
    private JLabel requestIdLabel = new JLabel();
    private JLabel contentEncodingLabel = new JLabel();
    private JLabel contextPathLabel = new JLabel();
    private JLabel protocolLabel = new JLabel();
    private JLabel responseTimeoutLabel = new JLabel();
    private JLabel domainLabel = new JLabel();
    private JLabel portLabel = new JLabel();
    private JTextField requestId = new JTextField();
    private JTextField contentEncoding = new JTextField();
    private JTextField path = new JTextField();
    private JTextField protocol = new JTextField();
    private JPanel parametersPanel = new JPanel();
    private JTextField responseTimeout = new JTextField();
    private JTextField domain = new JTextField(20);
    private JTextField port = new JTextField();
    private JCheckBox autoRedirects = new JCheckBox();
    private JCheckBox followRedirects = new JCheckBox();
    private JCheckBox syncRequest = new JCheckBox();
    private JLabel methodLabel = new JLabel();
    private JComboBox<String> method = new JComboBox();
    private JLabel http2ImplementationLabel = new JLabel();
    private JComboBox<String> http2Implementation = new JComboBox();
    private ValidationTabbedPane postContentTabbedPane;
    private final boolean notConfigOnly;
    private JSyntaxTextArea postBodyContent;
    private boolean showFileUploadPane;

    public HTTP2RequestPanel(boolean showSamplerFields) {
        this(showSamplerFields, false);
    }

    private HTTP2RequestPanel(boolean showSamplerFields, boolean showFileUploadPane) {
        this.notConfigOnly = showSamplerFields;
        this.showFileUploadPane = showFileUploadPane;
        this.init();
    }

    private void init() {
        this.initComponents();
        this.postContentTabbedPane = new ValidationTabbedPane();
        this.argsPanel = new HTTPArgumentsPanel();
        this.postContentTabbedPane.add(JMeterUtils.getResString((String)"post_as_parameters"), (Component)this.argsPanel);
        int indx = 0;
        ++indx;
        this.tabRawBodyIndex = indx++;
        this.postBodyContent = JSyntaxTextArea.getInstance((int)30, (int)50);
        this.postContentTabbedPane.add(JMeterUtils.getResString((String)"post_body"), (Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.postBodyContent));
        this.tabFileUploadIndex = indx;
        this.filesPanel = new HTTPFileArgsPanel();
        this.postContentTabbedPane.add(JMeterUtils.getResString((String)"post_files_upload"), (Component)this.filesPanel);
        this.parametersPanel.add(this.postContentTabbedPane);
    }

    private void initComponents() {
        String[] methodList;
        this.domainLabel.setText(JMeterUtils.getResString((String)"web_server_domain"));
        this.portLabel.setText("Port Number:");
        this.webServerPanel.setBorder(BorderFactory.createTitledBorder("Web Server"));
        GroupLayout webServerPanelLayout = new GroupLayout(this.webServerPanel);
        this.webServerPanel.setLayout(webServerPanelLayout);
        webServerPanelLayout.setHorizontalGroup(webServerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(webServerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.domainLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.domain).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.portLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.port, -2, 43, -2).addContainerGap()));
        webServerPanelLayout.setVerticalGroup(webServerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(webServerPanelLayout.createSequentialGroup().addContainerGap().addGroup(webServerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.domainLabel).addComponent(this.domain, -2, -1, -2).addComponent(this.portLabel).addComponent(this.port, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.timeoutPanel.setBorder(BorderFactory.createTitledBorder("Timeout (miliseconds)"));
        this.responseTimeoutLabel.setText("Response:");
        GroupLayout timeoutPanelLayout = new GroupLayout(this.timeoutPanel);
        this.timeoutPanel.setLayout(timeoutPanelLayout);
        timeoutPanelLayout.setHorizontalGroup(timeoutPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timeoutPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.responseTimeoutLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.responseTimeout).addContainerGap()));
        timeoutPanelLayout.setVerticalGroup(timeoutPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timeoutPanelLayout.createSequentialGroup().addContainerGap().addGroup(timeoutPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.responseTimeoutLabel).addComponent(this.responseTimeout, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.requestIdLabel.setText("Request Id:");
        this.contentEncodingLabel.setText("Content encoding:");
        this.contextPathLabel.setText("Path:");
        this.protocolLabel.setText("Protocol [http/https]:");
        this.methodLabel.setText("Method:");
        for (String aMethodList : methodList = HTTPSamplerBase.getValidMethodsAsArray()) {
            this.method.addItem(aMethodList);
        }
        this.http2ImplementationLabel.setText(JMeterUtils.getResString((String)"http_implementation"));
        this.http2Implementation.addItem("Jetty");
        this.webRequestPanel.setBorder(BorderFactory.createTitledBorder("HTTP Request"));
        this.protocol.setToolTipText("");
        this.parametersPanel.setLayout(new BoxLayout(this.parametersPanel, 2));
        this.autoRedirects.setText("Redirect Automatically");
        this.followRedirects.setText("Follow Redirects");
        this.syncRequest.setText("Synchronized Request");
        GroupLayout webRequestPanelLayout = new GroupLayout(this.webRequestPanel);
        this.webRequestPanel.setLayout(webRequestPanelLayout);
        if (this.notConfigOnly) {
            webRequestPanelLayout.setHorizontalGroup(webRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(webRequestPanelLayout.createSequentialGroup().addContainerGap().addGroup(webRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.parametersPanel, -1, -1, Short.MAX_VALUE).addGroup(webRequestPanelLayout.createSequentialGroup().addComponent(this.http2ImplementationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.http2Implementation).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.protocolLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.protocol, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.methodLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.method, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.contentEncodingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contentEncoding, -2, 40, -2)).addGroup(webRequestPanelLayout.createSequentialGroup().addGroup(webRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(webRequestPanelLayout.createSequentialGroup().addComponent(this.autoRedirects).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.followRedirects).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.syncRequest).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addGap(0, 0, Short.MAX_VALUE)).addGroup(webRequestPanelLayout.createSequentialGroup().addComponent(this.contextPathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.path))).addContainerGap()));
            webRequestPanelLayout.setVerticalGroup(webRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(webRequestPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(webRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.http2ImplementationLabel).addComponent(this.http2Implementation).addComponent(this.protocolLabel).addComponent(this.protocol).addComponent(this.methodLabel).addComponent(this.method).addComponent(this.contentEncodingLabel).addComponent(this.contentEncoding)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(webRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.contextPathLabel).addComponent(this.path, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(webRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoRedirects).addComponent(this.followRedirects).addComponent(this.syncRequest)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.parametersPanel, -1, 102, Short.MAX_VALUE).addContainerGap()));
        } else {
            webRequestPanelLayout.setHorizontalGroup(webRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(webRequestPanelLayout.createSequentialGroup().addContainerGap().addGroup(webRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.parametersPanel, -1, -1, Short.MAX_VALUE).addGroup(webRequestPanelLayout.createSequentialGroup().addComponent(this.http2ImplementationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.http2Implementation).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.protocolLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.protocol, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.contentEncodingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contentEncoding, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)).addGroup(webRequestPanelLayout.createSequentialGroup().addGroup(webRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(webRequestPanelLayout.createSequentialGroup().addComponent(this.syncRequest).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addGap(0, 0, Short.MAX_VALUE)).addGroup(webRequestPanelLayout.createSequentialGroup().addComponent(this.contextPathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.path))).addContainerGap()));
            webRequestPanelLayout.setVerticalGroup(webRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(webRequestPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(webRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.http2ImplementationLabel).addComponent(this.http2Implementation).addComponent(this.protocolLabel).addComponent(this.protocol).addComponent(this.contentEncodingLabel).addComponent(this.contentEncoding)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(webRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.contextPathLabel).addComponent(this.path, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(webRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.syncRequest)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.parametersPanel, -1, 102, Short.MAX_VALUE).addContainerGap()));
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.webRequestPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.webServerPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeoutPanel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.timeoutPanel, -2, -1, -2).addComponent(this.webServerPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.webRequestPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private boolean noData(int oldSelectedIndex) {
        if (oldSelectedIndex == this.tabRawBodyIndex) {
            return StringUtils.isEmpty((CharSequence)this.postBodyContent.getText().trim());
        }
        Arguments element = (Arguments)this.argsPanel.createTestElement();
        return !this.filesPanel.hasData() && StringUtils.isEmpty((CharSequence)HTTP2RequestPanel.computePostBody(element));
    }

    private static String computePostBody(Arguments arguments) {
        return HTTP2RequestPanel.computePostBody(arguments, false);
    }

    private boolean canConvertParameters() {
        Arguments arguments = (Arguments)this.argsPanel.createTestElement();
        for (int i = 0; i < arguments.getArgumentCount(); ++i) {
            if (StringUtils.isEmpty((CharSequence)arguments.getArgument(i).getName())) continue;
            return false;
        }
        return true;
    }

    private void convertParametersToRawBody() {
        this.postBodyContent.setInitialText(HTTP2RequestPanel.computePostBody((Arguments)this.argsPanel.createTestElement()));
        this.postBodyContent.setCaretPosition(0);
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        element.setName(this.getName());
        element.setProperty("TestElement.gui_class", this.getClass().getName());
        element.setProperty("TestElement.test_class", element.getClass().getName());
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        Arguments args;
        boolean useRaw;
        boolean bl = useRaw = this.postContentTabbedPane.getSelectedIndex() == this.tabRawBodyIndex;
        if (useRaw) {
            args = new Arguments();
            String text = this.postBodyContent.getText();
            HTTPArgument arg = new HTTPArgument("", text.replaceAll("\n", "\r\n"), false);
            arg.setAlwaysEncoded(false);
            args.addArgument((Argument)arg);
        } else {
            args = (Arguments)this.argsPanel.createTestElement();
            HTTPArgument.convertArgumentsToHTTP((Arguments)args);
            if (this.showFileUploadPane) {
                this.filesPanel.modifyTestElement(element);
            }
        }
        element.setProperty("HTTP2Request.postBodyRaw", useRaw, false);
        element.setProperty((JMeterProperty)new TestElementProperty("HTTP2Request.Arguments", (TestElement)args));
        element.setProperty("HTTP2Request.domain", this.domain.getText());
        element.setProperty("HTTPSampler.port", this.port.getText());
        element.setProperty("HTTP2Request.response_timeout", this.responseTimeout.getText());
        element.setProperty("HTTP2Request.protocol", this.protocol.getText());
        element.setProperty("HTTP2Request.contentEncoding", this.contentEncoding.getText());
        element.setProperty("HTTP2Request.path", this.path.getText());
        if (this.notConfigOnly) {
            element.setProperty("HTTP2Sampler.method", (String)this.method.getSelectedItem());
            element.setProperty((JMeterProperty)new BooleanProperty("HTTP2Request.follow_redirects", this.followRedirects.isSelected()));
            element.setProperty((JMeterProperty)new BooleanProperty("HTTP2Request.auto_redirects", this.autoRedirects.isSelected()));
            element.setProperty("HTTP2Request.request_id", this.requestId.getText());
        }
        if (this.syncRequest.isSelected()) {
            element.setProperty((JMeterProperty)new BooleanProperty("HTTP2Request.sync_request", true));
        } else {
            element.removeProperty("HTTP2Request.sync_request");
        }
    }

    public void configure(TestElement el) {
        this.setName(el.getName());
        Arguments arguments = (Arguments)el.getProperty("HTTP2Request.Arguments").getObjectValue();
        boolean useRaw = el.getPropertyAsBoolean("HTTP2Request.postBodyRaw", false);
        if (useRaw) {
            String postBody = HTTP2RequestPanel.computePostBody(arguments, true);
            this.postBodyContent.setInitialText(postBody);
            this.postBodyContent.setCaretPosition(0);
            this.postContentTabbedPane.setSelectedIndex(this.tabRawBodyIndex, false);
        } else {
            this.argsPanel.configure((TestElement)arguments);
            this.postContentTabbedPane.setSelectedIndex(0, false);
            if (this.showFileUploadPane) {
                this.filesPanel.configure(el);
            }
        }
        this.domain.setText(el.getPropertyAsString("HTTP2Request.domain"));
        String portString = el.getPropertyAsString("HTTPSampler.port");
        if (portString.equals("0")) {
            this.port.setText("");
        } else {
            this.port.setText(portString);
        }
        this.responseTimeout.setText(el.getPropertyAsString("HTTP2Request.response_timeout"));
        this.protocol.setText(el.getPropertyAsString("HTTP2Request.protocol"));
        this.contentEncoding.setText(el.getPropertyAsString("HTTP2Request.contentEncoding"));
        this.path.setText(el.getPropertyAsString("HTTP2Request.path"));
        if (this.notConfigOnly) {
            this.method.setSelectedItem(el.getPropertyAsString("HTTP2Sampler.method"));
            this.followRedirects.setSelected(el.getPropertyAsBoolean("HTTP2Request.follow_redirects"));
            this.autoRedirects.setSelected(el.getPropertyAsBoolean("HTTP2Request.auto_redirects"));
            this.requestId.setText(el.getPropertyAsString("HTTP2Request.request_id"));
        }
        this.syncRequest.setSelected(el.getPropertyAsBoolean("HTTP2Request.sync_request"));
    }

    private static String computePostBody(Arguments arguments, boolean crlfToLF) {
        StringBuilder postBody = new StringBuilder();
        for (JMeterProperty argument : arguments) {
            HTTPArgument arg = (HTTPArgument)argument.getObjectValue();
            String value = arg.getValue();
            if (crlfToLF) {
                value = value.replaceAll("\r\n", "\n");
            }
            postBody.append(value);
        }
        return postBody.toString();
    }

    public void clear() {
        this.domain.setText("");
        this.port.setText("");
        this.responseTimeout.setText("");
        this.http2Implementation.setSelectedItem("");
        this.protocol.setText("");
        this.http2Implementation.setSelectedItem("GET");
        this.contentEncoding.setText("");
        this.requestId.setText("");
        this.path.setText("");
        this.syncRequest.setSelected(false);
        this.argsPanel.clear();
        this.postBodyContent.setInitialText("");
        this.filesPanel.clear();
        this.postContentTabbedPane.setSelectedIndex(0, false);
        if (this.notConfigOnly) {
            this.followRedirects.setSelected(true);
            this.autoRedirects.setSelected(false);
            this.method.setSelectedItem("GET");
        }
    }

    class ValidationTabbedPane
    extends JTabbedPane {
        private static final long serialVersionUID = 7014311238367882880L;

        ValidationTabbedPane() {
        }

        @Override
        public void setSelectedIndex(int index) {
            this.setSelectedIndex(index, true);
        }

        private void setSelectedIndex(int index, boolean check) {
            int oldSelectedIndex = this.getSelectedIndex();
            if (!check || oldSelectedIndex == -1) {
                super.setSelectedIndex(index);
            } else if (index != oldSelectedIndex) {
                if (HTTP2RequestPanel.this.noData(oldSelectedIndex)) {
                    HTTP2RequestPanel.this.argsPanel.clear();
                    HTTP2RequestPanel.this.postBodyContent.setInitialText("");
                    HTTP2RequestPanel.this.filesPanel.clear();
                    super.setSelectedIndex(index);
                } else {
                    boolean filePanelHasData = HTTP2RequestPanel.this.filesPanel.hasData();
                    if (oldSelectedIndex == HTTP2RequestPanel.this.tabRawBodyIndex) {
                        if (index == 0 && HTTP2RequestPanel.this.postBodyContent.getText().equals(HTTP2RequestPanel.computePostBody((Arguments)HTTP2RequestPanel.this.argsPanel.createTestElement()).trim())) {
                            super.setSelectedIndex(index);
                        } else {
                            JOptionPane.showConfirmDialog(this, JMeterUtils.getResString((String)"web_cannot_switch_tab"), JMeterUtils.getResString((String)"warning"), -1, 0);
                        }
                    } else {
                        if (oldSelectedIndex == 0 && index == HTTP2RequestPanel.this.tabFileUploadIndex || oldSelectedIndex == HTTP2RequestPanel.this.tabFileUploadIndex && index == 0) {
                            super.setSelectedIndex(index);
                            return;
                        }
                        if (oldSelectedIndex == 0 && !filePanelHasData && HTTP2RequestPanel.this.canConvertParameters()) {
                            Object[] options = new Object[]{JMeterUtils.getResString((String)"confirm"), JMeterUtils.getResString((String)"cancel")};
                            int n = JOptionPane.showOptionDialog(this, JMeterUtils.getResString((String)"web_parameters_lost_message"), JMeterUtils.getResString((String)"warning"), 1, 3, null, options, options[1]);
                            if (n == 0) {
                                HTTP2RequestPanel.this.convertParametersToRawBody();
                                super.setSelectedIndex(index);
                            }
                        } else {
                            String messageKey = filePanelHasData ? "web_cannot_switch_tab" : "web_cannot_convert_parameters_to_raw";
                            JOptionPane.showConfirmDialog(this, JMeterUtils.getResString((String)messageKey), JMeterUtils.getResString((String)"warning"), -1, 0);
                        }
                    }
                }
            }
        }
    }
}

