/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.http2.sampler.gui;

import com.blazemeter.jmeter.http2.sampler.HTTP2Request;
import com.blazemeter.jmeter.http2.sampler.gui.BlazemeterLabsLogo;
import com.blazemeter.jmeter.http2.sampler.gui.HTTP2RequestPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

public class Http2DefaultsGui
extends AbstractConfigGui {
    private static final long serialVersionUID = 241L;
    private HTTP2RequestPanel http2RequestPanel;
    private JCheckBox retrieveEmbeddedResources;
    private JCheckBox useMD5;
    private JLabeledTextField embeddedResourceUrlRegexFilter;
    private JTextField sourceIpAddr;
    private JComboBox<String> sourceIpType = new JComboBox<String>(HTTPSamplerBase.getSourceTypeList());

    public Http2DefaultsGui() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.http2RequestPanel = new HTTP2RequestPanel(false);
        VerticalPanel advancedPanel = new VerticalPanel();
        advancedPanel.add(this.createEmbeddedRsrcPanel());
        advancedPanel.add(this.createSourceAddrPanel());
        advancedPanel.add(this.createOptionalTasksPanel());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(JMeterUtils.getResString((String)"web_testing_basic"), this.http2RequestPanel);
        tabbedPane.add(JMeterUtils.getResString((String)"web_testing_advanced"), (Component)advancedPanel);
        JPanel logoPanel = new JPanel();
        logoPanel.add(new BlazemeterLabsLogo());
        this.add(this.makeTitlePanel(), "North");
        this.add(tabbedPane, "Center");
        this.add(logoPanel, "South");
    }

    private JPanel createEmbeddedRsrcPanel() {
        this.retrieveEmbeddedResources = new JCheckBox(JMeterUtils.getResString((String)"web_testing_retrieve_images"));
        HorizontalPanel embeddedRsrcPanel = new HorizontalPanel();
        embeddedRsrcPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_testing_retrieve_title")));
        embeddedRsrcPanel.add(this.retrieveEmbeddedResources);
        this.embeddedResourceUrlRegexFilter = new JLabeledTextField(JMeterUtils.getResString((String)"web_testing_embedded_url_pattern"), 20);
        embeddedRsrcPanel.add((Component)this.embeddedResourceUrlRegexFilter);
        return embeddedRsrcPanel;
    }

    private JPanel createSourceAddrPanel() {
        HorizontalPanel sourceAddrPanel = new HorizontalPanel();
        sourceAddrPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_testing_source_ip")));
        this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
        sourceAddrPanel.add(this.sourceIpType);
        this.sourceIpAddr = new JTextField();
        sourceAddrPanel.add(this.sourceIpAddr);
        return sourceAddrPanel;
    }

    private JPanel createOptionalTasksPanel() {
        VerticalPanel checkBoxPanel = new VerticalPanel();
        checkBoxPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"optional_tasks")));
        this.useMD5 = new JCheckBox(JMeterUtils.getResString((String)"response_save_as_md5"));
        checkBoxPanel.add(this.useMD5);
        return checkBoxPanel;
    }

    public String getLabelResource() {
        return "HTTP2 Request Defaults";
    }

    public String getStaticLabel() {
        return "HTTP2 Request Defaults";
    }

    public TestElement createTestElement() {
        ConfigTestElement config = new ConfigTestElement();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement config) {
        ConfigTestElement cfg = (ConfigTestElement)config;
        ConfigTestElement el = (ConfigTestElement)this.http2RequestPanel.createTestElement();
        cfg.clear();
        cfg.addConfigElement((ConfigElement)el);
        super.configureTestElement(config);
        if (this.retrieveEmbeddedResources.isSelected()) {
            config.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.embedded_resources", true));
        } else {
            config.removeProperty("HTTPSampler.embedded_resources");
        }
        if (this.useMD5.isSelected()) {
            config.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.md5", true));
        } else {
            config.removeProperty("HTTPSampler.md5");
        }
        if (!StringUtils.isEmpty((CharSequence)this.embeddedResourceUrlRegexFilter.getText())) {
            config.setProperty((JMeterProperty)new StringProperty("HTTPSampler.embedded_url_re", this.embeddedResourceUrlRegexFilter.getText()));
        } else {
            config.removeProperty("HTTPSampler.embedded_url_re");
        }
        if (!StringUtils.isEmpty((CharSequence)this.sourceIpAddr.getText())) {
            config.setProperty((JMeterProperty)new StringProperty("HTTP2Request.ipSource", this.sourceIpAddr.getText()));
            config.setProperty((JMeterProperty)new IntegerProperty("HTTP2Request.ipSourceType", this.sourceIpType.getSelectedIndex()));
        } else {
            config.removeProperty("HTTP2Request.ipSource");
            config.removeProperty("HTTP2Request.ipSourceType");
        }
    }

    public void clearGui() {
        super.clearGui();
        this.retrieveEmbeddedResources.setSelected(false);
        this.useMD5.setSelected(false);
        this.http2RequestPanel.clear();
        this.embeddedResourceUrlRegexFilter.setText("");
        this.sourceIpAddr.setText("");
        this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
    }

    public void configure(TestElement el) {
        super.configure(el);
        AbstractTestElement http2Sampler = (AbstractTestElement)el;
        this.http2RequestPanel.configure(el);
        this.retrieveEmbeddedResources.setSelected(http2Sampler.getPropertyAsBoolean("HTTPSampler.embedded_resources"));
        this.useMD5.setSelected(http2Sampler.getPropertyAsBoolean("HTTPSampler.md5", false));
        this.embeddedResourceUrlRegexFilter.setText(http2Sampler.getPropertyAsString("HTTPSampler.embedded_url_re", ""));
        this.sourceIpAddr.setText(http2Sampler.getPropertyAsString("HTTP2Request.ipSource"));
        this.sourceIpType.setSelectedIndex(http2Sampler.getPropertyAsInt("HTTP2Request.ipSourceType", HTTP2Request.SOURCE_TYPE_DEFAULT));
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

