/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.controller;

import com.blazemeter.jmeter.controller.DummyThreadGroup;
import com.blazemeter.jmeter.controller.ParallelSampler;
import com.blazemeter.jmeter.controller.TestCompilerParallel;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterContextServiceAccessorParallel;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.TestCompiler;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMeterThreadParallel
extends JMeterThread {
    private static final Logger log = LoggerFactory.getLogger(ParallelSampler.class);
    private TestCompilerParallel parallelCompiler;
    private boolean generateParent;

    public JMeterThreadParallel(HashTree test, JMeterThreadMonitor monitor, ListenerNotifier notifier, boolean generateParent) {
        super(test, monitor, notifier);
        this.generateParent = generateParent;
        this.setThreadGroup(new DummyThreadGroup());
        try {
            this.copyCompilerFromParent();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    protected void copyCompilerFromParent() throws IllegalAccessException, NoSuchFieldException {
        Field field = JMeterThread.class.getDeclaredField("compiler");
        field.setAccessible(true);
        JMeterThread parentThread = JMeterContextService.getContext().getThread();
        if (parentThread == null) {
            throw new NullPointerException();
        }
        TestCompiler parentCompiler = (TestCompiler)field.get(parentThread);
        this.parallelCompiler = this.cloneTestCompiler(parentCompiler);
        field.set((Object)this, (Object)this.parallelCompiler);
    }

    private TestCompilerParallel cloneTestCompiler(TestCompiler parent) throws NoSuchFieldException, IllegalAccessException {
        TestCompilerParallel cloned = new TestCompilerParallel(new HashTree(), this.generateParent);
        Field samplerConfigMap = TestCompiler.class.getDeclaredField("samplerConfigMap");
        samplerConfigMap.setAccessible(true);
        samplerConfigMap.set((Object)cloned, ((HashMap)samplerConfigMap.get(parent)).clone());
        Field transactionControllerConfigMap = TestCompiler.class.getDeclaredField("transactionControllerConfigMap");
        transactionControllerConfigMap.setAccessible(true);
        transactionControllerConfigMap.set((Object)cloned, ((HashMap)transactionControllerConfigMap.get(parent)).clone());
        return cloned;
    }

    public TestCompilerParallel getParallelCompiler() {
        return this.parallelCompiler;
    }

    public void run() {
        JMeterContextServiceAccessorParallel.decrNumberOfThreads();
        super.run();
    }
}

