/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.controller;

import com.blazemeter.jmeter.controller.DummyThreadGroup;
import com.blazemeter.jmeter.controller.JMeterThreadParallel;
import com.blazemeter.jmeter.controller.ParallelListenerNotifier;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextServiceAccessorParallel;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelSampler
extends AbstractSampler
implements Controller,
ThreadListener,
Interruptible,
JMeterThreadMonitor,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(ParallelSampler.class);
    private static final String GENERATE_PARENT = "PARENT_SAMPLE";
    protected List<TestElement> controllers = new ArrayList<TestElement>();
    protected final ParallelListenerNotifier notifier = new ParallelListenerNotifier();
    private ExecutorService executorService;

    public void addTestElement(TestElement te) {
        if (te instanceof Controller || te instanceof Sampler) {
            this.controllers.add(te);
        }
        log.debug("Added {}, list size: {}", (Object)te, (Object)this.controllers.size());
    }

    public void setRunningVersion(boolean runningVersion) {
        super.setRunningVersion(runningVersion);
        for (TestElement ctl : this.controllers) {
            ctl.setRunningVersion(runningVersion);
        }
    }

    public SampleResult sample(Entry e) {
        SampleResult res = new SampleResult();
        res.setResponseCode("200");
        res.setResponseMessage("OK");
        res.setSuccessful(true);
        res.setSampleLabel(this.getName());
        res.setResponseData("".getBytes());
        this.notifier.setContainer(res);
        LinkedList<JMeterThreadParallel> jMeterThreads = new LinkedList<JMeterThreadParallel>();
        StringBuilder reqText = new StringBuilder("Parallel items:\n");
        for (TestElement ctl : this.controllers) {
            reqText.append(ctl.getName()).append("\n");
            JMeterThreadParallel jMeterThreadParallel = new JMeterThreadParallel(this.getTestTree(ctl), this, this.notifier, this.getGenerateParent());
            jMeterThreadParallel.setThreadName("parallel " + this.getName());
            jMeterThreadParallel.setThreadGroup(new DummyThreadGroup());
            this.injectVariables(jMeterThreadParallel, this.getThreadContext());
            jMeterThreads.add(jMeterThreadParallel);
        }
        res.setSamplerData(reqText.toString());
        res.sampleStart();
        LinkedList futures = new LinkedList();
        for (JMeterThread jMeterThread : jMeterThreads) {
            futures.add(this.executorService.submit((Runnable)jMeterThread));
        }
        for (Future future : futures) {
            try {
                future.get();
                log.debug("Thread is done {}", (Object)future.isDone());
            }
            catch (InterruptedException | ExecutionException e1) {
                log.debug("Interrupted {}", (Object)future.isCancelled());
            }
        }
        if (res.getEndTime() == 0L) {
            res.sampleEnd();
        }
        return this.getGenerateParent() ? res : null;
    }

    private HashTree getTestTree(TestElement te) {
        LoopController wrapper = new LoopController();
        wrapper.setLoops(1);
        wrapper.setContinueForever(false);
        wrapper.addTestElement(te);
        wrapper.setName("wrapped " + te.getName());
        wrapper.setRunningVersion(this.isRunningVersion());
        HashTree tree = new HashTree();
        tree.add((Object)wrapper);
        return tree;
    }

    public boolean interrupt() {
        this.executorService.shutdown();
        return true;
    }

    public Sampler next() {
        return null;
    }

    public boolean isDone() {
        return true;
    }

    public void initialize() {
        log.debug("Initialize");
    }

    public void triggerEndOfLoop() {
        log.debug("Trigger End of loop");
    }

    public void threadFinished(JMeterThread thread) {
        JMeterContextServiceAccessorParallel.incrNumberOfThreads();
        try {
            Field field = AbstractTestElement.class.getDeclaredField("threadContext");
            field.setAccessible(true);
            if (thread instanceof JMeterThreadParallel) {
                JMeterThreadParallel pthr = (JMeterThreadParallel)thread;
                for (TestElement testElement : pthr.getParallelCompiler().getKnownElements()) {
                    field.set(testElement, null);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.warn("Failed to reset context", (Throwable)e);
        }
    }

    public void addIterationListener(LoopIterationListener listener) {
    }

    public void removeIterationListener(LoopIterationListener iterationListener) {
    }

    public boolean getGenerateParent() {
        return this.getPropertyAsBoolean(GENERATE_PARENT);
    }

    public void setGenerateParent(boolean value) {
        this.setProperty(GENERATE_PARENT, value);
    }

    private void injectVariables(JMeterThread jmThread, JMeterContext threadContext) {
        if (threadContext != null && threadContext.getVariables() != null) {
            try {
                Class<JMeterThread> cls = JMeterThread.class;
                Field vars = cls.getDeclaredField("threadVars");
                vars.setAccessible(true);
                vars.set(jmThread, threadContext.getVariables());
            }
            catch (Throwable ex) {
                log.warn("Cannot inject variables into parallel thread ", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeVariablesMap() {
        block8: {
            try {
                Object obj;
                JMeterContext context = this.getThreadContext();
                if (context == null || context.getVariables() == null) break block8;
                JMeterVariables jMeterVariables = context.getVariables();
                Class<JMeterVariables> cls = JMeterVariables.class;
                Field variablesField = cls.getDeclaredField("variables");
                variablesField.setAccessible(true);
                Object object = obj = variablesField.get(jMeterVariables);
                synchronized (object) {
                    if (obj instanceof Map) {
                        Map variables = (Map)obj;
                        if (!(variables instanceof ConcurrentHashMap)) {
                            variablesField.set(jMeterVariables, new ConcurrentHashMap(variables));
                        }
                    } else {
                        log.warn("Unexpected variables map type " + obj.getClass().getName());
                    }
                }
            }
            catch (Throwable ex) {
                log.warn("Cannot change variables map ", ex);
            }
        }
    }

    public void threadStarted() {
        this.changeVariablesMap();
        this.executorService = Executors.newCachedThreadPool(new ParallelThreadFactory(this.getName()));
    }

    public void threadFinished() {
        this.executorService.shutdown();
    }

    public static class ParallelThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final String namePrefix;

        public ParallelThreadFactory(String controllerName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "parallel " + controllerName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix, 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

