/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.http;

import com.blazemeter.jmeter.http.ParallelHTTPSampler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.ButtonPanelAddCopyRemove;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ParallelHTTPSamplerGui
extends AbstractSamplerGui
implements TableModelListener,
CellEditorListener {
    public static final String WIKIPAGE = "https://github.com/Blazemeter/jmeter-bzm-plugins/tree/master/jmeter-parallel-http/Parallel.md#parallel-sampler";
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static String[] defaultValues = new String[]{""};
    protected PowerTableModel tableModel;
    protected JTable grid;
    protected ButtonPanelAddCopyRemove buttons;

    public ParallelHTTPSamplerGui() {
        this.init();
    }

    protected final void init() {
        this.setBorder(this.makeBorder());
        this.setLayout(new BorderLayout());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)this.makeTitlePanel(), (String)WIKIPAGE), "North");
        VerticalPanel containerPanel = new VerticalPanel();
        containerPanel.add((Component)this.createParamsPanel(), "Center");
        this.add((Component)containerPanel, "Center");
    }

    private JPanel createParamsPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createTitledBorder("URLs to Retrieve"));
        panel.setPreferredSize(new Dimension(200, 200));
        JScrollPane scroll = new JScrollPane(this.createGrid());
        scroll.setPreferredSize(scroll.getMinimumSize());
        panel.add((Component)scroll, "Center");
        this.buttons = new ButtonPanelAddCopyRemove(this.grid, this.tableModel, (Object[])defaultValues);
        panel.add((Component)this.buttons, "South");
        return panel;
    }

    private JTable createGrid() {
        this.grid = new JTable();
        this.grid.getDefaultEditor(String.class).addCellEditorListener(this);
        this.createTableModel();
        this.grid.setSelectionMode(0);
        this.grid.setMinimumSize(new Dimension(200, 100));
        return this.grid;
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"Parallel HTTP Requests");
    }

    public TestElement createTestElement() {
        ParallelHTTPSampler tg = new ParallelHTTPSampler();
        this.modifyTestElement((TestElement)tg);
        tg.setComment(JMeterPluginsUtils.getWikiLinkText((String)WIKIPAGE));
        return tg;
    }

    public void modifyTestElement(TestElement tg) {
        super.configureTestElement(tg);
        if (this.grid.isEditing()) {
            this.grid.getCellEditor().stopCellEditing();
        }
        if (tg instanceof ParallelHTTPSampler) {
            ParallelHTTPSampler utg = (ParallelHTTPSampler)tg;
            CollectionProperty rows = JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)this.tableModel, (String)"urls");
            utg.setData(rows);
        }
    }

    public void configure(TestElement tg) {
        super.configure(tg);
        ParallelHTTPSampler utg = (ParallelHTTPSampler)tg;
        JMeterProperty threadValues = utg.getData();
        if (threadValues instanceof NullProperty) {
            log.warn("Received null property instead of collection");
            return;
        }
        CollectionProperty columns = (CollectionProperty)threadValues;
        this.tableModel.removeTableModelListener((TableModelListener)this);
        JMeterPluginsUtils.collectionPropertyToTableModelRows((CollectionProperty)columns, (PowerTableModel)this.tableModel);
        this.tableModel.addTableModelListener((TableModelListener)this);
        this.buttons.checkDeleteButtonStatus();
        this.updateUI();
    }

    public void updateUI() {
        super.updateUI();
        if (this.tableModel != null) {
            ParallelHTTPSampler utgForPreview = new ParallelHTTPSampler();
            utgForPreview.setData(JMeterPluginsUtils.tableModelRowsToCollectionPropertyEval((PowerTableModel)this.tableModel, (String)"urls"));
        }
    }

    private void createTableModel() {
        this.tableModel = new PowerTableModel(ParallelHTTPSampler.columnIdentifiers, ParallelHTTPSampler.columnClasses);
        this.tableModel.addTableModelListener((TableModelListener)this);
        this.grid.setModel((TableModel)this.tableModel);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.updateUI();
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
    }

    public void clearGui() {
        super.clearGui();
        this.tableModel.clearData();
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateUI();
    }
}

