/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.controller;

import com.blazemeter.jmeter.controller.ParallelSampler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.control.gui.LogicControllerGui;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.testelement.TestElement;

public class ParallelControllerGui
extends LogicControllerGui {
    private static final String MSG = "All direct child elements of this controller will be executed as parallel.";
    public static final String WIKIPAGE = "https://github.com/Blazemeter/jmeter-bzm-plugins/tree/master/jmeter-parallel-http/Parallel.md#parallel-controller";
    private JCheckBox generateParentSamples;

    public ParallelControllerGui() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)this.makeTitlePanel(), (String)WIKIPAGE), "North");
        Container topPanel = this.makeTitlePanel();
        this.add(topPanel, "North");
        HorizontalPanel mainPanel = new HorizontalPanel();
        JLabel lbl = new JLabel(MSG, 0);
        topPanel.add(lbl);
        this.generateParentSamples = new JCheckBox();
        mainPanel.add(this.generateParentSamples);
        mainPanel.add(new JLabel("Generate parent sample", 4));
        topPanel.add((Component)mainPanel);
    }

    public String getStaticLabel() {
        return "bzm - Parallel Controller";
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public TestElement createTestElement() {
        ParallelSampler te = new ParallelSampler();
        this.modifyTestElement((TestElement)te);
        return te;
    }

    public void modifyTestElement(TestElement te) {
        super.configureTestElement(te);
        if (te instanceof ParallelSampler) {
            ParallelSampler parallelSampler = (ParallelSampler)te;
            parallelSampler.setGenerateParent(this.generateParentSamples.isSelected());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof ParallelSampler) {
            this.generateParentSamples.setSelected(((ParallelSampler)element).getGenerateParent());
        }
    }
}

