/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.jmeter.protocol.http.sampler.HCAccessor;
import org.apache.jmeter.protocol.http.sampler.HTTPAbstractImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ParallelHTTPSampler
extends HTTPSamplerBase
implements Interruptible {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String DATA_PROPERTY = "urls";
    public static final String[] columnIdentifiers = new String[]{"URL"};
    public static final Class[] columnClasses = new Class[]{String.class};
    protected transient HTTPAbstractImpl impl;

    public ParallelHTTPSampler() {
        this.setImageParser(true);
        this.setConcurrentDwn(true);
    }

    public ParallelHTTPSampler(String impl) {
        this.setImplementation(impl);
    }

    protected HTTPSampleResult sample(URL u, String method, boolean areFollowingRedirect, int depth) {
        if (depth < 1) {
            JMeterProperty data = this.getData();
            StringBuilder body = new StringBuilder();
            StringBuilder req = new StringBuilder();
            if (!(data instanceof NullProperty)) {
                CollectionProperty rows = (CollectionProperty)data;
                for (JMeterProperty row : rows) {
                    ArrayList curProp = (ArrayList)row.getObjectValue();
                    req.append(curProp.get(0)).append("\n");
                    body.append("<iframe src='").append(curProp.get(0)).append("'></iframe>\n");
                }
            }
            HTTPSampleResult res = new HTTPSampleResult();
            res.setSamplerData(req.toString());
            res.setRequestHeaders("\n");
            res.setHTTPMethod("GET");
            try {
                res.setURL(new URL("http://parallel-urls-list"));
            }
            catch (MalformedURLException e) {
                log.warn("Failed to set empty url", (Throwable)e);
            }
            res.setSuccessful(true);
            res.setResponseData(body.toString(), res.getDataEncodingWithDefault());
            res.setContentType("text/html");
            res.sampleStart();
            this.downloadPageResources(res, res, depth);
            if (res.getEndTime() == 0L) {
                res.sampleEnd();
            }
            return res;
        }
        if (this.impl == null) {
            this.impl = HCAccessor.getInstance(this);
        }
        return HCAccessor.sample(this.impl, u, method, areFollowingRedirect, depth);
    }

    public boolean interrupt() {
        return false;
    }

    public void setData(CollectionProperty rows) {
        this.setProperty((JMeterProperty)rows);
    }

    public JMeterProperty getData() {
        return this.getProperty(DATA_PROPERTY);
    }

    public void addURL(String s) {
        JMeterProperty data = this.getData();
        if (data instanceof NullProperty) {
            data = new CollectionProperty();
            data.setName(DATA_PROPERTY);
        }
        CollectionProperty rows = (CollectionProperty)data;
        CollectionProperty row = new CollectionProperty();
        row.addItem((Object)s);
        rows.addItem((Object)row);
        this.setData(rows);
    }
}

