/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.backend.apiclient.aop;

import com.blibli.oss.backend.apiclient.annotation.ApiClient;
import com.blibli.oss.backend.apiclient.aop.RequestMappingMetadata;
import com.blibli.oss.backend.apiclient.aop.RequestMappingMetadataBuilder;
import com.blibli.oss.backend.apiclient.aop.fallback.ApiClientFallback;
import com.blibli.oss.backend.apiclient.aop.fallback.FallbackMetadata;
import com.blibli.oss.backend.apiclient.aop.fallback.FallbackMetadataBuilder;
import com.blibli.oss.backend.apiclient.body.ApiBodyResolver;
import com.blibli.oss.backend.apiclient.customizer.ApiClientCodecCustomizer;
import com.blibli.oss.backend.apiclient.customizer.ApiClientTcpClientCustomizer;
import com.blibli.oss.backend.apiclient.customizer.ApiClientWebClientCustomizer;
import com.blibli.oss.backend.apiclient.error.ApiErrorResolver;
import com.blibli.oss.backend.apiclient.interceptor.ApiClientInterceptor;
import com.blibli.oss.backend.apiclient.interceptor.GlobalApiClientInterceptor;
import com.blibli.oss.backend.reactor.scheduler.SchedulerHelper;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.TcpClient;

public class ApiClientMethodInterceptor
implements MethodInterceptor,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ApiClientMethodInterceptor.class);
    private ApplicationContext applicationContext;
    private Class<?> type;
    private String name;
    private AnnotationMetadata annotationMetadata;
    private List<ApiBodyResolver> bodyResolvers;
    private WebClient webClient;
    private ApiClientFallback apiClientFallback;
    private RequestMappingMetadata metadata;
    private ApiErrorResolver errorResolver;
    private Scheduler scheduler;

    public void afterPropertiesSet() throws Exception {
        this.prepareAttribute();
        this.prepareWebClient();
        this.prepareFallback();
        this.prepareBodyResolvers();
        this.prepareErrorResolver();
        this.prepareScheduler();
    }

    private void prepareAttribute() {
        this.metadata = new RequestMappingMetadataBuilder(this.applicationContext, this.type, this.name).build();
    }

    private void prepareWebClient() {
        WebClient.Builder builder = ((WebClient.Builder)this.applicationContext.getBean(WebClient.Builder.class)).exchangeStrategies(this.getExchangeStrategies()).baseUrl(this.metadata.getProperties().getUrl()).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(HttpClient.from((TcpClient)this.getTcpClient()))).defaultHeaders(httpHeaders -> this.metadata.getProperties().getHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1))).filters(exchangeFilterFunctions -> exchangeFilterFunctions.addAll(this.getApiClientInterceptors()));
        for (ApiClientWebClientCustomizer apiClientWebClientCustomizer : this.getApiClientWebClientCustomizers()) {
            apiClientWebClientCustomizer.customize(builder);
        }
        this.webClient = builder.build();
    }

    private TcpClient getTcpClient() {
        TcpClient tcpClient = TcpClient.create().option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)this.metadata.getProperties().getConnectTimeout().toMillis())).doOnConnected(connection -> connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(this.metadata.getProperties().getReadTimeout().toMillis(), TimeUnit.MILLISECONDS)).addHandlerLast((ChannelHandler)new WriteTimeoutHandler(this.metadata.getProperties().getWriteTimeout().toMillis(), TimeUnit.MILLISECONDS)));
        for (ApiClientTcpClientCustomizer customizer : this.getApiClientTcpClientCustomizers()) {
            tcpClient = customizer.customize(tcpClient);
        }
        return tcpClient;
    }

    private ExchangeStrategies getExchangeStrategies() {
        ObjectMapper objectMapper = (ObjectMapper)this.applicationContext.getBean(ObjectMapper.class);
        return ExchangeStrategies.builder().codecs(clientDefaultCodecsConfigurer -> {
            clientDefaultCodecsConfigurer.defaultCodecs().jackson2JsonEncoder((Encoder)new Jackson2JsonEncoder(objectMapper, new MimeType[]{MediaType.APPLICATION_JSON}));
            clientDefaultCodecsConfigurer.defaultCodecs().jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(objectMapper, new MimeType[]{MediaType.APPLICATION_JSON}));
            for (ApiClientCodecCustomizer apiClientCodecCustomizer : this.getApiClientCodecCustomizers()) {
                apiClientCodecCustomizer.customize((ClientCodecConfigurer)clientDefaultCodecsConfigurer);
            }
        }).build();
    }

    private Set<ApiClientCodecCustomizer> getApiClientCodecCustomizers() {
        HashSet<ApiClientCodecCustomizer> apiClientCodecCustomizers = new HashSet<ApiClientCodecCustomizer>();
        this.metadata.getProperties().getCodecCustomizers().forEach(interceptorClass -> apiClientCodecCustomizers.add((ApiClientCodecCustomizer)this.applicationContext.getBean(interceptorClass)));
        ApiClient annotation = this.type.getAnnotation(ApiClient.class);
        for (Class<? extends ApiClientCodecCustomizer> interceptor : annotation.codecCustomizers()) {
            apiClientCodecCustomizers.add((ApiClientCodecCustomizer)this.applicationContext.getBean(interceptor));
        }
        return apiClientCodecCustomizers;
    }

    private Set<ApiClientWebClientCustomizer> getApiClientWebClientCustomizers() {
        HashSet<ApiClientWebClientCustomizer> apiClientWebClientCustomizers = new HashSet<ApiClientWebClientCustomizer>();
        this.metadata.getProperties().getWebClientCustomizers().forEach(interceptorClass -> apiClientWebClientCustomizers.add((ApiClientWebClientCustomizer)this.applicationContext.getBean(interceptorClass)));
        ApiClient annotation = this.type.getAnnotation(ApiClient.class);
        for (Class<? extends ApiClientWebClientCustomizer> interceptor : annotation.webClientCustomizers()) {
            apiClientWebClientCustomizers.add((ApiClientWebClientCustomizer)this.applicationContext.getBean(interceptor));
        }
        return apiClientWebClientCustomizers;
    }

    private Set<ApiClientTcpClientCustomizer> getApiClientTcpClientCustomizers() {
        HashSet<ApiClientTcpClientCustomizer> customizers = new HashSet<ApiClientTcpClientCustomizer>();
        this.metadata.getProperties().getTcpClientCustomizers().forEach(interceptorClass -> customizers.add((ApiClientTcpClientCustomizer)this.applicationContext.getBean(interceptorClass)));
        ApiClient annotation = this.type.getAnnotation(ApiClient.class);
        for (Class<? extends ApiClientTcpClientCustomizer> customizer : annotation.tcpClientCustomizers()) {
            customizers.add((ApiClientTcpClientCustomizer)this.applicationContext.getBean(customizer));
        }
        return customizers;
    }

    private Set<ExchangeFilterFunction> getApiClientInterceptors() {
        HashSet<ExchangeFilterFunction> interceptors = new HashSet<ExchangeFilterFunction>();
        this.metadata.getProperties().getInterceptors().forEach(interceptorClass -> interceptors.add((ExchangeFilterFunction)this.applicationContext.getBean(interceptorClass)));
        ApiClient annotation = this.type.getAnnotation(ApiClient.class);
        for (Class<? extends ApiClientInterceptor> interceptor : annotation.interceptors()) {
            interceptors.add((ExchangeFilterFunction)this.applicationContext.getBean(interceptor));
        }
        interceptors.addAll(this.applicationContext.getBeansOfType(GlobalApiClientInterceptor.class).values());
        return interceptors;
    }

    private void prepareFallback() {
        ApiClient annotation = this.type.getAnnotation(ApiClient.class);
        Object fallback = null;
        if (annotation.fallback() != Void.class) {
            fallback = this.applicationContext.getBean(annotation.fallback());
        }
        if (Objects.nonNull(this.metadata.getProperties().getFallback())) {
            fallback = this.applicationContext.getBean(this.metadata.getProperties().getFallback());
        }
        FallbackMetadata metadata = null;
        if (Objects.nonNull(fallback)) {
            metadata = new FallbackMetadataBuilder(this.type, fallback.getClass()).build();
        }
        this.apiClientFallback = ApiClientFallback.builder().fallback(fallback).metadata(metadata).build();
    }

    private void prepareBodyResolvers() {
        this.bodyResolvers = new ArrayList(this.applicationContext.getBeansOfType(ApiBodyResolver.class).values());
    }

    private void prepareErrorResolver() {
        ApiClient annotation = this.type.getAnnotation(ApiClient.class);
        this.errorResolver = (ApiErrorResolver)this.applicationContext.getBean(annotation.errorResolver());
        if (Objects.nonNull(this.metadata.getProperties().getErrorResolver())) {
            this.errorResolver = (ApiErrorResolver)this.applicationContext.getBean(this.metadata.getProperties().getErrorResolver());
        }
    }

    private void prepareScheduler() {
        ApiClient annotation;
        SchedulerHelper schedulerHelper = (SchedulerHelper)this.applicationContext.getBean(SchedulerHelper.class);
        if (schedulerHelper.of((annotation = this.type.getAnnotation(ApiClient.class)).name()) != Schedulers.immediate()) {
            this.scheduler = schedulerHelper.of(annotation.name());
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        String methodName = method.toString();
        Object[] arguments = invocation.getArguments();
        Mono mono = Mono.fromCallable(() -> this.webClient).map(client -> this.doMethod(methodName)).map(client -> this.getUriBuilder(methodName, arguments, (WebClient.RequestHeadersUriSpec<?>)client)).map(client -> this.doHeader((WebClient.RequestHeadersSpec<?>)client, methodName, arguments)).map(client -> this.doBody((WebClient.RequestHeadersSpec<?>)client, method, methodName, arguments)).flatMap(client -> this.doResponse((WebClient.RequestHeadersSpec<?>)client, methodName)).onErrorResume(throwable -> this.doFallback((Throwable)throwable, method, arguments));
        if (Objects.nonNull(this.scheduler)) {
            return mono.subscribeOn(this.scheduler);
        }
        return mono;
    }

    private WebClient.RequestHeadersUriSpec<?> doMethod(String methodName) {
        RequestMethod method = this.metadata.getRequestMethods().get(methodName);
        if (method.equals((Object)RequestMethod.GET)) {
            return this.webClient.get();
        }
        if (method.equals((Object)RequestMethod.POST)) {
            return this.webClient.post();
        }
        if (method.equals((Object)RequestMethod.PUT)) {
            return this.webClient.put();
        }
        if (method.equals((Object)RequestMethod.PATCH)) {
            return this.webClient.patch();
        }
        if (method.equals((Object)RequestMethod.DELETE)) {
            return this.webClient.delete();
        }
        if (method.equals((Object)RequestMethod.OPTIONS)) {
            return this.webClient.options();
        }
        if (method.equals((Object)RequestMethod.HEAD)) {
            return this.webClient.head();
        }
        return this.webClient.get();
    }

    private WebClient.RequestHeadersSpec<?> getUriBuilder(String methodName, Object[] arguments, WebClient.RequestHeadersUriSpec<?> client) {
        if (this.metadata.getApiUrlPositions().containsKey(methodName)) {
            String baseUrl = (String)arguments[this.metadata.getApiUrlPositions().get(methodName)];
            return client.uri(baseUrl, uriBuilder -> this.getUri((UriBuilder)uriBuilder, methodName, arguments));
        }
        return client.uri(uriBuilder -> this.getUri((UriBuilder)uriBuilder, methodName, arguments));
    }

    private URI getUri(UriBuilder builder, String methodName, Object[] arguments) {
        builder.path(this.metadata.getPaths().get(methodName));
        this.metadata.getQueryParamPositions().get(methodName).forEach((paramName, position) -> {
            if (arguments[position] instanceof Collection) {
                Collection collection = (Collection)arguments[position];
                builder.queryParam(paramName, collection);
            } else {
                builder.queryParam(paramName, new Object[]{arguments[position]});
            }
        });
        HashMap uriVariables = new HashMap();
        this.metadata.getPathVariablePositions().get(methodName).forEach((paramName, position) -> uriVariables.put(paramName, arguments[position]));
        return builder.build(uriVariables);
    }

    private WebClient.RequestHeadersSpec<?> doHeader(WebClient.RequestHeadersSpec<?> spec, String methodName, Object[] arguments) {
        this.metadata.getHeaders().get(methodName).forEach((key, values) -> spec.headers(httpHeaders -> httpHeaders.addAll(key, values)));
        this.metadata.getHeaderParamPositions().get(methodName).forEach((key, position) -> spec.headers(httpHeaders -> httpHeaders.add(key, String.valueOf(arguments[position]))));
        this.metadata.getCookieParamPositions().get(methodName).forEach((key, position) -> spec.cookies(cookies -> cookies.add(key, (Object)String.valueOf(arguments[position]))));
        return spec;
    }

    private WebClient.RequestHeadersSpec<?> doBody(WebClient.RequestHeadersSpec<?> client, Method method, String methodName, Object[] arguments) {
        if (client instanceof WebClient.RequestBodySpec) {
            WebClient.RequestBodySpec bodySpec = (WebClient.RequestBodySpec)client;
            String contentType = this.metadata.getContentTypes().get(methodName);
            BodyInserter<?, ? super ClientHttpRequest> body = null;
            for (ApiBodyResolver bodyResolver : this.bodyResolvers) {
                if (!bodyResolver.canResolve(contentType)) continue;
                body = bodyResolver.resolve(method, arguments);
            }
            if (body != null) {
                return bodySpec.body(body);
            }
        }
        return client;
    }

    private Mono doResponse(WebClient.RequestHeadersSpec<?> client, String methodName) {
        Type type = this.metadata.getResponseBodyClasses().get(methodName);
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (ResponseEntity.class.equals((Object)parameterizedType.getRawType())) {
                Type actualTypeArgument;
                WebClient.ResponseSpec responseEntitySpec = client.retrieve().onStatus(HttpStatus::isError, clientResponse -> Mono.empty());
                if (parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType && List.class.equals((Object)(actualTypeArgument = (ParameterizedType)parameterizedType.getActualTypeArguments()[0]).getRawType())) {
                    return responseEntitySpec.toEntityList(ParameterizedTypeReference.forType((Type)actualTypeArgument.getActualTypeArguments()[0]));
                }
                actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
                if (Void.class.equals((Object)actualTypeArgument)) {
                    return responseEntitySpec.toBodilessEntity();
                }
                return responseEntitySpec.toEntity(ParameterizedTypeReference.forType((Type)actualTypeArgument));
            }
            return client.retrieve().bodyToMono(ParameterizedTypeReference.forType((Type)parameterizedType));
        }
        return client.retrieve().bodyToMono((Class)type);
    }

    private Mono doFallback(Throwable throwable, Method method, Object[] arguments) {
        if (this.apiClientFallback.isAvailable()) {
            return this.errorResolver.resolve(throwable, this.type, method, arguments).switchIfEmpty(this.apiClientFallback.invoke(method, arguments, throwable));
        }
        return this.errorResolver.resolve(throwable, this.type, method, arguments);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        this.annotationMetadata = annotationMetadata;
    }
}

