/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.backend.apiclient.aop;

import com.blibli.oss.backend.apiclient.annotation.ApiUrl;
import com.blibli.oss.backend.apiclient.aop.RequestMappingMetadata;
import com.blibli.oss.backend.apiclient.properties.ApiClientProperties;
import com.blibli.oss.backend.apiclient.properties.PropertiesHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import reactor.core.publisher.Mono;

public class RequestMappingMetadataBuilder {
    private Map<String, Method> methods;
    private ApiClientProperties.ApiClientConfigProperties properties;
    private Map<String, MultiValueMap<String, String>> headers = new HashMap<String, MultiValueMap<String, String>>();
    private Map<String, Integer> apiUrlPositions = new HashMap<String, Integer>();
    private Map<String, Map<String, Integer>> queryParamPositions = new HashMap<String, Map<String, Integer>>();
    private Map<String, Map<String, Integer>> headerParamPositions = new HashMap<String, Map<String, Integer>>();
    private Map<String, Map<String, Integer>> cookieParamPositions = new HashMap<String, Map<String, Integer>>();
    private Map<String, Map<String, Integer>> pathVariablePositions = new HashMap<String, Map<String, Integer>>();
    private Map<String, RequestMethod> requestMethods = new HashMap<String, RequestMethod>();
    private Map<String, String> paths = new HashMap<String, String>();
    private Map<String, Type> responseBodyClasses = new HashMap<String, Type>();
    private Map<String, String> contentTypes = new HashMap<String, String>();
    private ApplicationContext applicationContext;
    private Class<?> type;
    private String name;

    public RequestMappingMetadataBuilder(ApplicationContext applicationContext, Class<?> type, String name) {
        this.applicationContext = applicationContext;
        this.type = type;
        this.name = name;
    }

    private void prepareProperties() {
        ApiClientProperties apiClientproperties = (ApiClientProperties)this.applicationContext.getBean(ApiClientProperties.class);
        this.properties = this.mergeApiClientConfigProperties(apiClientproperties.getConfigs().get("default"), apiClientproperties.getConfigs().get(this.name));
    }

    private ApiClientProperties.ApiClientConfigProperties mergeApiClientConfigProperties(ApiClientProperties.ApiClientConfigProperties defaultProperties, ApiClientProperties.ApiClientConfigProperties properties) {
        ApiClientProperties.ApiClientConfigProperties configProperties = new ApiClientProperties.ApiClientConfigProperties();
        PropertiesHelper.copyConfigProperties(defaultProperties, configProperties);
        PropertiesHelper.copyConfigProperties(properties, configProperties);
        return configProperties;
    }

    private void prepareMethods() {
        this.methods = Arrays.stream(ReflectionUtils.getAllDeclaredMethods(this.type)).filter(method -> method.getAnnotation(RequestMapping.class) != null).collect(Collectors.toMap(Method::toString, method -> method));
    }

    private void preparePaths() {
        this.methods.forEach((methodName, method) -> {
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping != null) {
                String[] pathValues;
                String[] stringArray = pathValues = requestMapping.path().length > 0 ? requestMapping.path() : requestMapping.value();
                if (pathValues.length > 0) {
                    this.paths.put((String)methodName, pathValues[0]);
                } else {
                    this.paths.put((String)methodName, "");
                }
            }
        });
    }

    private void prepareRequestMethods() {
        this.methods.forEach((methodName, method) -> {
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping != null) {
                RequestMethod[] methods = requestMapping.method();
                if (methods.length > 0) {
                    this.requestMethods.put((String)methodName, methods[0]);
                } else {
                    this.requestMethods.put((String)methodName, RequestMethod.GET);
                }
            }
        });
    }

    private void prepareResponseBodyClasses() {
        this.methods.forEach((methodName, method) -> {
            ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
            if (!parameterizedType.getRawType().getTypeName().equals(Mono.class.getName())) {
                throw new BeanCreationException(String.format("ApiClient method must return reactive, %s is not reactive", methodName));
            }
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new BeanCreationException(String.format("ApiClient method must return 1 generic type, %s generic type is not 1", methodName));
            }
            this.responseBodyClasses.put((String)methodName, typeArguments[0]);
        });
    }

    private void prepareQueryParams() {
        this.methods.forEach((methodName, method) -> {
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping != null) {
                Parameter[] parameters = method.getParameters();
                HashMap<String, Integer> queryParamPosition = new HashMap<String, Integer>();
                this.queryParamPositions.put((String)methodName, (Map<String, Integer>)queryParamPosition);
                if (parameters.length > 0) {
                    for (int i = 0; i < parameters.length; ++i) {
                        String name;
                        Parameter parameter = parameters[i];
                        RequestParam annotation = parameter.getAnnotation(RequestParam.class);
                        if (annotation == null) continue;
                        String string = name = StringUtils.isEmpty((Object)annotation.name()) ? annotation.value() : annotation.name();
                        if (StringUtils.isEmpty((Object)name)) continue;
                        queryParamPosition.put(name, i);
                    }
                }
            }
        });
    }

    private void prepareApiUrl() {
        this.methods.forEach((methodName, method) -> {
            Parameter[] parameters;
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping != null && (parameters = method.getParameters()).length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    Parameter parameter = parameters[i];
                    ApiUrl annotation = parameter.getAnnotation(ApiUrl.class);
                    if (annotation == null) continue;
                    this.apiUrlPositions.put((String)methodName, i);
                }
            }
        });
    }

    private void prepareHeaderParams() {
        this.methods.forEach((methodName, method) -> {
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping != null) {
                Parameter[] parameters = method.getParameters();
                HashMap<String, Integer> headerParamPosition = new HashMap<String, Integer>();
                this.headerParamPositions.put((String)methodName, (Map<String, Integer>)headerParamPosition);
                if (parameters.length > 0) {
                    for (int i = 0; i < parameters.length; ++i) {
                        String name;
                        Parameter parameter = parameters[i];
                        RequestHeader annotation = parameter.getAnnotation(RequestHeader.class);
                        if (annotation == null) continue;
                        String string = name = StringUtils.isEmpty((Object)annotation.name()) ? annotation.value() : annotation.name();
                        if (StringUtils.isEmpty((Object)name)) continue;
                        headerParamPosition.put(name, i);
                    }
                }
            }
        });
    }

    private void preparePathVariables() {
        this.methods.forEach((methodName, method) -> {
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping != null) {
                Parameter[] parameters = method.getParameters();
                HashMap<String, Integer> pathVariablePosition = new HashMap<String, Integer>();
                this.pathVariablePositions.put((String)methodName, (Map<String, Integer>)pathVariablePosition);
                if (parameters.length > 0) {
                    for (int i = 0; i < parameters.length; ++i) {
                        String name;
                        Parameter parameter = parameters[i];
                        PathVariable annotation = parameter.getAnnotation(PathVariable.class);
                        if (annotation == null) continue;
                        String string = name = StringUtils.isEmpty((Object)annotation.name()) ? annotation.value() : annotation.name();
                        if (StringUtils.isEmpty((Object)name)) continue;
                        pathVariablePosition.put(name, i);
                    }
                }
            }
        });
    }

    private void prepareHeaders() {
        this.methods.forEach((methodName, method) -> {
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping != null) {
                String[] requestHeaders;
                String[] produces;
                HttpHeaders httpHeaders = new HttpHeaders();
                String[] consumes = requestMapping.consumes();
                if (consumes.length > 0) {
                    httpHeaders.addAll("Content-Type", Arrays.asList(consumes));
                }
                if ((produces = requestMapping.produces()).length > 0) {
                    httpHeaders.addAll("Accept", Arrays.asList(produces));
                }
                for (String header : requestHeaders = requestMapping.headers()) {
                    String[] split = header.split("=");
                    if (split.length > 1) {
                        httpHeaders.add(split[0], split[1]);
                        continue;
                    }
                    httpHeaders.add(split[0], "");
                }
                this.headers.put((String)methodName, (MultiValueMap<String, String>)httpHeaders);
            }
        });
    }

    private void prepareCookieParams() {
        this.methods.forEach((methodName, method) -> {
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping != null) {
                Parameter[] parameters = method.getParameters();
                HashMap<String, Integer> cookieParamPosition = new HashMap<String, Integer>();
                this.cookieParamPositions.put((String)methodName, (Map<String, Integer>)cookieParamPosition);
                if (parameters.length > 0) {
                    for (int i = 0; i < parameters.length; ++i) {
                        String name;
                        Parameter parameter = parameters[i];
                        CookieValue annotation = parameter.getAnnotation(CookieValue.class);
                        if (annotation == null) continue;
                        String string = name = StringUtils.isEmpty((Object)annotation.name()) ? annotation.value() : annotation.name();
                        if (StringUtils.isEmpty((Object)name)) continue;
                        cookieParamPosition.put(name, i);
                    }
                }
            }
        });
    }

    private void prepareContentTypes() {
        String defaultContentType = this.getDefaultContentType();
        this.methods.forEach((methodName, method) -> {
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping != null) {
                String[] consumes = requestMapping.consumes();
                if (consumes.length > 0) {
                    this.contentTypes.put((String)methodName, consumes[0]);
                } else {
                    this.contentTypes.put((String)methodName, defaultContentType);
                }
            }
        });
    }

    private String getDefaultContentType() {
        String defaultContentType = null;
        for (Map.Entry<String, String> entry : this.properties.getHeaders().entrySet()) {
            if (!"Content-Type".equals(entry.getKey())) continue;
            defaultContentType = entry.getValue();
        }
        return defaultContentType;
    }

    public RequestMappingMetadata build() {
        this.prepareProperties();
        this.prepareMethods();
        this.prepareHeaders();
        this.prepareQueryParams();
        this.prepareHeaderParams();
        this.preparePathVariables();
        this.prepareResponseBodyClasses();
        this.prepareRequestMethods();
        this.preparePaths();
        this.prepareCookieParams();
        this.prepareContentTypes();
        this.prepareApiUrl();
        return RequestMappingMetadata.builder().properties(this.properties).methods(this.methods).headerParamPositions(this.headerParamPositions).headers(this.headers).queryParamPositions(this.queryParamPositions).pathVariablePositions(this.pathVariablePositions).responseBodyClasses(this.responseBodyClasses).requestMethods(this.requestMethods).paths(this.paths).cookieParamPositions(this.cookieParamPositions).contentTypes(this.contentTypes).apiUrlPositions(this.apiUrlPositions).build();
    }
}

