/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.backend.apiclient.aop.fallback;

import com.blibli.oss.backend.apiclient.aop.fallback.FallbackMetadata;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Mono;

public class ApiClientFallback {
    private Object fallback;
    private FallbackMetadata metadata;

    public boolean isAvailable() {
        return Objects.nonNull(this.fallback);
    }

    public Mono invoke(Method method, Object[] arguments, Throwable throwable) {
        return Mono.just((Object)throwable).flatMap(exception -> {
            if (method.getDeclaringClass().isAssignableFrom(this.fallback.getClass())) {
                return (Mono)ReflectionUtils.invokeMethod((Method)method, (Object)this.fallback, (Object[])arguments);
            }
            Method methodWithException = this.metadata.getExceptionMethods().get(method);
            if (Objects.nonNull(methodWithException)) {
                Object[] target = this.getArgumentsWithException(arguments, (Throwable)exception);
                return (Mono)ReflectionUtils.invokeMethod((Method)methodWithException, (Object)this.fallback, (Object[])target);
            }
            Method fallbackMethod = this.metadata.getMethods().get(method);
            if (Objects.nonNull(fallbackMethod)) {
                return (Mono)ReflectionUtils.invokeMethod((Method)fallbackMethod, (Object)this.fallback, (Object[])arguments);
            }
            return Mono.error((Throwable)exception);
        });
    }

    private Object[] getArgumentsWithException(Object[] arguments, Throwable exception) {
        Object[] target = new Object[arguments.length + 1];
        System.arraycopy(arguments, 0, target, 0, arguments.length);
        target[target.length - 1] = exception;
        return target;
    }

    public static ApiClientFallbackBuilder builder() {
        return new ApiClientFallbackBuilder();
    }

    public ApiClientFallback() {
    }

    public ApiClientFallback(Object fallback, FallbackMetadata metadata) {
        this.fallback = fallback;
        this.metadata = metadata;
    }

    public static class ApiClientFallbackBuilder {
        private Object fallback;
        private FallbackMetadata metadata;

        ApiClientFallbackBuilder() {
        }

        public ApiClientFallbackBuilder fallback(Object fallback) {
            this.fallback = fallback;
            return this;
        }

        public ApiClientFallbackBuilder metadata(FallbackMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public ApiClientFallback build() {
            return new ApiClientFallback(this.fallback, this.metadata);
        }

        public String toString() {
            return "ApiClientFallback.ApiClientFallbackBuilder(fallback=" + this.fallback + ", metadata=" + this.metadata + ")";
        }
    }
}

