/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.backend.apiclient.aop.fallback;

import com.blibli.oss.backend.apiclient.aop.fallback.FallbackMetadata;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.ReflectionUtils;

public class FallbackMetadataBuilder {
    private Class<?> apiClient;
    private Class<?> fallback;
    private Map<Method, Method> exceptionMethods = new HashMap<Method, Method>();
    private Map<Method, Method> methods = new HashMap<Method, Method>();

    public FallbackMetadataBuilder(Class<?> apiClient, Class<?> fallback) {
        this.apiClient = apiClient;
        this.fallback = fallback;
    }

    private void prepareExceptionMethods() {
        Method[] apiClientMethods = ReflectionUtils.getAllDeclaredMethods(this.apiClient);
        Method[] fallbackMethods = ReflectionUtils.getAllDeclaredMethods(this.fallback);
        for (Method apiClientMethod : apiClientMethods) {
            for (Method fallbackMethod : fallbackMethods) {
                if (!fallbackMethod.getName().equals(apiClientMethod.getName()) || !Arrays.equals(fallbackMethod.getParameterTypes(), this.getParameterClassesWithException(apiClientMethod))) continue;
                this.exceptionMethods.put(apiClientMethod, fallbackMethod);
            }
        }
    }

    private Class<?>[] getParameterClassesWithException(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class[] result = new Class[parameterTypes.length + 1];
        System.arraycopy(parameterTypes, 0, result, 0, parameterTypes.length);
        result[result.length - 1] = Throwable.class;
        return result;
    }

    private void prepareMethod() {
        Method[] apiClientMethods = ReflectionUtils.getAllDeclaredMethods(this.apiClient);
        Method[] fallbackMethods = ReflectionUtils.getAllDeclaredMethods(this.fallback);
        for (Method apiClientMethod : apiClientMethods) {
            for (Method fallbackMethod : fallbackMethods) {
                if (!fallbackMethod.getName().equals(apiClientMethod.getName()) || !Arrays.equals(fallbackMethod.getParameterTypes(), apiClientMethod.getParameterTypes())) continue;
                this.methods.put(apiClientMethod, fallbackMethod);
            }
        }
    }

    public FallbackMetadata build() {
        this.prepareExceptionMethods();
        this.prepareMethod();
        return FallbackMetadata.builder().methods(this.methods).exceptionMethods(this.exceptionMethods).build();
    }
}

