/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.backend.apiclient.body;

import com.blibli.oss.backend.apiclient.body.ApiBodyResolver;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;

public class JsonBodyResolver
implements ApiBodyResolver {
    private ObjectMapper objectMapper;

    public JsonBodyResolver(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean canResolve(String contentType) {
        return "application/json".equals(contentType);
    }

    @Override
    public BodyInserter<?, ? super ClientHttpRequest> resolve(Method method, Object[] arguments) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            RequestBody requestBody = parameter.getAnnotation(RequestBody.class);
            if (requestBody == null) continue;
            return BodyInserters.fromValue((Object)arguments[i]);
        }
        return null;
    }
}

