/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.backend.apiclient.body;

import com.blibli.oss.backend.apiclient.body.ApiBodyResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;

public class MultipartBodyResolver
implements ApiBodyResolver {
    @Override
    public boolean canResolve(String contentType) {
        return "multipart/form-data".equals(contentType);
    }

    @Override
    public BodyInserter<?, ? super ClientHttpRequest> resolve(Method method, Object[] arguments) {
        Parameter[] parameters = method.getParameters();
        MultipartBodyBuilder builder = new MultipartBodyBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            RequestPart annotation = parameter.getAnnotation(RequestPart.class);
            if (annotation == null) continue;
            String name = StringUtils.isEmpty((Object)annotation.name()) ? annotation.value() : annotation.name();
            builder.part(name, arguments[i]);
        }
        MultiValueMap multiValueMap = builder.build();
        if (!multiValueMap.isEmpty()) {
            return BodyInserters.fromMultipartData((MultiValueMap)multiValueMap);
        }
        return null;
    }
}

