/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.backend.apiclient.configuration;

import com.blibli.oss.backend.apiclient.annotation.ApiClient;
import com.blibli.oss.backend.apiclient.aop.ApiClientMethodInterceptor;
import com.blibli.oss.backend.reactor.ReactorAutoConfiguration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={ReactorAutoConfiguration.class})
public class ApiClientRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(ApiClientRegistrar.class);
    public static final String METHOD_INTERCEPTOR = "MethodInterceptor";
    private ResourceLoader resourceLoader;
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter(ApiClient.class);
        scanner.addIncludeFilter((TypeFilter)annotationTypeFilter);
        Set<String> basePackages = this.getBasePackages(metadata);
        for (String basePackage : basePackages) {
            Set candidateComponents = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition candidateComponent : candidateComponents) {
                if (!(candidateComponent instanceof AnnotatedBeanDefinition)) continue;
                AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
                AnnotationMetadata annotationMetadata = beanDefinition.getMetadata();
                Assert.isTrue((boolean)annotationMetadata.isInterface(), (String)"@ApiClient can only be specified on an interface");
                Map attributes = annotationMetadata.getAnnotationAttributes(ApiClient.class.getCanonicalName());
                String name = this.getBeanName(attributes);
                this.registerApiClientInterceptor(registry, name, annotationMetadata, attributes);
                this.registerApiClient(registry, name, annotationMetadata, attributes);
            }
        }
    }

    private void registerApiClientInterceptor(BeanDefinitionRegistry registry, String name, AnnotationMetadata annotationMetadata, Map<String, Object> attributes) {
        String beanName = annotationMetadata.getClassName() + METHOD_INTERCEPTOR;
        String aliasName = name + METHOD_INTERCEPTOR;
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(ApiClientMethodInterceptor.class);
        definition.addPropertyValue("annotationMetadata", (Object)annotationMetadata);
        try {
            definition.addPropertyValue("type", Class.forName(annotationMetadata.getClassName()));
        }
        catch (ClassNotFoundException e) {
            throw new BeanCreationException(e.getMessage(), (Throwable)e);
        }
        definition.addPropertyValue("name", (Object)name);
        definition.setAutowireMode(2);
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        boolean primary = (Boolean)attributes.get("primary");
        beanDefinition.setPrimary(primary);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, beanName, new String[]{aliasName});
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
    }

    private void registerApiClient(BeanDefinitionRegistry registry, String name, AnnotationMetadata annotationMetadata, Map<String, Object> attributes) {
        String beanName = annotationMetadata.getClassName();
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(ProxyFactoryBean.class);
        definition.addPropertyValue("interceptorNames", (Object)new String[]{name + METHOD_INTERCEPTOR});
        try {
            definition.addPropertyValue("proxyInterfaces", (Object)new Class[]{Class.forName(beanName)});
        }
        catch (ClassNotFoundException e) {
            throw new BeanCreationException(e.getMessage(), (Throwable)e);
        }
        definition.setAutowireMode(2);
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        boolean primary = (Boolean)attributes.get("primary");
        beanDefinition.setPrimary(primary);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, beanName, new String[]{name});
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
    }

    private String getBeanName(Map<String, Object> client) {
        String value = (String)client.get("name");
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        throw new IllegalStateException("'name' must be provided in @" + ApiClient.class.getSimpleName());
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        HashSet<String> basePackages = new HashSet<String>();
        String[] packages = (String[])this.environment.getProperty("blibli.backend.apiclient.packages", String[].class);
        if (packages != null) {
            basePackages.addAll(Arrays.asList(packages));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

