/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.backend.apiclient.sleuth;

import brave.Tracer;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.TraceContext;
import com.blibli.oss.backend.apiclient.interceptor.GlobalApiClientInterceptor;
import com.blibli.oss.backend.apiclient.properties.ApiClientProperties;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class SleuthGlobalApiClientInterceptor
implements GlobalApiClientInterceptor {
    private ApiClientProperties properties;
    private Tracer tracer;

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        if (this.properties.getSleuth().isEnabled() && this.tracer.currentSpan() != null) {
            return Mono.fromCallable(() -> {
                ClientRequest.Builder builder = ClientRequest.from((ClientRequest)request);
                ExtraFieldPropagation.getAll((TraceContext)this.tracer.currentSpan().context()).forEach((key, value) -> builder.header("baggage-" + key, new String[]{value}));
                return builder.build();
            }).flatMap(arg_0 -> ((ExchangeFunction)next).exchange(arg_0));
        }
        return next.exchange(request);
    }

    public SleuthGlobalApiClientInterceptor(ApiClientProperties properties, Tracer tracer) {
        this.properties = properties;
        this.tracer = tracer;
    }
}

