/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.backend.command.cache;

import com.blibli.oss.backend.command.Command;
import com.blibli.oss.backend.command.interceptor.CommandInterceptor;
import com.blibli.oss.backend.command.properties.CommandProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.reactivestreams.Publisher;
import org.springframework.core.Ordered;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class CommandCacheInterceptor
implements CommandInterceptor,
Ordered {
    private final int order = Integer.MIN_VALUE;
    private ReactiveStringRedisTemplate redisTemplate;
    private ObjectMapper objectMapper;
    private CommandProperties commandProperties;

    @Override
    public <R, T> Mono<T> before(Command<R, T> command, R request) {
        return Mono.fromCallable(() -> command.cacheKey(request)).flatMap(this::redisGet).map(json -> this.readJson(command, (String)json));
    }

    @Override
    public <R, T> Mono<Void> afterSuccess(Command<R, T> command, R request, T response) {
        return Mono.zip(this.evictCommandResponse(command, request), this.cacheCommandResponse(command, request, response)).flatMap(objects -> Mono.empty());
    }

    private <R, T> Mono<Boolean> cacheCommandResponse(Command<R, T> command, R request, T response) {
        return Mono.zip((Mono)Mono.fromCallable(() -> command.cacheKey(request)), (Mono)Mono.fromCallable(() -> this.writeJson(response))).flatMap(this::redisSet).switchIfEmpty(Mono.just((Object)false));
    }

    private <R, T> Mono<Long> evictCommandResponse(Command<R, T> command, R request) {
        return Mono.fromCallable(() -> command.evictKeys(request)).map(keys -> keys.toArray(new String[0])).flatMap(this::redisDelete).switchIfEmpty(Mono.just((Object)0L));
    }

    private Mono<String> redisGet(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    private Mono<Boolean> redisSet(Tuple2<String, String> tuple) {
        return this.redisTemplate.opsForValue().set(tuple.getT1(), tuple.getT2(), this.commandProperties.getCache().getTimeout());
    }

    private Mono<Long> redisDelete(String[] keys) {
        return this.redisTemplate.delete((Publisher)Flux.fromArray((Object[])keys));
    }

    private <T> String writeJson(T response) {
        return this.objectMapper.writeValueAsString(response);
    }

    private <R, T> T readJson(Command<R, T> command, String json) {
        return (T)this.objectMapper.readValue(json, command.responseClass());
    }

    public int getOrder() {
        return this.order;
    }

    public void setRedisTemplate(ReactiveStringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setCommandProperties(CommandProperties commandProperties) {
        this.commandProperties = commandProperties;
    }
}

